/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.core.util;

import java.util.Arrays;
import java.util.List;
import net.minecraft.util.StatCollector;

public enum GrcColorPreset {
    White("grc.color.White", 0xBEBEBE, 0xDBDBDB, 0xFAFAFA),
    Orange("grc.color.Orange", 16357177, 16428612, 16047811),
    Magenta("grc.color.Magenta", 8527490, 12069560, 12949704),
    LightBlue("grc.color.LightBlue", 6458827, 8563943, 14219007),
    Yellow("grc.color.Yellow", 0xFFF7AA, 16318282, 0xFFFFE8),
    Lime("grc.color.Lime", 8191818, 12320593, 15202263),
    Pink("grc.color.Pink", 14454197, 16299479, 16244459),
    Gray("grc.color.Gray", 0x7C7C7C, 0xA0A0A0, 0xC9C9C9),
    LightGray("grc.color.LightGray", 0x9D9D9D, 0xCDCDCD, 0xEFEFEF),
    Cyan("grc.color.Cyan", 3120037, 5352134, 11460084),
    Purple("grc.color.Purple", 8532146, 10769358, 13083596),
    Blue("grc.color.Blue", 2959776, 5327615, 14542591),
    Brown("grc.color.Brown", 7491125, 12031615, 14734024),
    Green("grc.color.Green", 4562977, 6349614, 14938851),
    Red("grc.color.Red", 10813481, 16711740, 16770797),
    Black("grc.color.Black", 0x2B2B2B, 0x565656, 0x848484),
    Transparent("grc.color.Transparent", 1778500, 9002152, 14138348);

    public static final List<GrcColorPreset> ALL_COLORS;
    public static final List<GrcColorPreset> VALID_COLORS;
    public final String unlocalizedName;
    public final int blackVariant;
    public final int mediumVariant;
    public final int whiteVariant;

    private GrcColorPreset(String unLocname, int blackHex, int medHex, int whiteHex) {
        this.unlocalizedName = unLocname;
        this.blackVariant = blackHex;
        this.mediumVariant = medHex;
        this.whiteVariant = whiteHex;
    }

    public boolean matches(GrcColorPreset colour) {
        return this == Transparent || colour == Transparent || this == colour;
    }

    public String toString() {
        return StatCollector.func_74838_a((String)this.unlocalizedName);
    }

    public static GrcColorPreset toColour(int id) {
        return ALL_COLORS.get(id);
    }

    static {
        ALL_COLORS = Arrays.asList(White, Orange, Magenta, LightBlue, Yellow, Lime, Pink, Gray, LightGray, Cyan, Purple, Blue, Brown, Green, Red, Black, Transparent);
        VALID_COLORS = Arrays.asList(White, Orange, Magenta, LightBlue, Yellow, Lime, Pink, Gray, LightGray, Cyan, Purple, Blue, Brown, Green, Red, Black);
    }
}

