/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.core.util;

public class ModelCuboid {
    public float x;
    public float y;
    public float z;
    public float w;
    public float h;
    public float l;

    public ModelCuboid(float ix, float iy, float iz, float iw, float ih, float il) {
        this.x = ix;
        this.y = iy;
        this.z = iz;
        this.w = iw;
        this.h = ih;
        this.l = il;
    }

    public ModelCuboid(ModelCuboid other) {
        this(other.x, other.y, other.z, other.w, other.h, other.l);
    }

    public ModelCuboid() {
    }

    public ModelCuboid copy() {
        return new ModelCuboid(this);
    }

    public ModelCuboid translate(float tx, float ty, float tz) {
        this.x += tx;
        this.y += ty;
        this.z += tz;
        return this;
    }

    public ModelCuboid moveto(float tx, float ty, float tz) {
        this.x = tx;
        this.y = ty;
        this.z = tz;
        return this;
    }

    public ModelCuboid scale(float tx, float ty, float tz) {
        this.w *= tx;
        this.h *= ty;
        this.l *= tz;
        return this;
    }

    public ModelCuboid scaleAll(float s) {
        this.x *= s;
        this.y *= s;
        this.z *= s;
        this.w *= s;
        this.h *= s;
        this.l *= s;
        return this;
    }

    public ModelCuboid resize(float tx, float ty, float tz) {
        this.w = tx;
        this.h = ty;
        this.l = tz;
        return this;
    }

    public float[] toBoundsArray(float[] bounds) {
        assert (bounds.length == 6);
        bounds[0] = this.x;
        bounds[1] = this.y;
        bounds[2] = this.z;
        bounds[3] = this.x + this.w;
        bounds[4] = this.y + this.h;
        bounds[5] = this.z + this.l;
        return bounds;
    }

    public float[] toBoundsArray() {
        return this.toBoundsArray(new float[6]);
    }

    public float[] toIntArray(float[] target) {
        assert (target.length == 6);
        target[0] = this.x;
        target[1] = this.y;
        target[2] = this.z;
        target[3] = this.w;
        target[4] = this.h;
        target[5] = this.l;
        return target;
    }

    public float[] toIntArray() {
        return this.toIntArray(new float[6]);
    }
}

