/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.core.vines.user;

import growthcraft.api.core.CoreRegistry;
import growthcraft.api.core.schema.BlockKeySchema;
import growthcraft.api.core.user.AbstractUserJSONConfig;
import growthcraft.api.core.util.BlockKey;
import growthcraft.api.core.vines.user.UserVineEntries;
import growthcraft.api.core.vines.user.UserVineEntry;
import java.io.BufferedReader;
import java.io.Reader;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;

public class UserVinesConfig
extends AbstractUserJSONConfig {
    private final UserVineEntries defaultEntries = new UserVineEntries();
    private UserVineEntries entries;

    public UserVineEntry addDefault(@Nonnull UserVineEntry entry) {
        this.defaultEntries.data.add(entry);
        return entry;
    }

    public UserVineEntry addDefault(@Nonnull Block block, int meta) {
        return this.addDefault(new UserVineEntry(block, meta));
    }

    public UserVineEntry addDefault(@Nonnull Block block) {
        return this.addDefault(new UserVineEntry(block));
    }

    public UserVineEntry addDefault(@Nonnull BlockKeySchema block) {
        return this.addDefault(new UserVineEntry(block));
    }

    public UserVineEntry addDefault(@Nonnull BlockKey block) {
        return this.addDefault(new UserVineEntry(block));
    }

    @Override
    protected String getDefault() {
        return this.gson.toJson((Object)this.defaultEntries);
    }

    @Override
    protected void loadFromBuffer(BufferedReader reader) throws IllegalStateException {
        this.entries = (UserVineEntries)this.gson.fromJson((Reader)reader, UserVineEntries.class);
    }

    private void addVineEntry(UserVineEntry entry) {
        if (entry == null) {
            this.logger.warn("UserVinesConfig entry is invalid!", new Object[0]);
            return;
        }
        if (entry.block == null || entry.block.isInvalid()) {
            this.logger.warn("UserVinesConfig entry has invalid block {%s}!", entry);
            return;
        }
        CoreRegistry.instance().vineDrops().addVineEntry(entry.block.getBlock(), entry.block.meta);
    }

    @Override
    public void postInit() {
        if (this.entries != null) {
            if (this.entries.data != null) {
                this.logger.debug("Adding %d user vine entries.", this.entries.data.size());
                for (UserVineEntry entry : this.entries.data) {
                    this.addVineEntry(entry);
                }
            } else {
                this.logger.warn("UserVinesConfig entries.data is invalid!", new Object[0]);
            }
        } else {
            this.logger.warn("UserVinesConfig entries is invalid!", new Object[0]);
        }
    }
}

