/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.milk.pancheon;

import growthcraft.api.core.fluids.FluidFormatString;
import growthcraft.api.milk.pancheon.IPancheonRecipe;
import net.minecraftforge.fluids.FluidStack;

public class PancheonRecipe
implements IPancheonRecipe {
    private FluidStack inputFluid;
    private FluidStack topOutFluid;
    private FluidStack bottomOutFluid;
    private int time;

    public PancheonRecipe(FluidStack inputStack, FluidStack topOutput, FluidStack bottomOutput, int t) {
        this.inputFluid = inputStack;
        this.topOutFluid = topOutput;
        this.bottomOutFluid = bottomOutput;
        this.time = t;
    }

    @Override
    public boolean isValidForRecipe(FluidStack stack) {
        if (stack == null) {
            return false;
        }
        if (!this.inputFluid.isFluidEqual(stack)) {
            return false;
        }
        return stack.amount >= this.inputFluid.amount;
    }

    @Override
    public FluidStack getInputFluid() {
        return this.inputFluid;
    }

    @Override
    public FluidStack getTopOutputFluid() {
        return this.topOutFluid;
    }

    @Override
    public FluidStack getBottomOutputFluid() {
        return this.bottomOutFluid;
    }

    @Override
    public int getTime() {
        return this.time;
    }

    public String toString() {
        return String.format("PancheonRecipe(`%s` / %d = `%s` & `%s`)", FluidFormatString.format(this.inputFluid), this.time, FluidFormatString.format(this.topOutFluid), FluidFormatString.format(this.bottomOutFluid));
    }
}

