/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.bees.common.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import growthcraft.bees.common.block.BlockBeeBox;
import growthcraft.bees.common.block.EnumBeeBoxForestry;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class BlockBeeBoxForestry
extends BlockBeeBox {
    private final EnumBeeBoxForestry[] beeboxTypes;
    private final boolean isFireproofFlag;
    private final int metaOffset;
    private final int subIndex;

    public BlockBeeBoxForestry(EnumBeeBoxForestry[] types, int offset, int index, boolean fireproof) {
        this.beeboxTypes = types;
        this.metaOffset = offset;
        this.subIndex = index;
        this.isFireproofFlag = fireproof;
        this.func_149711_c(2.0f);
        this.func_149663_c(String.format("grc.BeeBox.Forestry.%d.%s", this.subIndex, this.isFireproofFlag ? "Fireproof" : "Normal"));
    }

    @Override
    public String getMetaname(int meta) {
        if (meta >= 0 && meta < this.beeboxTypes.length) {
            return this.beeboxTypes[meta].name;
        }
        return super.getMetaname(meta);
    }

    public EnumBeeBoxForestry getBeeBoxType(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        return this.beeboxTypes[MathHelper.func_76125_a((int)meta, (int)0, (int)this.beeboxTypes.length)];
    }

    public float func_149712_f(World world, int x, int y, int z) {
        return this.getBeeBoxType(world, x, y, z).getHardness();
    }

    public boolean isFireproof() {
        return this.isFireproofFlag;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item block, CreativeTabs tab, List list) {
        for (EnumBeeBoxForestry type : this.beeboxTypes) {
            list.add(new ItemStack(block, 1, type.col));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        this.icons = new IIcon[4 * this.beeboxTypes.length];
        for (EnumBeeBoxForestry type : this.beeboxTypes) {
            this.registerBeeBoxIcons(reg, String.format("/forestry/%s/", type.name), type.col);
        }
    }
}

