/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.client.render;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import growthcraft.api.core.util.BBox;
import growthcraft.api.core.util.ColorUtils;
import growthcraft.cellar.common.block.BlockCultureJar;
import growthcraft.cellar.common.tileentity.TileEntityCultureJar;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.Fluid;

public class RenderCultureJar
implements ISimpleBlockRenderingHandler {
    public static int RENDER_ID = RenderingRegistry.getNextAvailableRenderId();
    private static final BBox fluidBBox = BBox.newCube(7.0f, 1.0f, 7.0f, 2.0f, 4.0f, 2.0f).scale(0.0625f);

    public int getRenderId() {
        return RENDER_ID;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return false;
    }

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        if (RENDER_ID != modelId) {
            return false;
        }
        if (block instanceof BlockCultureJar) {
            IIcon icon;
            double fluidRate;
            Tessellator tes = Tessellator.field_78398_a;
            BlockCultureJar fermentJar = (BlockCultureJar)block;
            TileEntityCultureJar te = (TileEntityCultureJar)fermentJar.getTileEntity(world, x, y, z);
            Fluid fluid = te.getFluid(0);
            if (fluid != null && (fluidRate = (double)te.getFluidAmountRate(0)) > 0.0 && (icon = fluid.getIcon()) != null) {
                int color = fluid.getColor();
                float[] tempFloatColor = new float[3];
                ColorUtils.rgb24FloatArray(tempFloatColor, color);
                tes.func_78386_a(tempFloatColor[0], tempFloatColor[1], tempFloatColor[2]);
                renderer.func_147782_a((double)fluidBBox.x0(), (double)fluidBBox.y0(), (double)fluidBBox.z0(), (double)fluidBBox.x1(), (double)fluidBBox.y0() + (double)(fluidBBox.y1() - fluidBBox.y0()) * fluidRate, (double)fluidBBox.z1());
                renderer.func_147798_e(block, (double)x, (double)y, (double)z, icon);
                renderer.func_147764_f(block, (double)x, (double)y, (double)z, icon);
                renderer.func_147768_a(block, (double)x, (double)y, (double)z, icon);
                renderer.func_147806_b(block, (double)x, (double)y, (double)z, icon);
                renderer.func_147761_c(block, (double)x, (double)y, (double)z, icon);
                renderer.func_147734_d(block, (double)x, (double)y, (double)z, icon);
                renderer.func_147782_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
                tes.func_78386_a(1.0f, 1.0f, 1.0f);
            }
        }
        return true;
    }
}

