/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.common.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import growthcraft.api.core.util.BBox;
import growthcraft.cellar.GrowthCraftCellar;
import growthcraft.cellar.client.render.RenderBrewKettle;
import growthcraft.cellar.common.block.BlockCellarContainer;
import growthcraft.cellar.common.tileentity.TileEntityBrewKettle;
import growthcraft.core.Utils;
import java.util.List;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class BlockBrewKettle
extends BlockCellarContainer {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;
    private final BBox kettleContentsBB = BBox.newCube(2.0f, 4.0f, 2.0f, 12.0f, 10.0f, 12.0f).scale(0.0625f);
    private final boolean dropItemsInBrewKettle;
    private final boolean fillsWithRain;
    private final boolean setFireToFallenLivingEntities;
    private final int rainFillPerUnit;

    public BlockBrewKettle() {
        super(Material.field_151573_f);
        this.dropItemsInBrewKettle = GrowthCraftCellar.getConfig().dropItemsInBrewKettle;
        this.fillsWithRain = GrowthCraftCellar.getConfig().brewKettleFillsWithRain;
        this.setFireToFallenLivingEntities = GrowthCraftCellar.getConfig().setFireToFallenLivingEntities;
        this.rainFillPerUnit = GrowthCraftCellar.getConfig().brewKettleRainFillPerUnit;
        this.func_149672_a(field_149777_j);
        this.setTileEntityType(TileEntityBrewKettle.class);
        this.func_149711_c(2.0f);
        this.func_149663_c("grc.brewKettle");
        this.func_149647_a(GrowthCraftCellar.tab);
    }

    public void func_149639_l(World world, int x, int y, int z) {
        TileEntityBrewKettle te;
        if (this.fillsWithRain && (te = (TileEntityBrewKettle)this.getTileEntity((IBlockAccess)world, x, y, z)) != null) {
            te.fill(ForgeDirection.UP, new FluidStack(FluidRegistry.WATER, this.rainFillPerUnit), true);
        }
        super.func_149639_l(world, x, y, z);
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        TileEntityBrewKettle te;
        if (!world.field_72995_K && (te = (TileEntityBrewKettle)this.getTileEntity((IBlockAccess)world, x, y, z)) != null) {
            float ez;
            float ey;
            float ex;
            EntityItem item;
            if (this.dropItemsInBrewKettle && entity instanceof EntityItem && te.tryMergeItemIntoMainSlot((item = (EntityItem)entity).func_92059_d()) != null) {
                world.func_72908_a((double)x, (double)y, (double)z, "liquid.splash", 0.3f, 0.5f);
            }
            if (this.setFireToFallenLivingEntities && entity instanceof EntityLivingBase && te.getHeatMultiplier() >= 0.5f && this.kettleContentsBB.contains(ex = (float)entity.field_70165_t - (float)x, ey = (float)entity.field_70163_u - (float)y, ez = (float)entity.field_70161_v - (float)z)) {
                entity.func_70015_d(1);
            }
        }
    }

    @Override
    protected boolean playerDrainTank(World world, int x, int y, int z, IFluidHandler fh, ItemStack is, EntityPlayer player) {
        FluidStack fs = Utils.playerDrainTank(world, x, y, z, fh, is, player);
        return fs != null && fs.amount > 0;
    }

    public int func_149745_a(Random random) {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        this.icons = new IIcon[4];
        this.icons[0] = reg.func_94245_a("grccellar:brewkettle_0");
        this.icons[1] = reg.func_94245_a("grccellar:brewkettle_1");
        this.icons[2] = reg.func_94245_a("grccellar:brewkettle_2");
        this.icons[3] = reg.func_94245_a("grccellar:brewkettle_3");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconByIndex(int index) {
        return this.icons[index];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (side == 1) {
            return this.icons[3];
        }
        if (side == 0) {
            return this.icons[0];
        }
        return this.icons[2];
    }

    public int func_149645_b() {
        return RenderBrewKettle.RENDER_ID;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        return true;
    }

    public void func_149683_g() {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB axis, List list, Entity entity) {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.3125f, 1.0f);
        super.func_149743_a(world, x, y, z, axis, list, entity);
        float f = 0.125f;
        this.func_149676_a(0.0f, 0.0f, 0.0f, 0.125f, 1.0f, 1.0f);
        super.func_149743_a(world, x, y, z, axis, list, entity);
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.125f);
        super.func_149743_a(world, x, y, z, axis, list, entity);
        this.func_149676_a(0.875f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        super.func_149743_a(world, x, y, z, axis, list, entity);
        this.func_149676_a(0.0f, 0.0f, 0.875f, 1.0f, 1.0f, 1.0f);
        super.func_149743_a(world, x, y, z, axis, list, entity);
        this.func_149683_g();
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World world, int x, int y, int z, int par5) {
        TileEntityBrewKettle te = (TileEntityBrewKettle)this.getTileEntity((IBlockAccess)world, x, y, z);
        if (te != null) {
            return te.getFluidAmountScaled(15, 1);
        }
        return 0;
    }
}

