/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.common.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import growthcraft.cellar.GrowthCraftCellar;
import growthcraft.cellar.client.render.RenderFruitPress;
import growthcraft.cellar.common.block.BlockCellarContainer;
import growthcraft.cellar.common.tileentity.TileEntityFruitPress;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockFruitPress
extends BlockCellarContainer {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;

    public BlockFruitPress() {
        super(Material.field_151575_d);
        this.setTileEntityType(TileEntityFruitPress.class);
        this.func_149711_c(2.0f);
        this.func_149672_a(field_149766_f);
        this.func_149663_c("grc.fruitPress");
        this.func_149647_a(GrowthCraftCellar.tab);
    }

    private Block getPresserBlock() {
        return GrowthCraftCellar.blocks.fruitPresser.getBlock();
    }

    @Override
    public boolean isRotatable(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return true;
    }

    @Override
    public void doRotateBlock(World world, int x, int y, int z, ForgeDirection side) {
        world.func_72921_c(x, y, z, world.func_72805_g(x, y, z) ^ 1, 2);
        world.func_72921_c(x, y + 1, z, world.func_72805_g(x, y + 1, z) ^ 1, 2);
    }

    public void func_149726_b(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
        this.setDefaultDirection(world, x, y, z);
        world.func_147465_d(x, y + 1, z, this.getPresserBlock(), world.func_72805_g(x, y, z), 2);
    }

    private void setDefaultDirection(World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            Block block = world.func_147439_a(x, y, z - 1);
            Block block1 = world.func_147439_a(x, y, z + 1);
            Block block2 = world.func_147439_a(x - 1, y, z);
            Block block3 = world.func_147439_a(x + 1, y, z);
            int meta = 3;
            if (block.func_149730_j() && !block1.func_149730_j()) {
                meta = 3;
            }
            if (block1.func_149730_j() && !block.func_149730_j()) {
                meta = 2;
            }
            if (block2.func_149730_j() && !block3.func_149730_j()) {
                meta = 5;
            }
            if (block3.func_149730_j() && !block2.func_149730_j()) {
                meta = 4;
            }
            world.func_72921_c(x, y, z, meta, 3);
        }
    }

    @Override
    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        super.func_149689_a(world, x, y, z, entity, stack);
        int a = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (a == 0 || a == 2) {
            world.func_72921_c(x, y, z, 0, 2);
        } else if (a == 1 || a == 3) {
            world.func_72921_c(x, y, z, 1, 2);
        }
        world.func_147465_d(x, y + 1, z, this.getPresserBlock(), world.func_72805_g(x, y, z), 2);
    }

    public void func_149681_a(World world, int x, int y, int z, int m, EntityPlayer player) {
        if (player.field_71075_bZ.field_75098_d && (m & 8) != 0 && this.presserIsAbove(world, x, y, z)) {
            world.func_147480_a(x, y + 1, z, true);
            world.func_147438_o(x, y + 1, z).func_145843_s();
        }
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        if (!this.func_149718_j(world, x, y, z)) {
            world.func_147480_a(x, y, z, true);
        }
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        int meta = world.func_72805_g(x, y, z);
        if (meta == 0) {
            return side == ForgeDirection.EAST || side == ForgeDirection.WEST;
        }
        if (meta == 1) {
            return side == ForgeDirection.NORTH || side == ForgeDirection.SOUTH;
        }
        return this.isNormalCube(world, x, y, z);
    }

    public boolean presserIsAbove(World world, int x, int y, int z) {
        return this.getPresserBlock() == world.func_147439_a(x, y + 1, z);
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        return this.presserIsAbove(world, x, y, z);
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        if (y >= 255) {
            return false;
        }
        return World.func_147466_a((IBlockAccess)world, (int)x, (int)(y - 1), (int)z) && super.func_149742_c(world, x, y, z) && super.func_149742_c(world, x, y + 1, z);
    }

    public int func_149745_a(Random random) {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        this.icons = new IIcon[6];
        this.icons[0] = reg.func_94245_a("grccellar:fruit_press_wood_bottom");
        this.icons[1] = reg.func_94245_a("grccellar:fruit_press_wood_top");
        this.icons[2] = reg.func_94245_a("grccellar:fruit_press_wood_side");
        this.icons[3] = reg.func_94245_a("grccellar:fruit_press_metal_bottom");
        this.icons[4] = reg.func_94245_a("grccellar:fruit_press_metal_top");
        this.icons[5] = reg.func_94245_a("grccellar:fruit_press_metal_side");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconByIndex(int index) {
        return this.icons[index];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (side == 0) {
            return this.icons[0];
        }
        if (side == 1) {
            return this.icons[1];
        }
        return this.icons[2];
    }

    public int func_149645_b() {
        return RenderFruitPress.RENDER_ID;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        return true;
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World world, int x, int y, int z, int par5) {
        TileEntityFruitPress te = (TileEntityFruitPress)this.getTileEntity((IBlockAccess)world, x, y, z);
        if (te != null) {
            return te.getFluidAmountScaled(15, 0);
        }
        return 0;
    }
}

