/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.integration;

import cpw.mods.fml.common.Optional;
import growthcraft.api.cellar.booze.BoozeTag;
import growthcraft.api.core.CoreRegistry;
import growthcraft.api.core.fluids.FluidTag;
import growthcraft.api.core.log.ILoggable;
import growthcraft.api.core.log.ILogger;
import growthcraft.api.core.log.NullLogger;
import growthcraft.core.common.definition.BlockTypeDefinition;
import growthcraft.core.common.definition.ItemTypeDefinition;
import growthcraft.core.common.item.IFluidItem;
import growthcraft.core.integration.thaumcraft.AspectsHelper;
import growthcraft.core.util.FluidFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;

public class ThaumcraftBoozeHelper
implements ILoggable {
    private static ThaumcraftBoozeHelper INSTANCE;
    private ILogger logger = NullLogger.INSTANCE;
    private final Map<FluidTag, AspectModifier> tagToAspects = new HashMap<FluidTag, AspectModifier>();

    public ThaumcraftBoozeHelper() {
        this.tagToAspects.put(BoozeTag.FERMENTED, new AspectModifier().set(Aspect.POISON, 1).set(Aspect.WATER, -1));
        this.tagToAspects.put(BoozeTag.EXTENDED, new AspectModifier().set(Aspect.ENERGY, 1).set(Aspect.WATER, -1));
        this.tagToAspects.put(BoozeTag.POTENT, new AspectModifier().set(Aspect.POISON, 1).set(Aspect.WATER, -1));
        this.tagToAspects.put(BoozeTag.HYPER_EXTENDED, new AspectModifier().set(Aspect.POISON, 1).set(Aspect.ENERGY, 1).set(Aspect.WATER, -2));
        this.tagToAspects.put(BoozeTag.DEADLY, new AspectModifier().set(Aspect.DEATH, 1));
        this.tagToAspects.put(BoozeTag.POISONED, new AspectModifier().set(Aspect.POISON, 3).set(Aspect.WATER, -3));
        this.tagToAspects.put(BoozeTag.CHILLED, new AspectModifier().set(Aspect.COLD, 1).set(Aspect.WATER, -1));
        this.tagToAspects.put(BoozeTag.INTOXICATED, new AspectModifier().set(Aspect.POISON, 2).set(Aspect.WATER, -3));
    }

    @Override
    public void setLogger(@Nonnull ILogger l) {
        this.logger = l;
    }

    @Optional.Method(modid="Thaumcraft")
    public AspectList setAspectsForFluid(Fluid fluid, AspectList aspects) {
        Collection<FluidTag> tags = CoreRegistry.instance().fluidDictionary().getFluidTags(fluid);
        for (FluidTag tag : tags) {
            AspectModifier mod = this.tagToAspects.get(tag);
            if (mod != null) {
                for (Map.Entry<Aspect, Integer> asp : mod) {
                    aspects.add(asp.getKey(), asp.getValue().intValue());
                }
                continue;
            }
            this.logger.error("AspectModifier %s not found!", tag);
        }
        return aspects;
    }

    @Optional.Method(modid="Thaumcraft")
    public AspectList setAspectsForFluidBucketContent(Fluid fluid, AspectList aspects) {
        return this.setAspectsForFluid(fluid, aspects.add(Aspect.WATER, 4));
    }

    @Optional.Method(modid="Thaumcraft")
    public AspectList setAspectsForFluidBottleContent(Fluid fluid, AspectList aspects) {
        return this.setAspectsForFluid(fluid, aspects.add(Aspect.WATER, 2));
    }

    @Optional.Method(modid="Thaumcraft")
    public AspectList setAspectsForFluidBucket(Fluid fluid, AspectList list) {
        list.add(Aspect.METAL, 3);
        return this.setAspectsForFluidBucketContent(fluid, list);
    }

    @Optional.Method(modid="Thaumcraft")
    public AspectList setAspectsForFluidBottle(Fluid fluid, AspectList list) {
        list.add(Aspect.CRYSTAL, 1);
        return this.setAspectsForFluidBottleContent(fluid, list);
    }

    @Optional.Method(modid="Thaumcraft")
    public void registerAspectsForBucket(ItemTypeDefinition<? extends IFluidItem> def, AspectList base) {
        ItemStack stack = def.asStack(1, Short.MAX_VALUE);
        Item item = stack.func_77973_b();
        if (item instanceof IFluidItem) {
            IFluidItem bucket = (IFluidItem)item;
            ThaumcraftApi.registerObjectTag((ItemStack)stack, (AspectList)this.setAspectsForFluidBucket(bucket.getFluid(stack), base.copy()));
        }
    }

    @Optional.Method(modid="Thaumcraft")
    public void registerAspectsForBuckets(ItemTypeDefinition<? extends IFluidItem>[] buckets, AspectList base) {
        for (ItemTypeDefinition<? extends IFluidItem> bucket : buckets) {
            this.registerAspectsForBucket(bucket, base);
        }
    }

    @Optional.Method(modid="Thaumcraft")
    public void registerAspectsForFluidBlock(BlockTypeDefinition<? extends BlockFluidBase> def, AspectList base) {
        BlockFluidBase block = def.getBlock();
        if (block instanceof BlockFluidBase) {
            ThaumcraftApi.registerObjectTag((ItemStack)def.asStack(1, Short.MAX_VALUE), (AspectList)this.setAspectsForFluidBucket(block.getFluid(), base.copy()));
        }
    }

    @Optional.Method(modid="Thaumcraft")
    public void registerAspectsForFluidBlocks(BlockTypeDefinition<? extends BlockFluidBase>[] blocks, AspectList base) {
        for (BlockTypeDefinition<? extends BlockFluidBase> block : blocks) {
            this.registerAspectsForFluidBlock(block, base);
        }
    }

    @Optional.Method(modid="Thaumcraft")
    public void registerAspectsForBottleStack(ItemStack stack, AspectList base) {
        Item item = stack.func_77973_b();
        if (item instanceof IFluidItem) {
            IFluidItem fluidItem = (IFluidItem)item;
            ThaumcraftApi.registerObjectTag((ItemStack)stack, (AspectList)this.setAspectsForFluidBottle(fluidItem.getFluid(stack), base.copy()));
        }
    }

    @Optional.Method(modid="Thaumcraft")
    public void registerAspectsForBottle(ItemTypeDefinition<? extends IFluidItem> def, AspectList base) {
        ItemStack stack = def.asStack(1, Short.MAX_VALUE);
        this.registerAspectsForBottleStack(stack, base);
    }

    @Optional.Method(modid="Thaumcraft")
    public void registerAspectsForFluidDetails(FluidFactory.FluidDetails details, AspectList base, Aspect ... aspects) {
        if (details.bottle != null) {
            this.registerAspectsForBottle(details.bottle, base.copy());
        }
        if (details.foodBottle != null) {
            this.registerAspectsForBottle(details.foodBottle, base.copy());
        }
        if (details.bucket != null) {
            this.registerAspectsForBucket(details.bucket, AspectsHelper.scaleAspects(base.copy(), 3, aspects));
        }
        if (details.block != null) {
            this.registerAspectsForFluidBlock(details.block, AspectsHelper.scaleAspects(base.copy(), 3, aspects));
        }
    }

    @Optional.Method(modid="Thaumcraft")
    public static ThaumcraftBoozeHelper instance() {
        if (INSTANCE == null) {
            INSTANCE = new ThaumcraftBoozeHelper();
        }
        return INSTANCE;
    }

    public static class AspectModifier
    implements Iterable<Map.Entry<Aspect, Integer>> {
        private Map<Aspect, Integer> aspects = new HashMap<Aspect, Integer>();

        @Optional.Method(modid="Thaumcraft")
        public AspectModifier set(Aspect aspect, int i) {
            this.aspects.put(aspect, i);
            return this;
        }

        @Override
        @Optional.Method(modid="Thaumcraft")
        public Iterator<Map.Entry<Aspect, Integer>> iterator() {
            return this.aspects.entrySet().iterator();
        }
    }
}

