/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.integration.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import growthcraft.api.cellar.CellarRegistry;
import growthcraft.api.cellar.fermenting.IFermentationRecipe;
import growthcraft.api.core.i18n.GrcI18n;
import growthcraft.cellar.GrowthCraftCellar;
import growthcraft.cellar.client.gui.GuiFermentBarrel;
import growthcraft.cellar.client.resource.GrcCellarResources;
import growthcraft.core.integration.nei.TemplateRenderHelper;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class RecipeHandlerFermentBarrel
extends TemplateRecipeHandler {
    public String getGuiTexture() {
        return GrcCellarResources.INSTANCE.textureGuiFermentBarrel.toString();
    }

    public String getRecipeName() {
        return GrcI18n.translate("grc.recipe_handler.ferment_barrel");
    }

    @SideOnly(value=Side.CLIENT)
    public Class<? extends GuiContainer> getGuiClass() {
        return GuiFermentBarrel.class;
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        List<IFermentationRecipe> recipes = CellarRegistry.instance().fermenting().findRecipes(ingredient);
        for (IFermentationRecipe recipe : recipes) {
            this.arecipes.add(new CachedFermentationRecipe(recipe));
        }
    }

    protected void drawOutputFluidStack(TemplateRecipeHandler.CachedRecipe recipe) {
        FluidStack stack;
        List<FluidStack> stacks;
        if (recipe instanceof CachedFermentationRecipe && (stacks = ((CachedFermentationRecipe)recipe).inputFluidStacks).size() > 0 && (stack = stacks.get(stacks.size() * this.cycleticks / 20 % stacks.size())) != null) {
            TemplateRenderHelper.drawFluid(58, 6, 50, 52, stack.getFluid(), 52);
        }
    }

    public void drawExtras(int recipe) {
        TemplateRecipeHandler.CachedRecipe crecipe = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipe);
        if (crecipe != null) {
            this.drawOutputFluidStack(crecipe);
        }
        GuiDraw.changeTexture((String)this.getGuiTexture());
        this.drawProgressBar(34, 10, 188, 0, 9, 29, 240, 3);
        this.drawProgressBar(44, 9, 176, 0, 12, 29, 20, 3);
    }

    public class CachedFermentationRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public IFermentationRecipe fermentationRecipe;
        public FluidStack outputFluidStack;
        public List<FluidStack> inputFluidStacks;
        protected PositionedStack ingredient;

        public CachedFermentationRecipe(IFermentationRecipe recipe) {
            super((TemplateRecipeHandler)RecipeHandlerFermentBarrel.this);
            this.fermentationRecipe = recipe;
            this.ingredient = new PositionedStack(this.fermentationRecipe.getFermentingItemStack().getItemStacks(), 38, 42);
            this.inputFluidStacks = this.fermentationRecipe.getInputFluidStack().getFluidStacks();
            this.outputFluidStack = this.fermentationRecipe.getOutputFluidStack().copy();
            this.outputFluidStack.amount = GrowthCraftCellar.getConfig().fermentBarrelMaxCap;
        }

        public PositionedStack getResult() {
            return null;
        }

        public PositionedStack getIngredient() {
            return this.ingredient;
        }
    }
}

