/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.client.gui.widget;

import growthcraft.api.core.util.Rectangle;
import growthcraft.core.client.gui.widget.WidgetManager;

public class Widget {
    public boolean visible = true;
    public Rectangle rect;
    protected WidgetManager manager;

    public Widget(WidgetManager man, Rectangle r) {
        this.manager = man;
        this.rect = r;
    }

    public Widget(WidgetManager man, int x, int y, int w, int h) {
        this(man, new Rectangle(x, y, w, h));
    }

    public int getX() {
        return this.rect.x;
    }

    public int getY() {
        return this.rect.y;
    }

    public int getWidth() {
        return this.rect.w;
    }

    public int getHeight() {
        return this.rect.h;
    }

    public int getGuiX() {
        return this.manager.gui.getGuiX();
    }

    public int getGuiY() {
        return this.manager.gui.getGuiY();
    }

    public int getGuiXSize() {
        return this.manager.gui.getXSize();
    }

    public int getGuiYSize() {
        return this.manager.gui.getYSize();
    }

    public int getSX() {
        return this.getGuiX() + this.getX();
    }

    public int getSY() {
        return this.getGuiY() + this.getY();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public Widget show() {
        this.visible = true;
        return this;
    }

    public Widget hide() {
        this.visible = false;
        return this;
    }

    protected void doDraw(int mx, int my, int x, int y) {
    }

    protected void doDrawForeground(int mx, int my, int x, int y) {
    }

    public final void draw(int mx, int my) {
        if (this.isVisible()) {
            this.manager.gui.bindGuiTexture();
            this.doDraw(mx, my, this.getSX(), this.getSY());
            this.manager.gui.bindGuiTexture();
        }
    }

    public final void drawForeground(int mx, int my) {
        if (this.isVisible()) {
            this.manager.gui.bindGuiTexture();
            this.doDrawForeground(mx, my, this.getSX(), this.getSY());
            this.manager.gui.bindGuiTexture();
        }
    }
}

