/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.common.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import growthcraft.api.core.util.FXHelper;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.util.IIcon;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;

public class GrcBlockFluid
extends BlockFluidClassic {
    @SideOnly(value=Side.CLIENT)
    protected IIcon[] icons;
    private int color = 0xFFFFFF;

    public GrcBlockFluid(Fluid fluid, Material material) {
        super(fluid, material);
        this.func_149663_c(fluid.getUnlocalizedName());
    }

    public GrcBlockFluid refreshSettings() {
        this.setDensity(this.definedFluid.getDensity());
        return this;
    }

    public GrcBlockFluid refreshLight() {
        float lum = 0.2126f * ((float)(this.color >> 16 & 0xFF) / 255.0f) + 0.7152f * ((float)(this.color >> 8 & 0xFF) / 255.0f) + 0.0722f * ((float)(this.color & 0xFF) / 255.0f);
        this.func_149713_g((int)((1.0f - lum) * 15.0f));
        return this;
    }

    public GrcBlockFluid setColor(int kolor) {
        this.color = kolor;
        return this;
    }

    public int getColor() {
        return this.color;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return side != 0 && side != 1 ? this.icons[1] : this.icons[0];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.icons = new IIcon[2];
        this.icons[0] = iconRegister.func_94245_a(this.func_149641_N() + "_still");
        this.icons[1] = iconRegister.func_94245_a(this.func_149641_N() + "_flow");
    }

    public boolean canDisplace(IBlockAccess world, int x, int y, int z) {
        if (world.func_147439_a(x, y, z).func_149688_o().func_76224_d()) {
            return false;
        }
        return super.canDisplace(world, x, y, z);
    }

    public boolean displaceIfPossible(World world, int x, int y, int z) {
        if (world.func_147439_a(x, y, z).func_149688_o().func_76224_d()) {
            return false;
        }
        return super.displaceIfPossible(world, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess world, int x, int y, int z) {
        return this.color;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        super.func_149734_b(world, x, y, z, rand);
        if (rand.nextInt(10) == 0 && World.func_147466_a((IBlockAccess)world, (int)x, (int)(y - 1), (int)z) && !world.func_147439_a(x, y - 2, z).func_149688_o().func_76230_c()) {
            double px = (float)x + rand.nextFloat();
            double py = (double)y - 1.05;
            double pz = (float)z + rand.nextFloat();
            FXHelper.dropParticle(world, px, py, pz, this.color);
        }
    }

    public boolean func_149659_a(Explosion explosion) {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }
}

