/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.common.tileentity.device;

import growthcraft.api.core.definition.IMultiItemStacks;
import growthcraft.core.common.inventory.InventoryProcessor;
import growthcraft.core.util.ItemUtils;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class DeviceInventorySlot {
    public final int index;
    private IInventory inventory;

    public DeviceInventorySlot(IInventory inv, int idx) {
        this.inventory = inv;
        this.index = idx;
    }

    public ItemStack get() {
        return this.inventory.func_70301_a(this.index);
    }

    public int getSize() {
        ItemStack stack = this.get();
        if (stack == null) {
            return 0;
        }
        return stack.field_77994_a;
    }

    public int getCapacity() {
        ItemStack stack = this.get();
        if (stack != null) {
            return stack.func_77976_d();
        }
        return this.inventory.func_70297_j_();
    }

    public int getAvailableCapacity() {
        return this.getCapacity() - this.getSize();
    }

    public void set(ItemStack newStack) {
        this.inventory.func_70299_a(this.index, newStack);
    }

    public boolean hasContent() {
        return this.getSize() > 0;
    }

    public boolean isEmpty() {
        return !this.hasContent();
    }

    public boolean isFull() {
        return this.getAvailableCapacity() <= 0;
    }

    public boolean hasMatching(ItemStack stack) {
        ItemStack s = this.get();
        if (stack == null) {
            return s == null;
        }
        if (stack != null && s != null) {
            return stack.func_77969_a(s);
        }
        return false;
    }

    public boolean hasMatching(IMultiItemStacks stack) {
        ItemStack s = this.get();
        if (stack == null || stack.isEmpty()) {
            return s == null;
        }
        if (stack != null && s != null) {
            return stack.containsItemStack(s);
        }
        return false;
    }

    public boolean hasMatchingWithCapacity(ItemStack stack) {
        if (stack == null) {
            return true;
        }
        if (!this.isEmpty() && !this.hasMatching(stack)) {
            return false;
        }
        return this.getAvailableCapacity() >= stack.field_77994_a;
    }

    public boolean hasCapacityFor(ItemStack stack) {
        if (stack == null) {
            return true;
        }
        if (this.hasContent() && !this.hasMatching(stack)) {
            return false;
        }
        return this.getAvailableCapacity() >= stack.field_77994_a;
    }

    public boolean hasEnough(ItemStack stack) {
        if (this.hasMatching(stack)) {
            if (stack != null) {
                ItemStack s = this.get();
                if (s.field_77994_a >= stack.field_77994_a) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public boolean hasEnough(IMultiItemStacks stack) {
        if (this.hasMatching(stack)) {
            if (stack != null) {
                ItemStack s = this.get();
                if (s.field_77994_a >= stack.getStackSize()) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public ItemStack consume(int count) {
        return this.inventory.func_70298_a(this.index, count);
    }

    public ItemStack consume(ItemStack stack) {
        if (this.hasEnough(stack)) {
            return this.consume(stack.field_77994_a);
        }
        return null;
    }

    public ItemStack consume(IMultiItemStacks stack) {
        if (this.hasEnough(stack)) {
            return this.consume(stack.getStackSize());
        }
        return null;
    }

    public ItemStack increaseStack(ItemStack stack) {
        ItemStack result = ItemUtils.mergeStacks(this.get(), stack);
        if (result != null) {
            this.set(result);
            return result;
        }
        return null;
    }

    public ItemStack yank() {
        return InventoryProcessor.instance().yankSlot(this.inventory, this.index);
    }
}

