/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.integration;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.Event;
import growthcraft.core.integration.ModIntegrationBase;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import squeek.applecore.api.AppleCoreAPI;

public class AppleCore
extends ModIntegrationBase {
    public static final String MOD_ID = "AppleCore";
    private static boolean appleCoreLoaded;

    public AppleCore() {
        super("Growthcraft", MOD_ID);
    }

    @Override
    public void doInit() {
        appleCoreLoaded = Loader.isModLoaded((String)this.modID);
    }

    @Optional.Method(modid="AppleCore")
    private static Event.Result validateGrowthTick_AC(Block block, World world, int x, int y, int z, Random random) {
        return AppleCoreAPI.dispatcher.validatePlantGrowth(block, world, x, y, z, random);
    }

    public static Event.Result validateGrowthTick(Block block, World world, int x, int y, int z, Random random) {
        if (appleCoreLoaded) {
            return AppleCore.validateGrowthTick_AC(block, world, x, y, z, random);
        }
        return Event.Result.DEFAULT;
    }

    @Optional.Method(modid="AppleCore")
    private static void announceGrowthTick_AC(Block block, World world, int x, int y, int z, int previousMetadata) {
        AppleCoreAPI.dispatcher.announcePlantGrowth(block, world, x, y, z, previousMetadata);
    }

    public static void announceGrowthTick(Block block, World world, int x, int y, int z, int previousMetadata) {
        if (appleCoreLoaded) {
            AppleCore.announceGrowthTick_AC(block, world, x, y, z, previousMetadata);
        }
    }
}

