/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.integration;

import cpw.mods.fml.common.Optional;
import forestry.api.core.ForestryAPI;
import forestry.api.core.IGameMode;
import forestry.api.farming.Farmables;
import forestry.api.farming.IFarmable;
import forestry.api.storage.BackpackManager;
import growthcraft.api.core.fluids.FluidTest;
import growthcraft.api.core.item.ItemTest;
import growthcraft.core.integration.ModIntegrationBase;
import growthcraft.core.integration.forestry.ForestryFluids;
import growthcraft.core.integration.forestry.recipes.RecipeManagersShims;
import java.util.Collection;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public abstract class ForestryModuleBase
extends ModIntegrationBase {
    public ForestryModuleBase(String modid) {
        super(modid, "Forestry");
    }

    @Optional.Method(modid="ForestryAPI|core")
    public IGameMode getActiveMode() {
        return ForestryAPI.activeMode;
    }

    public RecipeManagersShims recipes() {
        return ForestryRecipeUtils.recipes();
    }

    @Optional.Method(modid="ForestryAPI|farming")
    public void addFarmable(String ns, IFarmable farmable) {
        Collection farmables = (Collection)Farmables.farmables.get(ns);
        if (farmables != null) {
            farmables.add(farmable);
        }
    }

    public static class ForestryRecipeUtils {
        public static RecipeManagersShims recipes() {
            return RecipeManagersShims.instance();
        }

        public static void addFermenterRecipes(ItemStack resource, int fermentationValue, FluidStack output) {
            if (!ItemTest.isValid(resource)) {
                return;
            }
            if (!FluidTest.isValid(output)) {
                return;
            }
            if (ForestryFluids.WATER.exists()) {
                ForestryRecipeUtils.recipes().fermenterManager.addRecipe(resource, fermentationValue, 1.0f, output, ForestryFluids.WATER.asFluidStack());
            }
            if (ForestryFluids.JUICE.exists()) {
                ForestryRecipeUtils.recipes().fermenterManager.addRecipe(resource, fermentationValue, 1.5f, output, ForestryFluids.JUICE.asFluidStack());
            }
            if (ForestryFluids.HONEY.exists()) {
                ForestryRecipeUtils.recipes().fermenterManager.addRecipe(resource, fermentationValue, 1.5f, output, ForestryFluids.HONEY.asFluidStack());
            }
        }
    }

    public static enum Backpack {
        MINERS,
        DIGGERS,
        FORESTERS,
        HUNTERS,
        ADVENTURERS;

        public final int index = this.ordinal();

        @Optional.Method(modid="ForestryAPI|storage")
        public List<ItemStack> items() {
            if (BackpackManager.backpackItems == null) {
                return null;
            }
            return BackpackManager.backpackItems[this.index];
        }

        public void add(ItemStack stack) {
            List<ItemStack> target = this.items();
            if (target != null) {
                target.add(stack);
            }
        }
    }
}

