/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.integration.waila;

import cpw.mods.fml.common.Optional;
import growthcraft.api.core.i18n.GrcI18n;
import growthcraft.core.common.block.ICropDataProvider;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class CropDataProvider
implements IWailaDataProvider {
    @Optional.Method(modid="Waila")
    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return accessor.getStack();
    }

    @Optional.Method(modid="Waila")
    public List<String> getWailaHead(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return tooltip;
    }

    @Optional.Method(modid="Waila")
    public List<String> getWailaBody(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        Block block = accessor.getBlock();
        if (block instanceof ICropDataProvider) {
            ICropDataProvider prov = (ICropDataProvider)block;
            MovingObjectPosition pos = accessor.getPosition();
            float growth = prov.getGrowthProgress((IBlockAccess)accessor.getWorld(), pos.field_72311_b, pos.field_72312_c, pos.field_72309_d, accessor.getMetadata());
            String content = EnumChatFormatting.GRAY + GrcI18n.translate("grc.format.crop.growth_prefix") + " " + EnumChatFormatting.WHITE;
            content = growth >= 1.0f ? content + GrcI18n.translate("grc.format.crop.mature") : content + GrcI18n.translate("grc.format.crop.progress_format", (int)(growth * 100.0f));
            tooltip.add(content);
        }
        return tooltip;
    }

    @Optional.Method(modid="Waila")
    public List<String> getWailaTail(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return tooltip;
    }

    @Optional.Method(modid="Waila")
    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, int x, int y, int z) {
        return tag;
    }
}

