/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.logic;

import growthcraft.api.core.util.CuboidI;
import growthcraft.core.logic.ISpreadablePlant;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.world.World;

public class FlowerSpread {
    private CuboidI spreadCube;

    public FlowerSpread(@Nonnull CuboidI spread) {
        this.spreadCube = spread;
    }

    private boolean canSpreadTo(Block block, World world, int x, int y, int z) {
        if (block instanceof ISpreadablePlant) {
            return ((ISpreadablePlant)block).canSpreadTo(world, x, y, z);
        }
        return world.func_147437_c(x, y, z) && block.func_149718_j(world, x, y, z);
    }

    public boolean run(Block block, int meta, World world, int x, int y, int z, Random random) {
        int fx = x + random.nextInt(this.spreadCube.w) + this.spreadCube.x;
        int fz = z + random.nextInt(this.spreadCube.l) + this.spreadCube.z;
        for (int i = this.spreadCube.y; i <= this.spreadCube.y2(); ++i) {
            int fy = y + i;
            if (!this.canSpreadTo(block, world, fx, fy, fz)) continue;
            world.func_147465_d(fx, fy, fz, block, meta, 3);
            return true;
        }
        return false;
    }
}

