/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.registry;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import growthcraft.api.core.util.BlockKey;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;

public class FenceRopeRegistry {
    private static final FenceRopeRegistry INSTANCE = new FenceRopeRegistry();
    private final BiMap<BlockKey, FenceRopeEntry> entries = HashBiMap.create();

    public void addEntry(@Nonnull FenceRopeEntry entry) {
        this.entries.put((Object)entry.getFenceBlockKey(), (Object)entry);
    }

    public void addEntry(@Nonnull BlockKey fence, @Nonnull BlockKey fenceRope) {
        this.addEntry(new FenceRopeEntry(fence, fenceRope));
    }

    public void addEntry(@Nonnull Block fence, @Nonnull Block fenceRope) {
        this.addEntry(new BlockKey(fence, Short.MAX_VALUE), new BlockKey(fenceRope, Short.MAX_VALUE));
    }

    public FenceRopeEntry getEntry(@Nonnull BlockKey key) {
        for (FenceRopeEntry entry : this.entries.values()) {
            if (!entry.matches(key)) continue;
            return entry;
        }
        return null;
    }

    public FenceRopeEntry getEntry(@Nullable Block block, int meta) {
        if (block == null) {
            return null;
        }
        return this.getEntry(new BlockKey(block, meta));
    }

    public static FenceRopeRegistry instance() {
        return INSTANCE;
    }

    public static class FenceRopeEntry {
        private BlockKey fenceBlock;
        private BlockKey fenceRopeBlock;

        public FenceRopeEntry(BlockKey pFenceBlock, BlockKey pFenceRopeBlock) {
            this.fenceBlock = pFenceBlock;
            this.fenceRopeBlock = pFenceRopeBlock;
        }

        public BlockKey getFenceBlockKey() {
            return this.fenceBlock;
        }

        public BlockKey getFenceRopeBlockKey() {
            return this.fenceRopeBlock;
        }

        public Block getFenceBlock() {
            return this.fenceBlock.getBlock();
        }

        public int getFenceBlockMetadata() {
            return this.fenceBlock.getMetadata();
        }

        public Block getFenceRopeBlock() {
            return this.fenceRopeBlock.getBlock();
        }

        public int getFenceRopeBlockMetadata() {
            return this.fenceRopeBlock.getMetadata();
        }

        public boolean matches(BlockKey key) {
            return this.fenceBlock.matches(key);
        }
    }
}

