/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.util;

import growthcraft.api.core.util.NumUtils;
import growthcraft.api.core.util.ObjectUtils;
import growthcraft.core.GrowthCraftCore;
import growthcraft.core.common.block.GrcBlockFluid;
import growthcraft.core.common.definition.FluidDefinition;
import growthcraft.core.common.definition.GrcBlockFluidDefinition;
import growthcraft.core.common.definition.ItemTypeDefinition;
import growthcraft.core.common.item.ItemBottleFluid;
import growthcraft.core.common.item.ItemBucketFluid;
import growthcraft.core.common.item.ItemFoodBottleFluid;
import growthcraft.core.eventhandler.EventHandlerBucketFill;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;

public class FluidFactory {
    public static final int FEATURE_BLOCK = 1;
    public static final int FEATURE_BOTTLE = 2;
    public static final int FEATURE_FOOD_BOTTLE = 4;
    public static final int FEATURE_BUCKET = 8;
    public static final int FEATURE_NONE = 0;
    public static final int FEATURE_ALL_NON_EDIBLE = 11;
    public static final int FEATURE_ALL_EDIBLE = 13;
    private static FluidFactory INSTANCE = new FluidFactory();

    public FluidDetails create(Fluid fluid, int features) {
        FluidDetails details = new FluidDetails();
        details.fluid = new FluidDefinition(fluid);
        details.fluid.register();
        if (NumUtils.isFlagged(features, 1)) {
            details.block = GrcBlockFluidDefinition.create(details.fluid);
        }
        if (NumUtils.isFlagged(features, 2)) {
            details.bottle = new ItemTypeDefinition<ItemBottleFluid>(new ItemBottleFluid(fluid));
        }
        if (NumUtils.isFlagged(features, 8)) {
            details.bucket = new ItemTypeDefinition<ItemBucketFluid>(new ItemBucketFluid((Block)(details.block != null ? (GrcBlockFluid)((Object)details.block.getBlock()) : null), fluid, null));
        }
        details.refreshItemColor();
        details.refreshBlockColor();
        return details;
    }

    public FluidDetails create(Fluid fluid) {
        return this.create(fluid, 11);
    }

    public static FluidFactory instance() {
        return INSTANCE;
    }

    public static class FluidDetails {
        public FluidDefinition fluid;
        public GrcBlockFluidDefinition block;
        public ItemTypeDefinition<ItemBottleFluid> bottle;
        public ItemTypeDefinition<ItemFoodBottleFluid> foodBottle;
        public ItemTypeDefinition<ItemBucketFluid> bucket;
        private int itemColor = 0xFFFFFF;

        public Fluid getFluid() {
            return this.fluid.getFluid();
        }

        public Block getFluidBlock() {
            return this.block != null ? (GrcBlockFluid)((Object)this.block.getBlock()) : null;
        }

        public ItemStack asFluidBlockItemStack(int size) {
            return this.block != null ? this.block.asStack(size) : null;
        }

        public ItemStack asFluidBlockItemStack() {
            return this.asFluidBlockItemStack(1);
        }

        public ItemStack asBucketItemStack(int size) {
            return this.bucket != null ? this.bucket.asStack(size) : null;
        }

        public ItemStack asBucketItemStack() {
            return this.asBucketItemStack(1);
        }

        public ItemStack asFoodBottleItemStack(int size) {
            return this.foodBottle != null ? this.foodBottle.asStack(size) : null;
        }

        public ItemStack asFoodBottleItemStack() {
            return this.asFoodBottleItemStack(1);
        }

        public ItemStack asGenericBottleItemStack(int size) {
            return this.bottle != null ? this.bottle.asStack(size) : null;
        }

        public ItemStack asGenericBottleItemStack() {
            return this.asGenericBottleItemStack(1);
        }

        public ItemStack asBottleItemStack(int size) {
            return ObjectUtils.maybe(this.asFoodBottleItemStack(size), this.asGenericBottleItemStack(size));
        }

        public ItemStack asBottleItemStack() {
            return this.asBottleItemStack(1);
        }

        public FluidDetails registerObjects(String prefix, String basename) {
            FluidStack fluidStack;
            if (this.block != null) {
                ((GrcBlockFluid)((Object)this.block.getBlock())).func_149663_c(prefix + ".BlockFluid" + basename);
                this.block.register(prefix + ".BlockFluid" + basename);
            }
            if (this.bottle != null) {
                this.bottle.getItem().func_77655_b(prefix + ".BottleFluid" + basename);
                this.bottle.register(prefix + ".BottleFluid" + basename);
                fluidStack = this.fluid.asFluidStack(GrowthCraftCore.getConfig().bottleCapacity);
                FluidContainerRegistry.registerFluidContainer((FluidStack)fluidStack, (ItemStack)this.bottle.asStack(1), (ItemStack)GrowthCraftCore.EMPTY_BOTTLE);
            }
            if (this.foodBottle != null) {
                this.foodBottle.getItem().func_77655_b(prefix + ".FoodBottleFluid" + basename);
                this.foodBottle.register(prefix + ".BottleFluid" + basename);
                fluidStack = this.fluid.asFluidStack(GrowthCraftCore.getConfig().bottleCapacity);
                FluidContainerRegistry.registerFluidContainer((FluidStack)fluidStack, (ItemStack)this.foodBottle.asStack(1), (ItemStack)GrowthCraftCore.EMPTY_BOTTLE);
            }
            if (this.bucket != null) {
                this.bucket.getItem().func_77655_b(prefix + ".BucketFluid" + basename);
                this.bucket.register(prefix + ".BucketFluid" + basename);
                FluidStack boozeStack = this.fluid.asFluidStack(1000);
                FluidContainerRegistry.registerFluidContainer((FluidStack)boozeStack, (ItemStack)this.bucket.asStack(), (ItemStack)FluidContainerRegistry.EMPTY_BUCKET);
            }
            if (this.block != null && this.bucket != null) {
                EventHandlerBucketFill.instance().register((Block)this.block.getBlock(), (Item)this.bucket.getItem());
            }
            return this;
        }

        public FluidDetails setCreativeTab(CreativeTabs tab) {
            if (this.block != null) {
                ((GrcBlockFluid)((Object)this.block.getBlock())).func_149647_a(tab);
            }
            if (this.bottle != null) {
                this.bottle.getItem().func_77637_a(tab);
            }
            if (this.foodBottle != null) {
                this.foodBottle.getItem().func_77637_a(tab);
            }
            if (this.bucket != null) {
                this.bucket.getItem().func_77637_a(tab);
            }
            return this;
        }

        public FluidDetails setItemColor(int color) {
            this.itemColor = color;
            if (this.bottle != null) {
                this.bottle.getItem().setColor(color);
            }
            if (this.foodBottle != null) {
                this.foodBottle.getItem().setColor(color);
            }
            if (this.bucket != null) {
                this.bucket.getItem().setColor(color);
            }
            return this;
        }

        public FluidDetails setBlockColor(int color) {
            if (this.block != null) {
                ((GrcBlockFluid)((Object)this.block.getBlock())).setColor(color);
            }
            return this;
        }

        public FluidDetails refreshItemColor() {
            return this.setItemColor(this.fluid.getFluid().getColor());
        }

        public FluidDetails refreshBlockColor() {
            return this.setBlockColor(this.fluid.getFluid().getColor());
        }

        public int getItemColor() {
            return this.itemColor;
        }
    }
}

