/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.util;

import cpw.mods.fml.common.registry.GameRegistry;
import growthcraft.api.core.util.StringUtils;
import growthcraft.core.GrowthCraftCore;
import growthcraft.core.util.Platform;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fluids.FluidRegistry;

public class GameRegistryDumper {
    private GameRegistryDumper() {
    }

    private static void writeItemStackToFile(ItemStack stack, FileWriter writer) throws IOException {
        if (stack != null && stack.func_77973_b() != null) {
            Item item = stack.func_77973_b();
            int damage = stack.func_77960_j();
            String unlocName = stack.func_77977_a();
            String displayName = stack.func_82833_r();
            writer.write("\t" + item + "," + damage + "," + unlocName + "," + displayName + "\n");
        }
    }

    private static void writeItemSubtypes(Object obj, FileWriter writer) throws IOException {
        try {
            ArrayList sub = new ArrayList();
            if (obj instanceof Item) {
                Item item = (Item)obj;
                if (!item.func_77614_k()) {
                    return;
                }
                item.func_150895_a(item, item.func_77640_w(), sub);
            } else if (obj instanceof Block) {
                Block block = (Block)obj;
                Item item = Item.func_150898_a((Block)block);
                if (item == null) {
                    return;
                }
                if (!item.func_77614_k()) {
                    return;
                }
                block.func_149666_a(item, block.func_149708_J(), sub);
            }
            if (sub.size() > 0) {
                for (ItemStack stack : sub) {
                    if (stack == null || stack.func_77973_b() == null) continue;
                    GameRegistryDumper.writeItemStackToFile(stack, writer);
                }
            }
        }
        catch (NullPointerException ex) {
            ex.printStackTrace();
            writer.write("\tnull,,,\n");
        }
    }

    public static void dumpBlocks() {
        block19: {
            GrowthCraftCore.getLogger().info("Dumping Blocks", new Object[0]);
            Iterator it = GameRegistry.Type.BLOCK.getRegistry().iterator();
            try {
                FileWriter writer = new FileWriter("dumps/GameRegistry_Blocks.txt");
                Throwable throwable = null;
                block13: while (true) {
                    try {
                        while (it.hasNext()) {
                            Block obj = (Block)it.next();
                            try {
                                if (obj == null) continue block13;
                                writer.write("" + Block.func_149682_b((Block)obj) + "," + obj.func_149739_a() + "," + obj.func_149732_F() + "," + GameRegistry.findUniqueIdentifierFor((Block)obj) + "\n");
                                if (Platform.isClient()) {
                                    GameRegistryDumper.writeItemSubtypes(obj, writer);
                                    continue block13;
                                }
                                GameRegistryDumper.writeItemStackToFile(new ItemStack(obj), writer);
                                continue block13;
                            }
                            catch (NullPointerException ex) {
                                writer.write("null,,,\n");
                            }
                        }
                        break block19;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                finally {
                    if (writer != null) {
                        if (throwable != null) {
                            try {
                                writer.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                        } else {
                            writer.close();
                        }
                    }
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void dumpItems() {
        block19: {
            GrowthCraftCore.getLogger().info("Dumping Items", new Object[0]);
            Iterator it = GameRegistry.Type.ITEM.getRegistry().iterator();
            try {
                FileWriter writer = new FileWriter("dumps/GameRegistry_Items.txt");
                Throwable throwable = null;
                block13: while (true) {
                    try {
                        while (it.hasNext()) {
                            Item obj = (Item)it.next();
                            try {
                                if (obj == null) continue block13;
                                writer.write("" + Item.func_150891_b((Item)obj) + "," + obj.func_77658_a() + "," + "?" + "," + GameRegistry.findUniqueIdentifierFor((Item)obj) + "\n");
                                if (Platform.isClient()) {
                                    GameRegistryDumper.writeItemSubtypes(obj, writer);
                                    continue block13;
                                }
                                GameRegistryDumper.writeItemStackToFile(new ItemStack(obj), writer);
                                continue block13;
                            }
                            catch (NullPointerException ex) {
                                writer.write("null,,,\n");
                            }
                        }
                        break block19;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                finally {
                    if (writer != null) {
                        if (throwable != null) {
                            try {
                                writer.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                        } else {
                            writer.close();
                        }
                    }
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void dumpFluids() {
        GrowthCraftCore.getLogger().info("Dumping Fluids", new Object[0]);
        Set fluidKeys = FluidRegistry.getRegisteredFluids().keySet();
        try (FileWriter writer = new FileWriter("dumps/FluidRegistry_Fluids.txt");){
            for (String key : fluidKeys) {
                writer.write(key + "\n");
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static void dumpBiomes() {
        BiomeGenBase[] biomes = BiomeGenBase.func_150565_n();
        try (FileWriter writer = new FileWriter("dumps/Biomes_dump.txt");){
            writer.write("Biome ID, Name, [TYPES...]\n");
            for (BiomeGenBase biome : biomes) {
                if (biome == null) continue;
                writer.write(String.format("%d,%s,%s\n", biome.field_76756_M, biome.field_76791_y, StringUtils.inspect(BiomeDictionary.getTypesForBiome((BiomeGenBase)biome))));
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static void run() {
        GameRegistryDumper.dumpBlocks();
        GameRegistryDumper.dumpItems();
        GameRegistryDumper.dumpFluids();
        GameRegistryDumper.dumpBiomes();
    }
}

