/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.util;

import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public class SchemaToVillage {
    private SchemaToVillage() {
    }

    public static void drawSchema(IVillage village, World world, Random random, StructureBoundingBox box, String[][] schema, Map<Character, IBlockEntries> map, int offx, int offy, int offz) {
        for (int y = 0; y < schema.length; ++y) {
            String[] layer = schema[y];
            for (int z = 0; z < layer.length; ++z) {
                String row = layer[z];
                for (int x = 0; x < row.length(); ++x) {
                    BlockEntry entry;
                    int meta = 0;
                    Block block = null;
                    IBlockEntries entries = map.get(Character.valueOf(row.charAt(x)));
                    if (entries != null && (entry = entries.getBlockEntry(random)) != null) {
                        block = entry.getBlock();
                        meta = entry.getMetadata();
                    }
                    if (block == null) continue;
                    village.placeBlockAtCurrentPositionPub(world, block, meta, offx + x, offy + y, offz + z, box);
                }
            }
        }
    }

    public static void drawSchema(IVillage village, World world, Random random, StructureBoundingBox box, String[][] schema, Map<Character, IBlockEntries> map) {
        SchemaToVillage.drawSchema(village, world, random, box, schema, map, 0, 0, 0);
    }

    public static class MultiBlockEntries
    implements IBlockEntries {
        private BlockEntry[] entries;

        public MultiBlockEntries(BlockEntry[] blockEntries) {
            this.entries = blockEntries;
        }

        @Override
        public BlockEntry getBlockEntry(Random random) {
            if (this.entries.length == 0) {
                return null;
            }
            return this.entries[random.nextInt(this.entries.length)];
        }
    }

    public static class BlockEntry
    implements IBlockEntries {
        private Block block;
        private int meta;

        public BlockEntry(Block blok, int met) {
            this.block = blok;
            this.meta = met;
        }

        public BlockEntry(Block blok) {
            this(blok, 0);
        }

        @Override
        public BlockEntry getBlockEntry(Random random) {
            return this;
        }

        public Block getBlock() {
            return this.block;
        }

        public int getMetadata() {
            return this.meta;
        }
    }

    public static interface IBlockEntries {
        public BlockEntry getBlockEntry(Random var1);
    }

    public static interface IVillage {
        public void placeBlockAtCurrentPositionPub(World var1, Block var2, int var3, int var4, int var5, int var6, StructureBoundingBox var7);
    }
}

