/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.fishtrap.common.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import growthcraft.api.fishtrap.FishTrapRegistry;
import growthcraft.core.GrowthCraftCore;
import growthcraft.core.Utils;
import growthcraft.core.common.block.GrcBlockContainer;
import growthcraft.core.common.tileentity.feature.IInteractionObject;
import growthcraft.core.util.BlockCheck;
import growthcraft.fishtrap.GrowthCraftFishTrap;
import growthcraft.fishtrap.common.tileentity.TileEntityFishTrap;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public class BlockFishTrap
extends GrcBlockContainer {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;
    private final float chance;
    private Random rand;

    public BlockFishTrap() {
        super(Material.field_151575_d);
        this.chance = GrowthCraftFishTrap.getConfig().fishTrapCatchRate;
        this.rand = new Random();
        this.func_149675_a(true);
        this.func_149711_c(0.4f);
        this.func_149672_a(field_149766_f);
        this.func_149663_c("grc.fishTrap");
        this.setTileEntityType(TileEntityFishTrap.class);
        this.func_149647_a(GrowthCraftCore.creativeTab);
    }

    protected boolean openGui(EntityPlayer player, World world, int x, int y, int z) {
        Object te = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (te instanceof IInteractionObject) {
            player.openGui((Object)GrowthCraftFishTrap.instance, 0, world, x, y, z);
            return true;
        }
        return false;
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int meta, float par7, float par8, float par9) {
        if (super.func_149727_a(world, x, y, z, player, meta, par7, par8, par9)) {
            return true;
        }
        return !player.func_70093_af() && this.openGui(player, world, x, y, z);
    }

    private boolean isWater(Block block) {
        return BlockCheck.isWater(block);
    }

    private float applyBiomeCatchModifier(World world, int x, int y, int z, float f) {
        boolean isInWaterBiome;
        if (GrowthCraftFishTrap.getConfig().useBiomeDict) {
            BiomeGenBase biome = world.func_72807_a(x, z);
            isInWaterBiome = BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WATER);
        } else {
            isInWaterBiome = Utils.isIDInList(world.func_72807_a((int)x, (int)z).field_76756_M, GrowthCraftFishTrap.getConfig().biomesList);
        }
        if (isInWaterBiome) {
            f = (float)((double)f * 1.75);
        }
        return f;
    }

    private float getCatchRate(World world, int x, int y, int z) {
        TileEntityFishTrap te = (TileEntityFishTrap)this.getTileEntity((IBlockAccess)world, x, y, z);
        if (te == null) {
            return 0.0f;
        }
        int checkSize = 3;
        int i = x - 1;
        int j = y - 1;
        int k = z - 1;
        float f = 1.0f;
        for (int loopy = 0; loopy <= 3; ++loopy) {
            for (int loopx = 0; loopx <= 3; ++loopx) {
                for (int loopz = 0; loopz <= 3; ++loopz) {
                    Block water = world.func_147439_a(i + loopx, j + loopy, k + loopz);
                    float f1 = 0.0f;
                    if (water != null && this.isWater(water)) {
                        f1 = 3.0f;
                    }
                    f += (f1 /= 4.0f);
                }
            }
        }
        f = this.applyBiomeCatchModifier(world, x, y, z, f);
        return te.applyBaitModifier(f);
    }

    protected ItemStack pickCatch(World world, int x, int y, int z) {
        String catchGroup = FishTrapRegistry.instance().getRandomCatchGroup(world.field_73012_v);
        GrowthCraftFishTrap.getLogger().debug("Picking Catch from group=%s x=%d y=%d z=%d dimension=%d", catchGroup, x, y, z, world.field_73011_w.field_76574_g);
        return FishTrapRegistry.instance().getRandomCatchFromGroup(world.field_73012_v, catchGroup);
    }

    protected void doCatch(World world, int x, int y, int z, TileEntityFishTrap te) {
        ItemStack item = this.pickCatch(world, x, y, z);
        if (item != null) {
            GrowthCraftFishTrap.getLogger().debug("Attempting to add item to inventory x=%d y=%d z=%d dimension=%d item=%s", x, y, z, world.field_73011_w.field_76574_g, item);
            if (te.addStack(item)) {
                GrowthCraftFishTrap.getLogger().debug("Added item to inventory x=%d y=%d z=%d dimension=%d item=%s", x, y, z, world.field_73011_w.field_76574_g, item);
                te.consumeBait();
            }
        }
    }

    protected void attemptCatch(World world, int x, int y, int z, Random random, TileEntityFishTrap te, boolean debugFlag) {
        float f = this.getCatchRate(world, x, y, z);
        GrowthCraftFishTrap.getLogger().debug("Attempting Catch x=%d y=%d z=%d dimension=%d rate=%f", x, y, z, world.field_73011_w.field_76574_g, Float.valueOf(f));
        if (random.nextInt((int)(this.chance / f) + 1) == 0 || debugFlag) {
            this.doCatch(world, x, y, z, te);
        }
    }

    private boolean canCatch(World world, int x, int y, int z) {
        return this.isWater(world.func_147439_a(x, y, z - 1)) || this.isWater(world.func_147439_a(x, y, z + 1)) || this.isWater(world.func_147439_a(x - 1, y, z)) || this.isWater(world.func_147439_a(x + 1, y, z));
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        super.func_149674_a(world, x, y, z, random);
        TileEntityFishTrap te = (TileEntityFishTrap)this.getTileEntity((IBlockAccess)world, x, y, z);
        if (te != null) {
            GrowthCraftFishTrap.getLogger().debug("Checking if fishtrap can catch x=%d y=%d z=%d dimension=%d", x, y, z, world.field_73011_w.field_76574_g);
            if (this.canCatch(world, x, y, z)) {
                this.attemptCatch(world, x, y, z, random, te, false);
            }
        } else {
            GrowthCraftFishTrap.getLogger().warn("Missing TileEntityFishTrap at x=%d y=%d z=%d dimension=%d", x, y, z, world.field_73011_w.field_76574_g);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        this.icons = new IIcon[1];
        this.icons[0] = reg.func_94245_a("grcfishtrap:fishtrap");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.icons[0];
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149701_w() {
        return 0;
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World world, int x, int y, int z, int par5) {
        TileEntityFishTrap te = (TileEntityFishTrap)this.getTileEntity((IBlockAccess)world, x, y, z);
        if (te != null) {
            return Container.func_94526_b((IInventory)te);
        }
        return 0;
    }
}

