/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.hops.common.block;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import growthcraft.core.GrowthCraftCore;
import growthcraft.core.common.block.GrcBlockBase;
import growthcraft.core.common.block.IBlockRope;
import growthcraft.core.common.block.ICropDataProvider;
import growthcraft.core.integration.AppleCore;
import growthcraft.core.util.BlockCheck;
import growthcraft.hops.GrowthCraftHops;
import growthcraft.hops.client.renderer.RenderHops;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockHops
extends GrcBlockBase
implements IBlockRope,
IPlantable,
ICropDataProvider,
IGrowable {
    public static Boolean graphicFlag;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;
    private final float hopVineGrowthRate;
    private final float hopVineFlowerSpawnRate;

    public BlockHops() {
        super(Material.field_151585_k);
        this.hopVineGrowthRate = GrowthCraftHops.getConfig().hopVineGrowthRate;
        this.hopVineFlowerSpawnRate = GrowthCraftHops.getConfig().hopVineFlowerSpawnRate;
        this.func_149675_a(true);
        this.func_149711_c(0.0f);
        this.func_149672_a(field_149779_h);
        this.func_149663_c("grc.hopVine");
        this.func_149647_a(null);
    }

    public boolean isMature(IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        return meta >= 3;
    }

    @Override
    public float getGrowthProgress(IBlockAccess world, int x, int y, int z, int meta) {
        return (float)meta / 3.0f;
    }

    protected void incrementGrowth(World world, int x, int y, int z, int meta) {
        int previousMetadata = meta++;
        world.func_72921_c(x, y, z, meta, 2);
        AppleCore.announceGrowthTick(this, world, x, y, z, previousMetadata);
    }

    public void spreadLeaves(World world, int x, int y, int z) {
        world.func_147465_d(x, y + 1, z, (Block)this, 1, 3);
    }

    public boolean canSpreadLeaves(World world, int x, int y, int z) {
        return BlockCheck.isRope(world.func_147439_a(x, y + 1, z)) && this.func_149718_j(world, x, y + 1, z);
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        if (!this.func_149718_j(world, x, y, z)) {
            world.func_147449_b(x, y, z, GrowthCraftCore.blocks.ropeBlock.getBlock());
        } else {
            Event.Result allowGrowthResult = AppleCore.validateGrowthTick(this, world, x, y, z, random);
            if (allowGrowthResult == Event.Result.DENY) {
                return;
            }
            int meta = world.func_72805_g(x, y, z);
            float f = this.getGrowthRateLoop(world, x, y, z);
            if (meta < 2) {
                if (allowGrowthResult == Event.Result.ALLOW || random.nextInt((int)(this.hopVineGrowthRate / f) + 1) == 0) {
                    this.incrementGrowth(world, x, y, z, meta);
                }
            } else if (meta >= 2 && this.canSpreadLeaves(world, x, y, z)) {
                if (allowGrowthResult == Event.Result.ALLOW || random.nextInt((int)(this.hopVineGrowthRate / f) + 1) == 0) {
                    this.spreadLeaves(world, x, y, z);
                }
            } else if (allowGrowthResult == Event.Result.ALLOW || random.nextInt((int)(this.hopVineFlowerSpawnRate / f) + 1) == 0) {
                this.incrementGrowth(world, x, y, z, meta);
            }
        }
    }

    public boolean func_149851_a(World world, int x, int y, int z, boolean isClient) {
        int meta = world.func_72805_g(x, y, z);
        return meta < 3 || this.canSpreadLeaves(world, x, y, z);
    }

    public boolean func_149852_a(World world, Random random, int x, int y, int z) {
        return true;
    }

    public void func_149853_b(World world, Random random, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        if (meta < 2) {
            this.incrementGrowth(world, x, y, z, meta);
        } else if (meta >= 2 && this.canSpreadLeaves(world, x, y, z)) {
            this.spreadLeaves(world, x, y, z);
        } else {
            this.incrementGrowth(world, x, y, z, meta);
        }
    }

    private float getGrowthRateLoop(World world, int x, int y, int z) {
        if (BlockCheck.canSustainPlant((IBlockAccess)world, x, y - 1, z, ForgeDirection.UP, this)) {
            return this.getGrowthRate(world, x, y, z);
        }
        for (int loop = 1; loop < 5; ++loop) {
            if (world.func_147439_a(x, y - loop, z) != this) {
                return this.getGrowthRate(world, x, y, z);
            }
            if (!this.isVineRoot(world, x, y - loop, z)) continue;
            return this.getGrowthRate(world, x, y - loop, z);
        }
        return this.getGrowthRate(world, x, y, z);
    }

    private float getGrowthRate(World world, int x, int y, int z) {
        Block l = world.func_147439_a(x, y, z - 1);
        Block i1 = world.func_147439_a(x, y, z + 1);
        Block j1 = world.func_147439_a(x - 1, y, z);
        Block k1 = world.func_147439_a(x + 1, y, z);
        Block l1 = world.func_147439_a(x - 1, y, z - 1);
        Block i2 = world.func_147439_a(x + 1, y, z - 1);
        Block j2 = world.func_147439_a(x + 1, y, z + 1);
        Block k2 = world.func_147439_a(x - 1, y, z + 1);
        boolean flag = j1 == this || k1 == this;
        boolean flag1 = l == this || i1 == this;
        boolean flag2 = l1 == this || i2 == this || j2 == this || k2 == this;
        float f = 1.0f;
        for (int l2 = x - 1; l2 <= x + 1; ++l2) {
            for (int i3 = z - 1; i3 <= z + 1; ++i3) {
                Block block = BlockCheck.getFarmableBlock((IBlockAccess)world, l2, y - 1, i3, ForgeDirection.UP, this);
                float f1 = 0.0f;
                if (block != null) {
                    f1 = 1.0f;
                    if (block.isFertile(world, l2, y - 1, i3)) {
                        f1 = 3.0f;
                    }
                }
                if (l2 != x || i3 != z) {
                    f1 /= 4.0f;
                }
                f += f1;
            }
        }
        if (flag2 || flag && flag1) {
            f /= 2.0f;
        }
        return f;
    }

    public void removeFruit(World world, int x, int y, int z) {
        world.func_72921_c(x, y, z, 2, 3);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int dir, float par7, float par8, float par9) {
        if (world.func_72805_g(x, y, z) >= 3) {
            if (!world.field_72995_K) {
                this.removeFruit(world, x, y, z);
                this.func_149642_a(world, x, y, z, GrowthCraftHops.items.hops.asStack(1 + world.field_73012_v.nextInt(8)));
            }
            return true;
        }
        return false;
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        if (BlockCheck.canSustainPlant((IBlockAccess)world, x, y - 1, z, ForgeDirection.UP, this)) {
            return true;
        }
        for (int loop = 1; loop < 5; ++loop) {
            if (world.func_147439_a(x, y - loop, z) != this) {
                return false;
            }
            if (!this.isVineRoot(world, x, y - loop, z)) continue;
            return true;
        }
        return false;
    }

    private boolean isVineRoot(World world, int x, int y, int z) {
        return world.func_147439_a(x, y, z) == this && BlockCheck.canSustainPlant((IBlockAccess)world, x, y - 1, z, ForgeDirection.UP, this) && world.func_72805_g(x, y, z) >= 2;
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_149694_d(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        return meta < 3 ? GrowthCraftHops.items.hopSeeds.getItem() : GrowthCraftHops.items.hops.getItem();
    }

    public boolean canSilkHarvest(World world, EntityPlayer player, int x, int y, int z, int metadata) {
        return false;
    }

    @Override
    public boolean canConnectRopeTo(IBlockAccess world, int x, int y, int z) {
        return world.func_147439_a(x, y, z) instanceof IBlockRope;
    }

    public Item func_149650_a(int meta, Random par2Random, int par3) {
        return null;
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(GrowthCraftCore.items.rope.asStack());
        if (world.func_72805_g(x, y, z) >= 2) {
            ret.add(GrowthCraftHops.items.hops.asStack(1 + world.field_73012_v.nextInt(8)));
        }
        return ret;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        this.icons = new IIcon[7];
        this.icons[0] = reg.func_94245_a("grchops:leaves");
        this.icons[1] = reg.func_94245_a("grchops:leaves_opaque");
        this.icons[2] = reg.func_94245_a("grchops:bine");
        this.icons[3] = reg.func_94245_a("grchops:leaves_hops");
        this.icons[4] = reg.func_94245_a("grccore:rope_1");
        this.icons[5] = reg.func_94245_a("grchops:leaves_x");
        this.icons[6] = reg.func_94245_a("grchops:leaves_opaque_x");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconByIndex(int index) {
        return this.icons[index];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (meta != 0) {
            graphicFlag = !Blocks.field_150362_t.func_149662_c();
            if (meta >= 3) {
                return graphicFlag != false ? this.icons[5] : this.icons[6];
            }
            return graphicFlag != false ? this.icons[0] : this.icons[1];
        }
        return this.icons[2];
    }

    public int func_149645_b() {
        return RenderHops.id;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149635_D() {
        double d0 = 0.5;
        double d1 = 1.0;
        return ColorizerFoliage.func_77470_a((double)0.5, (double)1.0);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149741_i(int meta) {
        return ColorizerFoliage.func_77468_c();
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        int r = 0;
        int g = 0;
        int b = 0;
        for (int l1 = -1; l1 <= 1; ++l1) {
            for (int i2 = -1; i2 <= 1; ++i2) {
                int j2 = world.func_72807_a(x + i2, z + l1).func_150571_c(x + i2, y, z + l1);
                r += (j2 & 0xFF0000) >> 16;
                g += (j2 & 0xFF00) >> 8;
                b += j2 & 0xFF;
            }
        }
        return (r / 9 & 0xFF) << 16 | (g / 9 & 0xFF) << 8 | b / 9 & 0xFF;
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB aabb, List list, Entity entity) {
        boolean flag = this.canConnectRopeTo((IBlockAccess)world, x, y, z - 1);
        boolean flag1 = this.canConnectRopeTo((IBlockAccess)world, x, y, z + 1);
        boolean flag2 = this.canConnectRopeTo((IBlockAccess)world, x - 1, y, z);
        boolean flag3 = this.canConnectRopeTo((IBlockAccess)world, x + 1, y, z);
        boolean flag4 = this.canConnectRopeTo((IBlockAccess)world, x, y - 1, z);
        boolean flag5 = this.canConnectRopeTo((IBlockAccess)world, x, y + 1, z);
        float f = 0.4375f;
        float f1 = 0.5625f;
        float f2 = 0.4375f;
        float f3 = 0.5625f;
        float f4 = 0.4375f;
        float f5 = 0.5625f;
        if (flag) {
            f2 = 0.0f;
        }
        if (flag1) {
            f3 = 1.0f;
        }
        if (flag || flag1) {
            this.func_149676_a(f, f4, f2, f1, f5, f3);
            super.func_149743_a(world, x, y, z, aabb, list, entity);
        }
        f2 = 0.4375f;
        f3 = 0.5625f;
        if (flag2) {
            f = 0.0f;
        }
        if (flag3) {
            f1 = 1.0f;
        }
        if (flag2 || flag3) {
            this.func_149676_a(f, f4, f2, f1, f5, f3);
            super.func_149743_a(world, x, y, z, aabb, list, entity);
        }
        f = 0.4375f;
        f1 = 0.5625f;
        if (flag4) {
            f4 = 0.0f;
        }
        if (flag5) {
            f5 = 1.0f;
        }
        if (flag4 || flag5) {
            this.func_149676_a(f, f4, f2, f1, f5, f3);
            super.func_149743_a(world, x, y, z, aabb, list, entity);
        }
        this.func_149719_a((IBlockAccess)world, x, y, z);
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        float f = 0.0625f;
        switch (meta) {
            case 0: {
                this.func_149676_a(0.375f, 0.0f, 0.375f, 0.625f, 0.3125f, 0.625f);
                break;
            }
            case 1: {
                this.func_149676_a(0.25f, 0.0f, 0.25f, 0.75f, 0.5f, 0.75f);
                break;
            }
            default: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }

    public EnumPlantType getPlantType(IBlockAccess world, int x, int y, int z) {
        return EnumPlantType.Crop;
    }

    public Block getPlant(IBlockAccess world, int x, int y, int z) {
        return this;
    }

    public int getPlantMetadata(IBlockAccess world, int x, int y, int z) {
        return world.func_72805_g(x, y, z);
    }

    public static class HopsStage {
        public static final int BINE = 0;
        public static final int SMALL = 1;
        public static final int BIG = 2;
        public static final int FRUIT = 3;

        private HopsStage() {
        }
    }
}

