/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.client.render;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import growthcraft.api.core.util.BBox;
import growthcraft.api.core.util.ColorUtils;
import growthcraft.milk.client.resource.GrcMilkResources;
import growthcraft.milk.common.block.BlockPancheon;
import growthcraft.milk.common.tileentity.TileEntityPancheon;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class RenderPancheon
implements ISimpleBlockRenderingHandler {
    public static int RENDER_ID = RenderingRegistry.getNextAvailableRenderId();
    private static final BBox fluidBBox = BBox.newCube(1.0f, 1.0f, 1.0f, 14.0f, 4.0f, 14.0f).scale(0.0625f);

    public int getRenderId() {
        return RENDER_ID;
    }

    public boolean shouldRender3DInInventory(int modelID) {
        return true;
    }

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
        if (modelID == RENDER_ID) {
            GL11.glPushMatrix();
            Minecraft.func_71410_x().field_71446_o.func_110577_a(GrcMilkResources.INSTANCE.texturePancheon);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)-1.0f, (float)0.0f);
            GrcMilkResources.INSTANCE.modelPancheon.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
            GL11.glPopMatrix();
        }
    }

    private void renderFluidLayer(Block block, RenderBlocks renderer, Fluid fluid, double y0, double y1, int x, int y, int z) {
        if (fluid == null) {
            return;
        }
        float[] colorAry = new float[3];
        int color = fluid.getColor();
        ColorUtils.rgb24FloatArray(colorAry, color);
        Tessellator.field_78398_a.func_78386_a(colorAry[0], colorAry[1], colorAry[2]);
        renderer.func_147782_a((double)fluidBBox.x0(), y0, (double)fluidBBox.z0(), (double)fluidBBox.x1(), y1, (double)fluidBBox.z1());
        renderer.func_147806_b(block, (double)x, (double)y, (double)z, fluid.getIcon());
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        BlockPancheon pancheonBlock;
        TileEntityPancheon pancheonTile;
        if (modelId == RENDER_ID && block instanceof BlockPancheon && (pancheonTile = (TileEntityPancheon)(pancheonBlock = (BlockPancheon)block).getTileEntity(world, x, y, z)) != null) {
            float fluidHeight;
            double y0 = 0.0625;
            FluidStack fluid = pancheonTile.getFluidStack(0);
            if (fluid != null) {
                fluidHeight = (float)fluid.amount * fluidBBox.h() / (float)pancheonTile.getFluidTank(0).getCapacity();
                this.renderFluidLayer(block, renderer, fluid.getFluid(), y0, y0 + (double)fluidHeight, x, y, z);
            }
            if ((fluid = pancheonTile.getFluidStack(1)) != null) {
                fluidHeight = (float)fluid.amount * fluidBBox.h() / (float)pancheonTile.getFluidTank(1).getCapacity();
                this.renderFluidLayer(block, renderer, fluid.getFluid(), y0, y0 + (double)fluidHeight, x, y, z);
                y0 += (double)fluidHeight;
            }
            if ((fluid = pancheonTile.getFluidStack(2)) != null) {
                fluidHeight = (float)fluid.amount * fluidBBox.h() / (float)pancheonTile.getFluidTank(2).getCapacity();
                this.renderFluidLayer(block, renderer, fluid.getFluid(), y0, y0 + (double)fluidHeight, x, y, z);
            }
        }
        return true;
    }
}

