/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.common.struct;

import growthcraft.api.core.stream.IStreamable;
import growthcraft.milk.GrowthCraftMilk;
import growthcraft.milk.common.item.EnumCheeseStage;
import growthcraft.milk.common.item.EnumCheeseType;
import io.netty.buffer.ByteBuf;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;

public class Cheese
implements IStreamable {
    public boolean needClientUpdate = true;
    private int ageMax;
    private int age;
    private int slicesMax;
    private int slices;
    private final int cheesePerSlice;
    private EnumCheeseType cheese;
    private EnumCheeseStage cheeseStage;

    public Cheese() {
        this.ageMax = GrowthCraftMilk.getConfig().cheeseMaxAge;
        this.slicesMax = GrowthCraftMilk.getConfig().cheeseMaxSlices;
        this.slices = GrowthCraftMilk.getConfig().cheeseMaxSlices;
        this.cheesePerSlice = GrowthCraftMilk.getConfig().cheeseItemPerBlockSlice;
        this.cheese = EnumCheeseType.CHEDDAR;
        this.cheeseStage = EnumCheeseType.CHEDDAR.stages.get(0);
    }

    public EnumCheeseType getType() {
        return this.cheese;
    }

    public EnumCheeseStage getStage() {
        return this.cheeseStage;
    }

    public Cheese setStage(EnumCheeseStage stage) {
        this.cheeseStage = stage;
        this.needClientUpdate = true;
        return this;
    }

    public int getId() {
        return this.cheese.meta;
    }

    public int getStageId() {
        return this.cheeseStage.index;
    }

    public int getSlices() {
        return this.slices;
    }

    public int getSlicesMax() {
        return this.slicesMax;
    }

    public boolean hasSlices() {
        return this.getSlices() > 0;
    }

    public float getAgeProgress() {
        return (float)this.age / (float)this.ageMax;
    }

    public boolean canAge() {
        return this.cheeseStage == EnumCheeseStage.UNAGED;
    }

    public boolean isAged() {
        return this.cheeseStage == EnumCheeseStage.AGED || this.cheeseStage == EnumCheeseStage.CUT;
    }

    public boolean isUnwaxed() {
        return this.cheeseStage == EnumCheeseStage.UNWAXED;
    }

    public ItemStack yankSlices(int count, boolean doYank) {
        int yankedCount = MathHelper.func_76125_a((int)count, (int)0, (int)this.getSlices());
        int quantity = yankedCount * this.cheesePerSlice;
        if (quantity > 0) {
            if (doYank) {
                this.slices -= yankedCount;
                this.setStage(EnumCheeseStage.CUT);
            }
            return this.cheese.asStack(quantity);
        }
        return null;
    }

    public ItemStack asFullStack() {
        return this.yankSlices(this.getSlices(), false);
    }

    public boolean tryWaxing(ItemStack stack) {
        if (this.isUnwaxed() && this.getType().canWax(stack)) {
            this.setStage(EnumCheeseStage.UNAGED);
            return true;
        }
        return false;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        this.cheese.writeToNBT(nbt);
        this.cheeseStage.writeToNBT(nbt);
        nbt.func_74768_a("age", this.age);
        nbt.func_74768_a("slices", this.slices);
        nbt.func_74768_a("slices_max", this.slicesMax);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.cheese = EnumCheeseType.loadFromNBT(nbt);
        this.cheeseStage = EnumCheeseStage.loadFromNBT(nbt);
        if (nbt.func_74764_b("age")) {
            this.age = nbt.func_74762_e("age");
        }
        if (nbt.func_74764_b("slices")) {
            this.slices = nbt.func_74762_e("slices");
        }
        if (nbt.func_74764_b("slices_max")) {
            this.slicesMax = nbt.func_74762_e("slices_max");
        }
    }

    @Override
    public boolean readFromStream(ByteBuf stream) {
        this.cheese = EnumCheeseType.loadFromStream(stream);
        this.cheeseStage = EnumCheeseStage.loadFromStream(stream);
        this.age = stream.readInt();
        this.slices = stream.readInt();
        this.slicesMax = stream.readInt();
        return false;
    }

    @Override
    public boolean writeToStream(ByteBuf stream) {
        this.cheese.writeToStream(stream);
        this.cheeseStage.writeToStream(stream);
        stream.writeInt(this.age);
        stream.writeInt(this.slices);
        stream.writeInt(this.slicesMax);
        return false;
    }

    public void update() {
        if (!this.isAged() && this.canAge()) {
            if (this.age < this.ageMax) {
                ++this.age;
            } else {
                this.setStage(EnumCheeseStage.AGED);
            }
        }
    }
}

