/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.init;

import cpw.mods.fml.common.registry.GameRegistry;
import growthcraft.api.core.fluids.TaggedFluidStacks;
import growthcraft.api.core.item.CommonItemStackComparator;
import growthcraft.api.core.item.IItemStackComparator;
import growthcraft.api.core.item.OreItemStacks;
import growthcraft.api.milk.MilkRegistry;
import growthcraft.api.milk.cheesepress.ICheesePressRecipe;
import growthcraft.api.milk.util.CheeseVatRecipeBuilder;
import growthcraft.cellar.GrowthCraftCellar;
import growthcraft.core.common.GrcModuleBase;
import growthcraft.core.common.item.crafting.ShapelessItemComparableRecipe;
import growthcraft.milk.GrowthCraftMilk;
import growthcraft.milk.common.item.EnumCheeseType;
import growthcraft.milk.common.item.ItemBlockHangingCurds;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class GrcMilkRecipes
extends GrcModuleBase {
    private void registerCraftingRecipes() {
        int ricottaBowlCount = GrowthCraftMilk.getConfig().ricottaBowlCount;
        ArrayList<ItemStack> ricottaBowlRecipe = new ArrayList<ItemStack>();
        ricottaBowlRecipe.add(EnumCheeseType.RICOTTA.asCurdItemStack());
        for (int i = 0; i < ricottaBowlCount; ++i) {
            ricottaBowlRecipe.add(new ItemStack(Items.field_151054_z, 1));
        }
        GameRegistry.addRecipe((IRecipe)new ShapelessItemComparableRecipe(new DriedCurdComparator(), EnumCheeseType.RICOTTA.asStack(ricottaBowlCount), ricottaBowlRecipe));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(GrowthCraftMilk.blocks.cheeseVat.asStack(), new Object[]{GrowthCraftCellar.blocks.brewKettle.asStack()}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(GrowthCraftMilk.blocks.butterChurn.asStack(), new Object[]{" S ", "P P", "PPP", Character.valueOf('S'), "stickWood", Character.valueOf('P'), "plankWood"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(GrowthCraftMilk.blocks.cheesePress.asStack(), new Object[]{"iii", "iCi", "ppp", Character.valueOf('i'), "ingotIron", Character.valueOf('C'), Blocks.field_150486_ae, Character.valueOf('p'), "slabWood"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(GrowthCraftMilk.blocks.pancheon.asStack(), new Object[]{"c c", "ccc", Character.valueOf('c'), Items.field_151119_aD}));
    }

    private void registerCheeseVatRecipes() {
        String[] saltOres;
        for (String saltOre : saltOres = new String[]{"foodSalt", "materialSalt", "dustSalt"}) {
            CheeseVatRecipeBuilder.buildRecipe("CHEDDAR Orange Dye Recipe").outputFluids(EnumCheeseType.CHEDDAR.asFluidStack(5000)).inputFluids(new TaggedFluidStacks(5000, "milk_curds")).inputItems(new OreItemStacks(saltOre, 1), new OreItemStacks("dyeOrange", 1)).register();
            CheeseVatRecipeBuilder.buildRecipe("CHEDDAR Pumpkin Recipe").outputFluids(EnumCheeseType.CHEDDAR.asFluidStack(5000)).inputFluids(new TaggedFluidStacks(5000, "milk_curds")).inputItems(new OreItemStacks(saltOre, 1), new ItemStack(Blocks.field_150423_aK)).register();
            CheeseVatRecipeBuilder.buildRecipe("GORGONZOLA Recipe").outputFluids(EnumCheeseType.GORGONZOLA.asFluidStack(5000)).inputFluids(new TaggedFluidStacks(5000, "milk_curds")).inputItems(new OreItemStacks(saltOre, 1), new OreItemStacks("foodFruit", 1)).register();
            CheeseVatRecipeBuilder.buildRecipe("EMMENTALER Recipe").outputFluids(EnumCheeseType.EMMENTALER.asFluidStack(5000)).inputFluids(new TaggedFluidStacks(5000, "milk_curds")).inputItems(new OreItemStacks(saltOre, 1), new OreItemStacks("cropWheat", 1)).register();
            CheeseVatRecipeBuilder.buildRecipe("APPENZELLER Wine Recipe").outputFluids(EnumCheeseType.APPENZELLER.asFluidStack(5000)).inputFluids(new TaggedFluidStacks(5000, "milk_curds"), new TaggedFluidStacks(1000, "wine")).inputItems(new OreItemStacks(saltOre, 1)).register();
            CheeseVatRecipeBuilder.buildRecipe("APPENZELLER Cider Recipe").outputFluids(EnumCheeseType.APPENZELLER.asFluidStack(5000)).inputFluids(new TaggedFluidStacks(5000, "milk_curds"), new TaggedFluidStacks(1000, "cider")).inputItems(new OreItemStacks(saltOre, 1)).register();
            CheeseVatRecipeBuilder.buildRecipe("ASIAGO Recipe").outputFluids(EnumCheeseType.ASIAGO.asFluidStack(5000)).inputFluids(new TaggedFluidStacks(5000, "milk_curds")).inputItems(new OreItemStacks(saltOre, 1), new OreItemStacks(saltOre, 1), new OreItemStacks("dyeYellow", 1)).register();
            CheeseVatRecipeBuilder.buildRecipe("PARMESAN Recipe").outputFluids(EnumCheeseType.PARMESAN.asFluidStack(5000)).inputFluids(new TaggedFluidStacks(5000, "milk_curds")).inputItems(new OreItemStacks(saltOre, 1), new OreItemStacks("dyeWhite", 1)).register();
            CheeseVatRecipeBuilder.buildRecipe("MONTEREY Recipe").outputFluids(EnumCheeseType.MONTEREY.asFluidStack(5000)).inputFluids(new TaggedFluidStacks(5000, "milk_curds")).inputItems(new OreItemStacks(saltOre, 1), new OreItemStacks("dyeRed", 1)).register();
        }
    }

    private void registerCheesePressRecipes() {
        for (EnumCheeseType type : EnumCheeseType.VALUES) {
            if (!type.hasBlock() || !type.hasCurdBlock()) continue;
            MilkRegistry.instance().cheesePress().addRecipe(new DriedCurdsCheesePressRecipe(type.asCurdItemStack(), type.asBlockItemStack(), 200));
        }
    }

    private void registerCheeseWaxes() {
        EnumCheeseType.CHEDDAR.waxes.add(new OreItemStacks("materialBeeswaxRed", 1));
        EnumCheeseType.MONTEREY.waxes.add(new OreItemStacks("materialBeeswaxBlack", 1));
    }

    @Override
    public void init() {
        this.registerCraftingRecipes();
        this.registerCheeseVatRecipes();
        this.registerCheesePressRecipes();
        this.registerCheeseWaxes();
    }

    public static class DriedCurdsCheesePressRecipe
    implements ICheesePressRecipe {
        private ItemStack inputStack;
        private ItemStack outputStack;
        private int time;

        public DriedCurdsCheesePressRecipe(@Nonnull ItemStack pInputStack, @Nonnull ItemStack pOutputStack, int pTime) {
            this.inputStack = pInputStack;
            this.outputStack = pOutputStack;
            this.time = pTime;
        }

        @Override
        public ItemStack getInputItemStack() {
            return this.inputStack;
        }

        @Override
        public ItemStack getOutputItemStack() {
            return this.outputStack;
        }

        @Override
        public int getTimeMax() {
            return this.time;
        }

        @Override
        public boolean isMatchingRecipe(@Nonnull ItemStack stack) {
            if (this.inputStack.func_77969_a(stack) && stack.field_77994_a >= this.inputStack.field_77994_a && stack.func_77973_b() instanceof ItemBlockHangingCurds) {
                ItemBlockHangingCurds item = (ItemBlockHangingCurds)stack.func_77973_b();
                return item.isDried(stack);
            }
            return false;
        }

        public String toString() {
            return String.format("DriedCurdsCheesePressRecipe({%s} / %d = {%s})", this.getOutputItemStack(), this.time, this.getInputItemStack());
        }
    }

    public static class DriedCurdComparator
    implements IItemStackComparator {
        private CommonItemStackComparator common = new CommonItemStackComparator();

        @Override
        public boolean equals(ItemStack expected, ItemStack actual) {
            if (expected.func_77973_b() instanceof ItemBlockHangingCurds) {
                if (actual.func_77973_b() instanceof ItemBlockHangingCurds) {
                    ItemBlockHangingCurds actualCurd = (ItemBlockHangingCurds)actual.func_77973_b();
                    ItemBlockHangingCurds expectedCurd = (ItemBlockHangingCurds)expected.func_77973_b();
                    if (expectedCurd.getCheeseType(expected) == actualCurd.getCheeseType(actual) && actualCurd.isDried(actual)) {
                        return true;
                    }
                }
                return false;
            }
            return this.common.equals(expected, actual);
        }
    }
}

