/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.object;

import com.mrcrayfish.guns.entity.EntityProjectile;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class Bullet {
    private EntityProjectile projectile;
    private int entityId;
    private double posX;
    private double posY;
    private double posZ;
    private double motionX;
    private double motionY;
    private double motionZ;
    private float rotationYaw;
    private float rotationPitch;
    private boolean finished = false;
    private int trailColor;
    private double trailLengthMultiplier;

    public Bullet(@Nullable EntityProjectile projectile, int entityId, double posX, double posY, double posZ, double motionX, double motionY, double motionZ, int trailColor, double trailLengthMultiplier) {
        this.projectile = projectile;
        this.entityId = entityId;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.motionX = motionX;
        this.motionY = motionY;
        this.motionZ = motionZ;
        this.trailColor = trailColor;
        this.trailLengthMultiplier = trailLengthMultiplier;
        this.updateHeading();
    }

    private void updateHeading() {
        float d = MathHelper.func_76133_a((double)(this.motionX * this.motionX + this.motionZ * this.motionZ));
        this.rotationYaw = (float)(MathHelper.func_181159_b((double)this.motionX, (double)this.motionZ) * 57.29577951308232);
        this.rotationPitch = (float)(MathHelper.func_181159_b((double)this.motionY, (double)d) * 57.29577951308232);
    }

    public void tick(World world) {
        if (this.projectile == null) {
            Entity entity = world.func_73045_a(this.entityId);
            if (entity instanceof EntityProjectile) {
                this.projectile = (EntityProjectile)entity;
            }
        } else if (this.projectile.field_70128_L) {
            this.finished = true;
        } else {
            this.posX += this.motionX;
            this.posY += this.motionY;
            this.posZ += this.motionZ;
            if (this.projectile.getProjectile().gravity) {
                this.motionY -= 0.05;
                this.updateHeading();
            }
        }
    }

    public EntityProjectile getProjectile() {
        return this.projectile;
    }

    public double getPosX() {
        return this.posX;
    }

    public double getPosY() {
        return this.posY;
    }

    public double getPosZ() {
        return this.posZ;
    }

    public double getMotionX() {
        return this.motionX;
    }

    public double getMotionY() {
        return this.motionY;
    }

    public double getMotionZ() {
        return this.motionZ;
    }

    public float getRotationYaw() {
        return this.rotationYaw;
    }

    public float getRotationPitch() {
        return this.rotationPitch;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public int getTrailColor() {
        return this.trailColor;
    }

    public double getTrailLengthMultiplier() {
        return this.trailLengthMultiplier;
    }
}

