/*
 * Decompiled with CFR 0.152.
 */
package com.lazynessmind.horsemodifiers.configs;

import java.io.File;
import java.util.ArrayList;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class Configs {
    private static Configuration config = null;
    public static final String CATEGORY_NAME_ITEMS = "items";
    public static final String CATEGORY_NAME_FEATURE = "feature";
    public static double jumpAddValue;
    public static double healthyAddValue;
    public static double flashAddValue;
    public static boolean showUpdateMessage;

    public static void preInit() {
        File configFile = new File(Loader.instance().getConfigDir(), "horsemodifiers.cfg");
        config = new Configuration(configFile);
        Configs.syncFromFiles();
    }

    public static Configuration getConfig() {
        return config;
    }

    public static void clientPreInit() {
        MinecraftForge.EVENT_BUS.register((Object)new ConfigEventHandler());
    }

    public static void syncFromFiles() {
        Configs.syncConfig(true, true);
    }

    public static void syncFromGui() {
        Configs.syncConfig(false, true);
    }

    public static void syncFromFields() {
        Configs.syncConfig(false, false);
    }

    private static void syncConfig(boolean loadFromConfigFile, boolean readFieldsFromConfig) {
        if (loadFromConfigFile) {
            config.load();
        }
        Configs.setItemsConfigs(readFieldsFromConfig);
        Configs.setFeatureConfigs(readFieldsFromConfig);
        if (config.hasChanged()) {
            config.save();
        }
    }

    private static void setItemsConfigs(boolean readFieldsFromConfig) {
        Property flashCarrot = config.get(CATEGORY_NAME_ITEMS, "flashCarrotValue", 0.1);
        flashCarrot.setLanguageKey("gui.config.items.flashCarrotValue.name");
        flashCarrot.setComment(I18n.func_135052_a((String)"gui.config.items.flashCarrotValue.comment", (Object[])new Object[0]));
        flashCarrot.setMinValue(0.1);
        flashCarrot.setMaxValue(1.0);
        Property healthyCarrot = config.get(CATEGORY_NAME_ITEMS, "healthyCarrotValue", 2.0);
        healthyCarrot.setLanguageKey("gui.config.items.healthyCarrotValue.name");
        healthyCarrot.setComment(I18n.func_135052_a((String)"gui.config.items.healthyCarrotValue.comment", (Object[])new Object[0]));
        healthyCarrot.setMinValue(0.5);
        healthyCarrot.setMaxValue(20.0);
        Property jumpCarrot = config.get(CATEGORY_NAME_ITEMS, "jumpCarrotValue", 0.1);
        jumpCarrot.setLanguageKey("gui.config.items.jumpCarrotValue.name");
        jumpCarrot.setComment(I18n.func_135052_a((String)"gui.config.items.jumpCarrotValue.comment", (Object[])new Object[0]));
        jumpCarrot.setMinValue(0.1);
        jumpCarrot.setMaxValue(1.0);
        ArrayList<String> propertyOrderItems = new ArrayList<String>();
        propertyOrderItems.add(flashCarrot.getName());
        propertyOrderItems.add(healthyCarrot.getName());
        propertyOrderItems.add(jumpCarrot.getName());
        config.setCategoryPropertyOrder(CATEGORY_NAME_ITEMS, propertyOrderItems);
        if (readFieldsFromConfig) {
            flashAddValue = flashCarrot.getDouble();
            healthyAddValue = healthyCarrot.getDouble();
            jumpAddValue = jumpCarrot.getDouble();
        }
        flashCarrot.set(flashAddValue);
        healthyCarrot.set(healthyAddValue);
        jumpCarrot.set(jumpAddValue);
    }

    private static void setFeatureConfigs(boolean readFieldsFromConfig) {
        Property showUpdateMessageProp = config.get(CATEGORY_NAME_FEATURE, "show_update_message", true);
        showUpdateMessageProp.setLanguageKey("gui.config.features.showUpdateMessage.name");
        showUpdateMessageProp.setComment(I18n.func_135052_a((String)"gui.config.features.showUpdateMessage.comment", (Object[])new Object[0]));
        ArrayList<String> propertyOrderFeatures = new ArrayList<String>();
        propertyOrderFeatures.add(showUpdateMessageProp.getName());
        config.setCategoryPropertyOrder(CATEGORY_NAME_ITEMS, propertyOrderFeatures);
        if (readFieldsFromConfig) {
            showUpdateMessage = showUpdateMessageProp.getBoolean();
        }
        showUpdateMessageProp.set(showUpdateMessage);
    }

    public static class ConfigEventHandler {
        @SubscribeEvent(priority=EventPriority.LOWEST)
        public void onEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("horsemodifiers")) {
                Configs.syncFromGui();
            }
        }
    }
}

