/*
 * Decompiled with CFR 0.152.
 */
package com.lazynessmind.horsemodifier.common.items;

import com.lazynessmind.horsemodifier.common.horsedata.HorsesData;
import com.lazynessmind.horsemodifier.common.items.ModItem;
import com.lazynessmind.horsemodifier.common.util.ItemHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.horse.HorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.apache.commons.lang3.reflect.FieldUtils;

public class HorseSpy
extends ModItem {
    private static final String TAG_CURRENT_MODE = "CurrentMode";
    public int currentMode = 0;

    public HorseSpy() {
        super("horsespy");
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag tooltipFlag) {
        super.func_77624_a(stack, world, list, tooltipFlag);
        list.add(new TranslationTextComponent("translation.horsespy.tooltip.one", new Object[0]).func_211708_a(TextFormatting.GOLD));
        list.add(new TranslationTextComponent("translation.horsespy.tooltip.two", new Object[0]).func_211708_a(TextFormatting.RED));
    }

    public boolean func_111207_a(ItemStack stack, PlayerEntity player, LivingEntity entity, Hand hand) {
        if (!player.field_70170_p.field_72995_K && entity instanceof HorseEntity) {
            HorseEntity horseEntity = (HorseEntity)entity;
            if (horseEntity.func_110248_bS()) {
                this.createTag(stack);
                if (stack.func_77978_p() != null) {
                    if (stack.func_77978_p().func_74762_e(TAG_CURRENT_MODE) == 0) {
                        this.displayHorseStats(horseEntity, player);
                    } else if (stack.func_77978_p().func_74762_e(TAG_CURRENT_MODE) == 1) {
                        this.removeUpgrade(0, "translation.horsespy.message.speed", player, horseEntity);
                    } else if (stack.func_77978_p().func_74762_e(TAG_CURRENT_MODE) == 2) {
                        this.removeUpgrade(1, "translation.horsespy.message.jump", player, horseEntity);
                    } else if (stack.func_77978_p().func_74762_e(TAG_CURRENT_MODE) == 3) {
                        this.removeUpgrade(2, "translation.horsespy.message.health", player, horseEntity);
                    }
                }
            } else {
                player.func_145747_a(new TranslationTextComponent("translation.horsespy.message.tame", new Object[0]).func_211708_a(TextFormatting.RED));
            }
        }
        return true;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        if (!context.func_195991_k().field_72995_K && context.func_195999_j().func_70093_af()) {
            this.currentMode = this.currentMode < 3 ? ++this.currentMode : 0;
            this.createTag(context.func_195996_i());
            if (context.func_195996_i().func_77978_p() != null) {
                context.func_195996_i().func_77978_p().func_74768_a(TAG_CURRENT_MODE, this.currentMode);
            }
            this.sendStatusFromMode(this.currentMode, context.func_195999_j());
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    private void createTag(ItemStack stack) {
        if (!stack.func_77942_o()) {
            CompoundNBT data = new CompoundNBT();
            data.func_74768_a(TAG_CURRENT_MODE, this.currentMode);
            stack.func_77982_d(data);
        }
    }

    private void displayHorseStats(HorseEntity horseEntity, PlayerEntity player) {
        float speed = (float)horseEntity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e();
        float jump = 0.0f;
        try {
            jump = (float)horseEntity.func_110148_a((IAttribute)FieldUtils.readField((Object)horseEntity, (String)"JUMP_STRENGTH", (boolean)true)).func_111126_e();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        float health = (float)horseEntity.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111126_e();
        player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.DARK_PURPLE + "===================="));
        player.func_145747_a(new TranslationTextComponent("translation.horsespy.message.status.speed", new Object[0]).func_150258_a(String.valueOf(speed)));
        player.func_145747_a(new TranslationTextComponent("translation.horsespy.message.status.jump", new Object[0]).func_150258_a(String.valueOf(jump)));
        player.func_145747_a(new TranslationTextComponent("translation.horsespy.message.status.health", new Object[0]).func_150258_a(String.valueOf(health)));
        player.func_145747_a(new TranslationTextComponent("translation.horsespy.message.status.speedcount", new Object[0]).func_150258_a(String.valueOf(HorsesData.getSpeed(horseEntity))));
        player.func_145747_a(new TranslationTextComponent("translation.horsespy.message.status.jumpcount", new Object[0]).func_150258_a(String.valueOf(HorsesData.getJump(horseEntity))));
        player.func_145747_a(new TranslationTextComponent("translation.horsespy.message.status.healthcount", new Object[0]).func_150258_a(String.valueOf(HorsesData.getHealth(horseEntity))));
        player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.DARK_PURPLE + "===================="));
    }

    private void sendStatusFromMode(int id, PlayerEntity playerEntity) {
        switch (id) {
            case 0: {
                playerEntity.func_146105_b((ITextComponent)new TranslationTextComponent("translation.horsespy.message.mode.one", new Object[0]), true);
                break;
            }
            case 1: {
                playerEntity.func_146105_b((ITextComponent)new TranslationTextComponent("translation.horsespy.message.mode.two", new Object[0]), true);
                break;
            }
            case 2: {
                playerEntity.func_146105_b((ITextComponent)new TranslationTextComponent("translation.horsespy.message.mode.three", new Object[0]), true);
                break;
            }
            case 3: {
                playerEntity.func_146105_b((ITextComponent)new TranslationTextComponent("translation.horsespy.message.mode.four", new Object[0]), true);
            }
        }
    }

    private void removeUpgrade(int id, String succMessage, PlayerEntity playerEntity, HorseEntity horseEntity) {
        if (HorsesData.getValueById(id, horseEntity) - 1 >= 0) {
            HorsesData.setValueById(id, horseEntity, HorsesData.getValueById(id, horseEntity) - 1);
            HorsesData.setAttrValueById(id, horseEntity);
            ItemEntity itementity = new ItemEntity(playerEntity.field_70170_p, playerEntity.field_70165_t, playerEntity.field_70163_u + 1.0, playerEntity.field_70161_v, ItemHelper.getStackFromItem(HorsesData.getItemById(id, horseEntity)));
            itementity.func_174869_p();
            playerEntity.field_70170_p.func_217376_c((Entity)itementity);
            playerEntity.func_145747_a(new TranslationTextComponent(succMessage, new Object[0]).func_150258_a(String.valueOf(HorsesData.getValueById(id, horseEntity))));
        } else {
            playerEntity.func_145747_a(new TranslationTextComponent("translation.horsespy.message.failmodifier", new Object[0]).func_211708_a(TextFormatting.RED));
        }
    }
}

