/*
 * Decompiled with CFR 0.152.
 */
package com.lazynessmind.horsemodifier.horsedata;

import com.lazynessmind.horsemodifier.Configs;
import com.lazynessmind.horsemodifier.items.ModItems;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.passive.horse.HorseEntity;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public class HorsesData {
    public static final String TAG = "HM";
    public static final String TAG_SPEED = "Speed";
    public static final String TAG_JUMP = "Jump";
    public static final String TAG_HEALTH = "Health";

    public static void saveNewDataToHorse(HorseEntity entity) {
        CompoundNBT compoundNBT = new CompoundNBT();
        compoundNBT.func_74768_a(TAG_SPEED, 0);
        compoundNBT.func_74768_a(TAG_JUMP, 0);
        compoundNBT.func_74768_a(TAG_HEALTH, 0);
        entity.getPersistentData().func_218657_a(TAG, (INBT)compoundNBT);
    }

    public static void saveDataToHorse(HorseEntity entity, int speed, int jump, int health) {
        CompoundNBT compoundNBT = entity.getPersistentData().func_74775_l(TAG);
        compoundNBT.func_74768_a(TAG_SPEED, speed);
        compoundNBT.func_74768_a(TAG_JUMP, jump);
        compoundNBT.func_74768_a(TAG_HEALTH, health);
        entity.getPersistentData().func_218657_a(TAG, (INBT)compoundNBT);
    }

    public static CompoundNBT getData(HorseEntity entity) {
        return entity.getPersistentData().func_74775_l(TAG);
    }

    public static int getSpeed(HorseEntity entity) {
        return HorsesData.getData(entity).func_74762_e(TAG_SPEED);
    }

    public static int getJump(HorseEntity entity) {
        return HorsesData.getData(entity).func_74762_e(TAG_JUMP);
    }

    public static int getHealth(HorseEntity entity) {
        return HorsesData.getData(entity).func_74762_e(TAG_HEALTH);
    }

    public static void setSpeed(HorseEntity horseEntity, int newValue) {
        HorsesData.saveDataToHorse(horseEntity, newValue, HorsesData.getJump(horseEntity), HorsesData.getHealth(horseEntity));
    }

    public static void setJump(HorseEntity horseEntity, int newValue) {
        HorsesData.saveDataToHorse(horseEntity, HorsesData.getSpeed(horseEntity), newValue, HorsesData.getHealth(horseEntity));
    }

    public static void setHealth(HorseEntity horseEntity, int newValue) {
        HorsesData.saveDataToHorse(horseEntity, HorsesData.getSpeed(horseEntity), HorsesData.getJump(horseEntity), newValue);
    }

    public static double getAttrValue(HorseEntity entity, int index) {
        switch (index) {
            case 0: {
                return entity.func_110148_a(Attributes.field_233821_d_).func_111126_e();
            }
            case 1: {
                return entity.func_110148_a(Attributes.field_233830_m_).func_111126_e();
            }
            case 2: {
                return entity.func_110148_a(Attributes.field_233818_a_).func_111126_e();
            }
        }
        return 6.9;
    }

    public static void increaseAttrValue(HorseEntity entity, int index) {
        switch (index) {
            case 0: {
                entity.func_110148_a(Attributes.field_233821_d_).func_111128_a(HorsesData.getAttrValue(entity, 0) + (Double)Configs.CARROT_SPEED_ADD_VALUE.get());
                break;
            }
            case 1: {
                entity.func_110148_a(Attributes.field_233830_m_).func_111128_a(HorsesData.getAttrValue(entity, 1) + (Double)Configs.CARROT_JUMP_ADD_VALUE.get());
                break;
            }
            case 2: {
                entity.func_110148_a(Attributes.field_233818_a_).func_111128_a(HorsesData.getAttrValue(entity, 2) + (Double)Configs.CARROT_HEALTH_ADD_VALUE.get());
            }
        }
    }

    public static void setValueFromItem(Item item, HorseEntity entity) {
        if (item == ModItems.FLASH_CARROT.get()) {
            entity.func_110148_a(Attributes.field_233821_d_).func_111128_a(HorsesData.getAttrValue(entity, 0) - (Double)Configs.CARROT_SPEED_ADD_VALUE.get());
        } else if (item == ModItems.JUMP_CARROT.get()) {
            entity.func_110148_a(Attributes.field_233830_m_).func_111128_a(HorsesData.getAttrValue(entity, 1) - (Double)Configs.CARROT_JUMP_ADD_VALUE.get());
        } else if (item == ModItems.HEALTH_CARROT.get()) {
            entity.func_110148_a(Attributes.field_233818_a_).func_111128_a(HorsesData.getAttrValue(entity, 2) - (Double)Configs.CARROT_HEALTH_ADD_VALUE.get());
        }
    }

    public static int getValueById(int id, HorseEntity entity) {
        switch (id) {
            case 0: {
                return HorsesData.getSpeed(entity);
            }
            case 1: {
                return HorsesData.getJump(entity);
            }
            case 2: {
                return HorsesData.getHealth(entity);
            }
        }
        return 0;
    }

    public static void setValueById(int id, HorseEntity entity, int value) {
        switch (id) {
            case 0: {
                HorsesData.setSpeed(entity, value);
                break;
            }
            case 1: {
                HorsesData.setJump(entity, value);
                break;
            }
            case 2: {
                HorsesData.setHealth(entity, value);
            }
        }
    }

    public static void setAttrValueById(int id, HorseEntity entity) {
        switch (id) {
            case 0: {
                HorsesData.setValueFromItem((Item)ModItems.FLASH_CARROT.get(), entity);
                break;
            }
            case 1: {
                HorsesData.setValueFromItem((Item)ModItems.JUMP_CARROT.get(), entity);
                break;
            }
            case 2: {
                HorsesData.setValueFromItem((Item)ModItems.HEALTH_CARROT.get(), entity);
            }
        }
    }

    public static Item getItemById(int id) {
        switch (id) {
            case 0: {
                return (Item)ModItems.FLASH_CARROT.get();
            }
            case 1: {
                return (Item)ModItems.JUMP_CARROT.get();
            }
            case 2: {
                return (Item)ModItems.HEALTH_CARROT.get();
            }
        }
        return Items.field_190931_a;
    }
}

