/*
 * Decompiled with CFR 0.152.
 */
package com.lazynessmind.horsemodifier.items;

import com.lazynessmind.horsemodifier.horsedata.HorsesData;
import com.lazynessmind.horsemodifier.util.ItemHelper;
import com.lazynessmind.horsemodifier.util.Ref;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.horse.HorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class HorseSpy
extends Item {
    private static final String TAG_CURRENT_MODE = "CurrentMode";
    public int currentMode = 0;

    public HorseSpy() {
        super(new Item.Properties().func_200916_a(Ref.MOD_GROUP));
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag tooltipFlag) {
        super.func_77624_a(stack, world, list, tooltipFlag);
        list.add((ITextComponent)new TranslationTextComponent("translation.horsespy.tooltip.one").func_240699_a_(TextFormatting.GOLD));
        list.add((ITextComponent)new TranslationTextComponent("translation.horsespy.tooltip.two").func_240699_a_(TextFormatting.RED));
    }

    public ActionResultType func_111207_a(ItemStack stack, PlayerEntity player, LivingEntity entity, Hand hand) {
        if (!player.field_70170_p.field_72995_K && entity instanceof HorseEntity) {
            HorseEntity horseEntity = (HorseEntity)entity;
            if (horseEntity.func_110248_bS()) {
                this.createTag(stack);
                if (stack.func_77978_p() != null) {
                    if (stack.func_77978_p().func_74762_e(TAG_CURRENT_MODE) == 0) {
                        this.displayHorseStats(horseEntity, player);
                    } else if (stack.func_77978_p().func_74762_e(TAG_CURRENT_MODE) == 1) {
                        this.removeUpgrade(0, "translation.horsespy.message.speed", player, horseEntity);
                    } else if (stack.func_77978_p().func_74762_e(TAG_CURRENT_MODE) == 2) {
                        this.removeUpgrade(1, "translation.horsespy.message.jump", player, horseEntity);
                    } else if (stack.func_77978_p().func_74762_e(TAG_CURRENT_MODE) == 3) {
                        this.removeUpgrade(2, "translation.horsespy.message.health", player, horseEntity);
                    }
                }
            } else {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("translation.horsespy.message.tame").func_240699_a_(TextFormatting.RED), player.func_110124_au());
            }
        }
        return ActionResultType.SUCCESS;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        if (!context.func_195991_k().field_72995_K && context.func_195999_j() != null && context.func_195999_j().func_213453_ef()) {
            this.currentMode = this.currentMode < 3 ? ++this.currentMode : 0;
            this.createTag(context.func_195996_i());
            if (context.func_195996_i().func_77978_p() != null) {
                context.func_195996_i().func_77978_p().func_74768_a(TAG_CURRENT_MODE, this.currentMode);
            }
            this.sendStatusFromMode(this.currentMode, context.func_195999_j());
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    private void createTag(ItemStack stack) {
        if (!stack.func_77942_o()) {
            CompoundNBT data = new CompoundNBT();
            data.func_74768_a(TAG_CURRENT_MODE, this.currentMode);
            stack.func_77982_d(data);
        }
    }

    private void displayHorseStats(HorseEntity horseEntity, PlayerEntity player) {
        float speed = (float)horseEntity.func_110148_a(Attributes.field_233821_d_).func_111126_e();
        float jump = (float)horseEntity.func_110148_a(Attributes.field_233830_m_).func_111126_e();
        float health = (float)horseEntity.func_110148_a(Attributes.field_233818_a_).func_111126_e();
        player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.DARK_PURPLE + "===================="), player.func_110124_au());
        player.func_145747_a((ITextComponent)new TranslationTextComponent("translation.horsespy.message.status.speed").func_240702_b_(String.valueOf(speed)), player.func_110124_au());
        player.func_145747_a((ITextComponent)new TranslationTextComponent("translation.horsespy.message.status.jump").func_240702_b_(String.valueOf(jump)), player.func_110124_au());
        player.func_145747_a((ITextComponent)new TranslationTextComponent("translation.horsespy.message.status.health").func_240702_b_(String.valueOf(health)), player.func_110124_au());
        player.func_145747_a((ITextComponent)new TranslationTextComponent("translation.horsespy.message.status.speedcount").func_240702_b_(String.valueOf(HorsesData.getSpeed(horseEntity))), player.func_110124_au());
        player.func_145747_a((ITextComponent)new TranslationTextComponent("translation.horsespy.message.status.jumpcount").func_240702_b_(String.valueOf(HorsesData.getJump(horseEntity))), player.func_110124_au());
        player.func_145747_a((ITextComponent)new TranslationTextComponent("translation.horsespy.message.status.healthcount").func_240702_b_(String.valueOf(HorsesData.getHealth(horseEntity))), player.func_110124_au());
        player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.DARK_PURPLE + "===================="), player.func_110124_au());
    }

    private void sendStatusFromMode(int id, PlayerEntity playerEntity) {
        switch (id) {
            case 0: {
                playerEntity.func_146105_b((ITextComponent)new TranslationTextComponent("translation.horsespy.message.mode.one"), true);
                break;
            }
            case 1: {
                playerEntity.func_146105_b((ITextComponent)new TranslationTextComponent("translation.horsespy.message.mode.two"), true);
                break;
            }
            case 2: {
                playerEntity.func_146105_b((ITextComponent)new TranslationTextComponent("translation.horsespy.message.mode.three"), true);
                break;
            }
            case 3: {
                playerEntity.func_146105_b((ITextComponent)new TranslationTextComponent("translation.horsespy.message.mode.four"), true);
            }
        }
    }

    private void removeUpgrade(int id, String succMessage, PlayerEntity playerEntity, HorseEntity horseEntity) {
        if (HorsesData.getValueById(id, horseEntity) - 1 >= 0) {
            HorsesData.setValueById(id, horseEntity, HorsesData.getValueById(id, horseEntity) - 1);
            HorsesData.setAttrValueById(id, horseEntity);
            Vector3d playerPos = playerEntity.func_213303_ch();
            ItemEntity itementity = new ItemEntity(playerEntity.field_70170_p, playerPos.field_72450_a, playerPos.field_72448_b + 1.0, playerPos.field_72449_c, ItemHelper.getStackFromItem(HorsesData.getItemById(id)));
            itementity.func_174869_p();
            playerEntity.field_70170_p.func_217376_c((Entity)itementity);
            playerEntity.func_145747_a((ITextComponent)new TranslationTextComponent(succMessage).func_240702_b_(String.valueOf(HorsesData.getValueById(id, horseEntity))), playerEntity.func_110124_au());
        } else {
            playerEntity.func_145747_a((ITextComponent)new TranslationTextComponent("translation.horsespy.message.failmodifier").func_240699_a_(TextFormatting.RED), playerEntity.func_110124_au());
        }
    }
}

