/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.horsestandstill;

import com.lothrazar.horsestandstill.UtilWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.horse.HorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EventHorseStandStill {
    private static final int DISTANCE = 6;
    private static final String STATE_WAITING = "horsestandstill.waiting";
    private static final String STATE_RIDING = "horsestandstill.riding";
    private static final String NBT_RIDING = "horsestandstill.tracked";
    private static final String NBT_TRACKEDX = "horsestandstill.trackedx";
    private static final String NBT_TRACKEDY = "horsestandstill.trackedy";
    private static final String NBT_TRACKEDZ = "horsestandstill.trackedz";

    @SubscribeEvent
    public void onHit(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (!(entity instanceof HorseEntity)) {
            return;
        }
        HorseEntity horse = (HorseEntity)entity;
        boolean emptyState = !horse.getPersistentData().func_74764_b(NBT_RIDING);
        boolean ridingState = STATE_RIDING.equals(horse.getPersistentData().func_74779_i(NBT_RIDING));
        boolean isWaitingState = STATE_WAITING.equals(horse.getPersistentData().func_74779_i(NBT_RIDING));
        boolean isPlayerRiding = this.isRiddenByPlayer(horse);
        boolean isSaddled = horse.func_110257_ck();
        if (emptyState) {
            if (entity.field_70170_p.field_72995_K) {
                return;
            }
            if (isPlayerRiding) {
                this.setRidingState(horse);
            } else {
                horse.func_94061_f(false);
            }
        } else if (ridingState) {
            if (entity.field_70170_p.field_72995_K) {
                return;
            }
            if (!isPlayerRiding) {
                if (isSaddled) {
                    horse.func_70656_aK();
                    horse.func_70097_a(DamageSource.field_76376_m, 0.0f);
                    if (entity.field_70170_p.field_72995_K) {
                        return;
                    }
                    this.setWaitingStateAndPos(horse);
                } else {
                    if (entity.field_70170_p.field_72995_K) {
                        return;
                    }
                    this.clearState(horse);
                    horse.func_94061_f(false);
                }
            }
        } else if (isWaitingState) {
            if (entity.field_70170_p.field_72995_K) {
                return;
            }
            if (isSaddled && horse.func_70089_S()) {
                if (isPlayerRiding) {
                    this.setRidingState(horse);
                } else {
                    this.onWaitingStateTick(horse);
                    horse.func_94061_f(true);
                }
            } else {
                this.clearState(horse);
                horse.func_94061_f(false);
            }
        }
    }

    private boolean isRiddenByPlayer(HorseEntity horse) {
        return horse.func_184179_bs() instanceof PlayerEntity;
    }

    private void onWaitingStateTick(HorseEntity horse) {
        horse.func_174830_Y();
        int x = horse.getPersistentData().func_74762_e(NBT_TRACKEDX);
        int y = horse.getPersistentData().func_74762_e(NBT_TRACKEDY);
        int z = horse.getPersistentData().func_74762_e(NBT_TRACKEDZ);
        BlockPos pos = new BlockPos(x, y, z);
        double distance = UtilWorld.distanceBetweenHorizontal(pos, horse.func_180425_c());
        if (distance > 6.0) {
            horse.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        }
    }

    private void clearState(HorseEntity horse) {
        horse.getPersistentData().func_82580_o(NBT_RIDING);
        horse.getPersistentData().func_82580_o(NBT_TRACKEDX);
        horse.getPersistentData().func_82580_o(NBT_TRACKEDY);
        horse.getPersistentData().func_82580_o(NBT_TRACKEDZ);
    }

    private void setWaitingStateAndPos(HorseEntity horse) {
        horse.getPersistentData().func_74778_a(NBT_RIDING, STATE_WAITING);
        BlockPos pos = horse.func_180425_c();
        horse.getPersistentData().func_74768_a(NBT_TRACKEDX, pos.func_177958_n());
        horse.getPersistentData().func_74768_a(NBT_TRACKEDY, pos.func_177956_o());
        horse.getPersistentData().func_74768_a(NBT_TRACKEDZ, pos.func_177952_p());
    }

    private void setRidingState(HorseEntity horse) {
        horse.getPersistentData().func_74778_a(NBT_RIDING, STATE_RIDING);
        horse.getPersistentData().func_82580_o(NBT_TRACKEDX);
        horse.getPersistentData().func_82580_o(NBT_TRACKEDY);
        horse.getPersistentData().func_82580_o(NBT_TRACKEDZ);
    }
}

