/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.invcrafting.inventory;

import com.google.common.collect.Lists;
import com.lothrazar.invcrafting.ModInvCrafting;
import com.lothrazar.invcrafting.inventory.InventoryPlayerCrafting;
import com.mojang.datafixers.util.Pair;
import java.lang.reflect.Field;
import java.util.Optional;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.CraftingResultSlot;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class ContainerPlayerCrafting
extends PlayerContainer {
    private static final ResourceLocation[] ARMOR_SLOT_TEXTURES = new ResourceLocation[]{field_226619_g_, field_226618_f_, field_226617_e_, field_226616_d_};
    private static final EquipmentSlotType[] ARMOR = new EquipmentSlotType[]{EquipmentSlotType.HEAD, EquipmentSlotType.CHEST, EquipmentSlotType.LEGS, EquipmentSlotType.FEET};
    private int craftSize = 3;
    private CraftingInventory craftMatrix;
    private CraftResultInventory craftResult_;
    private final PlayerEntity player;

    public ContainerPlayerCrafting(InventoryPlayerCrafting playerInventory, boolean localWorld, final PlayerEntity player) {
        super((PlayerInventory)playerInventory, localWorld, player);
        int slot;
        int y;
        int x;
        this.player = player;
        this.initInventorySlots();
        this.initCraftingGrid(playerInventory);
        for (int i = 0; i < this.craftSize; ++i) {
            for (int j = 0; j < this.craftSize; ++j) {
                x = 82 + j * 18;
                y = 8 + i * 18;
                slot = j + i * this.craftSize;
                this.func_75146_a(new Slot((IInventory)this.craftMatrix, slot, x, y));
            }
        }
        for (int k = 0; k < 4; ++k) {
            final EquipmentSlotType equipmentslottype = ARMOR[k];
            slot = 36 + (3 - k);
            x = 8;
            y = 8 + k * 18;
            this.func_75146_a(new Slot((IInventory)playerInventory, slot, x, y){

                public int func_75219_a() {
                    return 1;
                }

                public boolean func_82869_a(PlayerEntity playerIn) {
                    ItemStack itemstack = this.func_75211_c();
                    return !itemstack.func_190926_b() && !playerIn.func_184812_l_() && EnchantmentHelper.func_190938_b((ItemStack)itemstack) ? false : super.func_82869_a(playerIn);
                }

                public boolean func_75214_a(ItemStack stack) {
                    return stack.canEquip(equipmentslottype, (Entity)player);
                }

                @OnlyIn(value=Dist.CLIENT)
                public Pair<ResourceLocation, ResourceLocation> func_225517_c_() {
                    return Pair.of((Object)PlayerContainer.field_226615_c_, (Object)ARMOR_SLOT_TEXTURES[equipmentslottype.func_188454_b()]);
                }
            });
        }
        for (int l = 0; l < 3; ++l) {
            for (int j1 = 0; j1 < 9; ++j1) {
                slot = j1 + (l + 1) * 9;
                x = 8 + j1 * 18;
                y = 84 + l * 18;
                this.func_75146_a(new Slot((IInventory)playerInventory, slot, x, y));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            slot = i1;
            x = 8 + i1 * 18;
            y = 142;
            this.func_75146_a(new Slot((IInventory)playerInventory, slot, x, y));
        }
        slot = 40;
        x = 77;
        y = 62;
        this.func_75146_a(new Slot((IInventory)playerInventory, slot, x, y){

            public boolean func_75214_a(ItemStack stack) {
                return super.func_75214_a(stack);
            }

            @OnlyIn(value=Dist.CLIENT)
            public Pair<ResourceLocation, ResourceLocation> func_225517_c_() {
                return Pair.of((Object)PlayerContainer.field_226615_c_, (Object)PlayerContainer.field_226620_h_);
            }
        });
        this.func_75130_a((IInventory)this.craftMatrix);
    }

    private void initCraftingGrid(InventoryPlayerCrafting playerInventory) {
        try {
            Field m = ObfuscationReflectionHelper.findField(PlayerContainer.class, (String)"field_75181_e");
            m.setAccessible(true);
            m.set((Object)this, new CraftingInventory((Container)this, this.craftSize, this.craftSize));
            this.craftMatrix = (CraftingInventory)m.get((Object)this);
            Field mResult = ObfuscationReflectionHelper.findField(PlayerContainer.class, (String)"field_75179_f");
            mResult.setAccessible(true);
            this.craftResult_ = (CraftResultInventory)mResult.get((Object)this);
            this.func_75146_a((Slot)new CraftingResultSlot(playerInventory.field_70458_d, this.craftMatrix, (IInventory)this.craftResult_, 0, 154, 24));
        }
        catch (Exception e) {
            ModInvCrafting.LOGGER.error(" Slots error", (Throwable)e);
        }
    }

    private void initInventorySlots() {
        try {
            Field m = ObfuscationReflectionHelper.findField(Container.class, (String)"field_75151_b");
            m.setAccessible(true);
            m.set((Object)this, Lists.newArrayList());
        }
        catch (Exception e) {
            ModInvCrafting.LOGGER.error(" Slots error", (Throwable)e);
        }
    }

    public void func_75130_a(IInventory inventoryIn) {
        try {
            ContainerPlayerCrafting.func_217066_a(this.field_75152_c, this.player.field_70170_p, this.player, this.craftMatrix, this.craftResult_);
        }
        catch (Exception e) {
            ModInvCrafting.LOGGER.error("crafting error", (Throwable)e);
        }
    }

    protected static void func_217066_a(int p_217066_0_, World p_217066_1_, PlayerEntity p_217066_2_, CraftingInventory p_217066_3_, CraftResultInventory p_217066_4_) {
        if (!p_217066_1_.field_72995_K) {
            ICraftingRecipe icraftingrecipe;
            ServerPlayerEntity serverplayerentity = (ServerPlayerEntity)p_217066_2_;
            ItemStack itemstack = ItemStack.field_190927_a;
            Optional optional = p_217066_1_.func_73046_m().func_199529_aN().func_215371_a(IRecipeType.field_222149_a, (IInventory)p_217066_3_, p_217066_1_);
            if (optional.isPresent() && p_217066_4_.func_201561_a(p_217066_1_, serverplayerentity, (IRecipe)(icraftingrecipe = (ICraftingRecipe)optional.get()))) {
                itemstack = icraftingrecipe.func_77572_b((IInventory)p_217066_3_);
            }
            p_217066_4_.func_70299_a(0, itemstack);
            serverplayerentity.field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(p_217066_0_, 0, itemstack));
        }
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        this.log("Transfer " + index + " ..sheild " + ((Slot)this.field_75151_b.get(50)).func_75211_c());
        int TOPLEFT = 14;
        int BOTRIGHT = 40;
        int HOTBARSTART = 41;
        int HOTBAREND = 49;
        int CRAFTSTART = 1;
        int CRAFTEND = 9;
        int ARMORSTART = 10;
        int ARMOREND = 13;
        int SHIELD = 50;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            int i;
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            EquipmentSlotType equipmentslottype = MobEntity.func_184640_d((ItemStack)itemstack);
            if (index == 0 || index == SHIELD) {
                if (!this.func_75135_a(itemstack1, TOPLEFT, HOTBAREND + 1, false)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(itemstack1, itemstack);
            } else if (index >= ARMORSTART && index <= ARMOREND ? !this.func_75135_a(itemstack1, TOPLEFT, HOTBAREND + 1, false) : (index >= CRAFTSTART && index <= CRAFTEND ? !this.func_75135_a(itemstack1, TOPLEFT, HOTBAREND + 1, false) : (equipmentslottype.func_188453_a() == EquipmentSlotType.Group.ARMOR && !((Slot)this.field_75151_b.get(8 - equipmentslottype.func_188454_b())).func_75216_d() ? !this.func_75135_a(itemstack1, i = ARMORSTART - equipmentslottype.func_188454_b() + 3, i + 1, false) : (equipmentslottype == EquipmentSlotType.OFFHAND && !((Slot)this.field_75151_b.get(SHIELD)).func_75216_d() ? !this.func_75135_a(itemstack1, SHIELD, SHIELD + 1, false) : (index >= TOPLEFT && index <= BOTRIGHT ? !this.func_75135_a(itemstack1, HOTBARSTART, HOTBAREND + 1, false) : (index >= HOTBARSTART && index <= HOTBAREND ? !this.func_75135_a(itemstack1, TOPLEFT, BOTRIGHT + 1, false) : !this.func_75135_a(itemstack1, HOTBARSTART, BOTRIGHT + 1, false))))))) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            ItemStack itemstack2 = slot.func_190901_a(playerIn, itemstack1);
            if (index == 0) {
                playerIn.func_71019_a(itemstack2, false);
            }
        }
        return itemstack;
    }

    private void log(String string) {
    }
}

