/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common;

import io.netty.buffer.ByteBufInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.Vector;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCocoa;
import net.minecraft.block.BlockLog;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.feature.WorldGenForest;
import net.minecraft.world.gen.feature.WorldGenTaiga2;
import net.minecraft.world.gen.feature.WorldGenTrees;
import org.millenaire.common.BuildingLocation;
import org.millenaire.common.Culture;
import org.millenaire.common.MLN;
import org.millenaire.common.MillVillager;
import org.millenaire.common.MillWorld;
import org.millenaire.common.MillWorldInfo;
import org.millenaire.common.Point;
import org.millenaire.common.PujaSacrifice;
import org.millenaire.common.TileEntityMillChest;
import org.millenaire.common.TileEntityPanel;
import org.millenaire.common.UserProfile;
import org.millenaire.common.VillageType;
import org.millenaire.common.VillagerRecord;
import org.millenaire.common.VillagerType;
import org.millenaire.common.construction.BuildingPlan;
import org.millenaire.common.construction.BuildingPlanSet;
import org.millenaire.common.construction.BuildingProject;
import org.millenaire.common.core.MillCommonUtilities;
import org.millenaire.common.forge.BuildingChunkLoader;
import org.millenaire.common.forge.Mill;
import org.millenaire.common.forge.MillAchievements;
import org.millenaire.common.goal.Goal;
import org.millenaire.common.item.Goods;
import org.millenaire.common.network.ServerSender;
import org.millenaire.common.network.StreamReadWrite;
import org.millenaire.common.pathing.AStarPathing;
import org.millenaire.common.pathing.PathingBinary;
import org.millenaire.common.pathing.atomicstryker.AStarConfig;
import org.millenaire.common.pathing.atomicstryker.AStarNode;
import org.millenaire.common.pathing.atomicstryker.AStarPathPlanner;
import org.millenaire.common.pathing.atomicstryker.IAStarPathedEntity;

public class Building {
    public static final AStarConfig PATH_BUILDER_JPS_CONFIG = new AStarConfig(true, false, false, false);
    public static final int INVADER_SPAWNING_DELAY = 500;
    public static final int RELATION_FAIR = 10;
    public static final int RELATION_DECENT = 30;
    public static final int RELATION_GOOD = 50;
    public static final int RELATION_VERYGOOD = 70;
    public static final int RELATION_EXCELLENT = 90;
    public static final int RELATION_CHILLY = -10;
    public static final int RELATION_BAD = -30;
    public static final int RELATION_VERYBAD = -50;
    public static final int RELATION_ATROCIOUS = -70;
    public static final int RELATION_OPENCONFLICT = -90;
    public static final int RELATION_MAX = 100;
    public static final int RELATION_MIN = -100;
    public static final String blArmoury = "armoury";
    public static final String blBakery = "bakery";
    public static final String blCattleFarm = "cattlefarm";
    public static final String blChurch = "church";
    public static final String blFarm = "farm";
    public static final String blForge = "forge";
    public static final String blLumbermanhut = "lumbermanhut";
    public static final String blMarket = "market";
    public static final String blPigFarm = "pigfarm";
    public static final String blPresbytery = "presbytery";
    public static final String blSheepChickenFarm = "sheepchickenfarm";
    public static final String blTavern = "tavern";
    public static final String blTownhall = "townhall";
    public static final String blWatchtower = "watchtower";
    private static final int LOCATION_SEARCH_DELAY = 80000;
    public static final int MIN_REPUTATION_FOR_TRADE = -1024;
    public static final int MAX_REPUTATION = 32768;
    private static final int PATHING_REBUILD_DELAY = 60000;
    public static final String tagAlembic = "Alembic";
    public static final String tagArchives = "archives";
    public static final String tagBakery = "bakery";
    public static final String tagCattle = "cattle";
    public static final String tagCider = "cider";
    public static final String tagDrinking = "Drinking";
    public static final String tagFishingSpot = "fishingspot";
    public static final String tagGrove = "grove";
    public static final String tagInn = "inn";
    public static final String tagKiln = "brickkiln";
    public static final String tagMaizeFarm = "maizefarm";
    public static final String tagMarket = "market";
    public static final String tagOven = "Oven";
    public static final String tagPaddy = "paddy";
    public static final String tagPatrol = "Patrol";
    public static final String tagPigs = "pigs";
    public static final String tagChicken = "chicken";
    public static final String tagPraying = "Praying";
    public static final String tagSheeps = "sheeps";
    public static final String tagSpiceGarden = "spicegarden";
    public static final String tagSugarPlantation = "sugarplantation";
    public static final String tagHoF = "hof";
    public static final String tagPujas = "pujas";
    public static final String tagSacrifices = "sacrifices";
    public static final String tagVineyard = "vineyard";
    public static final String tagSilkwormFarm = "silkwormfarm";
    public static final String tagDespawnAllMobs = "despawnallmobs";
    public static final String tagLeasure = "leasure";
    public static final String tagNoPaths = "nopaths";
    public static final String versionCompatibility = "1.0";
    private BuildingPlan.BuildingBlock[] bblocks = null;
    public int bblocksPos = 0;
    private boolean bblocksChanged = false;
    private boolean pathsChanged = false;
    private PathingBinary binaryPathing = null;
    public Vector<Point> brickspot = new Vector();
    public MillVillager builder = null;
    public String buildingGoal;
    public String buildingGoalIssue;
    public int buildingGoalLevel = 0;
    public BuildingLocation buildingGoalLocation = null;
    public int buildingGoalVariation = 0;
    public BuildingLocation buildingLocationIP = null;
    public Vector<Vector<BuildingProject>> buildingProjects = new Vector();
    public Vector<Point> buildings = new Vector();
    public Vector<String> buildingsBought = new Vector();
    public Vector<Point> chests = new Vector();
    public Culture culture;
    private boolean declaredPos = false;
    public HashMap<MillVillager.InvItem, Integer> exported = new HashMap();
    public Vector<Point> fishingspots = new Vector();
    public Vector<Point> sugarcanesoils = new Vector();
    public Vector<Point> healingspots = new Vector();
    public Vector<Point> furnaces = new Vector();
    public Vector<Point> brewingStands = new Vector();
    public HashMap<MillVillager.InvItem, Integer> imported = new HashMap();
    public boolean isActive = false;
    public boolean isAreaLoaded = false;
    public boolean chestLocked;
    public boolean isTownhall = false;
    public boolean isInn = false;
    public boolean isMarket = false;
    private long lastFailedOtherLocationSearch = 0L;
    private long lastFailedProjectLocationSearch = 0L;
    public long lastPathingUpdate;
    public long lastPing;
    private long lastSaved = 0L;
    public long lastVillagerRecordsRepair = 0L;
    public long lastWoodLocations = 0L;
    public long lastPlantingLocations = 0L;
    public long lastSignUpdate = 0L;
    public BuildingLocation location;
    public VillagerRecord merchantRecord = null;
    public boolean metadataMismatch = false;
    public PerformanceMonitor monitor;
    private String name = null;
    private String qualifier = "";
    public int nbNightsMerchant = 0;
    private HashMap<Goods, Integer> neededGoodsCached = new HashMap();
    private long neededGoodsLastGenerated = 0L;
    public boolean thNightActionPerformed = false;
    public boolean noProjectsLeft = false;
    public AStarPathing pathing = null;
    public EntityPlayer closestPlayer = null;
    private Point pos = null;
    private boolean rebuildingPathing = false;
    private boolean saveNeeded = false;
    private String saveReason = null;
    public MillVillager seller = null;
    public Point sellingPlace = null;
    public Vector<Point> signs = new Vector();
    public Vector<Vector<Point>> sources = new Vector();
    public Vector<Block> sourceTypes = new Vector();
    public Vector<Vector<Point>> spawns = new Vector();
    public Vector<String> spawnTypes = new Vector();
    public Vector<Vector<Point>> mobSpawners = new Vector();
    public Vector<String> mobSpawnerTypes = new Vector();
    public Vector<Vector<Point>> soils = new Vector();
    public Vector<String> soilTypes = new Vector();
    public Vector<Point> stalls = new Vector();
    public Vector<Point> woodspawn = new Vector();
    public Vector<Point> subBuildings = new Vector();
    public Vector<Point> netherwartsoils = new Vector();
    public Vector<Point> silkwormblock = new Vector();
    public Vector<Point> dispenderUnknownPowder = new Vector();
    private Point sleepingPos = null;
    private Point sellingPos = null;
    private Point craftingPos = null;
    private Point defendingPos = null;
    private Point shelterPos = null;
    private Point pathStartPos = null;
    private Point leasurePos = null;
    private Point townHallPos = null;
    public Vector<MillVillager> villagers = new Vector();
    public Vector<String> visitorsList = new Vector();
    public Vector<VillagerRecord> vrecords = new Vector();
    public VillageType villageType = null;
    private HashMap<Point, Integer> relations = new HashMap();
    public Point parentVillage = null;
    public MillWorldInfo winfo = new MillWorldInfo();
    public MillWorldInfo.MillMapInfo mapInfo = null;
    public MillWorld mw;
    public World worldObj;
    private boolean nightBackgroundActionPerformed;
    private boolean updateRaidPerformed;
    public Vector<String> raidsPerformed = new Vector();
    public Vector<String> raidsSuffered = new Vector();
    public Point raidTarget;
    public long raidStart = 0L;
    public long raidPlanningStart;
    public boolean underAttack = false;
    private int nbAnimalsRespawned;
    public PujaSacrifice pujas = null;
    public String controlledBy = null;
    public String controlledByName = null;
    private SaveWorker saveWorker = null;
    private long lastGoodsRefresh = 0L;
    private boolean refreshGoodsNightActionPerformed;
    private BuildingChunkLoader chunkLoader = null;
    public Vector<Vector<BuildingPlan.BuildingBlock>> pathsToBuild = null;
    public int pathsToBuildIndex = 0;
    public int pathsToBuildPathIndex = 0;
    public Vector<Point> oldPathPointsToClear = null;
    public int oldPathPointsToClearIndex = 0;
    private boolean autobuildPaths = false;
    private HashMap<String, LinkedHashMap<Goods, Integer>> shopBuys = new HashMap();
    private HashMap<String, LinkedHashMap<Goods, Integer>> shopSells = new HashMap();

    public static void readBuildingPacket(MillWorld mw, ByteBufInputStream ds) {
        Point pos = null;
        try {
            pos = StreamReadWrite.readNullablePoint((DataInput)ds);
        }
        catch (IOException e) {
            MLN.printException(e);
            return;
        }
        Building building = mw.getBuilding(pos);
        boolean newbuilding = false;
        if (building == null) {
            building = new Building(mw);
            newbuilding = true;
        }
        building.pos = pos;
        try {
            building.isTownhall = ds.readBoolean();
            building.chestLocked = ds.readBoolean();
            building.controlledBy = StreamReadWrite.readNullableString((DataInput)ds);
            building.controlledByName = StreamReadWrite.readNullableString((DataInput)ds);
            building.townHallPos = StreamReadWrite.readNullablePoint((DataInput)ds);
            building.culture = Culture.getCultureByName(StreamReadWrite.readNullableString((DataInput)ds));
            String vtype = StreamReadWrite.readNullableString((DataInput)ds);
            if (building.culture != null && building.culture.getVillageType(vtype) != null) {
                building.villageType = building.culture.getVillageType(vtype);
            } else if (building.culture != null && building.culture.getLoneBuildingType(vtype) != null) {
                building.villageType = building.culture.getLoneBuildingType(vtype);
            }
            building.location = StreamReadWrite.readNullableBuildingLocation((DataInput)ds);
            building.buildingGoal = StreamReadWrite.readNullableString((DataInput)ds);
            building.buildingGoalIssue = StreamReadWrite.readNullableString((DataInput)ds);
            building.buildingGoalLevel = ds.readInt();
            building.buildingGoalVariation = ds.readInt();
            building.buildingGoalLocation = StreamReadWrite.readNullableBuildingLocation((DataInput)ds);
            building.buildingLocationIP = StreamReadWrite.readNullableBuildingLocation((DataInput)ds);
            building.buildingProjects = StreamReadWrite.readProjectVectorVector((DataInput)ds, building.culture);
            building.chests = StreamReadWrite.readPointVector((DataInput)ds);
            building.furnaces = StreamReadWrite.readPointVector((DataInput)ds);
            building.signs = StreamReadWrite.readPointVector((DataInput)ds);
            building.buildings = StreamReadWrite.readPointVector((DataInput)ds);
            building.buildingsBought = StreamReadWrite.readStringVector((DataInput)ds);
            building.relations = StreamReadWrite.readPointIntegerMap((DataInput)ds);
            building.raidsPerformed = StreamReadWrite.readStringVector((DataInput)ds);
            building.raidsSuffered = StreamReadWrite.readStringVector((DataInput)ds);
            building.vrecords = StreamReadWrite.readVillagerRecordVector(mw, (DataInput)ds);
            building.pujas = StreamReadWrite.readOrUpdateNullablePuja((DataInput)ds, building, building.pujas);
            building.visitorsList = StreamReadWrite.readStringVector((DataInput)ds);
            building.imported = StreamReadWrite.readInventory((DataInput)ds);
            building.exported = StreamReadWrite.readInventory((DataInput)ds);
            building.name = StreamReadWrite.readNullableString((DataInput)ds);
            building.qualifier = StreamReadWrite.readNullableString((DataInput)ds);
            building.raidTarget = StreamReadWrite.readNullablePoint((DataInput)ds);
            building.raidPlanningStart = ds.readLong();
            building.raidStart = ds.readLong();
            for (Point p : building.chests) {
                TileEntityMillChest chest = p.getMillChest(mw.world);
                if (chest == null) continue;
                chest.buildingPos = building.getPos();
            }
        }
        catch (IOException e) {
            MLN.printException(e);
        }
        if (newbuilding) {
            mw.addBuilding(building, pos);
        }
    }

    private Building(MillWorld mw) {
        this.mw = mw;
        this.worldObj = mw.world;
    }

    public Building(MillWorld mw, Culture c, VillageType villageType, BuildingLocation l, boolean townHall, boolean villageCreation, Point p, Point townHallPos) {
        MLN.MillenaireException e;
        this.pos = p;
        this.mw = mw;
        this.worldObj = mw.world;
        this.location = l;
        this.culture = c;
        this.villageType = villageType;
        if (this.worldObj == null) {
            e = new MLN.MillenaireException("Null worldObj!");
            MLN.printException(e);
        }
        if (this.pos == null) {
            e = new MLN.MillenaireException("Null pos!");
            MLN.printException(e);
        }
        if (this.location == null) {
            e = new MLN.MillenaireException("Null location!");
            MLN.printException(e);
        }
        if (this.culture == null) {
            e = new MLN.MillenaireException("Null culture!");
            MLN.printException(e);
        }
        mw.addBuilding(this, p);
        if (MLN.DEV) {
            this.monitor = new PerformanceMonitor(this);
        }
        this.isTownhall = townHall;
        this.pathing = null;
        this.townHallPos = this.isTownhall ? this.getPos() : townHallPos;
        this.location = l;
        this.isTownhall = townHall;
        if (l.tags.contains(tagInn) && !this.isTownhall) {
            this.isInn = true;
        }
        if (l.tags.contains("market") && !this.isTownhall) {
            this.isMarket = true;
        }
        if (l.tags.contains(tagPujas)) {
            this.pujas = new PujaSacrifice(this, 0);
        }
        if (l.tags.contains(tagSacrifices)) {
            this.pujas = new PujaSacrifice(this, 1);
        }
    }

    public Building(MillWorld mw, NBTTagCompound nbttagcompound) {
        this.mw = mw;
        this.worldObj = mw.world;
        this.readFromNBT(nbttagcompound);
        if (MLN.DEV) {
            this.monitor = new PerformanceMonitor(this);
        }
        if (this.pos == null) {
            MLN.MillenaireException e = new MLN.MillenaireException("Null pos!");
            MLN.printException(e);
        }
        mw.addBuilding(this, this.pos);
    }

    public void computeShopGoods(EntityPlayer player) {
        Vector<Goods> buyingGoods;
        Vector<Goods> sellingGoods = this.calculateSellingGoods((IInventory)player.field_71071_by);
        if (sellingGoods != null) {
            LinkedHashMap<Goods, Integer> shopSellsPlayer = new LinkedHashMap<Goods, Integer>();
            for (Goods g : sellingGoods) {
                if (g.getBasicSellingPrice(this) <= 0) continue;
                shopSellsPlayer.put(g, g.getBasicSellingPrice(this));
            }
            this.shopSells.put(player.getDisplayName(), shopSellsPlayer);
        }
        if ((buyingGoods = this.calculateBuyingGoods((IInventory)player.field_71071_by)) != null) {
            LinkedHashMap<Goods, Integer> shopBuysPlayer = new LinkedHashMap<Goods, Integer>();
            for (Goods g : buyingGoods) {
                if (g.getBasicBuyingPrice(this) <= 0) continue;
                shopBuysPlayer.put(g, g.getBasicBuyingPrice(this));
            }
            this.shopBuys.put(player.getDisplayName(), shopBuysPlayer);
        }
    }

    public void addAdult(MillVillager child) throws MLN.MillenaireException {
        MillVillager adult;
        String type = "";
        HashMap<String, Integer> villagerCount = new HashMap<String, Integer>();
        HashMap<String, Integer> residentCount = new HashMap<String, Integer>();
        Vector<String> residents = child.gender == 1 ? this.location.maleResident : this.location.femaleResident;
        for (String s : residents) {
            if (MillVillager.oldVillagers.containsKey(type.toLowerCase())) {
                s = child.gender == 1 ? MillVillager.oldVillagers.get(type.toLowerCase())[0] : MillVillager.oldVillagers.get(type.toLowerCase())[1];
            }
            if (residentCount.containsKey(s)) {
                residentCount.put(s, (Integer)residentCount.get(s) + 1);
                continue;
            }
            residentCount.put(s, 1);
        }
        for (VillagerRecord vr : this.vrecords) {
            if (villagerCount.containsKey(vr.type)) {
                villagerCount.put(vr.type, (Integer)villagerCount.get(vr.type) + 1);
                continue;
            }
            villagerCount.put(vr.type, 1);
        }
        for (String s : residentCount.keySet()) {
            if (!villagerCount.containsKey(s)) {
                type = s;
                continue;
            }
            if ((Integer)villagerCount.get(s) >= (Integer)residentCount.get(s)) continue;
            type = s;
        }
        child.getHouse().removeVillagerRecord(child.villager_id);
        if (MLN.LogWorldGeneration >= 1) {
            MLN.major(this, "Creating " + type + " with child " + child.getName() + "/" + child.villager_id);
        }
        if ((adult = MillVillager.createVillager(this.culture, type, child.gender, this.worldObj, child.getPos(), this.getPos(), this.townHallPos, false, child.firstName, child.familyName)) == null) {
            MLN.error(this, "Couldn't create adult of type " + type + " from child " + child);
            return;
        }
        adult.villager_id = child.villager_id;
        VillagerRecord adultRecord = adult.getRecord();
        if (adultRecord == null) {
            adultRecord = new VillagerRecord(this.mw, adult);
        }
        adultRecord.updateRecord(adult);
        this.addOrReplaceVillager(adult);
        this.getTownHall().addOrReplaceVillager(adult);
        this.addOrReplaceRecord(adultRecord);
        this.getTownHall().addOrReplaceRecord(adultRecord);
        for (VillagerRecord vr : this.vrecords) {
            if (vr.gender == adult.gender) continue;
            if (adult.gender == 2) {
                adultRecord.maidenName = adultRecord.familyName;
                adultRecord.familyName = vr.familyName;
                adult.familyName = vr.familyName;
            }
            if (vr.gender == 2) {
                vr.maidenName = vr.familyName;
                vr.familyName = adult.familyName;
                MillVillager spouse = this.getVillagerById(vr.id);
                if (spouse != null) {
                    spouse.familyName = vr.familyName;
                }
            }
            adultRecord.spousesName = vr.getName();
            vr.spousesName = adult.getName();
        }
        child.despawnVillager();
        this.worldObj.func_72838_d((Entity)adult);
        if (this.isInn) {
            this.merchantCreated();
        } else {
            this.updateHouseSign();
        }
    }

    public void addMobSpawnerPoint(String type, Point p) {
        if (!this.mobSpawnerTypes.contains(type)) {
            Vector<Point> spawnsPoint = new Vector<Point>();
            spawnsPoint.add(p);
            this.mobSpawners.add(spawnsPoint);
            this.mobSpawnerTypes.add(type);
        } else {
            for (int i = 0; i < this.mobSpawnerTypes.size(); ++i) {
                if (!this.mobSpawnerTypes.get(i).equals(type) || this.mobSpawners.get(i).contains(p)) continue;
                this.mobSpawners.get(i).add(p);
            }
        }
    }

    public void addOrReplaceRecord(VillagerRecord vr) throws MLN.MillenaireException {
        if (vr == null) {
            throw new MLN.MillenaireException("Attempting to insert null VR");
        }
        while (this.vrecords.remove(vr)) {
        }
        this.vrecords.add(vr);
    }

    public void addOrReplaceVillager(MillVillager villager) {
        if (villager.vtype == null) {
            MLN.printException("Tried adding a villager, but his type is null: " + villager, new Exception());
            return;
        }
        for (int i = this.villagers.size() - 1; i >= 0; --i) {
            if (this.villagers.get((int)i).villager_id != villager.villager_id) continue;
            if (this.villagers.get(i) == villager) {
                this.villagers.remove(i);
                continue;
            }
            if (this.villagers.get(i).func_145782_y() == villager.func_145782_y()) {
                if (MLN.LogVillager >= 1) {
                    MLN.major(this.villagers.get(i), "Two copies with same entityId!");
                }
                this.villagers.remove(i);
                continue;
            }
            if (villager.client_lastupdated <= this.villagers.get((int)i).client_lastupdated) continue;
            if (MLN.LogVillagerSpawn >= 2) {
                Exception e = new Exception();
                MLN.printException("addOrReplaceVillager in " + this + ": Found an other copy of " + villager + " in village " + this.villagers.get(i).getTownHall() + ": " + this.villagers.get(i), e);
            }
            this.villagers.get(i).despawnVillagerSilent();
            this.villagers.remove(i);
        }
        this.villagers.add(villager);
    }

    public void addSoilPoint(String type, Point p) {
        if (!this.soilTypes.contains(type)) {
            Vector<Point> spawnsPoint = new Vector<Point>();
            spawnsPoint.add(p);
            this.soils.add(spawnsPoint);
            this.soilTypes.add(type);
        } else {
            for (int i = 0; i < this.soilTypes.size(); ++i) {
                if (!this.soilTypes.get(i).equals(type) || this.soils.get(i).contains(p)) continue;
                this.soils.get(i).add(p);
            }
        }
    }

    public void addSourcePoint(Block block, Point p) {
        if (!this.sourceTypes.contains(block)) {
            Vector<Point> spawnsPoint = new Vector<Point>();
            spawnsPoint.add(p);
            this.sources.add(spawnsPoint);
            this.sourceTypes.add(block);
        } else {
            for (int i = 0; i < this.sourceTypes.size(); ++i) {
                if (!this.sourceTypes.get(i).equals(block) || this.sources.get(i).contains(p)) continue;
                this.sources.get(i).add(p);
            }
        }
    }

    public void addSpawnPoint(String type, Point p) {
        if (!this.spawnTypes.contains(type)) {
            Vector<Point> spawnsPoint = new Vector<Point>();
            spawnsPoint.add(p);
            this.spawns.add(spawnsPoint);
            this.spawnTypes.add(type);
        } else {
            for (int i = 0; i < this.spawnTypes.size(); ++i) {
                if (!this.spawnTypes.get(i).equals(type) || this.spawns.get(i).contains(p)) continue;
                this.spawns.get(i).add(p);
            }
        }
    }

    public void addToExports(MillVillager.InvItem good, int quantity) {
        if (this.exported.containsKey(good)) {
            this.exported.put(good, this.exported.get(good) + quantity);
        } else {
            this.exported.put(good, quantity);
        }
    }

    public void addToImports(MillVillager.InvItem good, int quantity) {
        if (this.imported.containsKey(good)) {
            this.imported.put(good, this.imported.get(good) + quantity);
        } else {
            this.imported.put(good, quantity);
        }
    }

    public void adjustLanguage(EntityPlayer player, int l) {
        this.mw.getProfile(player.getDisplayName()).adjustLanguage(this.getTownHall().culture.key, l);
    }

    public void adjustRelation(Point villagePos, int change, boolean reset) {
        int relation = change;
        if (this.relations.containsKey(villagePos) && !reset) {
            relation += this.relations.get(villagePos).intValue();
        }
        if (relation > 100) {
            relation = 100;
        } else if (relation < -100) {
            relation = -100;
        }
        this.relations.put(villagePos, relation);
        this.saveNeeded = true;
        Building village = this.mw.getBuilding(villagePos);
        if (village == null) {
            MLN.error(this, "Could not find village at " + villagePos + " in order to adjust relation.");
        } else {
            village.relations.put(this.getPos(), relation);
            village.saveTownHall("distance relation change");
        }
    }

    public void adjustReputation(EntityPlayer player, int l) {
        this.mw.getProfile(player.getDisplayName()).adjustReputation(this.getTownHall(), l);
    }

    public boolean areBlocksLeft() {
        if (this.bblocks == null) {
            return false;
        }
        return this.bblocksPos < this.bblocks.length;
    }

    public void attemptMerchantMove(boolean forced) {
        Vector<Building> targets = new Vector<Building>();
        Vector<Building> backupTargets = new Vector<Building>();
        for (Point vp : this.getTownHall().relations.keySet()) {
            Building townHall = this.mw.getBuilding(vp);
            if (townHall == null || this.getTownHall() == null || townHall.villageType == this.getTownHall().villageType || this.getTownHall().relations.get(vp) < 90 && (this.getTownHall().relations.get(vp) < 50 || townHall.culture != this.culture) || !(this.getPos().distanceTo(townHall.getPos()) < 2000.0)) continue;
            if (MLN.LogMerchant >= 3) {
                MLN.debug(this, "Considering village " + townHall.getVillageQualifiedName() + " for merchant : " + this.merchantRecord);
            }
            for (Building inn : townHall.getBuildingsWithTag(tagInn)) {
                boolean moveNeeded = false;
                HashMap<MillVillager.InvItem, Integer> content = this.getChestsContent();
                for (MillVillager.InvItem good : content.keySet()) {
                    if (content.get(good) <= 0 || inn.getTownHall().nbGoodNeeded(good.getItem(), good.meta) <= 0) continue;
                    moveNeeded = true;
                    break;
                }
                if (moveNeeded) {
                    if (inn.merchantRecord == null) {
                        targets.add(inn);
                        targets.add(inn);
                        targets.add(inn);
                    } else if (inn.nbNightsMerchant > 1 || forced) {
                        targets.add(inn);
                    }
                    if (MLN.LogMerchant < 3) continue;
                    MLN.debug(this, "Found good move in " + townHall.getVillageQualifiedName() + " for merchant : " + this.merchantRecord);
                    continue;
                }
                if (this.nbNightsMerchant <= 3) continue;
                backupTargets.add(inn);
                if (MLN.LogMerchant < 3) continue;
                MLN.debug(this, "Found backup move in " + townHall.getVillageQualifiedName() + " for merchant : " + this.merchantRecord);
            }
        }
        if (targets.size() == 0 && backupTargets.size() == 0) {
            if (MLN.LogMerchant >= 2) {
                MLN.minor(this, "Failed to find a destination for merchant: " + this.merchantRecord);
            }
            return;
        }
        Building inn = targets.size() > 0 ? (Building)targets.get(MillCommonUtilities.randomInt(targets.size())) : (Building)backupTargets.get(MillCommonUtilities.randomInt(backupTargets.size()));
        if (inn.merchantRecord == null) {
            this.moveMerchant(inn);
        } else if (inn.nbNightsMerchant > 1 || forced) {
            this.swapMerchants(inn);
        }
    }

    private void attemptPlanNewRaid() {
        for (VillagerRecord vr : this.vrecords) {
            if (!vr.raidingVillage) continue;
            return;
        }
        int raidingStrength = (int)((float)this.getVillageRaidingStrength() * 2.0f);
        if (MLN.LogDiplomacy >= 3) {
            MLN.debug(this, "Checking out for new raid, strength: " + raidingStrength);
        }
        if (raidingStrength > 0) {
            Vector<Building> targets = new Vector<Building>();
            if (this.villageType.lonebuilding) {
                for (Building distantVillage : this.mw.allBuildings()) {
                    if (distantVillage == null || !distantVillage.isTownhall || distantVillage.villageType == null || distantVillage.villageType.lonebuilding || !(this.getPos().distanceTo(distantVillage.getPos()) < (double)MLN.BanditRaidRadius) || distantVillage.getVillageDefendingStrength() >= raidingStrength) continue;
                    if (MLN.LogDiplomacy >= 3) {
                        MLN.debug(this, "Lone building valid target: " + distantVillage);
                    }
                    targets.add(distantVillage);
                }
            } else {
                for (Point p : this.relations.keySet()) {
                    Building distantVillage;
                    if (this.relations.get(p) >= -90 || (distantVillage = this.mw.getBuilding(p)) == null) continue;
                    if (MLN.LogDiplomacy >= 3) {
                        MLN.debug(this, "Testing village valid target: " + distantVillage + "/" + distantVillage.getVillageDefendingStrength());
                    }
                    if (distantVillage.getVillageDefendingStrength() >= raidingStrength) continue;
                    if (MLN.LogDiplomacy >= 3) {
                        MLN.debug(this, "Village valid target: " + distantVillage);
                    }
                    targets.add(distantVillage);
                }
            }
            if (!targets.isEmpty()) {
                Building target = (Building)targets.get(MillCommonUtilities.randomInt(targets.size()));
                if (this.isActive || target.isActive) {
                    this.planRaid(target);
                }
            }
        }
    }

    public void planRaid(Building target) {
        this.raidPlanningStart = this.worldObj.func_72820_D();
        this.raidStart = 0L;
        this.raidTarget = target.getPos();
        if (MLN.LogDiplomacy >= 1) {
            MLN.major(this, "raidTarget set: " + this.raidTarget + " name: " + target.name);
        }
        this.saveNeeded = true;
        this.saveReason = "Raid planned";
        ServerSender.sendTranslatedSentenceInRange(this.worldObj, this.getPos(), MLN.BackgroundRadius, '4', "raid.planningstarted", this.getVillageQualifiedName(), target.getVillageQualifiedName());
    }

    public AStarPathing.PathingWorker calculatePath(MillVillager villager, Point start, Point dest, boolean extraLog) {
        if (!MillVillager.usingBinaryPathing && MillVillager.usingCustomPathing) {
            if (this.pathing == null) {
                try {
                    this.rebuildPathing(true);
                }
                catch (MLN.MillenaireException e) {
                    MLN.printException("Error when rebuilding pathing:", e);
                }
            }
            if (this.pathing == null) {
                if (MLN.LogPathing >= 1 && extraLog) {
                    MLN.major(this, "Can't do pathing as can't generate connections.");
                }
                return null;
            }
            if (!this.pathing.isInArea(start)) {
                if (MLN.LogPathing >= 1 && extraLog) {
                    MLN.major(this, "Start outside of TH area.");
                }
                return null;
            }
            if (!this.pathing.isInArea(dest)) {
                if (MLN.LogPathing >= 1 && extraLog) {
                    MLN.major(this, "Dest outside of TH area.");
                }
                return null;
            }
            if (MLN.LogConnections >= 1 && extraLog) {
                MLN.major(this, "calling getPath: " + (start.getiX() - this.winfo.mapStartX) + "/" + (start.getiZ() - this.winfo.mapStartZ) + " to " + (dest.getiX() - this.winfo.mapStartX) + "/" + (dest.getiZ() - this.winfo.mapStartZ));
            }
            return this.pathing.createWorkerForPath(villager, start.getiX(), start.getiZ(), dest.getiX(), dest.getiZ());
        }
        return null;
    }

    public void calculatePathsToClear() {
        if (this.pathsToBuild != null) {
            Vector<Vector<BuildingPlan.BuildingBlock>> pathsToBuildLocal = this.pathsToBuild;
            long startTime = System.currentTimeMillis();
            Vector<Point> oldPathPointsToClearNew = new Vector<Point>();
            HashSet<Point> newPathPoints = new HashSet<Point>();
            for (Vector<BuildingPlan.BuildingBlock> path : pathsToBuildLocal) {
                for (BuildingPlan.BuildingBlock bp : path) {
                    newPathPoints.add(bp.p);
                }
            }
            for (int x = this.winfo.mapStartX; x < this.winfo.mapStartX + this.winfo.length; ++x) {
                for (int z = this.winfo.mapStartZ; z < this.winfo.mapStartZ + this.winfo.width; ++z) {
                    short basey = this.winfo.topGround[x - this.winfo.mapStartX][z - this.winfo.mapStartZ];
                    for (int dy = -2; dy < 3; ++dy) {
                        Point p;
                        int y = dy + basey;
                        Block block = this.worldObj.func_147439_a(x, y, z);
                        int meta = this.worldObj.func_72805_g(x, y, z);
                        if (block != Mill.path && block != Mill.pathSlab || meta >= 8 || newPathPoints.contains(p = new Point(x, y, z))) continue;
                        oldPathPointsToClearNew.add(p);
                    }
                }
            }
            this.oldPathPointsToClearIndex = 0;
            this.oldPathPointsToClear = oldPathPointsToClearNew;
            if (MLN.LogVillagePaths >= 2) {
                MLN.minor(this, "Finished looking for paths to clear. Found: " + this.oldPathPointsToClear.size() + ". Duration: " + (System.currentTimeMillis() - startTime) + " ms.");
            }
        }
    }

    public void callForHelp(Entity attacker) {
        if (MLN.LogGeneralAI >= 3) {
            MLN.debug(this, "Calling for help among: " + this.villagers.size() + " villagers.");
        }
        for (MillVillager villager : this.villagers) {
            if (MLN.LogGeneralAI >= 3) {
                MLN.debug(villager, "Testing villager. Will fight? " + villager.helpsInAttacks() + ". Current target? " + villager.func_70777_m() + ". Distance to threat: " + villager.getPos().distanceTo(attacker));
            }
            if (villager.func_70777_m() != null || !villager.helpsInAttacks() || villager.isRaider || !(villager.getPos().distanceTo(attacker) < 80.0)) continue;
            if (MLN.LogGeneralAI >= 1) {
                MLN.major(villager, "Off to help a friend attacked by attacking: " + attacker);
            }
            villager.setEntityToAttack(attacker);
            villager.clearGoal();
            villager.speakSentence("calltoarms", 0, 50, 1);
        }
    }

    public boolean canAffordBuild(BuildingPlan plan) {
        for (MillVillager.InvItem key : plan.resCost.keySet()) {
            if (plan.resCost.get(key) <= this.countGoods(key.getItem(), key.meta)) continue;
            return false;
        }
        return true;
    }

    public boolean canAffordBuildAfterGoal(BuildingPlan plan) {
        BuildingPlan goalPlan = this.getCurrentGoalBuildingPlan();
        for (MillVillager.InvItem key : plan.resCost.keySet()) {
            if (!(goalPlan != null && goalPlan.resCost.containsKey(key) ? plan.resCost.get(key) + goalPlan.resCost.get(key) > this.countGoods(key.getItem(), key.meta) : plan.resCost.get(key) > this.countGoods(key.getItem(), key.meta))) continue;
            return false;
        }
        return true;
    }

    public void cancelBuilding(BuildingLocation location) {
        if (location.isLocationSamePlace(this.buildingLocationIP)) {
            this.buildingLocationIP = null;
        }
        if (location.isLocationSamePlace(this.buildingGoalLocation)) {
            this.buildingGoalLocation = null;
            this.buildingGoal = null;
        }
        block0: for (Vector<BuildingProject> projects : this.buildingProjects) {
            for (BuildingProject project : projects) {
                if (project.location != location) continue;
                projects.remove(project);
                continue block0;
            }
        }
        this.buildings.remove(location.pos);
        this.winfo.removeBuildingLocation(location);
        this.mw.removeBuilding(location.pos);
    }

    public void cancelRaid() {
        if (MLN.LogDiplomacy >= 1) {
            MLN.major(this, "Cancelling raid");
        }
        this.raidPlanningStart = 0L;
        this.raidStart = 0L;
        this.raidTarget = null;
    }

    public boolean canChildMoveIn(int pGender, String familyName) {
        if (pGender == 2 && this.location.femaleResident.size() == 0) {
            return false;
        }
        if (pGender == 1 && this.location.maleResident.size() == 0) {
            return false;
        }
        for (VillagerRecord vr : this.vrecords) {
            if (vr.gender == pGender || vr.getType().isChild || !vr.familyName.equals(familyName)) continue;
            return false;
        }
        int nbAdultSameSex = 0;
        for (VillagerRecord vr : this.vrecords) {
            if (vr.gender != pGender || vr.getType() == null || vr.getType().isChild) continue;
            ++nbAdultSameSex;
        }
        if (pGender == 1 && nbAdultSameSex >= this.location.maleResident.size()) {
            return false;
        }
        return pGender != 2 || nbAdultSameSex < this.location.femaleResident.size();
    }

    public boolean canSee(int x1, int z1, int x2, int z2) {
        if (x1 < this.winfo.mapStartX || x1 >= this.winfo.mapStartX + this.winfo.length || z1 < this.winfo.mapStartZ || z1 >= this.winfo.mapStartZ + this.winfo.width) {
            if (MLN.LogPathing >= 3) {
                MLN.debug(this, "Start outside of TH area.");
            }
            return false;
        }
        if (x2 < this.winfo.mapStartX || x2 >= this.winfo.mapStartX + this.winfo.length || z1 < this.winfo.mapStartZ || z2 >= this.winfo.mapStartZ + this.winfo.width) {
            if (MLN.LogPathing >= 3) {
                MLN.debug(this, "Dest outside of TH area.");
            }
            return false;
        }
        if (this.pathing == null) {
            return false;
        }
        z1 -= this.winfo.mapStartZ;
        return this.pathing.canSee(new AStarPathing.Point2D(x1 -= this.winfo.mapStartX, z2 -= this.winfo.mapStartZ), new AStarPathing.Point2D(x2 -= this.winfo.mapStartX, z2));
    }

    public void checkBattleStatus() {
        int nbAttackers = 0;
        int nbLiveAttackers = 0;
        int nbLiveDefenders = 0;
        Point attackingVillagePos = null;
        for (VillagerRecord vr : this.vrecords) {
            if (vr.raidingVillage) {
                ++nbAttackers;
                if (!vr.killed) {
                    ++nbLiveAttackers;
                }
                attackingVillagePos = vr.originalVillagePos;
                continue;
            }
            if (!vr.getType().helpInAttacks || vr.killed || vr.awayraiding || vr.awayhired) continue;
            ++nbLiveDefenders;
        }
        if (this.isTownhall) {
            if (this.chestLocked && nbLiveDefenders == 0) {
                this.unlockAllChests();
                ServerSender.sendTranslatedSentenceInRange(this.worldObj, this.getPos(), MLN.BackgroundRadius, '4', "ui.allchestsunlocked", this.getVillageQualifiedName());
            } else if (!this.chestLocked && nbLiveDefenders > 0) {
                this.lockAllBuildingsChests();
            }
        }
        if (nbAttackers > 0) {
            this.underAttack = true;
            if (nbLiveAttackers == 0 || nbLiveDefenders == 0) {
                boolean finish = false;
                if (nbLiveAttackers > 0) {
                    for (MillVillager v : this.villagers) {
                        if (finish || !v.isRaider || !(this.getDefendingPos().distanceToSquared((Entity)v) < 25.0)) continue;
                        finish = true;
                    }
                } else {
                    finish = true;
                }
                if (finish) {
                    if (attackingVillagePos == null) {
                        MLN.error(this, "Wanted to end raid but can't find originating village's position.");
                        this.clearAllAttackers();
                    } else {
                        Building attackingVillage = this.mw.getBuilding(attackingVillagePos);
                        if (attackingVillage == null) {
                            this.clearAllAttackers();
                        } else {
                            boolean endedProperly = attackingVillage.endRaid();
                            if (!endedProperly) {
                                this.clearAllAttackers();
                            }
                        }
                    }
                }
            }
        } else {
            this.underAttack = false;
        }
    }

    private void checkExploreTag(EntityPlayer player) {
        if (player != null && !this.mw.getProfile(player.getDisplayName()).isTagSet(this.location.getPlan().exploreTag) && this.getSleepingPos().distanceToSquared((Entity)player) < 16.0) {
            boolean valid = true;
            int x = this.getSleepingPos().getiX();
            int z = this.getSleepingPos().getiZ();
            while (valid && (x != (int)player.field_70165_t || z != (int)player.field_70161_v)) {
                Block block = this.worldObj.func_147439_a(x, this.getSleepingPos().getiY() + 1, z);
                if (block != Blocks.field_150350_a && block.func_149688_o().func_76230_c()) {
                    valid = false;
                    continue;
                }
                if (x > (int)player.field_70165_t) {
                    --x;
                    continue;
                }
                if (x < (int)player.field_70165_t) {
                    ++x;
                    continue;
                }
                if (z > (int)player.field_70161_v) {
                    --z;
                    continue;
                }
                if (z >= (int)player.field_70161_v) continue;
                ++z;
            }
            if (valid) {
                this.mw.getProfile(player.getDisplayName()).setTag(this.location.getPlan().exploreTag);
                ServerSender.sendTranslatedSentence(player, '2', "other.exploredbuilding", this.location.getPlan().nativeName);
            }
        }
    }

    public void checkSeller() {
        if (!this.worldObj.func_72935_r() || this.underAttack) {
            return;
        }
        if (this.closestPlayer == null || this.controlledBy(this.closestPlayer.getDisplayName())) {
            return;
        }
        if (this.closestPlayer != null && this.seller == null && this.getReputation(this.closestPlayer.getDisplayName()) >= -1024 && this.chestLocked) {
            this.sellingPlace = null;
            for (BuildingLocation l : this.getLocations()) {
                if (l.level < 0 || l.chestPos == null || l.shop == null || l.shop.length() <= 0) continue;
                if (l.getSellingPos() != null && l.getSellingPos().distanceTo((Entity)this.closestPlayer) < 3.0) {
                    this.sellingPlace = l.getSellingPos();
                    continue;
                }
                if (l.getSellingPos() != null || !(l.sleepingPos.distanceTo((Entity)this.closestPlayer) < 3.0)) continue;
                this.sellingPlace = l.sleepingPos;
            }
            if (this.sellingPlace != null) {
                for (MillVillager villager : this.villagers) {
                    if (!villager.isSeller() || this.builder == villager || this.seller != null && !(this.sellingPlace.distanceToSquared((Entity)villager) < this.sellingPlace.distanceToSquared((Entity)this.seller))) continue;
                    this.seller = villager;
                }
                if (this.seller != null) {
                    this.seller.clearGoal();
                    this.seller.goalKey = Goal.beSeller.key;
                    Goal.beSeller.onAccept(this.seller);
                    if (MLN.LogSelling >= 3) {
                        MLN.debug(this, "Sending seller: " + this.seller);
                    }
                }
            }
        }
    }

    public void checkWorkers() {
        if (this.seller != null && (!Goal.beSeller.key.equals(this.seller.goalKey) || this.seller.field_70128_L)) {
            this.seller = null;
        }
        if (this.builder != null && (this.builder.field_70128_L || !Goal.getResourcesForBuild.key.equals(this.builder.goalKey) && !Goal.construction.key.equals(this.builder.goalKey))) {
            if (MLN.LogBuildingPlan >= 1) {
                MLN.major(this, this.builder.getName() + " is no longer building.");
            }
            this.builder = null;
        }
    }

    private void clearAllAttackers() {
        int i;
        int nbCleared = 0;
        for (i = this.vrecords.size() - 1; i >= 0; --i) {
            VillagerRecord vr = this.vrecords.get(i);
            if (!vr.raidingVillage) continue;
            this.vrecords.remove(i);
            if (vr.getHouse().getTownHall() != this) {
                if (MLN.LogDiplomacy >= 1) {
                    MLN.error(this, "Tried clearing attacker record but its house is set to " + vr.getHouse() + " from village " + vr.getHouse().getTownHall() + ". TH is: " + vr.getTownHall());
                }
            } else {
                vr.getHouse().removeVillagerRecord(vr.id);
            }
            ++nbCleared;
        }
        if (MLN.LogDiplomacy >= 1) {
            MLN.major(this, "Cleared " + nbCleared + " attackers.");
        }
        for (i = this.villagers.size() - 1; i >= 0; --i) {
            MillVillager v = this.villagers.get(i);
            if (!v.isRaider) continue;
            this.villagers.remove(i);
            v.getHouse().villagers.remove(v);
            v.despawnVillagerSilent();
            if (MLN.LogDiplomacy < 1) continue;
            MLN.major(this, "Despawning invader: " + v);
        }
    }

    public void clearOldPaths() {
        if (this.oldPathPointsToClear != null) {
            for (Point p : this.oldPathPointsToClear) {
                Block block = p.getBlock(this.worldObj);
                Block blockBelow = p.getBelow().getBlock(this.worldObj);
                if (block == Mill.pathSlab) {
                    p.setBlock(this.worldObj, block, 0, true, false);
                    continue;
                }
                if (block != Mill.path) continue;
                if (MillCommonUtilities.getBlockIdValidGround(blockBelow, true) != null) {
                    p.setBlock(this.worldObj, MillCommonUtilities.getBlockIdValidGround(blockBelow, true), 0, true, false);
                    continue;
                }
                p.setBlock(this.worldObj, Blocks.field_150346_d, 0, true, false);
            }
            this.oldPathPointsToClear = null;
            this.pathsChanged = true;
            this.requestSave("paths clearing rushed");
        }
    }

    private void completeConstruction() throws MLN.MillenaireException {
        if (this.buildingLocationIP != null && this.getBblocks() == null) {
            BuildingPlan plan = this.getCurrentBuildingPlan();
            this.registerBuildingLocation(this.buildingLocationIP);
            this.updateWorldInfo();
            if (this.buildingLocationIP.isSameLocation(this.buildingGoalLocation)) {
                this.buildingGoalLocation = null;
                this.buildingGoal = null;
                this.buildingGoalIssue = null;
                this.buildingGoalLevel = -1;
            }
            this.builder = null;
            this.buildingLocationIP = null;
            if (plan.rebuildPath) {
                this.recalculatePaths(false);
            }
        }
    }

    public void constructCalculatedPaths() {
        if (this.pathsToBuild != null) {
            if (MLN.LogVillagePaths >= 2) {
                MLN.minor(this, "Rebuilding calculated paths.");
            }
            for (Vector<BuildingPlan.BuildingBlock> path : this.pathsToBuild) {
                if (path.isEmpty()) continue;
                for (BuildingPlan.BuildingBlock bp : path) {
                    bp.pathBuild(this);
                }
            }
            this.pathsToBuild = null;
            this.pathsChanged = true;
            this.requestSave("paths rushed");
        }
    }

    public boolean controlledBy(String playerName) {
        if (!this.isTownhall && this.getTownHall() != null) {
            return this.getTownHall().controlledBy(playerName);
        }
        return this.controlledBy != null && this.controlledBy.equals(this.mw.getProfile((String)playerName).key);
    }

    public int countChildren() {
        int nb = 0;
        for (VillagerRecord vr : this.vrecords) {
            if (vr.getType() == null || !vr.getType().isChild) continue;
            ++nb;
        }
        return nb;
    }

    public int countGoods(Item item) {
        return this.countGoods(item, 0);
    }

    public int countGoods(Block block) {
        return this.countGoods(Item.func_150898_a((Block)block), 0);
    }

    public int countGoods(Block block, int meta) {
        return this.countGoods(Item.func_150898_a((Block)block), meta);
    }

    public int countGoods(Item item, int meta) {
        int count = 0;
        for (Point p : this.chests) {
            TileEntityMillChest chest = p.getMillChest(this.worldObj);
            count += MillCommonUtilities.countChestItems((IInventory)chest, item, meta);
        }
        for (Point p : this.furnaces) {
            TileEntityFurnace furnace = p.getFurnace(this.worldObj);
            count += MillCommonUtilities.countFurnaceItems((IInventory)furnace, item, meta);
        }
        return count;
    }

    public int countGoods(MillVillager.InvItem iv) {
        return this.countGoods(iv.getItem(), iv.meta);
    }

    public MillVillager createChild(MillVillager mother, Building townHall, String fathersName) {
        try {
            int gender;
            String type;
            MillVillager child;
            if (MLN.LogWorldGeneration >= 2) {
                MLN.minor(this, "Creating child: " + mother.familyName);
            }
            if ((child = MillVillager.createVillager(townHall.culture, type = (gender = this.getNewGender()) == 1 ? mother.getMaleChild() : mother.getFemaleChild(), gender, this.worldObj, this.getSleepingPos(), this.getPos(), this.townHallPos, false, null, mother.familyName)) == null) {
                throw new MLN.MillenaireException("Child not instancied in createVillager");
            }
            this.addOrReplaceVillager(child);
            townHall.addOrReplaceVillager(child);
            VillagerRecord vr = new VillagerRecord(this.mw, child);
            vr.fathersName = fathersName;
            vr.mothersName = mother.getName();
            this.addOrReplaceRecord(vr);
            townHall.addOrReplaceRecord(vr);
            this.worldObj.func_72838_d((Entity)child);
            return child;
        }
        catch (Exception e) {
            Mill.proxy.sendChatAdmin("Error in createChild(). Check millenaire.log.");
            MLN.error(this, "Exception in createChild.onUpdate(): ");
            MLN.printException(e);
            return null;
        }
    }

    public String createResidents() throws MLN.MillenaireException {
        VillagerRecord vr;
        int i;
        if (this.location.maleResident.size() + this.location.femaleResident.size() == 0) {
            return null;
        }
        String familyName = null;
        String husbandType = null;
        if (this.location.maleResident.size() > 0) {
            husbandType = this.location.maleResident.get(0);
        }
        String wifeType = null;
        if (this.location.femaleResident.size() > 0) {
            wifeType = this.location.femaleResident.get(0);
        }
        if (MLN.LogMerchant >= 2) {
            MLN.minor(this, "Creating " + husbandType + " and " + wifeType + ": " + familyName);
        }
        VillagerRecord husbandRecord = null;
        VillagerRecord wifeRecord = null;
        if (this.sleepingPos == null) {
            MLN.error(this, "Wanted to create villagers but sleepingPos is null!");
            return "";
        }
        if (husbandType != null) {
            MillVillager husband = MillVillager.createVillager(this.culture, husbandType, 1, this.worldObj, this.sleepingPos, this.getPos(), this.townHallPos, false, null, null);
            familyName = husband.familyName;
            this.addOrReplaceVillager(husband);
            husbandRecord = new VillagerRecord(this.mw, husband);
            this.addOrReplaceRecord(husbandRecord);
            this.worldObj.func_72838_d((Entity)husband);
        }
        if (wifeType != null) {
            MillVillager wife = MillVillager.createVillager(this.culture, wifeType, 2, this.worldObj, this.sleepingPos, this.getPos(), this.townHallPos, false, null, familyName);
            this.addOrReplaceVillager(wife);
            wifeRecord = new VillagerRecord(this.mw, wife);
            this.addOrReplaceRecord(wifeRecord);
            this.worldObj.func_72838_d((Entity)wife);
        }
        if (MLN.LogWorldGeneration >= 1) {
            MLN.major(this, "Records: " + wifeRecord + "/" + husbandRecord);
        }
        if (wifeRecord != null && husbandRecord != null) {
            wifeRecord.spousesName = husbandRecord.getName();
            husbandRecord.spousesName = wifeRecord.getName();
        }
        for (i = 1; i < this.location.maleResident.size(); ++i) {
            MillVillager extraMale = MillVillager.createVillager(this.culture, this.location.maleResident.get(i), 1, this.worldObj, this.sleepingPos, this.getPos(), this.townHallPos, false, null, null);
            this.addOrReplaceVillager(extraMale);
            vr = new VillagerRecord(this.mw, extraMale);
            this.addOrReplaceRecord(vr);
            this.worldObj.func_72838_d((Entity)extraMale);
        }
        for (i = 1; i < this.location.femaleResident.size(); ++i) {
            MillVillager extraFemale = MillVillager.createVillager(this.culture, this.location.femaleResident.get(i), 2, this.worldObj, this.sleepingPos, this.getPos(), this.townHallPos, false, null, null);
            this.addOrReplaceVillager(extraFemale);
            vr = new VillagerRecord(this.mw, extraFemale);
            this.addOrReplaceRecord(vr);
            this.worldObj.func_72838_d((Entity)extraFemale);
        }
        if (this.isInn) {
            this.merchantCreated();
        } else {
            this.updateHouseSign();
        }
        return familyName;
    }

    public void deleteVillager(MillVillager villager) {
        while (this.villagers.remove(villager)) {
        }
    }

    public void deleteVillagerFromRecords(MillVillager villager) {
        for (int i = this.vrecords.size() - 1; i >= 0; --i) {
            VillagerRecord vr = this.vrecords.get(i);
            if (!vr.matches(villager)) continue;
            this.vrecords.remove(i);
        }
        this.saveNeeded = true;
        this.saveReason = "Deleted villager";
    }

    public void destroyVillage() {
        File file1;
        File buildingsDir;
        if (MLN.LogVillage >= 1) {
            MLN.major(this, "Destroying the village!");
        }
        for (Point p : this.chests) {
            TileEntityMillChest chest = p.getMillChest(this.worldObj);
            if (chest == null) continue;
            chest.buildingPos = null;
        }
        for (Point p : this.buildings) {
            Building building = this.mw.getBuilding(p);
            if (building == null) continue;
            for (Point p2 : this.chests) {
                TileEntityMillChest chest = p2.getMillChest(this.worldObj);
                if (chest == null) continue;
                chest.buildingPos = null;
            }
        }
        for (MillVillager villager : this.villagers) {
            villager.despawnVillager();
        }
        for (Point p : this.buildings) {
            this.mw.removeBuilding(p);
        }
        this.mw.removeVillageOrLoneBuilding(this.getPos());
        File millenaireDir = this.mw.millenaireDir;
        if (!millenaireDir.exists()) {
            millenaireDir.mkdir();
        }
        if (!(buildingsDir = new File(millenaireDir, "buildings")).exists()) {
            buildingsDir.mkdir();
        }
        if ((file1 = new File(buildingsDir, this.getPos().getPathString() + ".gz")).exists()) {
            file1.delete();
        }
    }

    public void displayInfos(EntityPlayer player) {
        if (this.location == null) {
            return;
        }
        int nbAdults = 0;
        int nbGrownChild = 0;
        for (MillVillager villager : this.villagers) {
            if (!villager.func_70631_g_()) {
                ++nbAdults;
                continue;
            }
            if (villager.size != 20) continue;
            ++nbGrownChild;
        }
        ServerSender.sendChat(player, EnumChatFormatting.GREEN, "It has " + this.villagers.size() + " villagers registered. (" + nbAdults + " adults, " + nbGrownChild + " grown children)");
        ServerSender.sendChat(player, EnumChatFormatting.GREEN, "Pos: " + this.getPos() + " sell pos:" + this.getSellingPos());
        if (this.isTownhall) {
            ServerSender.sendChat(player, EnumChatFormatting.GREEN, "It has " + this.buildings.size() + " houses registered.");
            ServerSender.sendChat(player, EnumChatFormatting.GREEN, "Connections build: " + (this.pathing != null));
            ServerSender.sendChat(player, EnumChatFormatting.GREEN, "Village name: " + this.getVillageQualifiedName());
            ServerSender.sendChat(player, EnumChatFormatting.GREEN, "Current building plan: " + this.getCurrentBuildingPlan() + " at " + this.buildingLocationIP);
            ServerSender.sendChat(player, EnumChatFormatting.GREEN, "Current builder: " + this.builder);
            ServerSender.sendChat(player, EnumChatFormatting.GREEN, "Current seller: " + this.seller);
            ServerSender.sendChat(player, EnumChatFormatting.GREEN, "Rep: " + this.getReputation(player.getDisplayName()) + " bought: " + this.buildingsBought);
        }
        if (this.isInn) {
            ServerSender.sendChat(player, EnumChatFormatting.GREEN, "Merchant: " + this.merchantRecord);
            ServerSender.sendChat(player, EnumChatFormatting.GREEN, "Merchant nights: " + this.nbNightsMerchant);
        }
        if (this.location.tags == null) {
            ServerSender.sendChat(player, EnumChatFormatting.GREEN, "UNKNOWN TAGS");
        } else if (this.location.tags.size() > 0) {
            String s = "Tags: ";
            for (String tag : this.location.tags) {
                s = s + tag + " ";
            }
            ServerSender.sendChat(player, EnumChatFormatting.GREEN, s);
        }
        if (this.chests.size() > 1) {
            ServerSender.sendChat(player, EnumChatFormatting.GREEN, "Chests registered: " + this.chests.size());
        }
        if (this.furnaces.size() > 1) {
            ServerSender.sendChat(player, EnumChatFormatting.GREEN, "Furnaces registered: " + this.furnaces.size());
        }
        for (int i = 0; i < this.soilTypes.size(); ++i) {
            ServerSender.sendChat(player, EnumChatFormatting.GREEN, "Fields registered: " + this.soilTypes.get(i) + ": " + this.soils.get(i).size());
        }
        if (this.sugarcanesoils.size() > 0) {
            ServerSender.sendChat(player, EnumChatFormatting.GREEN, "Sugar cane soils registered: " + this.sugarcanesoils.size());
        }
        if (this.fishingspots.size() > 0) {
            ServerSender.sendChat(player, EnumChatFormatting.GREEN, "Fishing spots registered: " + this.fishingspots.size());
        }
        if (this.stalls.size() > 0) {
            ServerSender.sendChat(player, EnumChatFormatting.GREEN, "Stalls registered: " + this.stalls.size());
        }
        if (this.woodspawn.size() > 0) {
            ServerSender.sendChat(player, EnumChatFormatting.GREEN, "Wood spawn registered: " + this.woodspawn.size());
        }
        if (this.spawns.size() > 0) {
            String s = "Pens: ";
            for (int i = 0; i < this.spawns.size(); ++i) {
                s = s + this.spawnTypes.get(i) + ": " + this.spawns.get(i).size() + " ";
            }
            ServerSender.sendChat(player, EnumChatFormatting.GREEN, s);
        }
        if (this.mobSpawners.size() > 0) {
            String s = "Mob spawners: ";
            for (int i = 0; i < this.mobSpawners.size(); ++i) {
                s = s + this.mobSpawnerTypes.get(i) + ": " + this.mobSpawners.get(i).size() + " ";
            }
            ServerSender.sendChat(player, EnumChatFormatting.GREEN, s);
        }
        if (this.sources.size() > 0) {
            String s = "Sources: ";
            for (int i = 0; i < this.sources.size(); ++i) {
                s = s + this.sourceTypes.get(i).func_149739_a() + ": " + this.sources.get(i).size() + " ";
            }
            ServerSender.sendChat(player, EnumChatFormatting.GREEN, s);
        }
        for (MillVillager villager : this.villagers) {
            if (villager == null) {
                ServerSender.sendChat(player, EnumChatFormatting.GREEN, "NULL villager!");
                continue;
            }
            ServerSender.sendChat(player, EnumChatFormatting.GREEN, villager.getClass().getSimpleName() + ": " + villager.getPos() + (villager.func_70089_S() ? "" : " DEAD") + " " + villager.getGoalLabel(villager.goalKey));
        }
        String s = "LKey: " + this.location.key + " Shop: " + this.location.shop + " special: ";
        if (this.isTownhall) {
            s = s + "Town Hall ";
        }
        if (this.isInn) {
            s = s + "Inn ";
        }
        if (this.isMarket) {
            s = s + "Market";
        }
        if (this.pujas != null) {
            s = s + "Shrine ";
        }
        if (!s.equals("")) {
            ServerSender.sendChat(player, EnumChatFormatting.GREEN, s);
        }
        if (this.pathsToBuild != null || this.oldPathPointsToClear != null) {
            s = this.pathsToBuild != null ? "pathsToBuild: " + this.pathsToBuild.size() + " " + this.pathsToBuildIndex + "/" + this.pathsToBuildPathIndex : "pathsToBuild:null";
            s = this.oldPathPointsToClear != null ? s + " oldPathPointsToClear: " + this.oldPathPointsToClear.size() + " " + this.oldPathPointsToClearIndex : s + " oldPathPointsToClear:null";
            ServerSender.sendChat(player, EnumChatFormatting.GREEN, s);
        }
        this.validateVillagerList();
    }

    private boolean endRaid() {
        boolean attackersWon;
        Building targetVillage = this.mw.getBuilding(this.raidTarget);
        if (targetVillage == null) {
            MLN.error(this, "endRaid() called but couldn't find raidTarget at: " + this.raidTarget);
            return false;
        }
        if (MLN.LogDiplomacy >= 1) {
            MLN.major(this, "Called to end raid on " + targetVillage);
        }
        float defendingForce = (float)targetVillage.getVillageDefendingStrength() * (1.0f + MillCommonUtilities.random.nextFloat());
        float attackingForce = (float)targetVillage.getVillageAttackerStrength() * (1.0f + MillCommonUtilities.random.nextFloat());
        if (attackingForce == 0.0f) {
            attackersWon = false;
        } else if (defendingForce == 0.0f) {
            attackersWon = true;
        } else {
            float ratio = attackingForce / defendingForce;
            boolean bl = attackersWon = (double)ratio > 1.2;
        }
        if (MLN.LogDiplomacy >= 1) {
            MLN.major(this, "Result of raid: " + attackersWon + " (" + attackingForce + "/" + attackingForce + ")");
        }
        for (VillagerRecord vr : this.vrecords) {
            if (!vr.awayraiding) continue;
            vr.awayraiding = false;
            VillagerRecord awayRecord = targetVillage.getVillagerRecordById(vr.id);
            if (awayRecord != null) {
                vr.killed = awayRecord.killed;
                continue;
            }
            vr.killed = false;
        }
        targetVillage.clearAllAttackers();
        for (MillVillager v : targetVillage.villagers) {
            if (v.func_70777_m() == null || !(v.func_70777_m() instanceof MillVillager)) continue;
            v.setEntityToAttack(null);
        }
        this.cancelRaid();
        targetVillage.underAttack = false;
        if (attackersWon) {
            int nbStolen = 0;
            String taken = "";
            for (Goods good : this.culture.goodsVector) {
                if (nbStolen > 1024) continue;
                int nbToTake = this.nbGoodNeeded(good.item.getItem(), good.item.meta);
                if ((nbToTake = Math.min(nbToTake, Math.max(0, 1024 - nbStolen))) <= 0 || (nbToTake = Math.min(nbToTake, targetVillage.countGoods(good.item))) <= 0) continue;
                if (MLN.LogDiplomacy >= 3) {
                    MLN.debug(this, "Able to take: " + nbToTake + " " + Mill.proxy.getInvItemName(good.item));
                }
                targetVillage.takeGoods(good.item, nbToTake);
                this.storeGoods(good.item, nbToTake);
                nbStolen += nbToTake;
                taken = taken + ";" + good.item.getItem() + "/" + good.item.meta + "/" + nbToTake;
            }
            this.raidsPerformed.add("success;" + targetVillage.getVillageQualifiedName() + taken);
            targetVillage.raidsSuffered.add("success;" + this.getVillageQualifiedName() + taken);
            if (MLN.LogDiplomacy >= 1) {
                MLN.major(this, "Raid on " + targetVillage + " successfull (" + attackingForce + "/" + defendingForce + ")");
            }
            ServerSender.sendTranslatedSentenceInRange(this.worldObj, this.getPos(), MLN.BackgroundRadius, '4', "raid.raidsuccesfull", this.getVillageQualifiedName(), targetVillage.getVillageQualifiedName(), "" + nbStolen);
        } else {
            this.raidsPerformed.add("failure;" + targetVillage.getVillageQualifiedName());
            targetVillage.raidsSuffered.add("failure;" + this.getVillageQualifiedName());
            if (MLN.LogDiplomacy >= 1) {
                MLN.major(this, "Raid on " + targetVillage + " failed (" + attackingForce + "/" + defendingForce + ")");
            }
            ServerSender.sendTranslatedSentenceInRange(this.worldObj, this.getPos(), MLN.BackgroundRadius, '4', "raid.raidfailed", this.getVillageQualifiedName(), targetVillage.getVillageQualifiedName());
        }
        MLN.major(this, "Finished ending raid. Records: " + this.vrecords.size());
        targetVillage.saveTownHall("Raid on village ended");
        this.saveNeeded = true;
        this.saveReason = "Raid finished";
        return true;
    }

    private void fillinBuildingLocation(BuildingLocation location) {
        this.mw.testLocations("fillinBuildingLocation start");
        boolean registered = false;
        for (Vector<BuildingProject> projectsLevel : this.buildingProjects) {
            Vector<BuildingProject> temp = new Vector<BuildingProject>(projectsLevel);
            for (BuildingProject project : temp) {
                int pos = 0;
                if (!registered && project.location == null && location.key.equals(project.key)) {
                    project.location = location;
                    registered = true;
                    if (MLN.LogBuildingPlan >= 2) {
                        MLN.minor(this, "Registered building: " + location + " (level " + location.level + ", variation: " + location.getVariation() + ")");
                    }
                    if (project.location.level >= 0) {
                        for (String s : project.location.subBuildings) {
                            BuildingProject newproject = new BuildingProject(this.culture.getBuildingPlanSet(s));
                            newproject.location = location.createLocationForSubBuilding(s);
                            projectsLevel.insertElementAt(newproject, pos + 1);
                            if (MLN.LogBuildingPlan < 1) continue;
                            MLN.major(this, "Adding sub-building to project list: " + newproject + " at pos " + pos + " in " + projectsLevel);
                        }
                    }
                    ++pos;
                    continue;
                }
                if (registered || project.location == null || project.location.level >= 0 || !location.key.equals(project.key)) continue;
                project.location = location;
                registered = true;
                if (MLN.LogBuildingPlan < 1) continue;
                MLN.major(this, "Registered subbuilding: " + location + " (level " + location.level + ", variation: " + location.getVariation() + ")");
            }
        }
        if (!registered) {
            BuildingProject project = new BuildingProject(this.culture.getBuildingPlanSet(location.key));
            project.location = location;
            if (this.villageType.playerControlled) {
                this.buildingProjects.get(3).add(project);
            } else {
                this.buildingProjects.lastElement().add(project);
            }
        }
        this.mw.testLocations("fillinBuildingLocation end");
    }

    public void fillStartingGoods() {
        for (Point p : this.chests) {
            TileEntityMillChest chest = p.getMillChest(this.worldObj);
            if (chest == null) continue;
            for (int i = 0; i < chest.func_70302_i_(); ++i) {
                chest.func_70299_a(i, null);
            }
        }
        for (BuildingPlan.StartingGood sg : this.location.getPlan().startingGoods) {
            int chestId;
            TileEntityMillChest chest;
            if (!MillCommonUtilities.probability(sg.probability)) continue;
            int nb = sg.fixedNumber;
            if (sg.randomNumber > 0) {
                nb += MillCommonUtilities.randomInt(sg.randomNumber + 1);
            }
            if (nb <= 0 || (chest = this.chests.get(chestId = MillCommonUtilities.randomInt(this.chests.size())).getMillChest(this.worldObj)) == null) continue;
            MillCommonUtilities.putItemsInChest((IInventory)chest, sg.item.getItem(), sg.item.meta, nb);
        }
        if (MLN.DEV) {
            this.testModeGoods();
        }
    }

    private Point findAttackerSpawnPoint(Point origin) {
        int x = origin.getiX() > this.pos.getiX() ? Math.min(this.winfo.length - 5, this.winfo.length / 2 + 50) : Math.max(5, this.winfo.length / 2 - 50);
        int z = origin.getiZ() > this.pos.getiZ() ? Math.min(this.winfo.width - 5, this.winfo.width / 2 + 50) : Math.max(5, this.winfo.width / 2 - 50);
        for (int i = 0; i < 40; ++i) {
            int tx = x + MillCommonUtilities.randomInt(5 + i) - MillCommonUtilities.randomInt(5 + i);
            int tz = z + MillCommonUtilities.randomInt(5 + i) - MillCommonUtilities.randomInt(5 + i);
            tx = Math.max(Math.min(tx, this.winfo.length - 1), 0);
            tz = Math.max(Math.min(tz, this.winfo.width - 1), 0);
            tx = Math.min(tx, this.winfo.length / 2 + 50);
            tx = Math.max(tx, this.winfo.length / 2 - 50);
            tz = Math.min(tz, this.winfo.width / 2 + 50);
            if (!this.winfo.canBuild[tx][tz = Math.max(tz, this.winfo.width / 2 - 50)]) continue;
            Chunk chunk = this.worldObj.func_72938_d(this.winfo.mapStartX + tx, this.winfo.mapStartZ + tz);
            if (!chunk.field_76636_d) continue;
            return new Point(this.winfo.mapStartX + tx, MillCommonUtilities.findTopSoilBlock(this.worldObj, this.winfo.mapStartX + tx, this.winfo.mapStartZ + tz) + 1, this.winfo.mapStartZ + tz);
        }
        return this.getDefendingPos();
    }

    private void findBuildingConstruction() {
        if (this.buildingGoal == null || this.buildingLocationIP != null) {
            return;
        }
        BuildingProject goalProject = null;
        for (Vector<BuildingProject> projectsLevel : this.buildingProjects) {
            for (BuildingProject project : projectsLevel) {
                if (this.buildingGoalLocation != null && this.buildingGoalLocation.isSameLocation(project.location)) {
                    goalProject = project;
                    continue;
                }
                if (this.buildingGoalLocation != null || project.location != null || !this.buildingGoal.equals(project.key)) continue;
                goalProject = project;
            }
        }
        if (MLN.LogBuildingPlan >= 3) {
            MLN.debug(this, "Building goal project: " + goalProject + " ");
        }
        if (goalProject == null) {
            MLN.error(this, "Could not find building project for " + this.buildingGoal + " and " + this.buildingGoalLocation + ", cancelling goal.");
            this.buildingGoal = null;
            return;
        }
        if (goalProject.location != null && goalProject.location.level >= 0 && goalProject.location.upgradesAllowed) {
            if (this.canAffordBuild(goalProject.getPlan(this.buildingGoalVariation, this.buildingGoalLevel))) {
                this.buildingLocationIP = this.buildingGoalLocation != null ? this.buildingGoalLocation : goalProject.location;
                this.setBblocks(goalProject.getPlan(this.buildingGoalVariation, this.buildingGoalLevel).getBuildingPoints(this.worldObj, this.buildingLocationIP, false));
                if (MLN.LogBuildingPlan >= 1) {
                    MLN.major(this, "Upgrade project possible at: " + this.location + " for level " + this.buildingGoalLevel);
                }
                if (this.getBblocks().length == 0) {
                    MLN.error(this, "No bblocks for  " + this.buildingLocationIP);
                    try {
                        this.rushBuilding();
                    }
                    catch (Exception e) {
                        MLN.printException("Exception when trying to rush building:", e);
                    }
                }
            } else {
                this.buildingGoalIssue = "ui.lackingresources";
            }
        } else if (goalProject.location != null && goalProject.location.level < 0) {
            if (this.canAffordBuild(goalProject.getPlan(this.buildingGoalVariation, this.buildingGoalLevel))) {
                this.buildingLocationIP = this.buildingGoalLocation != null ? this.buildingGoalLocation : goalProject.location;
                this.setBblocks(goalProject.getPlan(this.buildingGoalVariation, this.buildingGoalLevel).getBuildingPoints(this.worldObj, this.buildingLocationIP, false));
                if (this.getBblocks().length == 0) {
                    MLN.error(this, "No bblocks for  " + this.buildingLocationIP);
                }
            } else {
                this.buildingGoalIssue = "ui.lackingresources";
            }
        } else if (goalProject.location == null) {
            boolean canAffordProject = this.canAffordBuild(goalProject.getPlan(this.buildingGoalVariation, 0));
            if (System.currentTimeMillis() - this.lastFailedProjectLocationSearch > 80000L && canAffordProject) {
                BuildingLocation location = goalProject.getPlan(this.buildingGoalVariation, 0).findBuildingLocation(this.winfo, this.pathing, this.location.pos, this.villageType.radius, MillCommonUtilities.getRandom(), -1);
                this.lastFailedProjectLocationSearch = System.currentTimeMillis();
                if (location != null) {
                    this.lastFailedProjectLocationSearch = 0L;
                    this.buildingLocationIP = location;
                    this.buildingGoalLocation = location;
                    this.setBblocks(goalProject.getPlan(this.buildingGoalVariation, 0).getBuildingPoints(this.worldObj, this.buildingLocationIP, false));
                    if (MLN.LogBuildingPlan >= 1) {
                        MLN.major(this, "New project location: Loaded " + this.getBblocks().length + " building blocks for " + goalProject.getPlan((int)this.buildingGoalVariation, (int)0).planName);
                    }
                    int groundLevel = MillCommonUtilities.findTopSoilBlock(this.worldObj, location.pos.getiX(), location.pos.getiZ());
                    for (int i = groundLevel + 1; i < location.pos.getiY(); ++i) {
                        MillCommonUtilities.setBlockAndMetadata(this.worldObj, location.pos, Blocks.field_150346_d, 0);
                    }
                    if (MLN.LogBuildingPlan >= 1) {
                        MLN.major(this, "Found location for building project: " + location);
                    }
                } else {
                    this.buildingGoalIssue = "ui.nospace";
                    this.lastFailedProjectLocationSearch = System.currentTimeMillis();
                    if (MLN.LogBuildingPlan >= 1) {
                        MLN.major(this, "Searching for a location for the new project failed.");
                    }
                }
            } else if (!canAffordProject) {
                this.buildingGoalIssue = "ui.lackingresources";
                if (MLN.LogBuildingPlan >= 3) {
                    MLN.debug(this, "Cannot afford building project.");
                }
            } else {
                this.buildingGoalIssue = "ui.nospace";
            }
        }
        if (this.buildingLocationIP != null) {
            return;
        }
        boolean attemptedConstruction = false;
        for (Vector<BuildingProject> projectsLevel : this.buildingProjects) {
            for (BuildingProject project : projectsLevel) {
                if (goalProject == null || project != goalProject) {
                    if (project.location == null || project.location.level < 0) {
                        BuildingPlan plan = project.planSet.getRandomStartingPlan();
                        if (this.isValidProject(project)) {
                            BuildingLocation location = null;
                            if (project.location == null && System.currentTimeMillis() - this.lastFailedOtherLocationSearch > 80000L && this.canAffordBuildAfterGoal(plan)) {
                                location = plan.findBuildingLocation(this.winfo, this.pathing, this.location.pos, this.villageType.radius, MillCommonUtilities.getRandom(), -1);
                            } else if (project.location != null && this.canAffordBuildAfterGoal(plan)) {
                                location = project.location.createLocationForLevel(0);
                            }
                            if (location != null) {
                                this.lastFailedOtherLocationSearch = 0L;
                                this.buildingLocationIP = location;
                                this.setBblocks(plan.getBuildingPoints(this.worldObj, this.buildingLocationIP, false));
                                if (MLN.LogBuildingPlan >= 1) {
                                    MLN.major(this, "New location non-project: Loaded " + this.getBblocks().length + " building blocks for " + plan.planName);
                                }
                            } else {
                                attemptedConstruction = true;
                            }
                        }
                    } else {
                        int level = project.location.level + 1;
                        int variation = project.location.getVariation();
                        if (level < project.getLevelsNumber(variation) && project.location.upgradesAllowed && this.canAffordBuildAfterGoal(project.getPlan(variation, level))) {
                            this.buildingLocationIP = project.location.createLocationForLevel(level);
                            this.setBblocks(project.getPlan(variation, level).getBuildingPoints(this.worldObj, this.buildingLocationIP, false));
                            if (MLN.LogBuildingPlan >= 1) {
                                MLN.major(this, "Upgrade non-project: Loaded " + this.getBblocks().length + " building blocks for " + project.getPlan((int)variation, (int)level).planName + " upgrade. Old level: " + project.location.level + " New level: " + level);
                            }
                        }
                    }
                }
                if (this.buildingLocationIP == null) continue;
                break;
            }
            if (this.buildingLocationIP == null) continue;
            break;
        }
        if (attemptedConstruction) {
            this.lastFailedOtherLocationSearch = System.currentTimeMillis();
        }
    }

    private void findBuildingProject() {
        if (this.buildingGoal != null && this.buildingGoal.length() > 0) {
            return;
        }
        if (this.noProjectsLeft) {
            return;
        }
        this.buildingGoal = null;
        this.buildingGoalLocation = null;
        if (MLN.LogBuildingPlan >= 2) {
            MLN.minor(this, "Searching for new building goal");
        }
        Vector<BuildingProject> possibleProjects = new Vector<BuildingProject>();
        boolean foundNewBuildingsLevel = false;
        for (Vector<BuildingProject> projectLevel : this.buildingProjects) {
            boolean includedNewBuildings = false;
            for (BuildingProject project : projectLevel) {
                if (!(project.location != null && project.location.level >= 0 || foundNewBuildingsLevel)) {
                    if (!this.isValidProject(project)) continue;
                    possibleProjects.add(project);
                    includedNewBuildings = true;
                    if (MLN.LogBuildingPlan >= 3) {
                        MLN.debug(this, "Found a new building to add: " + project);
                    }
                    if (MLN.LogBuildingPlan < 2 || project.getChoiceWeight(null) >= 1) continue;
                    MLN.minor(this, "Project has null or negative weight: " + project + ": " + project.getChoiceWeight(null));
                    continue;
                }
                if (project.location == null || project.location.level < 0 || project.location.level >= project.getLevelsNumber(project.location.getVariation()) || !project.location.upgradesAllowed || project.getChoiceWeight(null) <= 0) continue;
                possibleProjects.add(project);
            }
            if (!includedNewBuildings) continue;
            foundNewBuildingsLevel = true;
        }
        if (possibleProjects.size() == 0) {
            this.noProjectsLeft = true;
            return;
        }
        BuildingProject project = BuildingProject.getRandomProject(possibleProjects);
        BuildingPlan plan = project.getNextBuildingPlan();
        this.buildingGoal = project.key;
        this.buildingGoalLevel = plan.level;
        this.buildingGoalVariation = plan.variation;
        this.buildingGoalLocation = project.location == null ? null : project.location.createLocationForLevel(this.buildingGoalLevel);
        if (MLN.LogBuildingPlan >= 1) {
            MLN.major(this, "Picked new upgrade goal: " + this.buildingGoal + " level: " + this.buildingGoalLevel + " buildingGoalLocation: " + this.buildingGoalLocation);
        }
    }

    public void findName(String pname) {
        if (pname != null) {
            this.name = pname;
        } else {
            if (this.villageType.nameList == null) {
                this.name = null;
                return;
            }
            this.name = this.culture.getRandomNameFromList(this.villageType.nameList);
        }
        Vector<String> qualifiers = new Vector<String>();
        for (String s : this.villageType.qualifiers) {
            qualifiers.add(s);
        }
        if (this.villageType.hillQualifier != null && this.pos.getiY() > 75 && this.pos.getiY() < 85) {
            qualifiers.add(this.villageType.hillQualifier);
        } else if (this.villageType.mountainQualifier != null && this.pos.getiY() >= 85) {
            qualifiers.add(this.villageType.mountainQualifier);
        }
        if (this.villageType.desertQualifier != null || this.villageType.forestQualifier != null || this.villageType.lavaQualifier != null || this.villageType.lakeQualifier != null || this.villageType.oceanQualifier != null) {
            int cactus = 0;
            int wood = 0;
            int lake = 0;
            int ocean = 0;
            int lava = 0;
            for (int i = -50; i < 50; ++i) {
                for (int j = -10; j < 20; ++j) {
                    for (int k = -50; k < 50; ++k) {
                        Block block = this.worldObj.func_147439_a(i + this.pos.getiX(), j + this.pos.getiY(), k + this.pos.getiZ());
                        if (block == Blocks.field_150434_aF) {
                            ++cactus;
                            continue;
                        }
                        if (block == Blocks.field_150364_r) {
                            ++wood;
                            continue;
                        }
                        if (block == Blocks.field_150353_l) {
                            ++lava;
                            continue;
                        }
                        if (block != Blocks.field_150355_j || this.worldObj.func_147439_a(i + this.pos.getiX(), j + this.pos.getiY() + 1, k + this.pos.getiZ()) != Blocks.field_150350_a) continue;
                        if (j + this.pos.getiY() < 65) {
                            ++ocean;
                            continue;
                        }
                        ++lake;
                    }
                }
            }
            if (this.villageType.desertQualifier != null && cactus > 0) {
                qualifiers.add(this.villageType.desertQualifier);
            }
            if (this.villageType.forestQualifier != null && wood > 40) {
                qualifiers.add(this.villageType.forestQualifier);
            }
            if (this.villageType.lavaQualifier != null && lava > 0) {
                qualifiers.add(this.villageType.lavaQualifier);
            }
            if (this.villageType.lakeQualifier != null && lake > 0) {
                qualifiers.add(this.villageType.lakeQualifier);
            }
            if (this.villageType.oceanQualifier != null && ocean > 0) {
                qualifiers.add(this.villageType.oceanQualifier);
            }
        }
        this.qualifier = qualifiers.size() > 0 ? (String)qualifiers.get(MillCommonUtilities.randomInt(qualifiers.size())) : "";
    }

    public int getAltitude(int x, int z) {
        if (this.winfo == null) {
            return -1;
        }
        if (x < this.winfo.mapStartX || x >= this.winfo.mapStartX + this.winfo.length || z < this.winfo.mapStartZ || z >= this.winfo.mapStartZ + this.winfo.width) {
            return -1;
        }
        return this.winfo.topGround[x - this.winfo.mapStartX][z - this.winfo.mapStartZ];
    }

    public BuildingPlan.BuildingBlock[] getBblocks() {
        return this.bblocks;
    }

    public Building getBuildingAtCoord(Point p) {
        for (Building b : this.getBuildings()) {
            if (!b.location.isInside(p)) continue;
            return b;
        }
        return null;
    }

    public Vector<Building> getBuildings() {
        Vector<Building> vbuildings = new Vector<Building>();
        for (Point p : this.buildings) {
            Building building = this.mw.getBuilding(p);
            if (building == null || building.location == null) continue;
            vbuildings.add(building);
        }
        return vbuildings;
    }

    public Vector<Building> getBuildingsWithTag(String s) {
        Vector<Building> matches = new Vector<Building>();
        for (Point p : this.buildings) {
            Building building = this.mw.getBuilding(p);
            if (building == null || building.location == null || building.location.tags == null || !building.location.tags.contains(s)) continue;
            matches.add(building);
        }
        return matches;
    }

    public Vector<Goods> calculateBuyingGoods(IInventory playerInventory) {
        BuildingPlan goalPlan;
        if (!this.culture.shopBuys.containsKey(this.location.shop) && !this.culture.shopBuysOptional.containsKey(this.location.shop)) {
            return null;
        }
        Vector<Goods> baseGoods = this.culture.shopBuys.get(this.location.shop);
        Vector<Goods> extraGoods = new Vector<Goods>();
        if (this.culture.shopBuysOptional.containsKey(this.location.shop)) {
            for (Goods g : this.culture.shopBuysOptional.get(this.location.shop)) {
                if (playerInventory != null && MillCommonUtilities.countChestItems(playerInventory, g.item.getItem(), g.item.meta) <= 0) continue;
                extraGoods.add(g);
            }
        }
        if (this.isTownhall && (goalPlan = this.getCurrentGoalBuildingPlan()) != null) {
            for (MillVillager.InvItem key : goalPlan.resCost.keySet()) {
                if (key.meta == -1) continue;
                boolean found = false;
                for (Goods tg : baseGoods) {
                    if (tg.item.getItem() != key.getItem() || tg.item.meta != key.meta) continue;
                    found = true;
                }
                if (found) continue;
                if (this.culture.goodsByItem.containsKey(key)) {
                    extraGoods.add(this.culture.goodsByItem.get(key));
                    continue;
                }
                extraGoods.add(new Goods(key));
            }
        }
        if (extraGoods.size() == 0) {
            return baseGoods;
        }
        Vector<Goods> finalGoods = new Vector<Goods>();
        for (Goods good : baseGoods) {
            finalGoods.add(good);
        }
        for (Goods good : extraGoods) {
            finalGoods.add(good);
        }
        return finalGoods;
    }

    public Vector<Goods> calculateSellingGoods(IInventory playerInventory) {
        if (!this.culture.shopSells.containsKey(this.location.shop)) {
            return null;
        }
        return this.culture.shopSells.get(this.location.shop);
    }

    public HashMap<MillVillager.InvItem, Integer> getChestsContent() {
        HashMap<MillVillager.InvItem, Integer> contents = new HashMap<MillVillager.InvItem, Integer>();
        for (Point p : this.chests) {
            TileEntityMillChest chest = p.getMillChest(this.worldObj);
            if (chest == null) continue;
            for (int i = 0; i < chest.func_70302_i_(); ++i) {
                ItemStack stack = chest.func_70301_a(i);
                if (stack == null) continue;
                MillVillager.InvItem key = new MillVillager.InvItem(stack);
                if (stack == null) continue;
                if (contents.containsKey(key)) {
                    contents.put(key, stack.field_77994_a + contents.get(key));
                    continue;
                }
                contents.put(key, stack.field_77994_a);
            }
        }
        return contents;
    }

    public Point getClosestBlockAround(Point p, Block[] blocks, int hlimit, int vstart, int vend) {
        if (this.pathing == null) {
            return null;
        }
        int cx = p.getiX();
        int cz = p.getiZ();
        int x = cx;
        int z = cz;
        int dir = 3;
        int radius = 0;
        vstart = p.getiY() + vstart;
        vend = p.getiY() + vend;
        while (radius < hlimit) {
            if (x > this.winfo.mapStartX && x < this.winfo.mapStartX + this.winfo.length && z > this.winfo.mapStartZ && z < this.winfo.mapStartZ + this.winfo.width) {
                for (int i = vend; i >= vstart; --i) {
                    Block block = this.worldObj.func_147439_a(x, i, z);
                    for (Block tblock : blocks) {
                        Point np;
                        if (block != tblock || !this.pathing.isValidPoint(np = new Point(x, i, z))) continue;
                        return np;
                    }
                }
            }
            if (dir == 0) {
                if (x - cx < radius) {
                    ++x;
                    continue;
                }
                dir = 1;
                ++z;
                continue;
            }
            if (dir == 1) {
                if (z - cz < radius) {
                    ++z;
                    continue;
                }
                dir = 2;
                --x;
                continue;
            }
            if (dir == 2) {
                if (cx - x < radius) {
                    --x;
                    continue;
                }
                dir = 3;
                --z;
                continue;
            }
            if (cz - z < radius) {
                --z;
                continue;
            }
            dir = 0;
            x = cx - ++radius;
            z = cz - radius;
        }
        return null;
    }

    public Point getCraftingPos() {
        if (this.craftingPos != null) {
            return this.craftingPos;
        }
        if (this.sellingPos != null) {
            return this.sellingPos;
        }
        return this.sleepingPos;
    }

    public BuildingPlan.BuildingBlock getCurrentBlock() {
        if (this.bblocks == null) {
            return null;
        }
        if (this.bblocksPos >= this.bblocks.length) {
            return null;
        }
        return this.bblocks[this.bblocksPos];
    }

    public BuildingPlan getCurrentBuildingPlan() {
        if (this.buildingLocationIP == null) {
            return null;
        }
        for (Vector<BuildingProject> projectsLevel : this.buildingProjects) {
            for (BuildingProject project : projectsLevel) {
                if (this.buildingLocationIP.level == 0 && (project.location == null || project.location.level < 0) && project.key.equals(this.buildingLocationIP.key)) {
                    if (MLN.LogBuildingPlan >= 3) {
                        MLN.debug(this, "Returning building plan for " + this.buildingLocationIP + ": " + project.getPlan(this.buildingLocationIP.getVariation(), this.buildingLocationIP.level));
                    }
                    return project.getPlan(this.buildingLocationIP.getVariation(), this.buildingLocationIP.level);
                }
                if (!this.buildingLocationIP.isSameLocation(project.location)) continue;
                if (MLN.LogBuildingPlan >= 3) {
                    MLN.debug(this, "Returning building plan for " + this.buildingLocationIP + ": " + project.getPlan(this.buildingLocationIP.getVariation(), this.buildingLocationIP.level));
                }
                return project.getPlan(this.buildingLocationIP.getVariation(), this.buildingLocationIP.level);
            }
        }
        MLN.error(this, "Could not find plan for current building location: " + this.buildingLocationIP);
        return null;
    }

    public Point getCurrentClearPathPoint() {
        if (this.oldPathPointsToClear == null) {
            return null;
        }
        if (this.oldPathPointsToClearIndex >= this.oldPathPointsToClear.size()) {
            this.oldPathPointsToClear = null;
            return null;
        }
        return this.oldPathPointsToClear.get(this.oldPathPointsToClearIndex);
    }

    public BuildingPlan getCurrentGoalBuildingPlan() {
        if (this.buildingGoal == null) {
            return null;
        }
        for (Vector<BuildingProject> projectsLevel : this.buildingProjects) {
            for (BuildingProject project : projectsLevel) {
                if (!project.key.equals(this.buildingGoal)) continue;
                if (this.buildingGoalLocation == null) {
                    return project.getPlan(this.buildingGoalVariation, 0);
                }
                return project.getPlan(this.buildingGoalVariation, this.buildingGoalLocation.level);
            }
        }
        return null;
    }

    public BuildingPlan.BuildingBlock getCurrentPathBuildingBlock() {
        if (this.pathsToBuild == null) {
            return null;
        }
        while (true) {
            int meta;
            if (this.pathsToBuildIndex >= this.pathsToBuild.size()) {
                this.pathsToBuild = null;
                return null;
            }
            if (this.pathsToBuildPathIndex >= this.pathsToBuild.get(this.pathsToBuildIndex).size()) {
                ++this.pathsToBuildIndex;
                this.pathsToBuildPathIndex = 0;
                continue;
            }
            BuildingPlan.BuildingBlock b = this.pathsToBuild.get(this.pathsToBuildIndex).get(this.pathsToBuildPathIndex);
            Block block = b.p.getBlock(this.worldObj);
            if (MillCommonUtilities.canPathBeBuiltHere(block, meta = b.p.getMeta(this.worldObj)) && (block != b.block || meta != b.meta)) {
                return b;
            }
            ++this.pathsToBuildPathIndex;
        }
    }

    public Point getDefendingPos() {
        if (this.defendingPos != null) {
            return this.defendingPos;
        }
        if (this.sellingPos != null) {
            return this.sellingPos;
        }
        return this.sleepingPos;
    }

    public Point getEmptyBrickLocation() {
        Point p;
        int start;
        int i;
        if (this.brickspot.size() == 0) {
            return null;
        }
        for (i = start = MillCommonUtilities.randomInt(this.brickspot.size()); i < this.brickspot.size(); ++i) {
            p = this.brickspot.get(i);
            if (MillCommonUtilities.getBlock(this.worldObj, p) != Blocks.field_150350_a) continue;
            return p;
        }
        for (i = 0; i < start; ++i) {
            p = this.brickspot.get(i);
            if (MillCommonUtilities.getBlock(this.worldObj, p) != Blocks.field_150350_a) continue;
            return p;
        }
        return null;
    }

    public Building getFirstBuildingWithTag(String s) {
        for (Point p : this.buildings) {
            Building building = this.mw.getBuilding(p);
            if (building == null || building.location == null || building.location.tags == null || !building.location.tags.contains(s)) continue;
            return building;
        }
        return null;
    }

    public Vector<BuildingProject> getFlatProjectList() {
        Vector<BuildingProject> projects = new Vector<BuildingProject>();
        for (Vector<BuildingProject> projectLevel : this.buildingProjects) {
            for (BuildingProject project : projectLevel) {
                projects.add(project);
            }
        }
        return projects;
    }

    public Point getFullBrickLocation() {
        Point p;
        int start;
        int i;
        if (this.brickspot.size() == 0) {
            return null;
        }
        for (i = start = MillCommonUtilities.randomInt(this.brickspot.size()); i < this.brickspot.size(); ++i) {
            p = this.brickspot.get(i);
            if (MillCommonUtilities.getBlock(this.worldObj, p) != Mill.stone_decoration || MillCommonUtilities.getBlockMeta(this.worldObj, p) != 1) continue;
            return p;
        }
        for (i = 0; i < start; ++i) {
            p = this.brickspot.get(i);
            if (MillCommonUtilities.getBlock(this.worldObj, p) != Mill.stone_decoration || MillCommonUtilities.getBlockMeta(this.worldObj, p) != 1) continue;
            return p;
        }
        return null;
    }

    public String getGameBuildingName() {
        return this.location.getPlan().getGameName();
    }

    public HashMap<Goods, Integer> getImportsNeededbyOtherVillages() {
        if (this.neededGoodsCached != null && System.currentTimeMillis() < this.neededGoodsLastGenerated + 60000L) {
            return this.neededGoodsCached;
        }
        this.neededGoodsCached = new HashMap();
        for (Point vp : this.mw.villagesList.pos) {
            Building townHall;
            Chunk chunk = this.worldObj.func_72938_d(vp.getiX(), vp.getiZ());
            if (!chunk.field_76636_d || (townHall = this.mw.getBuilding(vp)) == null || this.getTownHall() == null || townHall.villageType == this.getTownHall().villageType || townHall.culture != this.getTownHall().culture || townHall.getBuildingsWithTag(tagInn).size() <= 0) continue;
            townHall.getNeededImportGoods(this.neededGoodsCached);
        }
        this.neededGoodsLastGenerated = System.currentTimeMillis();
        return this.neededGoodsCached;
    }

    public Set<Point> getKnownVillages() {
        return this.relations.keySet();
    }

    public BuildingLocation getLocationAtCoord(Point p) {
        if (this.buildingLocationIP != null && this.buildingLocationIP.isInside(p)) {
            return this.buildingLocationIP;
        }
        for (BuildingLocation bl : this.getLocations()) {
            if (!bl.isInside(p)) continue;
            return bl;
        }
        return null;
    }

    public Vector<BuildingLocation> getLocations() {
        Vector<BuildingLocation> locations = new Vector<BuildingLocation>();
        for (Vector<BuildingProject> projectsLevel : this.buildingProjects) {
            for (BuildingProject project : projectsLevel) {
                if (project.location == null) continue;
                locations.add(project.location);
            }
        }
        return locations;
    }

    public String getNativeBuildingName() {
        if (this.location.getPlan() == null) {
            return "";
        }
        return this.location.getPlan().nativeName;
    }

    public int getNbEmptyBrickLocation() {
        if (this.brickspot.size() == 0) {
            return 0;
        }
        int nb = 0;
        for (int i = 0; i < this.brickspot.size(); ++i) {
            Point p = this.brickspot.get(i);
            if (MillCommonUtilities.getBlock(this.worldObj, p) != Blocks.field_150350_a) continue;
            ++nb;
        }
        return nb;
    }

    public int getNbFullBrickLocation() {
        if (this.brickspot.size() == 0) {
            return 0;
        }
        int nb = 0;
        for (int i = 0; i < this.brickspot.size(); ++i) {
            Point p = this.brickspot.get(i);
            if (MillCommonUtilities.getBlock(this.worldObj, p) != Mill.stone_decoration || MillCommonUtilities.getBlockMeta(this.worldObj, p) != 1) continue;
            ++nb;
        }
        return nb;
    }

    public int getNbNetherWartHarvestLocation() {
        if (this.netherwartsoils.size() == 0) {
            return 0;
        }
        int nb = 0;
        for (int i = 0; i < this.netherwartsoils.size(); ++i) {
            Point p = this.netherwartsoils.get(i);
            if (MillCommonUtilities.getBlock(this.worldObj, p.getAbove()) != Blocks.field_150388_bm || MillCommonUtilities.getBlockMeta(this.worldObj, p.getAbove()) < 3) continue;
            ++nb;
        }
        return nb;
    }

    public int getNbNetherWartPlantingLocation() {
        if (this.netherwartsoils.size() == 0) {
            return 0;
        }
        int nb = 0;
        for (int i = 0; i < this.netherwartsoils.size(); ++i) {
            Point p = this.netherwartsoils.get(i);
            if (MillCommonUtilities.getBlock(this.worldObj, p.getAbove()) != Blocks.field_150350_a) continue;
            ++nb;
        }
        return nb;
    }

    public int getNbProjects() {
        int nb = 0;
        for (Vector<BuildingProject> projects : this.buildingProjects) {
            nb += projects.size();
        }
        return nb;
    }

    public int getNbSilkWormHarvestLocation() {
        if (this.silkwormblock.size() == 0) {
            return 0;
        }
        int nb = 0;
        for (int i = 0; i < this.silkwormblock.size(); ++i) {
            Point p = this.silkwormblock.get(i);
            if (MillCommonUtilities.getBlock(this.worldObj, p) != Mill.wood_decoration || MillCommonUtilities.getBlockMeta(this.worldObj, p) != 4) continue;
            ++nb;
        }
        return nb;
    }

    public int getNbSugarCaneHarvestLocation() {
        if (this.sugarcanesoils.size() == 0) {
            return 0;
        }
        int nb = 0;
        for (int i = 0; i < this.sugarcanesoils.size(); ++i) {
            Point p = this.sugarcanesoils.get(i);
            if (MillCommonUtilities.getBlock(this.worldObj, p.getRelative(0.0, 2.0, 0.0)) != Blocks.field_150436_aH) continue;
            ++nb;
        }
        return nb;
    }

    public int getNbSugarCanePlantingLocation() {
        if (this.sugarcanesoils.size() == 0) {
            return 0;
        }
        int nb = 0;
        for (int i = 0; i < this.sugarcanesoils.size(); ++i) {
            Point p = this.sugarcanesoils.get(i);
            if (MillCommonUtilities.getBlock(this.worldObj, p.getAbove()) != Blocks.field_150350_a) continue;
            ++nb;
        }
        return nb;
    }

    public void getNeededImportGoods(HashMap<Goods, Integer> neededGoods) {
        for (Goods good : this.culture.goodsVector) {
            int nbneeded = this.nbGoodNeeded(good.item.getItem(), good.item.meta);
            if (nbneeded <= 0) continue;
            if (MLN.LogMerchant >= 3) {
                MLN.debug(this, "Import needed: " + good.getName() + " - " + nbneeded);
            }
            if (neededGoods.containsKey(good)) {
                neededGoods.put(good, neededGoods.get(good) + nbneeded);
                continue;
            }
            neededGoods.put(good, nbneeded);
        }
    }

    public Point getNetherWartsHarvestLocation() {
        Point p;
        int start;
        int i;
        if (this.netherwartsoils.size() == 0) {
            return null;
        }
        for (i = start = MillCommonUtilities.randomInt(this.netherwartsoils.size()); i < this.netherwartsoils.size(); ++i) {
            p = this.netherwartsoils.get(i);
            if (MillCommonUtilities.getBlock(this.worldObj, p.getAbove()) != Blocks.field_150388_bm || MillCommonUtilities.getBlockMeta(this.worldObj, p.getAbove()) != 3) continue;
            return p;
        }
        for (i = 0; i < start; ++i) {
            p = this.netherwartsoils.get(i);
            if (MillCommonUtilities.getBlock(this.worldObj, p.getAbove()) != Blocks.field_150388_bm || MillCommonUtilities.getBlockMeta(this.worldObj, p.getAbove()) != 3) continue;
            return p;
        }
        return null;
    }

    public Point getNetherWartsPlantingLocation() {
        Point p;
        int start;
        int i;
        if (this.netherwartsoils.size() == 0) {
            return null;
        }
        for (i = start = MillCommonUtilities.randomInt(this.netherwartsoils.size()); i < this.netherwartsoils.size(); ++i) {
            p = this.netherwartsoils.get(i);
            if (MillCommonUtilities.getBlock(this.worldObj, p.getAbove()) != Blocks.field_150350_a || MillCommonUtilities.getBlock(this.worldObj, p) != Blocks.field_150425_aM) continue;
            return p;
        }
        for (i = 0; i < start; ++i) {
            p = this.netherwartsoils.get(i);
            if (MillCommonUtilities.getBlock(this.worldObj, p.getAbove()) != Blocks.field_150350_a || MillCommonUtilities.getBlock(this.worldObj, p) != Blocks.field_150425_aM) continue;
            return p;
        }
        return null;
    }

    public int getNewGender() {
        int nbmales = 0;
        int nbfemales = 0;
        for (VillagerRecord vr : this.vrecords) {
            if (vr.gender == 1) {
                ++nbmales;
                continue;
            }
            ++nbfemales;
        }
        int maleChance = 3 + nbfemales - nbmales;
        return MillCommonUtilities.randomInt(6) < maleChance ? 1 : 2;
    }

    public Point getPathStartPos() {
        if (this.pathStartPos != null) {
            return this.pathStartPos;
        }
        return this.getSellingPos();
    }

    public Point getLeasurePos() {
        if (this.leasurePos != null) {
            return this.leasurePos;
        }
        return this.getSellingPos();
    }

    public Point getPlantingLocation() {
        for (Point p : this.woodspawn) {
            Block block = MillCommonUtilities.getBlock(this.worldObj, p);
            if (block != Blocks.field_150350_a && block != Blocks.field_150433_aE) continue;
            return p;
        }
        return null;
    }

    public Point getPos() {
        return this.pos;
    }

    public Point getRandomLocationWithTag(String tag) {
        Vector<Point> v = new Vector<Point>();
        for (BuildingLocation l : this.getLocations()) {
            if (l.level < 0 || !l.tags.contains(tag) || l.sleepingPos == null) continue;
            v.add(l.sleepingPos);
        }
        if (v.size() == 0) {
            return null;
        }
        return (Point)v.get(MillCommonUtilities.randomInt(v.size()));
    }

    public int getRelationWithVillage(Point p) {
        if (this.relations.containsKey(p)) {
            return this.relations.get(p);
        }
        return 0;
    }

    public int getReputation(String playerName) {
        return this.mw.getProfile(playerName).getReputation(this);
    }

    public String getReputationLevelLabel(String playerName) {
        return this.culture.getReputationLevelLabel(this.getReputation(playerName));
    }

    public String getReputationLevelDesc(String playerName) {
        return this.culture.getReputationLevelDesc(this.getReputation(playerName));
    }

    public Point getSellingPos() {
        if (this.sellingPos != null) {
            return this.sellingPos;
        }
        return this.sleepingPos;
    }

    public Point getShelterPos() {
        if (this.shelterPos != null) {
            return this.shelterPos;
        }
        return this.sleepingPos;
    }

    public Building getShop(String shop) {
        for (BuildingLocation l : this.getLocations()) {
            if (l.level < 0 || !shop.equals(l.shop)) continue;
            return l.getBuilding(this.worldObj);
        }
        return null;
    }

    public Point getShopPos(String shop) {
        for (BuildingLocation l : this.getLocations()) {
            if (l.level < 0 || !shop.equals(l.shop)) continue;
            return l.chestPos;
        }
        return null;
    }

    public Vector<Building> getShops() {
        Vector<Building> shops = new Vector<Building>();
        for (Point p : this.buildings) {
            Building building = this.mw.getBuilding(p);
            if (building == null || building.location == null || building.location.shop == null || building.location.shop.length() <= 0) continue;
            shops.add(building);
        }
        return shops;
    }

    public Point getSilkwormHarvestLocation() {
        Point p;
        int start;
        int i;
        if (this.silkwormblock.size() == 0) {
            return null;
        }
        for (i = start = MillCommonUtilities.randomInt(this.silkwormblock.size()); i < this.silkwormblock.size(); ++i) {
            p = this.silkwormblock.get(i);
            if (MillCommonUtilities.getBlock(this.worldObj, p) != Mill.wood_decoration || MillCommonUtilities.getBlockMeta(this.worldObj, p) != 4) continue;
            return p;
        }
        for (i = 0; i < start; ++i) {
            p = this.silkwormblock.get(i);
            if (MillCommonUtilities.getBlock(this.worldObj, p) != Mill.wood_decoration || MillCommonUtilities.getBlockMeta(this.worldObj, p) != 4) continue;
            return p;
        }
        return null;
    }

    public Point getSleepingPos() {
        return this.sleepingPos;
    }

    public Vector<Point> getSoilPoints(String type) {
        for (int i = 0; i < this.soilTypes.size(); ++i) {
            if (!this.soilTypes.get(i).equals(type)) continue;
            return this.soils.get(i);
        }
        return null;
    }

    public Point getSugarCaneHarvestLocation() {
        Point p;
        int start;
        int i;
        if (this.sugarcanesoils.size() == 0) {
            return null;
        }
        for (i = start = MillCommonUtilities.randomInt(this.sugarcanesoils.size()); i < this.sugarcanesoils.size(); ++i) {
            p = this.sugarcanesoils.get(i);
            if (MillCommonUtilities.getBlock(this.worldObj, p.getRelative(0.0, 2.0, 0.0)) != Blocks.field_150436_aH) continue;
            return p;
        }
        for (i = 0; i < start; ++i) {
            p = this.sugarcanesoils.get(i);
            if (MillCommonUtilities.getBlock(this.worldObj, p.getRelative(0.0, 2.0, 0.0)) != Blocks.field_150436_aH) continue;
            return p;
        }
        return null;
    }

    public Point getSugarCanePlantingLocation() {
        Point p;
        int start;
        int i;
        if (this.sugarcanesoils.size() == 0) {
            return null;
        }
        for (i = start = MillCommonUtilities.randomInt(this.sugarcanesoils.size()); i < this.sugarcanesoils.size(); ++i) {
            p = this.sugarcanesoils.get(i);
            if (MillCommonUtilities.getBlock(this.worldObj, p.getAbove()) != Blocks.field_150350_a) continue;
            return p;
        }
        for (i = 0; i < start; ++i) {
            p = this.sugarcanesoils.get(i);
            if (MillCommonUtilities.getBlock(this.worldObj, p.getAbove()) != Blocks.field_150350_a) continue;
            return p;
        }
        return null;
    }

    public Point getCocoaPlantingLocation() {
        for (int i = 0; i < this.soilTypes.size(); ++i) {
            if (!this.soilTypes.get(i).equals("cacao")) continue;
            for (Point p : this.soils.get(i)) {
                if (p.getBlock(this.worldObj) != Blocks.field_150350_a) continue;
                if (p.getNorth().getBlock(this.worldObj) == Blocks.field_150364_r && BlockLog.func_150165_c((int)p.getNorth().getMeta(this.worldObj)) == 3) {
                    return p;
                }
                if (p.getEast().getBlock(this.worldObj) == Blocks.field_150364_r && BlockLog.func_150165_c((int)p.getEast().getMeta(this.worldObj)) == 3) {
                    return p;
                }
                if (p.getSouth().getBlock(this.worldObj) == Blocks.field_150364_r && BlockLog.func_150165_c((int)p.getSouth().getMeta(this.worldObj)) == 3) {
                    return p;
                }
                if (p.getWest().getBlock(this.worldObj) != Blocks.field_150364_r || BlockLog.func_150165_c((int)p.getWest().getMeta(this.worldObj)) != 3) continue;
                return p;
            }
        }
        return null;
    }

    public Point getCocoaHarvestLocation() {
        for (int i = 0; i < this.soilTypes.size(); ++i) {
            if (!this.soilTypes.get(i).equals("cacao")) continue;
            for (Point p : this.soils.get(i)) {
                int meta;
                if (p.getBlock(this.worldObj) != Blocks.field_150375_by || BlockCocoa.func_149987_c((int)(meta = p.getMeta(this.worldObj))) < 2) continue;
                return p;
            }
        }
        return null;
    }

    public Building getTownHall() {
        if (this.townHallPos == null) {
            return null;
        }
        return this.mw.getBuilding(this.townHallPos);
    }

    public int getVillageAttackerStrength() {
        int strength = 0;
        for (VillagerRecord vr : this.vrecords) {
            if (!vr.raidingVillage || vr.killed) continue;
            strength += vr.getMilitaryStrength();
        }
        return strength;
    }

    public int getVillageDefendingStrength() {
        int strength = 0;
        for (VillagerRecord vr : this.vrecords) {
            if (vr.getType() == null || !vr.getType().helpInAttacks || vr.killed || vr.raidingVillage) continue;
            strength += vr.getMilitaryStrength();
        }
        return strength;
    }

    public int getVillageIrrigation() {
        int irrigation = 0;
        for (BuildingLocation bl : this.getLocations()) {
            if (bl.getPlan() == null) continue;
            irrigation += bl.getPlan().irrigation;
        }
        return irrigation;
    }

    public void changeVillageName(String s) {
        this.name = s;
    }

    public void changeVillageQualifier(String s) {
        this.qualifier = s;
    }

    public String getVillageNameWithoutQualifier() {
        if (this.name == null || this.name.length() == 0) {
            if (this.villageType != null) {
                return this.villageType.name;
            }
            return this.getNativeBuildingName();
        }
        return this.name;
    }

    public String getVillageQualifiedName() {
        if (this.name == null || this.name.length() == 0) {
            if (this.villageType != null) {
                return this.villageType.name;
            }
            return this.getNativeBuildingName();
        }
        if (this.qualifier == null || this.qualifier.length() == 0) {
            return this.name;
        }
        return this.name + this.culture.qualifierSeparator + this.qualifier;
    }

    public int getVillageRaidingStrength() {
        int strength = 0;
        for (VillagerRecord vr : this.vrecords) {
            if (vr.getType() == null || !vr.getType().isRaider || vr.killed || vr.raidingVillage) continue;
            strength += vr.getMilitaryStrength();
        }
        return strength;
    }

    public MillVillager getVillagerById(long id) {
        for (MillVillager v : this.villagers) {
            if (v.villager_id != id) continue;
            return v;
        }
        return null;
    }

    public VillagerRecord getVillagerRecordById(long id) {
        for (VillagerRecord vr : this.vrecords) {
            if (vr.id != id) continue;
            return vr;
        }
        return null;
    }

    public int getWoodCount() {
        if (!this.location.tags.contains(tagGrove)) {
            return 0;
        }
        int nb = 0;
        for (int i = this.location.minx - 3; i < this.location.maxx + 3; ++i) {
            for (int j = this.location.pos.getiY() - 1; j < this.location.pos.getiY() + 10; ++j) {
                for (int k = this.location.minz - 3; k < this.location.maxz + 3; ++k) {
                    if (this.worldObj.func_147439_a(i, j, k) != Blocks.field_150364_r) continue;
                    ++nb;
                }
            }
        }
        return nb;
    }

    public Point getWoodLocation() {
        if (!this.location.tags.contains(tagGrove)) {
            return null;
        }
        for (int i = this.location.minx - 3; i < this.location.maxx + 3; ++i) {
            for (int j = this.location.pos.getiY() - 1; j < this.location.pos.getiY() + 10; ++j) {
                for (int k = this.location.minz - 3; k < this.location.maxz + 3; ++k) {
                    if (this.worldObj.func_147439_a(i, j, k) != Blocks.field_150364_r) continue;
                    return new Point(i, j, k);
                }
            }
        }
        return null;
    }

    public void growTree(World world, int i, int j, int k, Random random) {
        int meta = world.func_72805_g(i, j, k) & 3;
        MillCommonUtilities.setBlockAndMetadata(this.worldObj, i, j, k, Blocks.field_150350_a, 0, true, false);
        Object obj = null;
        obj = meta == 1 ? new WorldGenTaiga2(true) : (meta == 2 ? new WorldGenForest(true, true) : (meta == 3 ? new WorldGenTrees(true, 4, 3, 3, false) : new WorldGenTrees(true)));
        obj.func_76484_a(world, random, i, j, k);
    }

    public void incrementBblockPos() {
        ++this.bblocksPos;
        if (!this.areBlocksLeft()) {
            this.bblocks = null;
            this.bblocksPos = 0;
            this.bblocksChanged = true;
        }
    }

    public void initialise(EntityPlayer owner, boolean villageCreation) {
        if (MLN.LogWorldGeneration >= 1) {
            MLN.major(this, "Initialising building at " + this.getPos() + ", TH pos: " + this.townHallPos + ", TH: " + this.getTownHall());
        }
        if (this.isHouse()) {
            try {
                this.initialiseHouse(villageCreation);
            }
            catch (MLN.MillenaireException e) {
                MLN.printException("Error when trying to create a building: ", e);
            }
            this.updateHouseSign();
        }
        if (this.isTownhall) {
            this.initialiseTownHall(owner);
        } else {
            this.chestLocked = this.getTownHall().chestLocked;
            if (!this.chestLocked) {
                this.unlockChests();
            }
        }
    }

    public void initialiseBuildingProjects() {
        if (this.villageType == null) {
            MLN.error(this, "villageType is null!");
            return;
        }
        this.buildingProjects = this.villageType.getBuildingProjects();
    }

    public void initialiseCurrentConstruction(Point refPos) throws MLN.MillenaireException {
        boolean isTownHall = false;
        if (this.buildingLocationIP.equals(this.location)) {
            isTownHall = true;
        }
        Building building = this.buildingLocationIP.level == 0 ? new Building(this.mw, this.culture, this.villageType, this.buildingLocationIP, isTownHall, false, refPos, this.getPos()) : this.mw.getBuilding(refPos);
        BuildingPlan plan = this.getCurrentBuildingPlan();
        plan.referenceBuildingPoints(this.worldObj, building, this.buildingLocationIP);
        if (this.buildingLocationIP.level == 0) {
            building.initialise(null, false);
            this.registerBuildingEntity(building);
            if (MLN.LogBuildingPlan >= 1) {
                MLN.major(this, "Created new Building Entity: " + plan.planName + " at " + refPos);
            }
        }
        this.completeConstruction();
    }

    private void initialiseHouse(boolean villageCreation) throws MLN.MillenaireException {
        if (villageCreation) {
            this.createResidents();
        }
    }

    public void initialiseRelations(Point parentVillage) {
        if (this.villageType.lonebuilding) {
            return;
        }
        this.parentVillage = parentVillage;
        for (Point p : this.mw.villagesList.pos) {
            Building distantVillage;
            if (this.pos.sameBlock(p) || !(this.pos.distanceToSquared(p) < (double)(MLN.BackgroundRadius * MLN.BackgroundRadius)) || (distantVillage = this.mw.getBuilding(p)) == null) continue;
            if (parentVillage != null && (p.sameBlock(parentVillage) || parentVillage.sameBlock(distantVillage.parentVillage))) {
                this.adjustRelation(p, 100, true);
                continue;
            }
            if (this.villageType.playerControlled && this.controlledBy.equals(distantVillage.controlledBy)) {
                this.adjustRelation(p, 100, true);
                continue;
            }
            if (distantVillage.culture == this.culture) {
                this.adjustRelation(p, 50, true);
                continue;
            }
            this.adjustRelation(p, -30, true);
        }
    }

    public void initialiseTownHall(EntityPlayer controller) {
        if (this.name == null) {
            this.findName(null);
        }
        if (MLN.LogWorldGeneration >= 1) {
            MLN.major(this, "Initialising town hall: " + this.getVillageQualifiedName());
        }
        this.buildings.add(this.getPos());
        if (this.villageType.playerControlled && controller != null) {
            UserProfile profile = this.mw.getProfile(controller.getDisplayName());
            this.controlledBy = profile.key;
            profile.adjustReputation(this, 131072);
        }
    }

    public void initialiseVillage() {
        boolean noMenLeft = true;
        for (int i = this.vrecords.size() - 1; i >= 0; --i) {
            VillagerRecord vr = this.vrecords.get(i);
            if (vr.gender != 1 || vr.getType().isChild) continue;
            noMenLeft = false;
        }
        for (Point p : this.buildings) {
            Building b = this.mw.getBuilding(p);
            if (b == null) continue;
            if (noMenLeft) {
                b.unlockChests();
                continue;
            }
            b.lockChests();
        }
        this.recalculatePaths(true);
    }

    public boolean isDisplayableProject(BuildingProject project) {
        return !(project.getPlan((int)0, (int)0).requiredTag != null ? !this.mw.isGlobalTagSet(project.getPlan((int)0, (int)0).requiredTag) : project.getPlan((int)0, (int)0).isgift && !MLN.bonusEnabled);
    }

    public boolean isHouse() {
        return this.location != null && (this.location.maleResident.size() > 0 || this.location.femaleResident.size() > 0);
    }

    public boolean isPointProtectedFromPathBuilding(Point p) {
        Point above = p.getAbove();
        Point below = p.getBelow();
        for (Building b : this.getBuildings()) {
            if (b.location == null || !b.location.isInside(p)) continue;
            if (b.location.tags.contains(tagNoPaths)) {
                return true;
            }
            if (b.soils != null) {
                for (Vector<Point> vpoints : b.soils) {
                    if (!vpoints.contains(p) && !vpoints.contains(above) && !vpoints.contains(below)) continue;
                    return true;
                }
            }
            if (b.sources == null) continue;
            for (Vector<Point> vpoints : b.sources) {
                if (!vpoints.contains(p) && !vpoints.contains(above) && !vpoints.contains(below)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isReachableFromRegion(byte regionId) {
        if (this.getTownHall().pathing == null) {
            return true;
        }
        if (this.getTownHall().pathing.regions[this.getSleepingPos().getiX() - this.getTownHall().winfo.mapStartX][this.getSleepingPos().getiZ() - this.getTownHall().winfo.mapStartZ] != regionId) {
            return false;
        }
        if (this.getTownHall().pathing.regions[this.getSellingPos().getiX() - this.getTownHall().winfo.mapStartX][this.getSellingPos().getiZ() - this.getTownHall().winfo.mapStartZ] != regionId) {
            return false;
        }
        if (this.getTownHall().pathing.regions[this.getDefendingPos().getiX() - this.getTownHall().winfo.mapStartX][this.getDefendingPos().getiZ() - this.getTownHall().winfo.mapStartZ] != regionId) {
            return false;
        }
        return this.getTownHall().pathing.regions[this.getShelterPos().getiX() - this.getTownHall().winfo.mapStartX][this.getShelterPos().getiZ() - this.getTownHall().winfo.mapStartZ] == regionId;
    }

    public boolean isValidProject(BuildingProject project) {
        if (!(this.villageType.playerControlled || project.getPlan((int)0, (int)0).price <= 0 && !project.getPlan((int)0, (int)0).isgift || this.buildingsBought.contains(project.key))) {
            return false;
        }
        return project.getPlan((int)0, (int)0).requiredTag == null || this.mw.isGlobalTagSet(project.getPlan((int)0, (int)0).requiredTag);
    }

    private boolean isVillageChunksLoaded() {
        for (int x = this.winfo.mapStartX; x < this.winfo.mapStartX + this.winfo.width; x += 16) {
            for (int z = this.winfo.mapStartZ; z < this.winfo.mapStartZ + this.winfo.length; z += 16) {
                if (!this.worldObj.func_72863_F().func_73149_a(x / 16, z / 16)) {
                    return false;
                }
                if (this.worldObj.func_72938_d((int)x, (int)z).field_76636_d) continue;
                return false;
            }
        }
        return true;
    }

    private void killMobs() {
        if (this.winfo == null) {
            return;
        }
        for (Point buildingPos : this.buildings) {
            Building b = this.mw.getBuilding(buildingPos);
            if (b == null || b.location == null) continue;
            int radius = Math.max(b.location.length, b.location.width) / 2 + 8;
            Point start = new Point(b.location.pos.x - (double)radius, b.location.pos.getiY() - 10, b.location.pos.z - (double)radius);
            Point end = new Point(b.location.pos.x + (double)radius, b.location.pos.getiY() + 30, b.location.pos.z + (double)radius);
            if (this.location.tags.contains(tagDespawnAllMobs)) {
                List<Entity> mobs = MillCommonUtilities.getEntitiesWithinAABB(this.worldObj, EntityMob.class, start, end);
                for (Entity ent : mobs) {
                    if (ent.field_70128_L) continue;
                    if (MLN.LogTileEntityBuilding >= 3) {
                        MLN.debug(this, "Killing mob " + ent + " at " + ent.field_70165_t + "/" + ent.field_70163_u + "/" + ent.field_70161_v);
                    }
                    ent.func_70106_y();
                }
                continue;
            }
            List<Entity> creepers = MillCommonUtilities.getEntitiesWithinAABB(this.worldObj, EntityCreeper.class, start, end);
            for (Entity ent : creepers) {
                if (ent.field_70128_L) continue;
                if (MLN.LogTileEntityBuilding >= 3) {
                    MLN.debug(this, "Killing creeper " + ent + " at " + ent.field_70165_t + "/" + ent.field_70163_u + "/" + ent.field_70161_v);
                }
                ent.func_70106_y();
            }
            List<Entity> endermen = MillCommonUtilities.getEntitiesWithinAABB(this.worldObj, EntityEnderman.class, start, end);
            for (Entity ent : endermen) {
                if (ent.field_70128_L) continue;
                if (MLN.LogTileEntityBuilding >= 3) {
                    MLN.debug(this, "Killing enderman " + ent + " at " + ent.field_70165_t + "/" + ent.field_70163_u + "/" + ent.field_70161_v);
                }
                ent.func_70106_y();
            }
        }
    }

    private void loadChunks() {
        if (this.winfo != null && this.winfo.width > 0) {
            if (this.chunkLoader == null) {
                this.chunkLoader = new BuildingChunkLoader(this);
            }
            if (!this.chunkLoader.chunksLoaded) {
                this.chunkLoader.loadChunks();
            }
        }
    }

    public void lockAllBuildingsChests() {
        for (Point p : this.buildings) {
            Building b = this.mw.getBuilding(p);
            if (b == null) continue;
            b.lockChests();
        }
        this.saveNeeded = true;
        this.saveReason = "Locking chests";
    }

    public void lockChests() {
        this.chestLocked = true;
        for (Point p : this.chests) {
            TileEntityMillChest chest = p.getMillChest(this.worldObj);
            if (chest == null) continue;
            chest.buildingPos = this.getPos();
        }
    }

    public boolean lockedForPlayer(String playerName) {
        if (!this.chestLocked) {
            return false;
        }
        return !this.controlledBy(playerName);
    }

    private void merchantCreated() {
        if (MLN.LogMerchant >= 2) {
            MLN.minor(this, "Creating a new merchant");
        }
        this.merchantRecord = this.vrecords.lastElement();
        this.visitorsList.add("panels.startedtrading;" + this.merchantRecord.getName() + ";" + this.merchantRecord.getNativeOccupationName());
    }

    private void moveMerchant(Building destInn) {
        HashMap<MillVillager.InvItem, Integer> contents = this.getChestsContent();
        for (MillVillager.InvItem key : contents.keySet()) {
            int nb = this.takeGoods(key.getItem(), key.meta, 9999999);
            destInn.storeGoods(key.getItem(), key.meta, nb);
            destInn.addToImports(key, nb);
            this.addToExports(key, nb);
        }
        this.transferVillager(this.merchantRecord, destInn, false);
        this.visitorsList.add("panels.merchantmovedout;" + this.merchantRecord.getName() + ";" + this.merchantRecord.getNativeOccupationName() + ";" + destInn.getTownHall().getVillageQualifiedName() + ";" + this.nbNightsMerchant);
        destInn.visitorsList.add("panels.merchantarrived;" + this.merchantRecord.getName() + ";" + this.merchantRecord.getNativeOccupationName() + ";" + this.getTownHall().getVillageQualifiedName());
        if (MLN.LogMerchant >= 1) {
            MLN.major(this, "Moved merchant " + this.merchantRecord + " to " + destInn.getTownHall());
        }
        destInn.merchantRecord = this.merchantRecord;
        this.merchantRecord = null;
        this.nbNightsMerchant = 0;
    }

    public int nbGoodAvailable(Block block, boolean forExport, boolean forShop) {
        return this.nbGoodAvailable(new MillVillager.InvItem(block), forExport, forShop);
    }

    public int nbGoodAvailable(Block block, int meta, boolean forExport, boolean forShop) {
        return this.nbGoodAvailable(new MillVillager.InvItem(block, meta), forExport, forShop);
    }

    public int nbGoodAvailable(Item item, boolean forExport, boolean forShop) {
        return this.nbGoodAvailable(new MillVillager.InvItem(item), forExport, forShop);
    }

    public int nbGoodAvailable(Item item, int meta, boolean forExport, boolean forShop) {
        return this.nbGoodAvailable(new MillVillager.InvItem(item, meta), forExport, forShop);
    }

    public int nbGoodAvailable(MillVillager.InvItem ii, boolean forExport, boolean forShop) {
        BuildingPlan project;
        if (forShop && this.culture.shopNeeds.containsKey(this.location.shop)) {
            for (MillVillager.InvItem item : this.culture.shopNeeds.get(this.location.shop)) {
                if (!item.matches(ii)) continue;
                return 0;
            }
        }
        int nb = this.countGoods(ii.getItem(), ii.meta);
        if (this.builder != null && this.buildingLocationIP != null && this.buildingLocationIP.key.equals(this.buildingGoal)) {
            nb += this.builder.countInv(ii);
        }
        if (nb == 0) {
            return 0;
        }
        int reserveAmount = 0;
        boolean tradedHere = false;
        if (this.location.shop != null && this.culture.shopSells.containsKey(this.location.shop)) {
            for (Goods g : this.culture.shopSells.get(this.location.shop)) {
                if (!g.item.matches(ii)) continue;
                tradedHere = true;
            }
        }
        if (this.isTownhall || tradedHere || forExport) {
            Goods good;
            if (ii.meta == -1) {
                for (int i = 0; i < 16; ++i) {
                    Goods good2;
                    MillVillager.InvItem nitem = new MillVillager.InvItem(ii.item, i);
                    if (!this.culture.goodsByItem.containsKey(nitem) || (good2 = this.culture.goodsByItem.get(nitem)) == null) continue;
                    reserveAmount = forExport ? good2.targetQuantity : good2.reservedQuantity;
                }
            } else if (this.culture.goodsByItem.containsKey(ii.item) && (good = this.culture.goodsByItem.get(ii.item)) != null) {
                reserveAmount = forExport ? good.targetQuantity : good.reservedQuantity;
            }
        }
        for (VillagerRecord vr : this.vrecords) {
            if (vr.housePos == null || !vr.housePos.equals(this.getPos()) || vr.getType() == null) continue;
            for (MillVillager.InvItem requiredItem : vr.getType().requiredFoodAndGoods.keySet()) {
                if (!ii.matches(requiredItem)) continue;
                reserveAmount += vr.getType().requiredFoodAndGoods.get(requiredItem).intValue();
            }
        }
        if (MLN.LogMerchant >= 3) {
            MLN.debug(this, "Reserved amount: " + ii.getName() + ": " + reserveAmount + "/" + nb);
        }
        if ((project = this.getCurrentGoalBuildingPlan()) != null) {
            for (MillVillager.InvItem key : project.resCost.keySet()) {
                if (!key.matches(ii)) continue;
                if (MLN.LogMerchant >= 3) {
                    MLN.debug(this, "Needed for project: " + project.resCost.get(key));
                }
                if (project.resCost.get(key) + reserveAmount >= nb) {
                    return 0;
                }
                return nb - project.resCost.get(key) - reserveAmount;
            }
        }
        if (reserveAmount < nb) {
            return nb - reserveAmount;
        }
        return 0;
    }

    public int nbGoodNeeded(Item item, int meta) {
        Goods good;
        int nb = this.countGoods(item, meta);
        if (this.builder != null && this.buildingLocationIP != null && this.buildingLocationIP.key.equals(this.buildingGoal)) {
            nb += this.builder.countInv(item, meta);
        }
        int targetAmount = 0;
        MillVillager.InvItem invitem = new MillVillager.InvItem(item, meta);
        if (meta == -1) {
            for (int i = 0; i < 16; ++i) {
                Goods good2;
                if (!this.culture.goodsByItem.containsKey(invitem) || (good2 = this.culture.goodsByItem.get(new MillVillager.InvItem(item, i))) == null) continue;
                targetAmount += good2.targetQuantity;
            }
        } else if (this.culture.goodsByItem.containsKey(invitem) && (good = this.culture.goodsByItem.get(invitem)) != null) {
            targetAmount = good.targetQuantity;
        }
        BuildingPlan project = this.getCurrentGoalBuildingPlan();
        int neededForProject = 0;
        if (project != null) {
            for (MillVillager.InvItem key : project.resCost.keySet()) {
                if (key.getItem() != item || key.meta != meta && meta != -1 && key.meta != -1) continue;
                neededForProject += project.resCost.get(key).intValue();
            }
        }
        if (MLN.LogMerchant >= 3) {
            MLN.debug(this, "Goods needed: " + invitem.getName() + ": " + targetAmount + "/" + neededForProject + "/" + nb);
        }
        return Math.max(neededForProject + targetAmount - nb, 0);
    }

    private void readBblocks() {
        File buildingsDir = MillCommonUtilities.getBuildingsDir(this.worldObj);
        File file1 = new File(buildingsDir, this.getPos().getPathString() + "_bblocks.bin");
        if (file1.exists()) {
            try {
                FileInputStream fis = new FileInputStream(file1);
                DataInputStream ds = new DataInputStream(fis);
                int size = ds.readInt();
                this.bblocks = new BuildingPlan.BuildingBlock[size];
                for (int i = 0; i < size; ++i) {
                    BuildingPlan.BuildingBlock b;
                    Point p = new Point(ds.readInt(), ds.readShort(), ds.readInt());
                    this.bblocks[i] = b = new BuildingPlan.BuildingBlock(p, ds.readInt(), (int)ds.readByte(), (int)ds.readByte());
                }
                if (this.bblocks.length == 0) {
                    MLN.error(this, "Saved bblocks had zero elements. Rushing construction.");
                    try {
                        this.rushBuilding();
                    }
                    catch (Exception e) {
                        MLN.printException("Exception when trying to rush building:", e);
                    }
                }
                ds.close();
            }
            catch (Exception e) {
                MLN.printException("Error when reading bblocks: ", e);
                this.bblocks = null;
            }
        }
    }

    public boolean readFromNBT(NBTTagCompound nbttagcompound) {
        try {
            Point p;
            NBTTagList nbttaglist2;
            Vector<Point> v;
            Point p2;
            NBTTagCompound nbttagcompound1;
            int i;
            String version = nbttagcompound.func_74779_i("versionCompatibility");
            if (!version.equals(versionCompatibility)) {
                MLN.error(this, "Tried to load building with incompatible version: " + version);
                return false;
            }
            if (this.pos == null) {
                this.pos = Point.read(nbttagcompound, "pos");
            }
            this.chestLocked = nbttagcompound.func_74767_n("chestLocked");
            this.location = BuildingLocation.read(nbttagcompound, "buildingLocation", "self");
            if (this.location == null) {
                MLN.error(this, "No location found!");
                return false;
            }
            this.culture = Culture.getCultureByName(nbttagcompound.func_74779_i("culture"));
            if (this.culture == null) {
                MLN.error(this, "Could not load culture: " + nbttagcompound.func_74779_i("culture") + ", skipping building.");
                return false;
            }
            this.isTownhall = nbttagcompound.func_74764_b("isTownhall") ? nbttagcompound.func_74767_n("isTownhall") : this.location.key.equals(blTownhall);
            this.sleepingPos = Point.read(nbttagcompound, "spawnPos");
            this.sellingPos = Point.read(nbttagcompound, "sellingPos");
            this.craftingPos = Point.read(nbttagcompound, "craftingPos");
            this.defendingPos = Point.read(nbttagcompound, "defendingPos");
            this.shelterPos = Point.read(nbttagcompound, "shelterPos");
            this.pathStartPos = Point.read(nbttagcompound, "pathStartPos");
            this.leasurePos = Point.read(nbttagcompound, "leasurePos");
            this.townHallPos = Point.read(nbttagcompound, "townHallPos");
            this.thNightActionPerformed = nbttagcompound.func_74767_n("nightActionPerformed");
            this.nightBackgroundActionPerformed = nbttagcompound.func_74767_n("nightBackgroundActionPerformed");
            if (this.sleepingPos == null) {
                this.sleepingPos = this.pos.getAbove();
            }
            NBTTagList nbttaglist = nbttagcompound.func_150295_c("chests", 10);
            for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
                nbttagcompound1 = nbttaglist.func_150305_b(i);
                p2 = Point.read(nbttagcompound1, "pos");
                if (p2 == null || this.chests.contains(p2)) continue;
                this.chests.add(p2);
            }
            if (!this.chests.contains(this.pos)) {
                this.chests.insertElementAt(this.pos, 0);
            }
            nbttaglist = nbttagcompound.func_150295_c("furnaces", 10);
            for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
                nbttagcompound1 = nbttaglist.func_150305_b(i);
                p2 = Point.read(nbttagcompound1, "pos");
                if (p2 == null) continue;
                this.furnaces.add(p2);
            }
            nbttaglist = nbttagcompound.func_150295_c("brewingStands", 10);
            for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
                nbttagcompound1 = nbttaglist.func_150305_b(i);
                p2 = Point.read(nbttagcompound1, "pos");
                if (p2 == null) continue;
                this.brewingStands.add(p2);
            }
            nbttaglist = nbttagcompound.func_150295_c("signs", 10);
            for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
                nbttagcompound1 = nbttaglist.func_150305_b(i);
                p2 = Point.read(nbttagcompound1, "pos");
                if (p2 == null) continue;
                this.signs.add(p2);
            }
            nbttaglist = nbttagcompound.func_150295_c("netherwartsoils", 10);
            for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
                nbttagcompound1 = nbttaglist.func_150305_b(i);
                p2 = Point.read(nbttagcompound1, "pos");
                if (p2 == null) continue;
                this.netherwartsoils.add(p2);
            }
            nbttaglist = nbttagcompound.func_150295_c("silkwormblock", 10);
            for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
                nbttagcompound1 = nbttaglist.func_150305_b(i);
                p2 = Point.read(nbttagcompound1, "pos");
                if (p2 == null) continue;
                this.silkwormblock.add(p2);
            }
            nbttaglist = nbttagcompound.func_150295_c("sugarcanesoils", 10);
            for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
                nbttagcompound1 = nbttaglist.func_150305_b(i);
                p2 = Point.read(nbttagcompound1, "pos");
                if (p2 == null) continue;
                this.sugarcanesoils.add(p2);
            }
            nbttaglist = nbttagcompound.func_150295_c("fishingspots", 10);
            for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
                nbttagcompound1 = nbttaglist.func_150305_b(i);
                p2 = Point.read(nbttagcompound1, "pos");
                if (p2 == null) continue;
                this.fishingspots.add(p2);
            }
            nbttaglist = nbttagcompound.func_150295_c("healingspots", 10);
            for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
                nbttagcompound1 = nbttaglist.func_150305_b(i);
                p2 = Point.read(nbttagcompound1, "pos");
                if (p2 == null) continue;
                this.healingspots.add(p2);
            }
            nbttaglist = nbttagcompound.func_150295_c("stalls", 10);
            for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
                nbttagcompound1 = nbttaglist.func_150305_b(i);
                p2 = Point.read(nbttagcompound1, "pos");
                if (p2 == null) continue;
                this.stalls.add(p2);
            }
            nbttaglist = nbttagcompound.func_150295_c("woodspawn", 10);
            for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
                nbttagcompound1 = nbttaglist.func_150305_b(i);
                p2 = Point.read(nbttagcompound1, "pos");
                if (p2 == null) continue;
                this.woodspawn.add(p2);
            }
            nbttaglist = nbttagcompound.func_150295_c("brickspot", 10);
            for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
                nbttagcompound1 = nbttaglist.func_150305_b(i);
                p2 = Point.read(nbttagcompound1, "pos");
                if (p2 == null) continue;
                this.brickspot.add(p2);
            }
            nbttaglist = nbttagcompound.func_150295_c("spawns", 10);
            for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
                nbttagcompound1 = nbttaglist.func_150305_b(i);
                String spawnType = nbttagcompound1.func_74779_i("type");
                if (spawnType.equals("ml_FarmPig")) {
                    spawnType = "Pig";
                } else if (spawnType.equals("ml_FarmCow")) {
                    spawnType = "Cow";
                } else if (spawnType.equals("ml_FarmChicken")) {
                    spawnType = "Chicken";
                } else if (spawnType.equals("ml_FarmSheep")) {
                    spawnType = "Sheep";
                }
                this.spawnTypes.add(spawnType);
                Vector<Point> v2 = new Vector<Point>();
                NBTTagList nbttaglist22 = nbttagcompound1.func_150295_c("points", 10);
                for (int j = 0; j < nbttaglist22.func_74745_c(); ++j) {
                    NBTTagCompound nbttagcompound2 = nbttaglist22.func_150305_b(j);
                    Point p3 = Point.read(nbttagcompound2, "pos");
                    if (p3 == null) continue;
                    v2.add(p3);
                    if (MLN.LogHybernation < 2) continue;
                    MLN.minor(this, "Loaded spawn point: " + p3);
                }
                this.spawns.add(v2);
                if (MLN.LogHybernation < 2) continue;
                MLN.minor(this, "Loaded " + v2.size() + " spawn points for " + this.spawnTypes.get(i));
            }
            this.nbAnimalsRespawned = nbttagcompound.func_74762_e("nbAnimalsRespawned");
            nbttaglist = nbttagcompound.func_150295_c("mobspawns", 10);
            for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
                nbttagcompound1 = nbttaglist.func_150305_b(i);
                this.mobSpawnerTypes.add(nbttagcompound1.func_74779_i("type"));
                v = new Vector<Point>();
                nbttaglist2 = nbttagcompound1.func_150295_c("points", 10);
                for (int j = 0; j < nbttaglist2.func_74745_c(); ++j) {
                    NBTTagCompound nbttagcompound2 = nbttaglist2.func_150305_b(j);
                    p = Point.read(nbttagcompound2, "pos");
                    if (p == null) continue;
                    v.add(p);
                    if (MLN.LogHybernation < 2) continue;
                    MLN.minor(this, "Loaded spawn point: " + p);
                }
                this.mobSpawners.add(v);
                if (MLN.LogHybernation < 2) continue;
                MLN.minor(this, "Loaded " + v.size() + " mob spawn points for " + this.spawnTypes.get(i));
            }
            nbttaglist = nbttagcompound.func_150295_c("sources", 10);
            for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
                nbttagcompound1 = nbttaglist.func_150305_b(i);
                this.sourceTypes.add(Block.func_149729_e((int)nbttagcompound1.func_74762_e("type")));
                v = new Vector();
                nbttaglist2 = nbttagcompound1.func_150295_c("points", 10);
                for (int j = 0; j < nbttaglist2.func_74745_c(); ++j) {
                    NBTTagCompound nbttagcompound2 = nbttaglist2.func_150305_b(j);
                    p = Point.read(nbttagcompound2, "pos");
                    if (p == null) continue;
                    v.add(p);
                    if (MLN.LogHybernation < 3) continue;
                    MLN.debug(this, "Loaded source point: " + p);
                }
                this.sources.add(v);
                if (MLN.LogHybernation < 1) continue;
                MLN.debug(this, "Loaded " + v.size() + " sources points for " + this.sourceTypes.get(i).func_149739_a());
            }
            nbttaglist = nbttagcompound.func_150295_c("villagersrecords", 10);
            for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
                nbttagcompound1 = nbttaglist.func_150305_b(i);
                VillagerRecord vr = VillagerRecord.read(this.mw, this.culture, this.townHallPos, nbttagcompound1, "vr");
                if (vr == null) {
                    MLN.error(this, "Couldn't load VR record.");
                    continue;
                }
                this.addOrReplaceRecord(vr);
                if (MLN.LogHybernation < 2) continue;
                MLN.minor(this, "Loaded VR: " + vr);
            }
            nbttaglist = nbttagcompound.func_150295_c("visitorsList", 10);
            for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
                nbttagcompound1 = nbttaglist.func_150305_b(i);
                this.visitorsList.add(nbttagcompound1.func_74779_i("visitor"));
            }
            nbttaglist = nbttagcompound.func_150295_c("subBuildings", 10);
            for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
                nbttagcompound1 = nbttaglist.func_150305_b(i);
                p2 = Point.read(nbttagcompound1, "pos");
                if (p2 == null) continue;
                this.subBuildings.add(p2);
            }
            this.readLegacySoilsFromNBT(nbttagcompound);
            nbttaglist = nbttagcompound.func_150295_c("genericsoils", 10);
            for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
                nbttagcompound1 = nbttaglist.func_150305_b(i);
                String type = nbttagcompound1.func_74779_i("type");
                nbttaglist2 = nbttagcompound1.func_150295_c("points", 10);
                for (int j = 0; j < nbttaglist2.func_74745_c(); ++j) {
                    NBTTagCompound nbttagcompound2 = nbttaglist2.func_150305_b(j);
                    p = Point.read(nbttagcompound2, "pos");
                    if (p == null) continue;
                    this.addSoilPoint(type, p);
                }
            }
            if (this.location.tags.contains(tagPujas) || this.location.tags.contains(tagSacrifices)) {
                this.pujas = new PujaSacrifice(this, nbttagcompound.func_74775_l(tagPujas));
                if (MLN.LogPujas >= 2) {
                    MLN.minor(this, "read pujas object");
                }
            }
            this.lastGoodsRefresh = nbttagcompound.func_74763_f("lastGoodsRefresh");
            if (this.location.tags.contains(tagInn) && !this.isTownhall) {
                this.isInn = true;
                this.readInn(nbttagcompound);
            }
            if (this.isInn && this.vrecords.size() > 0) {
                this.merchantRecord = this.vrecords.get(0);
            }
            if (this.location.tags.contains("market") && !this.isTownhall) {
                this.isMarket = true;
            }
            if (this.isTownhall) {
                if (MLN.LogHybernation >= 1) {
                    MLN.major(this, "Loading Townhall data.");
                }
                this.readTownHall(nbttagcompound);
            }
            for (Point p4 : this.chests) {
                if (!this.worldObj.func_72899_e(p4.getiX(), p4.getiY(), p4.getiZ()) || p4.getMillChest(this.worldObj) == null) continue;
                p4.getMillChest((World)this.worldObj).buildingPos = this.getPos();
            }
            if (MLN.LogTileEntityBuilding >= 3) {
                MLN.debug(this, "Loading building. Type: " + this.location + ", pos: " + this.getPos());
            }
            return true;
        }
        catch (Exception e) {
            Mill.proxy.sendChatAdmin("Error when trying to load building. Check millenaire.log.");
            MLN.error(this, "Error when trying to load building of type: " + this.location);
            MLN.printException(e);
            return false;
        }
    }

    public void readInn(NBTTagCompound nbttagcompound) throws MLN.MillenaireException {
        MillVillager.InvItem good;
        NBTTagCompound tag;
        int i;
        NBTTagList nbttaglist = nbttagcompound.func_150295_c("importedGoods", 10);
        for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
            tag = nbttaglist.func_150305_b(i);
            good = new MillVillager.InvItem(Item.func_150899_d((int)tag.func_74762_e("itemid")), tag.func_74762_e("itemmeta"));
            this.imported.put(good, tag.func_74762_e("quantity"));
        }
        nbttaglist = nbttagcompound.func_150295_c("exportedGoods", 10);
        for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
            tag = nbttaglist.func_150305_b(i);
            good = new MillVillager.InvItem(Item.func_150899_d((int)tag.func_74762_e("itemid")), tag.func_74762_e("itemmeta"));
            this.exported.put(good, tag.func_74762_e("quantity"));
        }
    }

    private void readLegacySoilsFromNBT(NBTTagCompound nbttagcompound) {
        Point p;
        NBTTagCompound nbttagcompound1;
        int i;
        NBTTagList nbttaglist = nbttagcompound.func_150295_c("soils", 10);
        for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
            nbttagcompound1 = nbttaglist.func_150305_b(i);
            p = Point.read(nbttagcompound1, "pos");
            if (p == null) continue;
            this.addSoilPoint("wheat", p);
        }
        nbttaglist = nbttagcompound.func_150295_c("ricesoils", 10);
        for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
            nbttagcompound1 = nbttaglist.func_150305_b(i);
            p = Point.read(nbttagcompound1, "pos");
            if (p == null) continue;
            this.addSoilPoint("rice", p);
        }
        nbttaglist = nbttagcompound.func_150295_c("turmericsoils", 10);
        for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
            nbttagcompound1 = nbttaglist.func_150305_b(i);
            p = Point.read(nbttagcompound1, "pos");
            if (p == null) continue;
            this.addSoilPoint("turmeric", p);
        }
        nbttaglist = nbttagcompound.func_150295_c("maizesoils", 10);
        for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
            nbttagcompound1 = nbttaglist.func_150305_b(i);
            p = Point.read(nbttagcompound1, "pos");
            if (p == null) continue;
            this.addSoilPoint("maize", p);
        }
        nbttaglist = nbttagcompound.func_150295_c("vinesoils", 10);
        for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
            nbttagcompound1 = nbttaglist.func_150305_b(i);
            p = Point.read(nbttagcompound1, "pos");
            if (p == null) continue;
            this.addSoilPoint("vine", p);
        }
    }

    private void readPaths() {
        int i;
        int size;
        DataInputStream ds;
        FileInputStream fis;
        File buildingsDir = MillCommonUtilities.getBuildingsDir(this.worldObj);
        File file1 = new File(buildingsDir, this.getPos().getPathString() + "_paths.bin");
        if (file1.exists()) {
            try {
                fis = new FileInputStream(file1);
                ds = new DataInputStream(fis);
                size = ds.readInt();
                this.pathsToBuild = new Vector();
                for (i = 0; i < size; ++i) {
                    Vector<BuildingPlan.BuildingBlock> path = new Vector<BuildingPlan.BuildingBlock>();
                    int sizePath = ds.readInt();
                    for (int j = 0; j < sizePath; ++j) {
                        Point p = new Point(ds.readInt(), ds.readShort(), ds.readInt());
                        BuildingPlan.BuildingBlock b = new BuildingPlan.BuildingBlock(p, ds.readInt(), (int)ds.readByte(), (int)ds.readByte());
                        path.add(b);
                    }
                    this.pathsToBuild.add(path);
                }
                ds.close();
            }
            catch (Exception e) {
                MLN.printException("Error when reading pathsToBuild: ", e);
                this.bblocks = null;
            }
        }
        if ((file1 = new File(buildingsDir, this.getPos().getPathString() + "_pathstoclear.bin")).exists()) {
            try {
                fis = new FileInputStream(file1);
                ds = new DataInputStream(fis);
                size = ds.readInt();
                this.oldPathPointsToClear = new Vector();
                for (i = 0; i < size; ++i) {
                    Point p = new Point(ds.readInt(), ds.readShort(), ds.readInt());
                    this.oldPathPointsToClear.add(p);
                }
                ds.close();
            }
            catch (Exception e) {
                MLN.printException("Error when reading oldPathPointsToClear: ", e);
                this.bblocks = null;
            }
        }
    }

    public void readTownHall(NBTTagCompound nbttagcompound) {
        int i;
        Point p;
        NBTTagCompound nbttagcompound1;
        int i2;
        this.name = nbttagcompound.func_74779_i("name");
        this.qualifier = nbttagcompound.func_74779_i("qualifier");
        String vtype = nbttagcompound.func_74779_i("villageType");
        this.villageType = vtype.length() == 0 ? this.culture.getRandomVillage() : (this.culture.getVillageType(vtype) != null ? this.culture.getVillageType(vtype) : (this.culture.getLoneBuildingType(vtype) != null ? this.culture.getLoneBuildingType(vtype) : this.culture.getRandomVillage()));
        this.controlledBy = nbttagcompound.func_74779_i("controlledBy");
        NBTTagList nbttaglist = nbttagcompound.func_150295_c("houses", 10);
        for (i2 = 0; i2 < nbttaglist.func_74745_c(); ++i2) {
            nbttagcompound1 = nbttaglist.func_150305_b(i2);
            p = Point.read(nbttagcompound1, "pos");
            if (p == null) continue;
            this.buildings.add(p);
        }
        nbttaglist = nbttagcompound.func_150295_c("buildings", 10);
        for (i2 = 0; i2 < nbttaglist.func_74745_c(); ++i2) {
            nbttagcompound1 = nbttaglist.func_150305_b(i2);
            p = Point.read(nbttagcompound1, "pos");
            if (p == null) continue;
            this.buildings.add(p);
        }
        this.initialiseBuildingProjects();
        nbttaglist = nbttagcompound.func_150295_c("locations", 10);
        for (i2 = 0; i2 < nbttaglist.func_74745_c(); ++i2) {
            nbttagcompound1 = nbttaglist.func_150305_b(i2);
            BuildingLocation location = BuildingLocation.read(nbttagcompound1, "location", "locations");
            if (location == null) {
                MLN.error(this, "Could not load building location. Skipping.");
                continue;
            }
            this.fillinBuildingLocation(location);
        }
        for (i2 = this.buildings.size() - 1; i2 >= 0; --i2) {
            boolean foundLocation = false;
            for (BuildingLocation l : this.getLocations()) {
                if (!this.buildings.get(i2).equals(l.chestPos)) continue;
                foundLocation = true;
            }
            if (foundLocation) continue;
            MLN.error(this, "Deleting building as could not find the location for it at: " + this.buildings.get(i2));
            this.buildings.remove(i2);
        }
        if (this.villageType.playerControlled) {
            for (Vector<BuildingProject> level : this.buildingProjects) {
                Vector<BuildingProject> toDelete = new Vector<BuildingProject>();
                for (BuildingProject project : level) {
                    if (project.location != null) continue;
                    toDelete.add(project);
                }
                for (BuildingProject project : toDelete) {
                    level.remove(project);
                }
            }
        }
        this.buildingGoal = nbttagcompound.func_74779_i("buildingGoal");
        if (this.culture.getBuildingPlanSet(this.buildingGoal) == null) {
            this.buildingGoal = null;
            this.buildingGoalLevel = 0;
            this.buildingGoalVariation = 0;
            if (MLN.LogHybernation >= 1) {
                MLN.major(this, "No goal found: " + this.buildingGoal);
            }
        } else {
            this.buildingGoalLevel = nbttagcompound.func_74762_e("buildingGoalLevel");
            this.buildingGoalVariation = nbttagcompound.func_74762_e("buildingGoalVariation");
            if (MLN.LogHybernation >= 1) {
                MLN.major(this, "Reading building goal: " + this.buildingGoal);
            }
        }
        this.buildingGoalLocation = BuildingLocation.read(nbttagcompound, "buildingGoalLocation", "buildingGoalLocation");
        if (this.buildingGoalLocation != null && MLN.LogHybernation >= 1) {
            MLN.major(this, "Loaded buildingGoalLocation: " + this.buildingGoalLocation);
        }
        this.buildingGoalIssue = nbttagcompound.func_74779_i("buildingGoalIssue");
        this.buildingLocationIP = BuildingLocation.read(nbttagcompound, "buildingLocationIP", "buildingLocationIP");
        if (this.buildingLocationIP != null) {
            if (this.culture.getBuildingPlanSet(this.buildingLocationIP.key) == null) {
                this.buildingLocationIP = null;
            } else {
                BuildingPlanSet set = this.culture.getBuildingPlanSet(this.buildingLocationIP.key);
                if (this.buildingLocationIP.level >= set.plans.get(this.buildingLocationIP.getVariation()).length) {
                    this.buildingLocationIP = null;
                }
            }
            this.readBblocks();
            this.bblocksPos = nbttagcompound.func_74762_e("bblocksPos");
        }
        nbttaglist = nbttagcompound.func_150295_c("buildingsBought", 10);
        for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound12 = nbttaglist.func_150305_b(i);
            this.buildingsBought.add(nbttagcompound12.func_74779_i("key"));
        }
        this.parentVillage = Point.read(nbttagcompound, "parentVillage");
        if (nbttagcompound.func_74764_b("relations")) {
            nbttaglist = nbttagcompound.func_150295_c("relations", 10);
            for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound13 = nbttaglist.func_150305_b(i);
                this.relations.put(Point.read(nbttagcompound13, "pos"), nbttagcompound13.func_74762_e("value"));
            }
        }
        this.updateRaidPerformed = nbttagcompound.func_74767_n("updateRaidPerformed");
        this.nightBackgroundActionPerformed = nbttagcompound.func_74767_n("nightBackgroundActionPerformed");
        this.thNightActionPerformed = nbttagcompound.func_74767_n("nightActionPerformed");
        this.raidTarget = Point.read(nbttagcompound, "raidTarget");
        this.raidPlanningStart = nbttagcompound.func_74763_f("raidPlanningStart");
        this.raidStart = nbttagcompound.func_74763_f("raidStart");
        this.underAttack = nbttagcompound.func_74767_n("underAttack");
        nbttaglist = nbttagcompound.func_150295_c("raidsPerformed", 10);
        for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound14 = nbttaglist.func_150305_b(i);
            this.raidsPerformed.add(nbttagcompound14.func_74779_i("raid"));
        }
        nbttaglist = nbttagcompound.func_150295_c("raidsTaken", 10);
        for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound15 = nbttaglist.func_150305_b(i);
            this.raidsSuffered.add(nbttagcompound15.func_74779_i("raid"));
        }
        this.pathsToBuildIndex = nbttagcompound.func_74762_e("pathsToBuildIndex");
        this.pathsToBuildPathIndex = nbttagcompound.func_74762_e("pathsToBuildPathIndex");
        this.oldPathPointsToClearIndex = nbttagcompound.func_74762_e("oldPathPointsToClearIndex");
        this.readPaths();
    }

    public boolean rebuildPathing(boolean sync) throws MLN.MillenaireException {
        if (MLN.jpsPathing) {
            return false;
        }
        if (sync) {
            AStarPathing temp = new AStarPathing();
            if (temp.createConnectionsTable(this.winfo, this.sleepingPos)) {
                this.pathing = temp;
                this.lastPathingUpdate = System.currentTimeMillis();
                return true;
            }
            this.pathing = null;
            this.lastPathingUpdate = System.currentTimeMillis();
            return false;
        }
        if (!this.rebuildingPathing) {
            try {
                this.rebuildingPathing = true;
                PathingThread thread = new PathingThread(this.winfo.clone());
                thread.setPriority(1);
                if (MLN.LogPathing >= 1) {
                    MLN.major(this, "Thread starting.");
                }
                thread.start();
                if (MLN.LogPathing >= 1) {
                    MLN.major(this, "Thread started.");
                }
            }
            catch (CloneNotSupportedException e) {
                MLN.printException(e);
            }
            return true;
        }
        return true;
    }

    public void rebuildSurfacePathing() {
        if (this.binaryPathing == null) {
            this.binaryPathing = new PathingBinary(this.worldObj);
        }
        this.binaryPathing.updatePathing(this.getPos(), this.villageType.radius + 20, 20);
        this.lastPathingUpdate = System.currentTimeMillis();
    }

    public void recalculatePaths(boolean autobuild) {
        if (!MLN.BuildVillagePaths) {
            return;
        }
        int nbPaths = 0;
        for (Building b : this.getBuildings()) {
            if (b == this || b.location == null || b.location.getPlan() == null || b.location.getPlan().isSubBuilding() || b.getPathStartPos() == null) continue;
            ++nbPaths;
        }
        PathCreatorInfo info = new PathCreatorInfo(nbPaths);
        this.autobuildPaths = autobuild;
        Point start = this.getPathStartPos();
        if (MLN.LogVillagePaths >= 2) {
            MLN.minor(this, "Launching path rebuild, expected paths number: " + nbPaths);
        }
        for (Building b : this.getBuildings()) {
            if (b == this || b.location == null || b.location.getPlan() == null || b.location.getPlan().isSubBuilding() || b.getPathStartPos() == null) continue;
            MillVillager.InvItem pathMaterial = this.villageType.pathMaterial.firstElement();
            if (b.location.getPlan().pathLevel < this.villageType.pathMaterial.size()) {
                pathMaterial = this.villageType.pathMaterial.get(b.location.getPlan().pathLevel);
            }
            PathCreator pathCreator = new PathCreator(info, pathMaterial, b.location.getPlan().pathWidth, b);
            AStarPathPlanner jpsPathPlanner = new AStarPathPlanner(this.worldObj, pathCreator);
            jpsPathPlanner.getPath(start.getiX(), start.getiY(), start.getiZ(), b.getPathStartPos().getiX(), b.getPathStartPos().getiY(), b.getPathStartPos().getiZ(), PATH_BUILDER_JPS_CONFIG);
        }
    }

    private void refreshGoods() {
        if (this.location == null || this.location.getPlan() == null || this.location.getPlan().startingGoods.size() == 0) {
            return;
        }
        if (this.worldObj.func_72935_r()) {
            this.refreshGoodsNightActionPerformed = false;
        } else if (!this.refreshGoodsNightActionPerformed) {
            long interval = this.chestLocked ? 20L : 100L;
            if (this.lastGoodsRefresh + interval * 24000L < this.worldObj.func_72820_D() && this.chestLocked) {
                this.fillStartingGoods();
                this.lastGoodsRefresh = this.worldObj.func_72820_D();
            }
            this.refreshGoodsNightActionPerformed = true;
        }
    }

    public void registerBuildingEntity(Building buildingEntity) throws MLN.MillenaireException {
        if (buildingEntity != this) {
            for (MillVillager v : buildingEntity.villagers) {
                this.addOrReplaceVillager(v);
                if (v.getRecord() != null) {
                    this.addOrReplaceRecord(v.getRecord());
                    continue;
                }
                this.addOrReplaceRecord(new VillagerRecord(this.mw, v));
            }
        }
        this.buildings.add(buildingEntity.getPos());
        this.saveNeeded = true;
        this.saveReason = "Registering building";
    }

    public void registerBuildingLocation(BuildingLocation location) {
        boolean registered = false;
        int nbProjects = 0;
        for (int i = 0; i < this.buildingProjects.size() && !registered; ++i) {
            for (int j = 0; j < this.buildingProjects.get(i).size() && !registered; ++j) {
                BuildingProject project = this.buildingProjects.get(i).get(j);
                if (location.level == 0) {
                    if (project.key.equals(location.key) && (project.location == null || project.location.level < 0 && project.location.isSameLocation(location))) {
                        if (project.location != null) {
                            location.upgradesAllowed = project.location.upgradesAllowed;
                        }
                        project.location = location;
                        registered = true;
                        if (MLN.LogBuildingPlan >= 1) {
                            MLN.major(this, "Updated building project: " + project + " with initial location.");
                        }
                    }
                } else if (location.isSameLocation(project.location)) {
                    if (MLN.LogBuildingPlan >= 1) {
                        MLN.major(this, "Updated building project: " + project + " from level " + project.location.level + " to " + location.level);
                    }
                    location.upgradesAllowed = project.location.upgradesAllowed;
                    project.location = location;
                    registered = true;
                }
                ++nbProjects;
            }
        }
        if (registered) {
            if (MLN.LogBuildingPlan >= 1) {
                MLN.major(this, "Registered building location: " + location);
            }
        } else {
            MLN.error(this, "Could not register building location: " + location + " amoung " + nbProjects + " projects.");
        }
        if (this.getCurrentBuildingPlan() != null) {
            for (Point p : this.buildings) {
                Building building = this.mw.getBuilding(p);
                if (MLN.LogBuildingPlan >= 1) {
                    MLN.major(this, "Testing building: " + building);
                }
                if (building == null || building.location == null || !building.location.isSameLocation(location)) continue;
                building.location = location;
                this.getCurrentBuildingPlan().referenceBuildingPoints(this.worldObj, building, location);
                if (MLN.LogBuildingPlan < 1) continue;
                MLN.major(this, "Updated building location for building: " + building + " now at upgrade: " + location.level);
            }
        }
        for (String s : location.subBuildings) {
            boolean found = false;
            Vector<BuildingProject> parentProjectLevel = null;
            int parentPos = 0;
            for (Vector<BuildingProject> projects : this.buildingProjects) {
                int pos = 0;
                for (BuildingProject project : projects) {
                    if (project.location != null) {
                        if (project.location.isLocationSamePlace(location) && project.key.equals(s)) {
                            found = true;
                        } else if (project.location.isSameLocation(location)) {
                            parentProjectLevel = projects;
                            parentPos = pos;
                        }
                    }
                    ++pos;
                }
            }
            if (found || parentProjectLevel == null) continue;
            if (this.culture.getBuildingPlanSet(s) == null) {
                MLN.error(this, "Could not find plan for finished building: " + s);
                return;
            }
            BuildingProject project = new BuildingProject(this.culture.getBuildingPlanSet(s));
            project.location = location.createLocationForSubBuilding(s);
            parentProjectLevel.insertElementAt(project, parentPos + 1);
        }
        this.saveNeeded = true;
        this.saveReason = "Registering location";
    }

    public void registerVillager(MillVillager villager) throws MLN.MillenaireException {
        if (MLN.LogGeneralAI >= 3) {
            MLN.debug(this, "Registering villager " + villager);
        }
        this.addOrReplaceVillager(villager);
        int nbFound = 0;
        VillagerRecord vrfound = null;
        for (int i = 0; i < this.vrecords.size(); ++i) {
            VillagerRecord vr = this.vrecords.get(i);
            if (vr.id != villager.villager_id) continue;
            ++nbFound;
            vrfound = vr;
        }
        if (vrfound != null) {
            vrfound.updateRecord(villager);
        }
        if (nbFound == 0) {
            VillagerRecord vr = villager.getRecord();
            if (vr != null) {
                if (MLN.LogGeneralAI >= 1) {
                    MLN.major(this, "Adding record " + vr);
                }
                this.addOrReplaceRecord(vr);
            } else {
                if (MLN.LogGeneralAI >= 1) {
                    MLN.major(this, "Adding new record " + new VillagerRecord(this.mw, villager));
                }
                this.addOrReplaceRecord(new VillagerRecord(this.mw, villager));
            }
            this.saveNeeded = true;
            this.saveReason = "Registering villager";
        }
    }

    public boolean removeVillagerRecord(long vid) {
        for (VillagerRecord vr : this.vrecords) {
            if (vr.id != vid) continue;
            this.vrecords.remove(vr);
            return true;
        }
        return false;
    }

    private void repairVillagerList() throws MLN.MillenaireException {
        List<Entity> entities = MillCommonUtilities.getEntitiesWithinAABB(this.worldObj, MillVillager.class, this.getPos(), this.villageType.radius + 20, 50);
        for (Entity o : entities) {
            MillVillager v = (MillVillager)o;
            if (v.getTownHall() != this || this.villagers.contains(v) || v.vtype == null) continue;
            this.villagers.add(v);
        }
        for (int i = this.villagers.size() - 1; i > -1; --i) {
            if (!this.villagers.get((int)i).field_70128_L) continue;
            this.villagers.remove(i);
        }
        int time = (int)(this.worldObj.func_72820_D() % 24000L);
        boolean resurect = time >= 13000 && time < 13100;
        for (VillagerRecord vr : this.vrecords) {
            Vector<MillVillager> found = new Vector<MillVillager>();
            for (MillVillager v : this.villagers) {
                if (!vr.matches(v)) continue;
                found.add(v);
            }
            if (found.size() == 0) {
                boolean spawned;
                boolean respawn = false;
                if (!vr.flawedRecord) {
                    if (vr.raidingVillage) {
                        if (!vr.killed && this.worldObj.func_72820_D() > vr.raiderSpawn + 500L) {
                            respawn = true;
                        }
                    } else if (!(vr.awayraiding || vr.awayhired || vr.getType().noResurrect || vr.killed && !resurect)) {
                        respawn = true;
                    }
                }
                if (!respawn) continue;
                if (MLN.LogGeneralAI >= 1) {
                    MLN.major(this, "Recreating missing villager from record " + vr + ". Killed: " + vr.killed);
                }
                if (this.mw.getBuilding(vr.housePos) == null) {
                    MLN.error(this, "Error when trying to recreate a villager from record " + vr + ": couldn't load house at " + vr.housePos + ".");
                    continue;
                }
                Point villagerPos = vr.raidingVillage && vr.originalVillagePos != null ? this.findAttackerSpawnPoint(vr.originalVillagePos) : (this.underAttack ? (vr.getType().helpInAttacks ? this.getDefendingPos() : this.getShelterPos()) : this.mw.getBuilding(vr.housePos).getSleepingPos());
                MillVillager villager = MillVillager.createVillager(vr.culture, vr.type, vr.gender, this.worldObj, villagerPos, vr.housePos, this.getPos(), true, vr.firstName, vr.familyName);
                if (villager == null) {
                    MLN.error(this, "Could not recreate villager " + vr + " of type " + vr.type);
                    continue;
                }
                vr.nameKey = villager.getNameKey();
                if (!vr.killed) {
                    if (MLN.LogGeneralAI >= 1) {
                        MLN.major(this, "Giving the villager back " + vr.inventory.size() + " item types.");
                    }
                    for (MillVillager.InvItem iv : vr.inventory.keySet()) {
                        villager.addToInv(iv, (int)vr.inventory.get(iv));
                    }
                }
                vr.killed = false;
                if (villager.getHouse() == null) continue;
                villager.setTexture(vr.texture);
                villager.villager_id = vr.id;
                villager.size = vr.villagerSize;
                villager.isRaider = vr.raidingVillage;
                if (!villager.isTextureValid(villager.getTexture().func_110623_a())) {
                    villager.setTexture(villager.getNewTexture());
                }
                if (villager.func_70631_g_()) {
                    villager.adjustSize();
                }
                if (!(spawned = this.worldObj.func_72838_d((Entity)villager))) continue;
                this.registerVillager(villager);
                villager.getHouse().registerVillager(villager);
                villager.registerInGlobalList();
                continue;
            }
            if (found.size() > 1) {
                if (MLN.LogGeneralAI >= 1) {
                    MLN.major(this, "Found " + found.size() + " villagers for record " + vr + ", killing the extras.");
                }
                for (int i = found.size() - 1; i > 0; --i) {
                    MillVillager v;
                    v = (MillVillager)found.get(i);
                    this.villagers.remove(i);
                    v.getHouse().villagers.remove(v);
                    v.despawnVillager();
                }
                continue;
            }
            if (found.size() != 1 || vr.housePos != null && vr.texture != null && vr.nameKey != "" && !vr.nameKey.equals("villager")) continue;
            MLN.major(this, "Updating record for villager: " + found.get(0));
            vr.updateRecord((MillVillager)found.get(0));
            vr.flawedRecord = false;
        }
    }

    private void repairVillagerListClient() {
        for (int i = this.villagers.size() - 1; i > -1; --i) {
            if (!this.villagers.get((int)i).field_70128_L) continue;
            if (MLN.LogGeneralAI >= 1) {
                MLN.major(this, "Client detected a dead villager in the list, removing it: " + this.villagers.get(i));
            }
            this.villagers.remove(i);
        }
        for (VillagerRecord vr : this.vrecords) {
            Vector<MillVillager> found = new Vector<MillVillager>();
            for (MillVillager v : this.villagers) {
                if (!vr.matches(v)) continue;
                found.add(v);
            }
            if (found.size() > 1) {
                int i;
                if (MLN.LogGeneralAI >= 1) {
                    MLN.major(this, "Client found " + found.size() + " villagers for record " + vr + ", killing the extras.");
                }
                long mostrecent = 0L;
                int mostrecentId = 0;
                for (i = 0; i < found.size(); ++i) {
                    if (((MillVillager)found.get((int)i)).client_lastupdated < mostrecent) continue;
                    mostrecent = ((MillVillager)found.get((int)i)).client_lastupdated;
                    mostrecentId = i;
                }
                for (i = found.size(); i > 0; --i) {
                    MillVillager v = (MillVillager)found.get(i);
                    if (i == mostrecentId) continue;
                    this.villagers.remove(i);
                    v.getHouse().villagers.remove(v);
                    v.despawnVillager();
                }
                continue;
            }
            if (found.size() != 1 || vr.housePos != null && vr.texture != null && vr.nameKey != "" && !vr.nameKey.equals("villager")) continue;
            MLN.major(this, "Updating record for villager: " + found.get(0));
            vr.updateRecord((MillVillager)found.get(0));
            vr.flawedRecord = false;
        }
    }

    public void requestSave(String reason) {
        this.saveNeeded = true;
        this.saveReason = reason;
    }

    public void rushBuilding() throws MLN.MillenaireException {
        if (this.buildingLocationIP != null) {
            BuildingPlan plan = this.getCurrentBuildingPlan();
            Vector<BuildingPlan.LocationBuildingPair> lbps = this.buildingLocationIP.isSameLocation(this.location) ? plan.build(this.mw, this.villageType, this.buildingLocationIP, false, true, this.pos, false, null, true) : plan.build(this.mw, this.villageType, this.buildingLocationIP, false, false, this.pos, false, null, true);
            for (BuildingPlan.LocationBuildingPair b : lbps) {
                this.registerBuildingEntity(b.building);
            }
            this.setBblocks(null);
        }
        this.completeConstruction();
    }

    public void saveTownHall(String reason) {
        if (!this.worldObj.field_72995_K && this.saveWorker == null) {
            this.saveWorker = new SaveWorker(reason);
            this.saveWorker.start();
        }
    }

    public void sendShopPacket(EntityPlayer player) {
        DataOutput data = ServerSender.getNewByteBufOutputStream();
        try {
            data.write(11);
            StreamReadWrite.writeNullablePoint(this.getPos(), data);
            if (this.shopSells.containsKey(player.getDisplayName())) {
                data.writeInt(this.shopSells.get(player.getDisplayName()).size());
                for (Goods g : this.shopSells.get(player.getDisplayName()).keySet()) {
                    StreamReadWrite.writeNullableGoods(g, data);
                    data.writeInt(this.shopSells.get(player.getDisplayName()).get(g));
                }
            } else {
                data.writeInt(0);
            }
            if (this.shopBuys.containsKey(player.getDisplayName())) {
                data.writeInt(this.shopBuys.get(player.getDisplayName()).size());
                for (Goods g : this.shopBuys.get(player.getDisplayName()).keySet()) {
                    StreamReadWrite.writeNullableGoods(g, data);
                    data.writeInt(this.shopBuys.get(player.getDisplayName()).get(g));
                }
            } else {
                data.writeInt(0);
            }
        }
        catch (IOException e) {
            MLN.printException(this + ": Error in sendShopPacket", e);
        }
        ServerSender.createAndSendPacketToPlayer(data, player);
    }

    public static void readShopPacket(MillWorld mw, ByteBufInputStream ds) {
        Point pos = null;
        try {
            pos = StreamReadWrite.readNullablePoint((DataInput)ds);
        }
        catch (IOException e) {
            MLN.printException(e);
            return;
        }
        Building building = mw.getBuilding(pos);
        if (building == null) {
            MLN.error(null, "Received shop packet for null building at: " + pos);
            return;
        }
        try {
            int nbBuys;
            int nbSells = ds.readInt();
            if (nbSells > 0) {
                LinkedHashMap<Goods, Integer> shopSellsPlayer = new LinkedHashMap<Goods, Integer>();
                for (int i = 0; i < nbSells; ++i) {
                    Goods g = StreamReadWrite.readNullableGoods((DataInput)ds);
                    shopSellsPlayer.put(g, ds.readInt());
                }
                building.shopSells.put(Mill.proxy.getSinglePlayerName(), shopSellsPlayer);
            }
            if ((nbBuys = ds.readInt()) > 0) {
                LinkedHashMap<Goods, Integer> shopBuysPlayer = new LinkedHashMap<Goods, Integer>();
                for (int i = 0; i < nbBuys; ++i) {
                    Goods g = StreamReadWrite.readNullableGoods((DataInput)ds);
                    shopBuysPlayer.put(g, ds.readInt());
                }
                building.shopBuys.put(Mill.proxy.getSinglePlayerName(), shopBuysPlayer);
            }
        }
        catch (IOException e) {
            MLN.printException(e);
        }
    }

    public void sendBuildingPacket(EntityPlayer player, boolean sendChest) {
        if (this.worldObj.field_72995_K) {
            return;
        }
        if (sendChest) {
            for (Point p : this.chests) {
                TileEntityMillChest chest = p.getMillChest(this.worldObj);
                if (chest == null) continue;
                chest.buildingPos = this.getPos();
                chest.sendUpdatePacket(player);
            }
        }
        DataOutput data = ServerSender.getNewByteBufOutputStream();
        try {
            data.write(2);
            StreamReadWrite.writeNullablePoint(this.getPos(), data);
            data.writeBoolean(this.isTownhall);
            data.writeBoolean(this.chestLocked);
            StreamReadWrite.writeNullableString(this.controlledBy, data);
            StreamReadWrite.writeNullableString(this.controlledByName, data);
            StreamReadWrite.writeNullablePoint(this.townHallPos, data);
            StreamReadWrite.writeNullableString(this.culture.key, data);
            String vtype = null;
            if (this.villageType != null) {
                vtype = this.villageType.key;
            }
            StreamReadWrite.writeNullableString(vtype, data);
            StreamReadWrite.writeNullableBuildingLocation(this.location, data);
            StreamReadWrite.writeNullableString(this.buildingGoal, data);
            StreamReadWrite.writeNullableString(this.buildingGoalIssue, data);
            data.writeInt(this.buildingGoalLevel);
            data.writeInt(this.buildingGoalVariation);
            StreamReadWrite.writeNullableBuildingLocation(this.buildingGoalLocation, data);
            StreamReadWrite.writeNullableBuildingLocation(this.buildingLocationIP, data);
            StreamReadWrite.writeProjectVectorVector(this.buildingProjects, data);
            StreamReadWrite.writePointVector(this.chests, data);
            StreamReadWrite.writePointVector(this.furnaces, data);
            StreamReadWrite.writePointVector(this.signs, data);
            StreamReadWrite.writePointVector(this.buildings, data);
            StreamReadWrite.writeStringVector(this.buildingsBought, data);
            StreamReadWrite.writePointIntegerMap(this.relations, data);
            StreamReadWrite.writeStringVector(this.raidsPerformed, data);
            StreamReadWrite.writeStringVector(this.raidsSuffered, data);
            StreamReadWrite.writeVillagerRecordVector(this.vrecords, data);
            StreamReadWrite.writeNullablePuja(this.pujas, data);
            StreamReadWrite.writeStringVector(this.visitorsList, data);
            StreamReadWrite.writeInventory(this.imported, data);
            StreamReadWrite.writeInventory(this.exported, data);
            StreamReadWrite.writeNullableString(this.name, data);
            StreamReadWrite.writeNullableString(this.qualifier, data);
            StreamReadWrite.writeNullablePoint(this.raidTarget, data);
            data.writeLong(this.raidPlanningStart);
            data.writeLong(this.raidStart);
        }
        catch (IOException e) {
            MLN.printException(this + ": Error in sendUpdatePacket", e);
        }
        this.mw.getProfile((String)player.getDisplayName()).buildingsSent.put(this.pos, this.mw.world.func_72820_D());
        ServerSender.createAndSendPacketToPlayer(data, player);
    }

    private void sendInitialBuildingPackets() {
        for (EntityPlayer player : MillCommonUtilities.getServerPlayers(this.mw.world)) {
            if (!(this.pos.distanceToSquared((Entity)player) < 256.0)) continue;
            UserProfile profile = MillCommonUtilities.getServerProfile(this.mw.world, player.getDisplayName());
            if (profile.buildingsSent.containsKey(this.pos)) continue;
            this.sendBuildingPacket(player, false);
        }
    }

    public void sendMapInfo(EntityPlayer player) {
        if (this.winfo != null) {
            MillWorldInfo.MillMapInfo minfo = new MillWorldInfo.MillMapInfo(this, this.winfo);
            minfo.sendMapInfoPacket(player);
        }
    }

    public void setBblocks(BuildingPlan.BuildingBlock[] bblocks) {
        this.bblocks = bblocks;
        this.bblocksPos = 0;
        this.bblocksChanged = true;
    }

    public void setCraftingPos(Point p) {
        this.craftingPos = p;
    }

    public void setDefendingPos(Point p) {
        this.defendingPos = p;
    }

    public void setGoods(Item item, int newVal) {
        this.setGoods(item, 0, newVal);
    }

    public void setGoods(Item item, int meta, int newVal) {
        int nb = this.countGoods(item, meta);
        if (nb < newVal) {
            this.storeGoods(item, meta, newVal - nb);
        } else {
            this.takeGoods(item, meta, nb - newVal);
        }
    }

    public void setPathStartPos(Point p) {
        this.pathStartPos = p;
    }

    public void setLeasurePos(Point p) {
        this.leasurePos = p;
    }

    public void setSellingPos(Point p) {
        this.sellingPos = p;
    }

    public void setShelterPos(Point p) {
        this.shelterPos = p;
    }

    public void setSleepingPos(Point p) {
        this.sleepingPos = p;
    }

    private void startRaid() {
        Building distantVillage = this.mw.getBuilding(this.raidTarget);
        if (this.relations.get(this.raidTarget) != null && this.relations.get(this.raidTarget) > -90) {
            this.cancelRaid();
        }
        if (distantVillage != null) {
            this.raidStart = this.worldObj.func_72820_D();
            int nbRaider = 0;
            for (VillagerRecord vr : this.vrecords) {
                if (!vr.getType().isRaider || vr.killed || vr.raidingVillage || vr.awayraiding || vr.awayhired) continue;
                if (MLN.LogDiplomacy >= 2) {
                    MLN.minor(this, "Need to transfer raider; " + vr);
                }
                vr.getHouse().transferVillager(vr, distantVillage, true);
                ++nbRaider;
            }
            if (nbRaider > 0) {
                ServerSender.sendTranslatedSentenceInRange(this.worldObj, this.getPos(), MLN.BackgroundRadius, '4', "raid.started", this.getVillageQualifiedName(), distantVillage.getVillageQualifiedName(), "" + nbRaider);
                distantVillage.cancelRaid();
                distantVillage.underAttack = true;
            } else {
                this.cancelRaid();
            }
        } else {
            this.cancelRaid();
        }
    }

    public int storeGoods(Item item, int toPut) {
        return this.storeGoods(item, 0, toPut);
    }

    public int storeGoods(Block block, int toPut) {
        return this.storeGoods(Item.func_150898_a((Block)block), 0, toPut);
    }

    public int storeGoods(Block block, int meta, int toPut) {
        return this.storeGoods(Item.func_150898_a((Block)block), meta, toPut);
    }

    public int storeGoods(Item item, int meta, int toPut) {
        int stored = 0;
        for (int i = 0; stored < toPut && i < this.chests.size(); ++i) {
            TileEntityMillChest chest = this.chests.get(i).getMillChest(this.worldObj);
            if (chest == null) continue;
            stored += MillCommonUtilities.putItemsInChest((IInventory)chest, item, meta, toPut - stored);
        }
        return stored;
    }

    public int storeGoods(MillVillager.InvItem item, int toPut) {
        return this.storeGoods(item.getItem(), item.meta, toPut);
    }

    private void swapMerchants(Building destInn) {
        int nb;
        HashMap<MillVillager.InvItem, Integer> contents = this.getChestsContent();
        HashMap<MillVillager.InvItem, Integer> destContents = destInn.getChestsContent();
        for (MillVillager.InvItem key : contents.keySet()) {
            nb = this.takeGoods(key.getItem(), key.meta, (int)contents.get(key));
            destInn.storeGoods(key.getItem(), key.meta, nb);
            destInn.addToImports(key, nb);
            this.addToExports(key, nb);
        }
        for (MillVillager.InvItem key : destContents.keySet()) {
            nb = destInn.takeGoods(key.getItem(), key.meta, (int)destContents.get(key));
            this.storeGoods(key.getItem(), key.meta, nb);
            destInn.addToExports(key, nb);
            this.addToImports(key, nb);
        }
        VillagerRecord oldMerchant = this.merchantRecord;
        VillagerRecord newMerchant = destInn.merchantRecord;
        this.transferVillager(this.merchantRecord, destInn, false);
        destInn.transferVillager(destInn.merchantRecord, this, false);
        this.visitorsList.add("panels.merchantmovedout;" + oldMerchant.getName() + ";" + oldMerchant.getNativeOccupationName() + ";" + destInn.getTownHall().getVillageQualifiedName() + ";" + this.nbNightsMerchant);
        destInn.visitorsList.add("panels.merchantmovedout;" + newMerchant.getName() + ";" + newMerchant.getNativeOccupationName() + ";" + this.getTownHall().getVillageQualifiedName() + ";" + this.nbNightsMerchant);
        this.visitorsList.add("panels.merchantarrived;" + newMerchant.getName() + ";" + newMerchant.getNativeOccupationName() + ";" + destInn.getTownHall().getVillageQualifiedName());
        destInn.visitorsList.add("panels.merchantarrived;" + oldMerchant.getName() + ";" + oldMerchant.getNativeOccupationName() + ";" + this.getTownHall().getVillageQualifiedName());
        if (MLN.LogMerchant >= 1) {
            MLN.major(this, "Swaped merchant " + oldMerchant + " and " + newMerchant + " with " + destInn.getTownHall());
        }
        this.merchantRecord = newMerchant;
        destInn.merchantRecord = oldMerchant;
        this.nbNightsMerchant = 0;
        destInn.nbNightsMerchant = 0;
        destInn.saveTownHall("merchant moved");
        this.saveNeeded = true;
        this.saveReason = "Swapped merchant";
    }

    public int takeGoods(Item item, int toTake) {
        return this.takeGoods(item, 0, toTake);
    }

    public int takeGoods(Block block, int toTake) {
        return this.takeGoods(Item.func_150898_a((Block)block), 0, toTake);
    }

    public int takeGoods(Block block, int meta, int toTake) {
        return this.takeGoods(Item.func_150898_a((Block)block), meta, toTake);
    }

    public int takeGoods(Item item, int meta, int toTake) {
        int i;
        int taken = 0;
        for (i = 0; taken < toTake && i < this.chests.size(); ++i) {
            TileEntityMillChest chest = this.chests.get(i).getMillChest(this.worldObj);
            if (chest == null) continue;
            taken += MillCommonUtilities.getItemsFromChest((IInventory)chest, item, meta, toTake - taken);
        }
        for (i = 0; taken < toTake && i < this.furnaces.size(); ++i) {
            TileEntityFurnace furnace = (TileEntityFurnace)this.worldObj.func_147438_o(this.furnaces.get(i).getiX(), this.furnaces.get(i).getiY(), this.furnaces.get(i).getiZ());
            if (furnace == null) continue;
            taken += MillCommonUtilities.getItemsFromFurnace((IInventory)furnace, item, toTake - taken);
        }
        return taken;
    }

    public int takeGoods(MillVillager.InvItem item, int toTake) {
        return this.takeGoods(item.getItem(), item.meta, toTake);
    }

    public void testModeGoods() {
        if (this.isTownhall && !this.villageType.lonebuilding) {
            int stored = this.storeGoods(Mill.denier_or, 64);
            if (stored < 64) {
                MLN.error(this, "Should have stored 64 test goods but stored only " + stored);
            }
            this.storeGoods(Mill.summoningWand, 1);
            if (this.culture.key.equals("hindi")) {
                this.storeGoods(Mill.indianstatue, 64);
                this.storeGoods(Mill.stone_decoration, 0, 2048);
                this.storeGoods(Mill.stone_decoration, 1, 2048);
                this.storeGoods(Blocks.field_150322_A, 2048);
                this.storeGoods(Blocks.field_150348_b, 2048);
                this.storeGoods(Blocks.field_150347_e, 512);
            } else if (this.culture.key.equals("mayan")) {
                this.storeGoods(Blocks.field_150322_A, 512);
                this.storeGoods(Blocks.field_150348_b, 3500);
                this.storeGoods(Blocks.field_150347_e, 2048);
                this.storeGoods(Mill.stone_decoration, 2, 64);
                this.storeGoods(Blocks.field_150364_r, 1, 512);
                this.storeGoods(Blocks.field_150364_r, 3, 1024);
            } else if (this.culture.key.equals("japanese")) {
                this.storeGoods(Blocks.field_150345_g, 64);
                this.storeGoods(Mill.wood_decoration, 2, 2048);
                this.storeGoods(Blocks.field_150351_n, 512);
                this.storeGoods(Mill.paperWall, 2048);
                this.storeGoods(Blocks.field_150348_b, 2048);
                this.storeGoods(Blocks.field_150347_e, 1024);
                this.storeGoods(Mill.wood_decoration, 0, 512);
                this.storeGoods(Mill.wood_decoration, 1, 512);
                this.storeGoods(Blocks.field_150364_r, 1, 512);
            } else if (this.culture.key.equals("byzantines")) {
                this.storeGoods(Blocks.field_150359_w, 512);
                this.storeGoods(Blocks.field_150347_e, 1500);
                this.storeGoods(Blocks.field_150348_b, 1500);
                this.storeGoods(Blocks.field_150336_V, 512);
                this.storeGoods(Blocks.field_150322_A, 512);
                this.storeGoods(Blocks.field_150325_L, 11, 64);
                this.storeGoods(Blocks.field_150325_L, 14, 64);
                this.storeGoods(Blocks.field_150364_r, 2, 128);
                this.storeGoods(Blocks.field_150342_X, 0, 64);
                this.storeGoods(Mill.byzantine_tiles, 128);
                this.storeGoods((Block)Mill.byzantine_tile_slab, 128);
                this.storeGoods(Mill.byzantine_stone_tiles, 128);
            } else {
                this.storeGoods(Blocks.field_150359_w, 512);
                this.storeGoods(Blocks.field_150347_e, 2048);
                this.storeGoods(Blocks.field_150348_b, 3500);
                this.storeGoods(Mill.wood_decoration, 0, 2048);
                this.storeGoods(Mill.wood_decoration, 1, 2048);
                this.storeGoods(Blocks.field_150325_L, 11, 64);
                this.storeGoods(Blocks.field_150325_L, 14, 64);
            }
            this.storeGoods(Blocks.field_150364_r, 1024);
            this.storeGoods(Items.field_151042_j, 256);
            this.storeGoods(Blocks.field_150325_L, 64);
        }
    }

    public void testShowGroundLevel() {
        for (int i = 0; i < this.winfo.length; ++i) {
            for (int j = 0; j < this.winfo.width; ++j) {
                Point p = new Point(this.winfo.mapStartX + i, this.winfo.topGround[i][j] - 1, this.winfo.mapStartZ + j);
                if (MillCommonUtilities.getBlock(this.worldObj, p) == Mill.lockedChest) continue;
                if (!this.winfo.topAdjusted[i][j]) {
                    MillCommonUtilities.setBlockAndMetadata(this.worldObj, p, Blocks.field_150325_L, this.pathing.regions[i][j] % 16);
                    continue;
                }
                MillCommonUtilities.setBlockAndMetadata(this.worldObj, p, Blocks.field_150339_S, 0);
            }
        }
    }

    public String toString() {
        if (this.location != null) {
            return "(" + this.location + "/" + this.getVillageQualifiedName() + "/" + this.worldObj + ")";
        }
        return super.toString();
    }

    public void transferVillager(VillagerRecord vr, Building dest, boolean raid) {
        MillVillager v;
        if (MLN.LogDiplomacy >= 2) {
            MLN.minor(this, "Transfering villager " + vr + " to " + dest + ". Raid: " + raid);
        }
        if (!raid) {
            this.removeVillagerRecord(vr.id);
            this.getTownHall().removeVillagerRecord(vr.id);
        } else {
            vr.awayraiding = true;
            this.getTownHall().getVillagerRecordById((long)vr.id).awayraiding = true;
            if (MLN.LogDiplomacy >= 3) {
                MLN.debug(this, "Set record to away raiding");
            }
        }
        VillagerRecord newRecord = vr.clone();
        newRecord.housePos = dest.getPos();
        newRecord.townHallPos = dest.getTownHall().getPos();
        newRecord.raidingVillage = raid;
        newRecord.awayraiding = false;
        if (raid) {
            newRecord.originalVillagePos = this.getTownHall().getPos();
            newRecord.raiderSpawn = this.worldObj.func_72820_D();
        }
        dest.vrecords.add(newRecord);
        if (!dest.isTownhall) {
            dest.getTownHall().vrecords.add(newRecord.clone());
        }
        if ((v = this.getVillagerById(vr.id)) != null) {
            this.villagers.remove(v);
            this.getTownHall().villagers.remove(v);
            if (!raid && dest.getTownHall().isActive) {
                v.setHousePoint(dest.getPos());
                v.setTownHallPoint(dest.getTownHall().getPos());
                v.isRaider = false;
                v.func_70107_b(dest.getSleepingPos().getiX(), dest.getSleepingPos().getiY(), dest.getSleepingPos().getiZ());
                dest.villagers.add(v);
                dest.getTownHall().villagers.add(v);
                if (MLN.LogDiplomacy >= 3) {
                    MLN.debug(this, "Villager entity moved.");
                }
            } else {
                v.despawnVillager();
                if (MLN.LogDiplomacy >= 3) {
                    MLN.debug(this, "Villager entity despawned.");
                }
            }
        }
        dest.getTownHall().saveTownHall("incoming villager");
    }

    private void unloadChunks() {
        if (this.chunkLoader != null && this.chunkLoader.chunksLoaded) {
            this.chunkLoader.unloadChunks();
        }
    }

    public void unlockAllChests() {
        this.chestLocked = false;
        for (Point p : this.buildings) {
            Building b = this.mw.getBuilding(p);
            if (b == null) continue;
            b.unlockChests();
        }
        if (this.countGoods(Mill.negationWand) == 0) {
            this.storeGoods(Mill.negationWand, 1);
        }
    }

    public void unlockChests() {
        if (!this.isMarket) {
            this.chestLocked = false;
            for (Point p : this.chests) {
                TileEntityMillChest chest = p.getMillChest(this.worldObj);
                if (chest == null) continue;
                chest.buildingPos = this.getPos();
            }
        }
    }

    private void updateAchievements() {
        if (this.villageType == null) {
            return;
        }
        List<Entity> players = MillCommonUtilities.getEntitiesWithinAABB(this.worldObj, EntityPlayer.class, this.getPos(), this.villageType.radius, 20);
        for (Entity ent : players) {
            int nbcultures;
            EntityPlayer player = (EntityPlayer)ent;
            if (this.villageType.lonebuilding) {
                player.func_71064_a((StatBase)MillAchievements.explorer, 1);
            }
            if (this.location.tags.contains(tagHoF)) {
                player.func_71064_a((StatBase)MillAchievements.pantheon, 1);
            }
            if ((nbcultures = this.mw.nbCultureInGeneratedVillages()) >= 3) {
                player.func_71064_a((StatBase)MillAchievements.marcopolo, 1);
            }
            if (nbcultures < Culture.vectorCultures.size()) continue;
            player.func_71064_a((StatBase)MillAchievements.magellan, 1);
        }
    }

    private void updateArchiveSigns() {
        if (this.worldObj.field_72995_K) {
            return;
        }
        EntityPlayer player = this.worldObj.func_72977_a((double)this.pos.getiX(), (double)this.pos.getiY(), (double)this.pos.getiZ(), 16.0);
        if (player == null) {
            return;
        }
        if (System.currentTimeMillis() - this.lastSignUpdate < 10000L) {
            return;
        }
        if (this.signs.size() == 0) {
            return;
        }
        for (int i = 0; i < this.signs.size(); ++i) {
            Point p = this.signs.get(i);
            if (p != null && MillCommonUtilities.getBlock(this.worldObj, p) != Mill.panel) {
                int meta = MillCommonUtilities.guessSignMetaData(this.worldObj, p);
                if (meta <= 0) continue;
                MillCommonUtilities.setBlockAndMetadata(this.worldObj, p, Mill.panel, meta);
                continue;
            }
            if (p != null) continue;
            MLN.error(this, "The pos of sign " + i + " is null.");
        }
        int signId = 0;
        for (VillagerRecord vr : this.getTownHall().vrecords) {
            TileEntityPanel sign;
            if (!vr.raidingVillage && !vr.getType().visitor && this.signs.get(signId) != null && (sign = this.signs.get(signId).getPanel(this.worldObj)) != null) {
                String[][] lines = null;
                if (vr.awayraiding) {
                    lines = new String[][]{{vr.firstName}, {vr.familyName}, {""}, {"panels.awayraiding"}};
                } else if (vr.awayhired) {
                    lines = new String[][]{{vr.firstName}, {vr.familyName}, {""}, {"panels.awayhired"}};
                } else if (vr.killed) {
                    lines = new String[][]{{vr.firstName}, {vr.familyName}, {""}, {"panels.dead"}};
                } else {
                    MillVillager villager = this.getTownHall().getVillagerById(vr.id);
                    if (villager == null) {
                        lines = new String[][]{{vr.firstName}, {vr.familyName}, {""}, {"panels.missing"}};
                    } else if (!villager.isVisitor()) {
                        String distance = "" + Math.floor(this.getPos().distanceTo((Entity)villager));
                        String direction = this.getPos().directionTo(villager.getPos());
                        String occupation = "";
                        if (villager.goalKey != null && Goal.goals.containsKey(villager.goalKey)) {
                            occupation = "goal." + villager.goalKey;
                        }
                        if (occupation.length() > 15) {
                            occupation = occupation.substring(0, 10) + "(...)";
                        }
                        lines = new String[][]{{vr.firstName}, {vr.familyName}, {"other.shortdistancedirection", distance, direction}, {occupation}};
                    }
                    ServerSender.updatePanel(this.mw, this.signs.get(signId), lines, 7, this.townHallPos, vr.id);
                }
            }
            if (++signId < this.signs.size()) continue;
            break;
        }
        for (int i = signId; i < this.signs.size(); ++i) {
            TileEntityPanel sign = this.signs.get(i).getPanel(this.worldObj);
            if (sign == null) continue;
            String[][] lines = new String[][]{{"ui.reservedforvillager1"}, {"ui.reservedforvillager2"}, {""}, {"#" + (i + 1)}};
            ServerSender.updatePanel(this.mw, this.signs.get(i), lines, 0, this.townHallPos, 0L);
        }
        this.lastSignUpdate = System.currentTimeMillis();
    }

    public void updateBackgroundVillage() {
        if (this.worldObj.field_72995_K) {
            return;
        }
        if (this.villageType == null || !this.isTownhall || this.location == null) {
            return;
        }
        EntityPlayer player = this.worldObj.func_72977_a((double)this.pos.getiX(), (double)this.pos.getiY(), (double)this.pos.getiZ(), (double)MLN.BackgroundRadius);
        if (player != null) {
            if (this.worldObj.func_72935_r()) {
                this.nightBackgroundActionPerformed = false;
            } else if (!this.nightBackgroundActionPerformed) {
                if (this.villageType.carriesRaid && this.raidTarget == null && MillCommonUtilities.randomInt(100) < MLN.RaidingRate) {
                    if (MLN.LogDiplomacy >= 3) {
                        MLN.debug(this, "Calling attemptPlanNewRaid");
                    }
                    this.attemptPlanNewRaid();
                }
                this.nightBackgroundActionPerformed = true;
            }
        }
        if (this.worldObj.func_72820_D() % 24000L > 23500L && this.raidTarget != null) {
            if (!this.updateRaidPerformed) {
                if (MLN.LogDiplomacy >= 3) {
                    MLN.debug(this, "Calling updateRaid for raid: " + this.raidPlanningStart + "/" + this.raidStart + "/" + this.worldObj.func_72820_D());
                }
                this.updateRaid();
                this.updateRaidPerformed = true;
            }
        } else {
            this.updateRaidPerformed = false;
        }
    }

    public void updateBuildingClient() {
        if (this.location != null && this.pos != null && this.isTownhall && this.villageType != null && this.location != null) {
            if (this.lastVillagerRecordsRepair == 0L) {
                this.lastVillagerRecordsRepair = this.worldObj.func_72820_D();
            } else if (this.worldObj.func_72820_D() - this.lastVillagerRecordsRepair >= 100L) {
                this.repairVillagerListClient();
                this.lastVillagerRecordsRepair = this.worldObj.func_72820_D();
            }
        }
    }

    public void updateBuildingServer() {
        if (this.worldObj.field_72995_K) {
            this.updateBuildingClient();
            return;
        }
        if (this.location == null) {
            return;
        }
        EntityPlayer player = this.worldObj.func_72977_a((double)this.pos.getiX(), (double)this.pos.getiY(), (double)this.pos.getiZ(), (double)MLN.KeepActiveRadius);
        if (this.isTownhall) {
            EntityPlayer p;
            if (player != null && this.getPos().distanceTo((Entity)player) < (double)MLN.KeepActiveRadius) {
                this.loadChunks();
            } else if (player == null || this.getPos().distanceTo((Entity)player) > (double)(MLN.KeepActiveRadius + 32)) {
                this.unloadChunks();
            }
            this.isAreaLoaded = this.isVillageChunksLoaded();
            if (this.isActive && !this.isAreaLoaded) {
                this.isActive = false;
                for (Object o : this.worldObj.field_73010_i) {
                    p = (EntityPlayer)o;
                    this.sendBuildingPacket(p, false);
                }
                this.saveTownHall("becoming inactive");
            } else if (!this.isActive && this.isAreaLoaded) {
                for (Object o : this.worldObj.field_73010_i) {
                    p = (EntityPlayer)o;
                    this.sendBuildingPacket(p, false);
                }
                this.isActive = true;
            }
            if (!this.isActive) {
                return;
            }
        } else if (this.getTownHall() == null || !this.getTownHall().isActive) {
            return;
        }
        if (this.location == null) {
            return;
        }
        try {
            if (this.isTownhall && this.villageType != null) {
                this.updateTownHall();
            }
            if (this.location.tags.contains(tagArchives)) {
                this.updateArchiveSigns();
            }
            if (this.location.tags.contains(tagGrove)) {
                this.updateGrove();
            }
            if (this.location.tags.contains(tagKiln)) {
                this.updateKiln();
            }
            if (this.spawns.size() > 0) {
                this.updatePens();
            }
            if (this.healingspots.size() > 0) {
                this.updateHealingSpots();
            }
            if (this.mobSpawners.size() > 0 && player != null && this.pos.distanceToSquared((Entity)player) < 400.0) {
                this.updateMobSpawners();
            }
            if (this.dispenderUnknownPowder.size() > 0) {
                this.updateDispensers();
            }
            if (this.netherwartsoils.size() > 0) {
                this.updateNetherWartSoils();
            }
            if (!(!this.isHouse() || this.isTownhall && this.location.showTownHallSigns)) {
                this.updateHouseSign();
            }
            if (this.isInn) {
                this.updateInn();
            }
            if (this.isMarket) {
                this.updateMarket(false);
            }
            if (this.isTownhall) {
                if (this.saveNeeded) {
                    this.saveTownHall("Save needed");
                } else if (this.worldObj.func_72820_D() - this.lastSaved > 1000L) {
                    this.saveTownHall("Delay up");
                }
            }
            if (player != null && this.location.getPlan() != null && this.location.getPlan().exploreTag != null) {
                this.checkExploreTag(player);
            }
            this.sendInitialBuildingPackets();
            if (MillCommonUtilities.chanceOn(100)) {
                for (Point p : this.chests) {
                    if (p.getMillChest(this.worldObj) == null) continue;
                    p.getMillChest((World)this.worldObj).buildingPos = this.getPos();
                }
            }
            this.refreshGoods();
        }
        catch (Exception e) {
            Mill.proxy.sendChatAdmin(MLN.string("ui.updateEntity"));
            MLN.error(this, "Exception in TileEntityBuilding.onUpdate(): ");
            MLN.printException(e);
        }
    }

    private void updateDispensers() {
        for (Point p : this.dispenderUnknownPowder) {
            TileEntityDispenser dispenser;
            if (!MillCommonUtilities.chanceOn(5000) || (dispenser = p.getDispenser(this.worldObj)) == null) continue;
            MillCommonUtilities.putItemsInChest((IInventory)dispenser, Mill.unknownPowder, 1);
        }
    }

    private void updateGrove() {
        for (Point p : this.woodspawn) {
            if (!MillCommonUtilities.chanceOn(4000) || MillCommonUtilities.getBlock(this.worldObj, p) != Blocks.field_150345_g) continue;
            this.growTree(this.worldObj, p.getiX(), p.getiY(), p.getiZ(), MillCommonUtilities.random);
        }
    }

    private void updateHealingSpots() {
        if (this.worldObj.func_72820_D() % 100L == 0L) {
            for (Point p : this.healingspots) {
                EntityPlayer player = this.worldObj.func_72977_a((double)p.getiX(), (double)p.getiY(), (double)p.getiZ(), 4.0);
                if (player == null || !(player.func_110143_aJ() < player.func_110138_aP())) continue;
                player.func_70606_j(player.func_110143_aJ() + 1.0f);
                ServerSender.sendTranslatedSentence(player, 'a', "other.buildinghealing", this.getNativeBuildingName());
            }
        }
    }

    private void updateHouseSign() {
        TileEntityPanel panel;
        int meta;
        if (this.worldObj.field_72995_K) {
            return;
        }
        if (this.signs.size() == 0) {
            return;
        }
        if (this.pos == null || this.location == null) {
            return;
        }
        EntityPlayer player = this.worldObj.func_72977_a((double)this.pos.getiX(), (double)this.pos.getiY(), (double)this.pos.getiZ(), 16.0);
        if (player == null) {
            return;
        }
        if (System.currentTimeMillis() - this.lastSignUpdate < 10000L) {
            return;
        }
        VillagerRecord wife = null;
        VillagerRecord husband = null;
        for (VillagerRecord vr : this.getTownHall().vrecords) {
            if (!this.getPos().equals(vr.housePos)) continue;
            if (!(vr.gender != 2 || vr.getType() != null && vr.getType().isChild)) {
                wife = vr;
            }
            if (vr.gender != 1 || vr.getType() != null && vr.getType().isChild) continue;
            husband = vr;
        }
        Point p = this.signs.get(0);
        if (p == null) {
            return;
        }
        if (this.worldObj.func_147439_a(p.getiX(), p.getiY(), p.getiZ()) != Mill.panel && (meta = MillCommonUtilities.guessSignMetaData(this.worldObj, p)) > 0) {
            MillCommonUtilities.setBlockAndMetadata(this.worldObj, p, Mill.panel, meta);
        }
        if ((panel = p.getPanel(this.worldObj)) == null) {
            MLN.error(this, "No TileEntitySign at: " + p);
        } else {
            String[][] lines = null;
            lines = husband != null && wife != null ? new String[][]{{"panels.nameand", wife.firstName}, {husband.firstName}, {husband.familyName}, {""}} : (husband != null ? new String[][]{{husband.firstName}, {""}, {husband.familyName}, {""}} : (wife != null ? new String[][]{{wife.firstName}, {""}, {wife.familyName}, {""}} : new String[][]{{"ui.currentlyempty1"}, {""}, {"ui.currentlyempty2"}, {""}}));
            ServerSender.updatePanel(this.mw, p, lines, 5, this.getPos(), 0L);
        }
        this.lastSignUpdate = System.currentTimeMillis();
    }

    private void updateInn() {
        if (this.worldObj.func_72935_r()) {
            this.thNightActionPerformed = false;
        } else if (!this.thNightActionPerformed) {
            if (this.merchantRecord != null) {
                ++this.nbNightsMerchant;
                if (this.nbNightsMerchant > 1) {
                    this.attemptMerchantMove(false);
                }
            }
            this.thNightActionPerformed = true;
        }
        this.updateInnSign();
    }

    private void updateInnSign() {
        String[][] lines;
        if (this.worldObj.field_72995_K) {
            return;
        }
        EntityPlayer player = this.worldObj.func_72977_a((double)this.pos.getiX(), (double)this.pos.getiY(), (double)this.pos.getiZ(), 20.0);
        if (player == null) {
            return;
        }
        if (this.signs.size() == 0) {
            return;
        }
        for (int i = 0; i < this.signs.size(); ++i) {
            int meta;
            Point p = this.signs.get(i);
            if (p == null || MillCommonUtilities.getBlock(this.worldObj, p) == Mill.panel || (meta = MillCommonUtilities.guessSignMetaData(this.worldObj, p)) <= 0) continue;
            MillCommonUtilities.setBlockAndMetadata(this.worldObj, p, Mill.panel, meta);
        }
        TileEntityPanel sign = this.signs.get(0).getPanel(this.worldObj);
        if (sign != null) {
            lines = new String[][]{{this.getNativeBuildingName()}, {""}, {"ui.visitorslist1"}, {"ui.visitorslist2"}};
            ServerSender.updatePanel(this.mw, this.signs.get(0), lines, 11, this.getPos(), 0L);
        }
        if (this.signs.size() < 2) {
            return;
        }
        sign = this.signs.get(1).getPanel(this.worldObj);
        if (sign != null) {
            lines = new String[][]{{"ui.goodstraded"}, {""}, {"ui.import_total", "" + MillCommonUtilities.getInvItemHashTotal(this.imported)}, {"ui.export_total", "" + MillCommonUtilities.getInvItemHashTotal(this.exported)}};
            ServerSender.updatePanel(this.mw, this.signs.get(1), lines, 10, this.getPos(), 0L);
        }
    }

    private void updateKiln() {
        for (Point p : this.brickspot) {
            if (MillCommonUtilities.getBlock(this.worldObj, p) != Blocks.field_150349_c) continue;
            MillCommonUtilities.setBlock(this.worldObj, p, Blocks.field_150346_d);
        }
    }

    public void updateMarket(boolean devAttempt) throws MLN.MillenaireException {
        if (this.worldObj.func_72935_r() && !devAttempt) {
            this.thNightActionPerformed = false;
        } else if (!this.thNightActionPerformed || devAttempt) {
            int maxMerchants = this.stalls.size();
            if (this.vrecords.size() < maxMerchants) {
                if (MLN.LogMerchant >= 1) {
                    MLN.major(this, "Attempting to create a foreign merchant.");
                }
                Vector<VillagerType> merchantTypesOtherVillages = new Vector<VillagerType>();
                for (Point p : this.getTownHall().relations.keySet()) {
                    Building distantVillage;
                    if (this.getTownHall().relations.get(p) <= 70 || (distantVillage = this.mw.getBuilding(p)) == null || distantVillage.culture == this.getTownHall().culture || distantVillage.getBuildingsWithTag("market").size() <= 0) continue;
                    merchantTypesOtherVillages.add(distantVillage.culture.getRandomForeignMerchant());
                }
                int foreignChance = Math.min(1 + merchantTypesOtherVillages.size(), 5);
                VillagerType type = merchantTypesOtherVillages.size() > 0 && MillCommonUtilities.randomInt(11) < foreignChance ? (merchantTypesOtherVillages.size() == 0 ? this.culture.getRandomForeignMerchant() : (VillagerType)merchantTypesOtherVillages.get(MillCommonUtilities.randomInt(merchantTypesOtherVillages.size()))) : this.culture.getRandomForeignMerchant();
                MillVillager merchant = MillVillager.createVillager(type.culture, type.key, 0, this.worldObj, this.sleepingPos, this.getPos(), this.townHallPos, false, null, null);
                this.addOrReplaceVillager(merchant);
                VillagerRecord merchantRecord = new VillagerRecord(this.mw, merchant);
                this.addOrReplaceRecord(merchantRecord);
                this.worldObj.func_72838_d((Entity)merchant);
                for (MillVillager.InvItem iv : merchant.vtype.foreignMerchantStock.keySet()) {
                    this.storeGoods(iv.getItem(), iv.meta, (int)merchant.vtype.foreignMerchantStock.get(iv));
                }
                if (MLN.LogMerchant >= 1) {
                    MLN.major(this, "Created foreign merchant: " + merchantRecord);
                }
            }
            this.thNightActionPerformed = true;
        }
        this.updateMarketSigns();
    }

    private void updateMarketSigns() {
        EntityPlayer player = this.worldObj.func_72977_a((double)this.pos.getiX(), (double)this.pos.getiY(), (double)this.pos.getiZ(), 20.0);
        if (player == null) {
            return;
        }
        if (this.signs.size() == 0) {
            return;
        }
        for (int i = 0; i < this.signs.size(); ++i) {
            int meta;
            Point p = this.signs.get(i);
            if (p == null || MillCommonUtilities.getBlock(this.worldObj, p) == Mill.panel || (meta = MillCommonUtilities.guessSignMetaData(this.worldObj, p)) <= 0) continue;
            MillCommonUtilities.setBlockAndMetadata(this.worldObj, p, Mill.panel, meta);
        }
        TileEntityPanel sign = this.signs.get(0).getPanel(this.worldObj);
        if (sign != null) {
            String[][] lines = new String[][]{{this.getNativeBuildingName()}, {""}, {"ui.merchants"}, {"" + this.vrecords.size()}};
            ServerSender.updatePanel(this.mw, this.signs.get(0), lines, 12, this.getPos(), 0L);
        }
    }

    private void updateMobSpawners() {
        for (int i = 0; i < this.mobSpawners.size(); ++i) {
            for (int j = 0; j < this.mobSpawners.get(i).size(); ++j) {
                Block block;
                if (!MillCommonUtilities.chanceOn(180) || (block = MillCommonUtilities.getBlock(this.worldObj, this.mobSpawners.get(i).get(j))) != Blocks.field_150474_ac) continue;
                List<Entity> mobs = MillCommonUtilities.getEntitiesWithinAABB(this.worldObj, EntityMob.class, this.mobSpawners.get(i).get(j), 10, 5);
                int nbmob = 0;
                for (Entity ent : mobs) {
                    if (!EntityList.func_75621_b((Entity)ent).equals(this.mobSpawnerTypes.get(i))) continue;
                    ++nbmob;
                }
                if (nbmob >= 4) continue;
                MillCommonUtilities.spawnMobsSpawner(this.worldObj, this.mobSpawners.get(i).get(j), this.mobSpawnerTypes.get(i));
            }
        }
    }

    private void updateNetherWartSoils() {
        for (Point p : this.netherwartsoils) {
            int meta;
            if (!MillCommonUtilities.chanceOn(1000) || MillCommonUtilities.getBlock(this.worldObj, p.getAbove()) != Blocks.field_150388_bm || (meta = MillCommonUtilities.getBlockMeta(this.worldObj, p.getAbove())) >= 3) continue;
            MillCommonUtilities.setBlockMetadata(this.worldObj, p.getAbove(), meta + 1);
        }
    }

    private void updatePens() {
        if (!this.worldObj.func_72935_r() && (this.vrecords.size() > 0 || this.location.maleResident.isEmpty() && this.location.femaleResident.isEmpty()) && !this.worldObj.field_72995_K) {
            int nbMaxRespawn = 0;
            for (Vector<Point> spawnPoints : this.spawns) {
                nbMaxRespawn += spawnPoints.size();
            }
            if (this.nbAnimalsRespawned <= nbMaxRespawn) {
                int sheep = 0;
                int cow = 0;
                int pig = 0;
                int chicken = 0;
                int squid = 0;
                List<Entity> animals = MillCommonUtilities.getEntitiesWithinAABB(this.worldObj, IAnimals.class, this.getPos(), 15, 5);
                for (Entity animal : animals) {
                    if (animal instanceof EntitySheep) {
                        ++sheep;
                        continue;
                    }
                    if (animal instanceof EntityPig) {
                        ++pig;
                        continue;
                    }
                    if (animal instanceof EntityCow) {
                        ++cow;
                        continue;
                    }
                    if (animal instanceof EntityChicken) {
                        ++chicken;
                        continue;
                    }
                    if (!(animal instanceof EntitySquid)) continue;
                    ++squid;
                }
                for (int i = 0; i < this.spawns.size(); ++i) {
                    int nb = 0;
                    if (this.spawnTypes.get(i).equals("Sheep")) {
                        nb = sheep;
                    } else if (this.spawnTypes.get(i).equals("Chicken")) {
                        nb = chicken;
                    } else if (this.spawnTypes.get(i).equals("Pig")) {
                        nb = pig;
                    } else if (this.spawnTypes.get(i).equals("Cow")) {
                        nb = cow;
                    } else if (this.spawnTypes.get(i).equals("Squid")) {
                        nb = squid;
                    }
                    int multipliyer = 1;
                    if (this.spawnTypes.get(i).equals("Squid")) {
                        multipliyer = 2;
                    }
                    for (int j = 0; j < this.spawns.get(i).size() * multipliyer - nb; ++j) {
                        if (!MillCommonUtilities.chanceOn(100)) continue;
                        EntityCreature animal = (EntityCreature)EntityList.func_75620_a((String)this.spawnTypes.get(i), (World)this.worldObj);
                        Point pen = this.spawns.get(i).get(MillCommonUtilities.randomInt(this.spawns.get(i).size()));
                        animal.func_70107_b((double)pen.getiX() + 0.5, (double)pen.getiY(), (double)pen.getiZ() + 0.5);
                        this.worldObj.func_72838_d((Entity)animal);
                        ++this.nbAnimalsRespawned;
                    }
                }
            }
        } else {
            this.nbAnimalsRespawned = 0;
        }
    }

    private void updateRaid() {
        if (this.worldObj.func_72820_D() > this.raidPlanningStart + 24000L && this.raidStart == 0L) {
            if (MLN.LogDiplomacy >= 2) {
                MLN.minor(this, "Starting raid on " + this.mw.getBuilding(this.raidTarget));
            }
            this.startRaid();
        } else if (this.raidStart > 0L && this.worldObj.func_72820_D() > this.raidStart + 23000L) {
            Building distantVillage = this.mw.getBuilding(this.raidTarget);
            if (distantVillage != null) {
                if (!distantVillage.isActive) {
                    this.endRaid();
                }
            } else {
                this.cancelRaid();
                for (VillagerRecord vr : this.vrecords) {
                    vr.awayraiding = false;
                }
            }
        }
    }

    private void updateTownHall() throws MLN.MillenaireException {
        if (this.vrecords.size() > 0) {
            this.updateWorldInfo();
        }
        this.closestPlayer = this.worldObj.func_72977_a((double)this.pos.getiX(), (double)this.pos.getiY(), (double)this.pos.getiZ(), 100.0);
        this.completeConstruction();
        this.findBuildingProject();
        this.findBuildingConstruction();
        if (this.location.showTownHallSigns) {
            this.updateTownHallSigns(false);
        }
        this.checkSeller();
        this.checkWorkers();
        if (this.worldObj.func_72820_D() % 10L == 0L) {
            this.checkBattleStatus();
        }
        this.killMobs();
        if (this.vrecords.size() > 0 && !this.worldObj.func_72935_r() && System.currentTimeMillis() - this.lastPathingUpdate > 60000L) {
            this.rebuildPathing(false);
        }
        if (!this.declaredPos && this.worldObj != null) {
            if (this.villageType.lonebuilding) {
                this.mw.registerLoneBuildingsLocation(this.worldObj, this.getPos(), this.getVillageQualifiedName(), this.villageType, this.culture, false, null);
            } else {
                this.mw.registerVillageLocation(this.worldObj, this.getPos(), this.getVillageQualifiedName(), this.villageType, this.culture, false, null);
            }
            this.declaredPos = true;
        }
        if (this.lastVillagerRecordsRepair == 0L) {
            this.lastVillagerRecordsRepair = this.worldObj.func_72820_D();
        } else if (this.worldObj.func_72820_D() - this.lastVillagerRecordsRepair >= 100L) {
            this.repairVillagerList();
            this.lastVillagerRecordsRepair = this.worldObj.func_72820_D();
        }
        if (this.worldObj.func_72935_r()) {
            this.thNightActionPerformed = false;
        } else if (!this.thNightActionPerformed) {
            if (!this.villageType.playerControlled && !this.villageType.lonebuilding) {
                for (EntityPlayer player : MillCommonUtilities.getServerPlayers(this.worldObj)) {
                    UserProfile profile = MillCommonUtilities.getServerProfile(this.worldObj, player.getDisplayName());
                    profile.adjustDiplomacyPoint(this, 5);
                }
                for (Point p : this.relations.keySet()) {
                    Building village;
                    if (!MillCommonUtilities.chanceOn(10) || (village = this.mw.getBuilding(p)) == null) continue;
                    int relation = this.relations.get(p);
                    int improveChance = relation < -90 ? 0 : (relation < -50 ? 30 : (relation < 0 ? 40 : (relation > 90 ? 100 : (relation > 50 ? 70 : 60))));
                    if (MillCommonUtilities.randomInt(100) < improveChance) {
                        if (this.relations.get(p) >= 100) continue;
                        this.adjustRelation(p, 10 + MillCommonUtilities.randomInt(10), false);
                        ServerSender.sendTranslatedSentenceInRange(this.worldObj, this.getPos(), MLN.BackgroundRadius, '2', "ui.relationfriendly", this.getVillageQualifiedName(), village.getVillageQualifiedName(), MillCommonUtilities.getRelationName(this.relations.get(p)));
                        continue;
                    }
                    if (this.relations.get(p) <= -100) continue;
                    this.adjustRelation(p, -10 - MillCommonUtilities.randomInt(10), false);
                    ServerSender.sendTranslatedSentenceInRange(this.worldObj, this.getPos(), MLN.BackgroundRadius, '6', "ui.relationunfriendly", this.getVillageQualifiedName(), village.getVillageQualifiedName(), MillCommonUtilities.getRelationName(this.relations.get(p)));
                }
            }
            this.thNightActionPerformed = true;
        }
        if (this.villageType.playerControlled && this.worldObj.func_72820_D() % 1000L == 0L && this.countGoods(Mill.parchmentVillageScroll, -1) == 0) {
            for (int i = 0; i < this.mw.villagesList.pos.size(); ++i) {
                Point p;
                p = this.mw.villagesList.pos.get(i);
                if (!this.getPos().sameBlock(p)) continue;
                this.storeGoods(Mill.parchmentVillageScroll, i, 1);
            }
        }
        if (this.controlledBy != null && this.controlledBy.length() > 0 && this.controlledByName == null) {
            UserProfile profile = MillCommonUtilities.getServerProfile(this.worldObj, this.controlledBy);
            this.controlledByName = profile.playerName;
        }
        if (this.worldObj.func_72820_D() % 200L == 0L) {
            this.updateAchievements();
        }
        if (this.autobuildPaths) {
            this.clearOldPaths();
            this.constructCalculatedPaths();
        }
    }

    private void updateTownHallSigns(boolean forced) {
        if (this.worldObj.field_72995_K) {
            return;
        }
        EntityPlayer player = this.worldObj.func_72977_a((double)this.pos.getiX(), (double)this.pos.getiY(), (double)this.pos.getiZ(), 20.0);
        if (player == null) {
            return;
        }
        if (!forced && System.currentTimeMillis() - this.lastSignUpdate < 2000L) {
            return;
        }
        if (this.signs.size() == 0 || this.signs.get(0) == null) {
            return;
        }
        for (int i = 0; i < this.signs.size(); ++i) {
            int meta;
            Point p = this.signs.get(i);
            if (p == null || MillCommonUtilities.getBlock(this.worldObj, p) == Mill.panel || (meta = MillCommonUtilities.guessSignMetaData(this.worldObj, p)) <= 0) continue;
            MillCommonUtilities.setBlockAndMetadata(this.worldObj, p, Mill.panel, meta);
        }
        TileEntityPanel sign = (TileEntityPanel)this.worldObj.func_147438_o(this.signs.get(0).getiX(), this.signs.get(0).getiY(), this.signs.get(0).getiZ());
        if (sign != null) {
            int nbvill = 0;
            for (VillagerRecord vr : this.vrecords) {
                boolean belongsToVillage;
                if (vr == null || !(belongsToVillage = !vr.raidingVillage && vr.getType() != null && !vr.getType().visitor)) continue;
                ++nbvill;
            }
            String[][] lines = this.controlledBy != null && this.controlledBy.length() > 0 ? new String[][]{{this.getVillageNameWithoutQualifier()}, {this.qualifier}, {this.villageType.name}, {this.controlledByName}} : new String[][]{{this.getVillageNameWithoutQualifier()}, {this.qualifier}, {this.villageType.name}, {"ui.populationnumber", "" + nbvill}};
            ServerSender.updatePanel(this.mw, this.signs.get(0), lines, 1, this.getPos(), 0L);
        }
        if (this.signs.size() == 1) {
            return;
        }
        BuildingPlan goalPlan = this.getCurrentGoalBuildingPlan();
        Vector<MillVillager.InvItem> res = new Vector<MillVillager.InvItem>();
        Vector<Integer> resCost = new Vector<Integer>();
        Vector<Integer> resHas = new Vector<Integer>();
        if (goalPlan != null) {
            for (MillVillager.InvItem key : goalPlan.resCost.keySet()) {
                res.add(key);
                resCost.add(goalPlan.resCost.get(key));
                int has = this.countGoods(key.getItem(), key.meta);
                if (this.builder != null && this.buildingLocationIP != null && this.buildingLocationIP.key.equals(this.buildingGoal)) {
                    has += this.builder.countInv(key.getItem(), key.meta);
                }
                if (has > goalPlan.resCost.get(key)) {
                    has = goalPlan.resCost.get(key);
                }
                resHas.add(has);
            }
        }
        for (int i = 1; i < 4 && i < this.signs.size(); ++i) {
            sign = this.signs.get(i).getPanel(this.worldObj);
            if (sign == null) continue;
            String[][] lines = goalPlan == null || res.size() < i * 2 - 1 ? new String[][]{{""}, {""}, {""}, {""}} : (res.size() > 6 && i == 3 ? new String[][]{{((MillVillager.InvItem)res.get(i * 2 - 2)).getTranslationKey()}, {"ui.xoutofy", "" + resHas.get(i * 2 - 2), "" + resCost.get(i * 2 - 2)}, {"ui.extraresneeded1", "" + (res.size() - 5)}, {"ui.extraresneeded2", "" + (res.size() - 5)}} : (res.size() > i * 2 - 1 ? new String[][]{{((MillVillager.InvItem)res.get(i * 2 - 2)).getTranslationKey()}, {"ui.xoutofy", "" + resHas.get(i * 2 - 2), "" + resCost.get(i * 2 - 2)}, {((MillVillager.InvItem)res.get(i * 2 - 1)).getTranslationKey()}, {"ui.xoutofy", "" + resHas.get(i * 2 - 1), "" + resCost.get(i * 2 - 1)}} : new String[][]{{((MillVillager.InvItem)res.get(i * 2 - 2)).getTranslationKey()}, {"ui.xoutofy", "" + resHas.get(i * 2 - 2), "" + resCost.get(i * 2 - 2)}, {""}, {""}}));
            ServerSender.updatePanel(this.mw, this.signs.get(i), lines, 6, this.getPos(), 0L);
        }
        if (this.signs.size() < 5) {
            return;
        }
        sign = this.signs.get(4).getPanel(this.worldObj);
        if (sign != null) {
            String[][] lines;
            if (this.buildingGoal == null) {
                lines = new String[][]{{""}, {"ui.goalscompleted1"}, {"ui.goalscompleted2"}, {""}};
            } else {
                BuildingPlan goal = this.getCurrentGoalBuildingPlan();
                String[] status = this.buildingLocationIP != null && this.buildingLocationIP.key.equals(this.buildingGoal) ? (this.buildingLocationIP.level == 0 ? new String[]{"ui.inconstruction"} : new String[]{"ui.upgrading", "" + this.buildingLocationIP.level}) : new String[]{this.buildingGoalIssue};
                lines = new String[][]{{"ui.project"}, {goal.nativeName}, {goal.getGameNameKey()}, status};
            }
            int type = this.villageType.playerControlled ? 4 : 3;
            ServerSender.updatePanel(this.mw, this.signs.get(4), lines, type, this.getPos(), 0L);
        }
        if (this.signs.size() < 6) {
            return;
        }
        sign = this.signs.get(5).getPanel(this.worldObj);
        if (sign != null) {
            String[][] lines;
            if (this.buildingLocationIP == null) {
                lines = new String[][]{{""}, {"ui.noconstruction1"}, {"ui.noconstruction2"}, {""}};
            } else {
                String[] loc;
                String planName = this.culture.getBuildingPlanSet(this.buildingLocationIP.key).getNativeName();
                String[] status = this.buildingLocationIP.level == 0 ? new String[]{"ui.inconstruction"} : new String[]{"ui.upgrading", "" + this.buildingLocationIP.level};
                if (this.buildingLocationIP != null) {
                    int distance = MathHelper.func_76128_c((double)this.getPos().distanceTo(this.buildingLocationIP.pos));
                    String direction = this.getPos().directionTo(this.buildingLocationIP.pos);
                    loc = new String[]{"other.shortdistancedirection", "" + distance, "" + direction};
                } else {
                    loc = new String[]{};
                }
                String[] constr = this.getBblocks() != null && this.getBblocks().length > 0 ? new String[]{"ui.construction", "" + (int)Math.floor(this.bblocksPos * 100 / this.getBblocks().length)} : new String[]{"ui.inconstruction"};
                lines = new String[][]{constr, {planName}, status, loc};
            }
            ServerSender.updatePanel(this.mw, this.signs.get(5), lines, 2, this.getPos(), 0L);
        }
        if (this.signs.size() < 7) {
            return;
        }
        sign = this.signs.get(6).getPanel(this.worldObj);
        if (sign != null) {
            int nbMen = 0;
            int nbFemale = 0;
            int nbGrownBoy = 0;
            int nbGrownGirl = 0;
            int nbBoy = 0;
            int nbGirl = 0;
            for (VillagerRecord vr : this.vrecords) {
                boolean belongsToVillage = vr.getType() != null && !vr.getType().visitor && !vr.raidingVillage;
                if (!belongsToVillage) continue;
                if (!vr.getType().isChild) {
                    if (vr.gender == 1) {
                        ++nbMen;
                        continue;
                    }
                    ++nbFemale;
                    continue;
                }
                if (vr.villagerSize == 20) {
                    if (vr.gender == 1) {
                        ++nbGrownBoy;
                        continue;
                    }
                    ++nbGrownGirl;
                    continue;
                }
                if (vr.gender == 1) {
                    ++nbBoy;
                    continue;
                }
                ++nbGirl;
            }
            String[][] lines = new String[][]{{"ui.population"}, {"ui.adults", "" + (nbMen + nbFemale), "" + nbMen, "" + nbFemale}, {"ui.teens", "" + (nbGrownBoy + nbGrownGirl), "" + nbGrownBoy, "" + nbGrownGirl}, {"ui.children", "" + (nbBoy + nbGirl), "" + nbBoy, "" + nbGirl}};
            ServerSender.updatePanel(this.mw, this.signs.get(6), lines, 1, this.getPos(), 0L);
        }
        if (this.signs.size() < 8) {
            return;
        }
        sign = this.signs.get(7).getPanel(this.worldObj);
        if (sign != null) {
            String[][] lines = new String[][]{{"ui.villagemap"}, {""}, {"ui.nbbuildings", "" + this.buildings.size()}, {""}};
            ServerSender.updatePanel(this.mw, this.signs.get(7), lines, 8, this.getPos(), 0L);
        }
        if (this.signs.size() < 9) {
            return;
        }
        sign = this.signs.get(8).getPanel(this.worldObj);
        if (sign != null) {
            String status = "";
            if (this.raidTarget != null) {
                status = this.raidStart > 0L ? "panels.raidinprogress" : "panels.planningraid";
            } else if (this.underAttack) {
                status = "panels.underattack";
            }
            String[][] lines = new String[][]{{"panels.military"}, {status}, {"panels.offense", "" + this.getVillageRaidingStrength()}, {"panels.defense", "" + this.getVillageDefendingStrength()}};
            int type = this.villageType.playerControlled ? 13 : 9;
            ServerSender.updatePanel(this.mw, this.signs.get(8), lines, type, this.getPos(), 0L);
        }
        this.lastSignUpdate = System.currentTimeMillis();
    }

    public void updateVillagerRecord(MillVillager v) {
        VillagerRecord vr = this.getVillagerRecordById(v.villager_id);
        if (vr != null) {
            vr.updateRecord(v);
        }
    }

    public void updateWorldInfo() throws MLN.MillenaireException {
        if (this.villageType == null) {
            MLN.error(this, "updateWorldInfo: villageType is null");
            return;
        }
        boolean areaChanged = this.winfo.update(this.worldObj, this.getLocations(), this.buildingLocationIP, this.location.pos, this.villageType.radius);
        if (areaChanged) {
            this.rebuildPathing(false);
        }
    }

    private void validateVillagerList() {
        Vector<Object> found;
        for (MillVillager v : this.villagers) {
            if (v == null) {
                MLN.error(this, "Null value in villager list");
            }
            if (v.field_70128_L && MLN.LogTileEntityBuilding >= 2) {
                MLN.minor(this, "Villager " + v + " is dead.");
            }
            found = new Vector<Object>();
            for (VillagerRecord villagerRecord : this.vrecords) {
                if (!villagerRecord.matches(v)) continue;
                found.add(villagerRecord);
            }
            if (found.size() == 0) {
                MLN.error(this, "Villager " + v + " not present in records.");
                continue;
            }
            if (found.size() <= 1) continue;
            MLN.error(this, "Villager " + v + " present " + found.size() + " times in records: ");
            for (VillagerRecord villagerRecord : found) {
                MLN.major(this, villagerRecord.toString() + " / " + villagerRecord.hashCode());
            }
        }
        for (VillagerRecord vr : this.vrecords) {
            found = new Vector();
            if (vr.housePos == null) {
                MLN.error(this, "Record " + vr + " has no house.");
            }
            for (MillVillager millVillager : this.villagers) {
                if (!vr.matches(millVillager)) continue;
                found.add(millVillager);
            }
            if (found.size() == vr.nb) continue;
            MLN.error(this, "Record " + vr + " present " + found.size() + " times in villagers, previously: " + vr.nb + ". Villagers: ");
            for (MillVillager millVillager : found) {
                MLN.major(this, millVillager.toString() + " / " + millVillager.hashCode());
            }
            vr.nb = found.size();
        }
    }

    private void writeBblocks() {
        File buildingsDir = MillCommonUtilities.getBuildingsDir(this.worldObj);
        File file1 = new File(buildingsDir, this.getPos().getPathString() + "_bblocks.bin");
        BuildingPlan.BuildingBlock[] blocks = this.getBblocks();
        if (blocks != null) {
            try {
                FileOutputStream fos = new FileOutputStream(file1);
                DataOutputStream ds = new DataOutputStream(fos);
                ds.writeInt(blocks.length);
                for (int i = 0; i < blocks.length; ++i) {
                    BuildingPlan.BuildingBlock b = blocks[i];
                    ds.writeInt(b.p.getiX());
                    ds.writeShort(b.p.getiY());
                    ds.writeInt(b.p.getiZ());
                    ds.writeInt(MillCommonUtilities.getBlockId(b.block));
                    ds.writeByte(b.meta);
                    ds.writeByte(b.special);
                }
                ds.close();
                fos.close();
            }
            catch (IOException e) {
                MLN.printException("Error when writing bblocks: ", e);
            }
        } else {
            file1.delete();
        }
        this.bblocksChanged = false;
    }

    private void writePaths() {
        DataOutputStream ds;
        FileOutputStream fos;
        File buildingsDir = MillCommonUtilities.getBuildingsDir(this.worldObj);
        File file1 = new File(buildingsDir, this.getPos().getPathString() + "_paths.bin");
        if (this.pathsToBuild != null) {
            try {
                fos = new FileOutputStream(file1);
                ds = new DataOutputStream(fos);
                ds.writeInt(this.pathsToBuild.size());
                for (Vector<BuildingPlan.BuildingBlock> path : this.pathsToBuild) {
                    ds.writeInt(path.size());
                    for (BuildingPlan.BuildingBlock b : path) {
                        ds.writeInt(b.p.getiX());
                        ds.writeShort(b.p.getiY());
                        ds.writeInt(b.p.getiZ());
                        ds.writeInt(Block.func_149682_b((Block)b.block));
                        ds.writeByte(b.meta);
                        ds.writeByte(b.special);
                    }
                }
                ds.close();
                fos.close();
            }
            catch (IOException e) {
                MLN.printException("Error when writing pathsToBuild: ", e);
            }
        } else {
            file1.delete();
        }
        file1 = new File(buildingsDir, this.getPos().getPathString() + "_pathstoclear.bin");
        if (this.oldPathPointsToClear != null) {
            try {
                fos = new FileOutputStream(file1);
                ds = new DataOutputStream(fos);
                ds.writeInt(this.oldPathPointsToClear.size());
                for (Point p : this.oldPathPointsToClear) {
                    ds.writeInt(p.getiX());
                    ds.writeShort(p.getiY());
                    ds.writeInt(p.getiZ());
                }
                ds.close();
                fos.close();
            }
            catch (IOException e) {
                MLN.printException("Error when writing oldPathPointsToClear: ", e);
            }
        } else {
            file1.delete();
        }
        this.pathsChanged = false;
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        if (this.location == null) {
            MLN.error(this, "Null location. Skipping write.");
            return;
        }
        nbttagcompound.func_74778_a("versionCompatibility", versionCompatibility);
        try {
            NBTTagCompound nbttagcompound2;
            NBTTagList nbttaglist2;
            int i;
            NBTTagCompound nbttagcompound1;
            this.pos.write(nbttagcompound, "pos");
            this.location.write(nbttagcompound, "buildingLocation", "self");
            nbttagcompound.func_74757_a("chestLocked", this.chestLocked);
            if (this.name != null && this.name.length() > 0) {
                nbttagcompound.func_74778_a("name", this.name);
            }
            nbttagcompound.func_74778_a("qualifier", this.qualifier);
            nbttagcompound.func_74757_a("isTownhall", this.isTownhall);
            nbttagcompound.func_74778_a("culture", this.culture.key);
            if (this.villageType != null) {
                nbttagcompound.func_74778_a("villageType", this.villageType.key);
            }
            if (this.controlledBy != null) {
                nbttagcompound.func_74778_a("controlledBy", this.controlledBy);
            }
            if (this.sleepingPos != null) {
                this.sleepingPos.write(nbttagcompound, "spawnPos");
            }
            if (this.sellingPos != null) {
                this.sellingPos.write(nbttagcompound, "sellingPos");
            }
            if (this.craftingPos != null) {
                this.craftingPos.write(nbttagcompound, "craftingPos");
            }
            if (this.defendingPos != null) {
                this.defendingPos.write(nbttagcompound, "defendingPos");
            }
            if (this.shelterPos != null) {
                this.shelterPos.write(nbttagcompound, "shelterPos");
            }
            if (this.pathStartPos != null) {
                this.pathStartPos.write(nbttagcompound, "pathStartPos");
            }
            if (this.leasurePos != null) {
                this.leasurePos.write(nbttagcompound, "leasurePos");
            }
            if (this.townHallPos != null) {
                this.townHallPos.write(nbttagcompound, "townHallPos");
            }
            nbttagcompound.func_74757_a("nightActionPerformed", this.thNightActionPerformed);
            nbttagcompound.func_74757_a("nightBackgroundActionPerformed", this.nightBackgroundActionPerformed);
            NBTTagList nbttaglist = new NBTTagList();
            for (Point point : this.signs) {
                if (point == null) continue;
                NBTTagCompound nbttagcompound12 = new NBTTagCompound();
                point.write(nbttagcompound12, "pos");
                nbttaglist.func_74742_a((NBTBase)nbttagcompound12);
            }
            nbttagcompound.func_74782_a("signs", (NBTBase)nbttaglist);
            nbttaglist = new NBTTagList();
            for (Point point : this.netherwartsoils) {
                nbttagcompound1 = new NBTTagCompound();
                point.write(nbttagcompound1, "pos");
                nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
            }
            nbttagcompound.func_74782_a("netherwartsoils", (NBTBase)nbttaglist);
            nbttaglist = new NBTTagList();
            for (Point point : this.silkwormblock) {
                nbttagcompound1 = new NBTTagCompound();
                point.write(nbttagcompound1, "pos");
                nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
            }
            nbttagcompound.func_74782_a("silkwormblock", (NBTBase)nbttaglist);
            nbttaglist = new NBTTagList();
            for (Point point : this.sugarcanesoils) {
                nbttagcompound1 = new NBTTagCompound();
                point.write(nbttagcompound1, "pos");
                nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
            }
            nbttagcompound.func_74782_a("sugarcanesoils", (NBTBase)nbttaglist);
            nbttaglist = new NBTTagList();
            for (Point point : this.fishingspots) {
                nbttagcompound1 = new NBTTagCompound();
                point.write(nbttagcompound1, "pos");
                nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
            }
            nbttagcompound.func_74782_a("fishingspots", (NBTBase)nbttaglist);
            nbttaglist = new NBTTagList();
            for (Point point : this.healingspots) {
                nbttagcompound1 = new NBTTagCompound();
                point.write(nbttagcompound1, "pos");
                nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
            }
            nbttagcompound.func_74782_a("healingspots", (NBTBase)nbttaglist);
            nbttaglist = new NBTTagList();
            for (Point point : this.stalls) {
                nbttagcompound1 = new NBTTagCompound();
                point.write(nbttagcompound1, "pos");
                nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
            }
            nbttagcompound.func_74782_a("stalls", (NBTBase)nbttaglist);
            nbttaglist = new NBTTagList();
            for (Point point : this.woodspawn) {
                nbttagcompound1 = new NBTTagCompound();
                point.write(nbttagcompound1, "pos");
                nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
            }
            nbttagcompound.func_74782_a("woodspawn", (NBTBase)nbttaglist);
            nbttaglist = new NBTTagList();
            for (Point point : this.brickspot) {
                nbttagcompound1 = new NBTTagCompound();
                point.write(nbttagcompound1, "pos");
                nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
            }
            nbttagcompound.func_74782_a("brickspot", (NBTBase)nbttaglist);
            nbttaglist = new NBTTagList();
            for (i = 0; i < this.spawns.size(); ++i) {
                NBTTagCompound nBTTagCompound = new NBTTagCompound();
                nBTTagCompound.func_74778_a("type", this.spawnTypes.get(i));
                nbttaglist2 = new NBTTagList();
                for (Point p : this.spawns.get(i)) {
                    nbttagcompound2 = new NBTTagCompound();
                    p.write(nbttagcompound2, "pos");
                    nbttaglist2.func_74742_a((NBTBase)nbttagcompound2);
                }
                nBTTagCompound.func_74782_a("points", (NBTBase)nbttaglist2);
                nbttaglist.func_74742_a((NBTBase)nBTTagCompound);
            }
            nbttagcompound.func_74782_a("spawns", (NBTBase)nbttaglist);
            nbttagcompound.func_74768_a("nbAnimalsRespawned", this.nbAnimalsRespawned);
            nbttaglist = new NBTTagList();
            for (i = 0; i < this.soilTypes.size(); ++i) {
                NBTTagCompound nBTTagCompound = new NBTTagCompound();
                nBTTagCompound.func_74778_a("type", this.soilTypes.get(i));
                nbttaglist2 = new NBTTagList();
                for (Point p : this.soils.get(i)) {
                    nbttagcompound2 = new NBTTagCompound();
                    p.write(nbttagcompound2, "pos");
                    nbttaglist2.func_74742_a((NBTBase)nbttagcompound2);
                }
                nBTTagCompound.func_74782_a("points", (NBTBase)nbttaglist2);
                nbttaglist.func_74742_a((NBTBase)nBTTagCompound);
            }
            nbttagcompound.func_74782_a("genericsoils", (NBTBase)nbttaglist);
            nbttaglist = new NBTTagList();
            for (i = 0; i < this.mobSpawners.size(); ++i) {
                NBTTagCompound nBTTagCompound = new NBTTagCompound();
                nBTTagCompound.func_74778_a("type", this.mobSpawnerTypes.get(i));
                nbttaglist2 = new NBTTagList();
                for (Point p : this.mobSpawners.get(i)) {
                    nbttagcompound2 = new NBTTagCompound();
                    p.write(nbttagcompound2, "pos");
                    nbttaglist2.func_74742_a((NBTBase)nbttagcompound2);
                }
                nBTTagCompound.func_74782_a("points", (NBTBase)nbttaglist2);
                nbttaglist.func_74742_a((NBTBase)nBTTagCompound);
            }
            nbttagcompound.func_74782_a("mobspawns", (NBTBase)nbttaglist);
            nbttaglist = new NBTTagList();
            for (i = 0; i < this.sources.size(); ++i) {
                NBTTagCompound nBTTagCompound = new NBTTagCompound();
                nBTTagCompound.func_74768_a("type", Block.func_149682_b((Block)this.sourceTypes.get(i)));
                nbttaglist2 = new NBTTagList();
                for (Point p : this.sources.get(i)) {
                    nbttagcompound2 = new NBTTagCompound();
                    p.write(nbttagcompound2, "pos");
                    nbttaglist2.func_74742_a((NBTBase)nbttagcompound2);
                }
                nBTTagCompound.func_74782_a("points", (NBTBase)nbttaglist2);
                nbttaglist.func_74742_a((NBTBase)nBTTagCompound);
            }
            nbttagcompound.func_74782_a("sources", (NBTBase)nbttaglist);
            nbttaglist = new NBTTagList();
            for (Point point : this.chests) {
                nbttagcompound1 = new NBTTagCompound();
                point.write(nbttagcompound1, "pos");
                nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
            }
            nbttagcompound.func_74782_a("chests", (NBTBase)nbttaglist);
            nbttaglist = new NBTTagList();
            for (Point point : this.furnaces) {
                nbttagcompound1 = new NBTTagCompound();
                point.write(nbttagcompound1, "pos");
                nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
            }
            nbttagcompound.func_74782_a("furnaces", (NBTBase)nbttaglist);
            nbttaglist = new NBTTagList();
            for (Point point : this.brewingStands) {
                nbttagcompound1 = new NBTTagCompound();
                point.write(nbttagcompound1, "pos");
                nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
            }
            nbttagcompound.func_74782_a("brewingStands", (NBTBase)nbttaglist);
            nbttaglist = new NBTTagList();
            for (Point point : this.buildings) {
                nbttagcompound1 = new NBTTagCompound();
                point.write(nbttagcompound1, "pos");
                nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
            }
            nbttagcompound.func_74782_a("buildings", (NBTBase)nbttaglist);
            nbttagcompound.func_74768_a("bblocksPos", this.bblocksPos);
            if (this.bblocksChanged) {
                this.writeBblocks();
                if (MLN.LogHybernation >= 1) {
                    MLN.major(this, "Saved bblocks.");
                }
            }
            nbttaglist = new NBTTagList();
            for (Vector vector : this.buildingProjects) {
                for (BuildingProject project : vector) {
                    if (project.location == null) continue;
                    NBTTagCompound nbttagcompound13 = new NBTTagCompound();
                    project.location.write(nbttagcompound13, "location", "buildingProjects");
                    nbttaglist.func_74742_a((NBTBase)nbttagcompound13);
                    if (MLN.LogHybernation < 1) continue;
                    MLN.major(this, "Writing building location: " + project.location + " (level: " + project.location.level + ", variation: " + project.location.getVariation() + ")");
                }
            }
            nbttagcompound.func_74782_a("locations", (NBTBase)nbttaglist);
            if (this.buildingGoal != null) {
                nbttagcompound.func_74778_a("buildingGoal", this.buildingGoal);
                if (MLN.LogHybernation >= 1) {
                    MLN.major(this, "Writing building goal: " + this.buildingGoal);
                }
            }
            nbttagcompound.func_74768_a("buildingGoalLevel", this.buildingGoalLevel);
            nbttagcompound.func_74768_a("buildingGoalVariation", this.buildingGoalVariation);
            if (this.buildingGoalIssue != null) {
                nbttagcompound.func_74778_a("buildingGoalIssue", this.buildingGoalIssue);
            }
            if (this.buildingGoalLocation != null) {
                this.buildingGoalLocation.write(nbttagcompound, "buildingGoalLocation", "buildingGoalLocation");
                if (MLN.LogHybernation >= 1) {
                    MLN.major(this, "Writing buildingGoalLocation: " + this.buildingGoalLocation);
                }
            }
            if (this.buildingLocationIP != null) {
                this.buildingLocationIP.write(nbttagcompound, "buildingLocationIP", "buildingLocationIP");
                if (MLN.LogHybernation >= 1) {
                    MLN.major(this, "Writing buildingLocationIP: " + this.buildingLocationIP);
                }
            }
            nbttaglist = new NBTTagList();
            for (VillagerRecord villagerRecord : this.vrecords) {
                nbttagcompound1 = new NBTTagCompound();
                villagerRecord.write(nbttagcompound1, "vr");
                nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
                if (MLN.LogHybernation < 3) continue;
                MLN.debug(this, "Writing VR: " + villagerRecord);
            }
            nbttagcompound.func_74782_a("villagersrecords", (NBTBase)nbttaglist);
            nbttaglist = new NBTTagList();
            for (String string : this.visitorsList) {
                nbttagcompound1 = new NBTTagCompound();
                nbttagcompound1.func_74778_a("visitor", string);
                nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
            }
            nbttagcompound.func_74782_a("visitorsList", (NBTBase)nbttaglist);
            nbttaglist = new NBTTagList();
            for (String string : this.buildingsBought) {
                nbttagcompound1 = new NBTTagCompound();
                nbttagcompound1.func_74778_a("key", string);
                nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
            }
            nbttagcompound.func_74782_a("buildingsBought", (NBTBase)nbttaglist);
            nbttagcompound.func_74757_a("updateRaidPerformed", this.updateRaidPerformed);
            nbttagcompound.func_74757_a("nightBackgroundActionPerformed", this.nightBackgroundActionPerformed);
            nbttagcompound.func_74757_a("nightActionPerformed", this.thNightActionPerformed);
            nbttagcompound.func_74757_a("underAttack", this.underAttack);
            if (this.raidTarget != null) {
                this.raidTarget.write(nbttagcompound, "raidTarget");
                nbttagcompound.func_74772_a("raidPlanningStart", this.raidPlanningStart);
                nbttagcompound.func_74772_a("raidStart", this.raidStart);
            }
            nbttaglist = new NBTTagList();
            for (String string : this.raidsPerformed) {
                nbttagcompound1 = new NBTTagCompound();
                nbttagcompound1.func_74778_a("raid", string);
                nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
            }
            nbttagcompound.func_74782_a("raidsPerformed", (NBTBase)nbttaglist);
            nbttaglist = new NBTTagList();
            for (String string : this.raidsSuffered) {
                nbttagcompound1 = new NBTTagCompound();
                nbttagcompound1.func_74778_a("raid", string);
                nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
            }
            nbttagcompound.func_74782_a("raidsTaken", (NBTBase)nbttaglist);
            if (this.villageType != null && !this.villageType.lonebuilding) {
                nbttaglist = new NBTTagList();
                for (Point point : this.relations.keySet()) {
                    Building dv = this.mw.getBuilding(point);
                    if (dv == null || dv.villageType.lonebuilding) continue;
                    NBTTagCompound nbttagcompound14 = new NBTTagCompound();
                    point.write(nbttagcompound14, "pos");
                    nbttagcompound14.func_74768_a("value", this.relations.get(point).intValue());
                    nbttaglist.func_74742_a((NBTBase)nbttagcompound14);
                }
                nbttagcompound.func_74782_a("relations", (NBTBase)nbttaglist);
            }
            if (this.parentVillage != null) {
                this.parentVillage.write(nbttagcompound, "parentVillage");
            }
            nbttaglist = new NBTTagList();
            for (MillVillager.InvItem invItem : this.imported.keySet()) {
                nbttagcompound1 = new NBTTagCompound();
                nbttagcompound1.func_74768_a("itemid", Item.func_150891_b((Item)invItem.getItem()));
                nbttagcompound1.func_74768_a("itemmeta", invItem.meta);
                nbttagcompound1.func_74768_a("quantity", this.imported.get(invItem).intValue());
                nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
            }
            nbttagcompound.func_74782_a("importedGoods", (NBTBase)nbttaglist);
            nbttaglist = new NBTTagList();
            for (MillVillager.InvItem invItem : this.exported.keySet()) {
                nbttagcompound1 = new NBTTagCompound();
                nbttagcompound1.func_74768_a("itemid", Item.func_150891_b((Item)invItem.getItem()));
                nbttagcompound1.func_74768_a("itemmeta", invItem.meta);
                nbttagcompound1.func_74768_a("quantity", this.exported.get(invItem).intValue());
                nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
            }
            nbttagcompound.func_74782_a("exportedGoods", (NBTBase)nbttaglist);
            if (MLN.LogTileEntityBuilding >= 3) {
                MLN.debug(this, "Saving building. Location: " + this.location + ", pos: " + this.getPos());
            }
            nbttaglist = new NBTTagList();
            for (Point point : this.subBuildings) {
                nbttagcompound1 = new NBTTagCompound();
                point.write(nbttagcompound1, "pos");
                nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
            }
            nbttagcompound.func_74782_a("subBuildings", (NBTBase)nbttaglist);
            if (this.pujas != null) {
                NBTTagCompound tag = new NBTTagCompound();
                this.pujas.writeToNBT(tag);
                nbttagcompound.func_74782_a(tagPujas, (NBTBase)tag);
            }
            nbttagcompound.func_74772_a("lastGoodsRefresh", this.lastGoodsRefresh);
            nbttagcompound.func_74768_a("pathsToBuildIndex", this.pathsToBuildIndex);
            nbttagcompound.func_74768_a("pathsToBuildPathIndex", this.pathsToBuildPathIndex);
            nbttagcompound.func_74768_a("oldPathPointsToClearIndex", this.oldPathPointsToClearIndex);
            if (this.pathsChanged) {
                this.writePaths();
            }
        }
        catch (Exception e) {
            Mill.proxy.sendChatAdmin("Error when trying to save building. Check millenaire.log.");
            MLN.error(this, "Exception in Villager.onUpdate(): ");
            MLN.printException(e);
        }
    }

    public Set<Goods> getSellingGoods(EntityPlayer player) {
        if (!this.shopSells.containsKey(player.getDisplayName())) {
            return null;
        }
        return this.shopSells.get(player.getDisplayName()).keySet();
    }

    public Set<Goods> getBuyingGoods(EntityPlayer player) {
        if (!this.shopBuys.containsKey(player.getDisplayName())) {
            return null;
        }
        return this.shopBuys.get(player.getDisplayName()).keySet();
    }

    public int getSellingPrice(Goods g, EntityPlayer player) {
        if (player == null || !this.shopSells.containsKey(player.getDisplayName())) {
            return 0;
        }
        return this.shopSells.get(player.getDisplayName()).get(g);
    }

    public int getBuyingPrice(Goods g, EntityPlayer player) {
        if (!this.shopBuys.containsKey(player.getDisplayName())) {
            return 0;
        }
        return this.shopBuys.get(player.getDisplayName()).get(g);
    }

    private class SaveWorker
    extends Thread {
        private final String reason;

        private SaveWorker(String reason) {
            this.reason = reason;
        }

        @Override
        public void run() {
            File buildingsDir;
            if (!Building.this.isTownhall) {
                return;
            }
            long startTime = System.currentTimeMillis();
            NBTTagCompound mainTag = new NBTTagCompound();
            NBTTagList nbttaglist = new NBTTagList();
            for (int i = 0; i < Building.this.buildings.size(); ++i) {
                Building b;
                Point p = Building.this.buildings.get(i);
                if (p == null || (b = Building.this.mw.getBuilding(p)) == null) continue;
                NBTTagCompound buildingTag = new NBTTagCompound();
                b.writeToNBT(buildingTag);
                nbttaglist.func_74742_a((NBTBase)buildingTag);
            }
            mainTag.func_74782_a("buildings", (NBTBase)nbttaglist);
            File millenaireDir = Building.this.mw.millenaireDir;
            if (!millenaireDir.exists()) {
                millenaireDir.mkdir();
            }
            if (!(buildingsDir = new File(millenaireDir, "buildings")).exists()) {
                buildingsDir.mkdir();
            }
            File file1 = new File(buildingsDir, Building.this.getPos().getPathString() + "_temp.gz");
            try {
                FileOutputStream fileoutputstream = new FileOutputStream(file1);
                CompressedStreamTools.func_74799_a((NBTTagCompound)mainTag, (OutputStream)fileoutputstream);
                file1.renameTo(new File(buildingsDir, Building.this.getPos().getPathString() + ".gz"));
            }
            catch (IOException e) {
                MLN.printException(e);
            }
            if (MLN.LogHybernation >= 1) {
                MLN.major(Building.this, "Saved " + Building.this.buildings.size() + " buildings in " + (System.currentTimeMillis() - startTime) + " ms due to " + this.reason + " (" + Building.this.saveReason + ").");
            }
            Building.this.lastSaved = Building.this.worldObj.func_72820_D();
            Building.this.saveNeeded = false;
            Building.this.saveReason = null;
            Building.this.saveWorker = null;
        }
    }

    public static class PerformanceMonitor {
        public HashMap<String, Double> goalTime = new HashMap();
        public int nbPathing;
        public int nbCached;
        public int nbPartlyCached;
        public int nbReused;
        public double totalTime;
        public double pathingTime;
        public double noPathFoundTime;
        Building townHall;

        PerformanceMonitor(Building townHall) {
            this.townHall = townHall;
            this.reset();
        }

        public void addToGoal(String key, double time) {
            this.totalTime += time;
            if (this.goalTime.containsKey(Goal.goals.get(key))) {
                time = this.goalTime.get(Goal.goals.get(key)) + time;
            }
            this.goalTime.put(key, time);
        }

        public String getStats() {
            if (this.townHall.pathing == null) {
                return null;
            }
            String s = Math.round(this.totalTime) + "/" + Math.round(this.pathingTime) + "/" + Math.round(this.noPathFoundTime) + " - " + this.nbPathing + "(" + (float)Math.round(this.nbReused * 10000 / (this.nbPathing + 1)) * 1.0f / 100.0f + "% / " + (float)Math.round(this.nbCached * 10000 / (this.nbPathing + 1)) * 1.0f / 100.0f + "% / " + (float)Math.round(this.nbPartlyCached * 10000 / (this.nbPathing + 1)) * 1.0f / 100.0f + "%) Nb cached: " + this.townHall.pathing.cache.size() + " ";
            for (String goalKey : this.goalTime.keySet()) {
                if (Goal.goals.containsKey(goalKey)) {
                    s = s + Goal.goals.get(goalKey).gameName(null) + ": " + this.goalTime.get(goalKey) + " ";
                    continue;
                }
                s = s + "No goal: " + this.goalTime.get(goalKey) + " ";
            }
            for (int i = 0; i < this.townHall.pathing.firstDemand.size(); ++i) {
            }
            return s;
        }

        public void reset() {
            this.goalTime = new HashMap();
            this.totalTime = 0.0;
            this.pathingTime = 0.0;
            this.nbPathing = 0;
            this.nbCached = 0;
            this.noPathFoundTime = 0.0;
            this.nbPartlyCached = 0;
            this.nbReused = 0;
        }
    }

    public class PathingThread
    extends Thread {
        MillWorldInfo winfo;

        public PathingThread(MillWorldInfo wi) {
            this.winfo = wi;
        }

        @Override
        public void run() {
            AStarPathing temp = new AStarPathing();
            if (MLN.LogPathing >= 1) {
                MLN.major(this, "Start");
            }
            long tm = System.currentTimeMillis();
            try {
                if (temp.createConnectionsTable(this.winfo, Building.this.sleepingPos)) {
                    Building.this.pathing = temp;
                    Building.this.lastPathingUpdate = System.currentTimeMillis();
                } else {
                    Building.this.lastPathingUpdate = System.currentTimeMillis();
                    Building.this.pathing = null;
                }
            }
            catch (MLN.MillenaireException e) {
                MLN.printException(e);
            }
            if (MLN.LogPathing >= 1) {
                MLN.major(this, "Done: " + (double)(System.currentTimeMillis() - tm) * 1.0 / 1000.0);
            }
            Building.this.rebuildingPathing = false;
        }
    }

    private class PathCreatorInfo {
        private final int nbPathsExpected;
        private int nbPathsReceived = 0;
        private Vector<Vector<BuildingPlan.BuildingBlock>> pathsReceived = new Vector();
        private boolean creationComplete = false;

        PathCreatorInfo(int nbPathsExpected) {
            this.nbPathsExpected = nbPathsExpected;
        }
    }

    private class PathCreator
    implements IAStarPathedEntity {
        final PathCreatorInfo info;
        final MillVillager.InvItem pathConstructionGood;
        final int pathWidth;
        final Building destination;

        PathCreator(PathCreatorInfo info, MillVillager.InvItem pathConstructionGood, int pathWidth, Building destination) {
            this.pathConstructionGood = pathConstructionGood;
            this.pathWidth = pathWidth;
            this.destination = destination;
            this.info = info;
        }

        private void checkForRebuild() {
            if (this.info.nbPathsReceived == this.info.nbPathsExpected) {
                Collections.reverse(this.info.pathsReceived);
                Building.this.pathsToBuild = this.info.pathsReceived;
                Building.this.pathsToBuildIndex = 0;
                Building.this.pathsToBuildPathIndex = 0;
                Building.this.calculatePathsToClear();
                Building.this.pathsChanged = true;
                this.info.pathsReceived = null;
                this.info.creationComplete = true;
            }
        }

        @Override
        public void onFoundPath(ArrayList<AStarNode> result) {
            if (this.info.creationComplete) {
                MLN.error(Building.this, "onFoundPath triggered on completed info object.");
                return;
            }
            this.info.pathsReceived.add(MillCommonUtilities.buildPath(Building.this, result, this.pathConstructionGood.block, this.pathConstructionGood.meta, this.pathWidth));
            this.info.nbPathsReceived++;
            this.checkForRebuild();
        }

        @Override
        public void onNoPathAvailable() {
            if (this.info.creationComplete) {
                MLN.error(Building.this, "onNoPathAvailable triggered on completed info object.");
                return;
            }
            this.info.nbPathsReceived++;
            if (MLN.LogVillagePaths >= 2) {
                MLN.minor(Building.this, "Path calculation failed. Target: " + this.destination);
            }
            this.checkForRebuild();
        }
    }
}

