/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common.goal;

import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import org.millenaire.common.MillVillager;
import org.millenaire.common.Point;
import org.millenaire.common.goal.Goal;

public class GoalPlantCacao
extends Goal {
    private static ItemStack[] cacao = new ItemStack[]{new ItemStack(Blocks.field_150375_by, 1)};

    @Override
    public Goal.GoalInformation getDestination(MillVillager villager) {
        Point p = villager.getHouse().getCocoaPlantingLocation();
        return this.packDest(p, villager.getHouse());
    }

    @Override
    public ItemStack[] getHeldItemsTravelling(MillVillager villager) {
        return cacao;
    }

    @Override
    public boolean isPossibleSpecific(MillVillager villager) {
        return this.getDestination(villager).getDest() != null;
    }

    @Override
    public boolean lookAtGoal() {
        return true;
    }

    @Override
    public boolean performAction(MillVillager villager) {
        Block block = villager.getBlock(villager.getGoalDestPoint());
        Point cropPoint = villager.getGoalDestPoint();
        block = villager.getBlock(cropPoint);
        if (block == Blocks.field_150350_a) {
            villager.setBlockAndMetadata(cropPoint, Blocks.field_150375_by, this.getCocoaMeta(villager.field_70170_p, cropPoint));
            villager.func_71038_i();
        }
        return true;
    }

    private int getCocoaMeta(World world, Point p) {
        Block var5 = p.getRelative(0.0, 0.0, -1.0).getBlock(world);
        Block var6 = p.getRelative(0.0, 0.0, 1.0).getBlock(world);
        Block var7 = p.getRelative(-1.0, 0.0, 0.0).getBlock(world);
        Block var8 = p.getRelative(1.0, 0.0, 0.0).getBlock(world);
        int meta = 0;
        if (var5 == Blocks.field_150364_r) {
            meta = 2;
        }
        if (var6 == Blocks.field_150364_r) {
            meta = 0;
        }
        if (var7 == Blocks.field_150364_r) {
            meta = 1;
        }
        if (var8 == Blocks.field_150364_r) {
            meta = 3;
        }
        return meta;
    }

    @Override
    public int priority(MillVillager villager) {
        return 120;
    }
}

