/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.client.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import org.millenaire.client.gui.GuiText;
import org.millenaire.client.network.ClientSender;
import org.millenaire.common.MLN;
import org.millenaire.common.Point;
import org.millenaire.common.TileEntityPanel;
import org.millenaire.common.building.Building;
import org.millenaire.common.core.MillCommonUtilities;

public class GuiControlledMilitary
extends GuiText {
    private final Building townHall;
    private final EntityPlayer player;
    ResourceLocation background = new ResourceLocation("millenaire", "textures/gui/ML_panel.png");

    public GuiControlledMilitary(EntityPlayer player, Building th) {
        this.townHall = th;
        this.player = player;
    }

    protected void func_146284_a(GuiButton guibutton) {
        if (!guibutton.field_146124_l) {
            return;
        }
        GuiButtonDiplomacy gbp = (GuiButtonDiplomacy)guibutton;
        if (gbp.field_146127_k == 0) {
            ClientSender.controlledMilitaryDiplomacy(this.player, this.townHall, gbp.targetVillage, gbp.data);
        } else if (gbp.field_146127_k == 1) {
            ClientSender.controlledMilitaryPlanRaid(this.player, this.townHall, gbp.targetVillage);
        } else if (gbp.field_146127_k == 2) {
            ClientSender.controlledMilitaryCancelRaid(this.player, this.townHall);
        }
        this.fillData();
    }

    @Override
    protected void customDrawBackground(int i, int j, float f) {
    }

    @Override
    protected void customDrawScreen(int i, int j, float f) {
    }

    private void fillData() {
        Building b;
        ArrayList<GuiText.Line> text = new ArrayList<GuiText.Line>();
        text.add(new GuiText.Line(this.townHall.getVillageQualifiedName(), false));
        text.add(new GuiText.Line(false));
        text.add(new GuiText.Line(MLN.string("ui.controldiplomacy")));
        text.add(new GuiText.Line());
        ArrayList<VillageRelation> relations = new ArrayList<VillageRelation>();
        for (Point p : this.townHall.getKnownVillages()) {
            b = this.townHall.mw.getBuilding(p);
            if (b == null) continue;
            relations.add(new VillageRelation(p, this.townHall.getRelationWithVillage(p), b.getVillageQualifiedName()));
        }
        Collections.sort(relations);
        for (VillageRelation vr : relations) {
            GuiButtonDiplomacy raid;
            b = this.townHall.mw.getBuilding(vr.pos);
            if (b == null) continue;
            String col = "";
            if (vr.relation > 70) {
                col = "<darkgreen>";
            } else if (vr.relation > 30) {
                col = "<darkblue>";
            } else if (vr.relation <= -90) {
                col = "<darkred>";
            } else if (vr.relation <= -30) {
                col = "<lightred>";
            }
            text.add(new GuiText.Line(col + MLN.string("ui.villagerelations", b.getVillageQualifiedName(), b.villageType.name, b.culture.getCultureGameName(), MLN.string(MillCommonUtilities.getRelationName(vr.relation)) + " (" + vr.relation + ")"), false));
            GuiButtonDiplomacy relGood = new GuiButtonDiplomacy(vr.pos, 0, 100, MLN.string("ui.relgood"));
            GuiButtonDiplomacy relNeutral = new GuiButtonDiplomacy(vr.pos, 0, 0, MLN.string("ui.relneutral"));
            GuiButtonDiplomacy relBad = new GuiButtonDiplomacy(vr.pos, 0, -100, MLN.string("ui.relbad"));
            text.add(new GuiText.Line(relGood, relNeutral, relBad));
            text.add(new GuiText.Line(false));
            if (this.townHall.raidTarget == null) {
                raid = new GuiButtonDiplomacy(vr.pos, 1, -100, MLN.string("ui.raid"));
                text.add(new GuiText.Line(raid));
                text.add(new GuiText.Line(false));
            } else if (this.townHall.raidStart > 0L) {
                if (this.townHall.raidTarget.equals(vr.pos)) {
                    text.add(new GuiText.Line("<darkred>" + MLN.string("ui.raidinprogress")));
                } else {
                    text.add(new GuiText.Line("<darkred>" + MLN.string("ui.otherraidinprogress")));
                }
            } else if (this.townHall.raidTarget.equals(vr.pos)) {
                raid = new GuiButtonDiplomacy(vr.pos, 2, 0, MLN.string("ui.raidcancel"));
                text.add(new GuiText.Line(raid));
                text.add(new GuiText.Line(false));
                text.add(new GuiText.Line("<lightred>" + MLN.string("ui.raidplanned")));
            } else {
                raid = new GuiButtonDiplomacy(vr.pos, 1, -100, MLN.string("ui.raid"));
                text.add(new GuiText.Line(raid));
                text.add(new GuiText.Line(false));
                text.add(new GuiText.Line("<lightred>" + MLN.string("ui.otherraidplanned")));
            }
            text.add(new GuiText.Line());
        }
        ArrayList<List<GuiText.Line>> pages = new ArrayList<List<GuiText.Line>>();
        pages.add(text);
        List<List<String>> milpages = TileEntityPanel.generateMilitary(this.player, this.townHall);
        for (List<String> textPage : milpages) {
            ArrayList<GuiText.Line> page = new ArrayList<GuiText.Line>();
            for (String s : textPage) {
                page.add(new GuiText.Line(s));
            }
            pages.add(page);
        }
        this.descText = this.adjustText(pages);
        this.buttonPagination();
    }

    @Override
    public int getLineSizeInPx() {
        return 195;
    }

    @Override
    public int getPageSize() {
        return 19;
    }

    @Override
    public ResourceLocation getPNGPath() {
        return this.background;
    }

    @Override
    public int getXSize() {
        return 204;
    }

    @Override
    public int getYSize() {
        return 220;
    }

    @Override
    public void initData() {
        this.fillData();
    }

    private class VillageRelation
    implements Comparable<VillageRelation> {
        int relation;
        Point pos;
        String name;

        VillageRelation(Point p, int r, String name) {
            this.relation = r;
            this.pos = p;
            this.name = name;
        }

        @Override
        public int compareTo(VillageRelation arg0) {
            return this.name.compareTo(arg0.name);
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof VillageRelation)) {
                return false;
            }
            return this.pos.equals(((VillageRelation)o).pos);
        }

        public int hashCode() {
            return this.pos.hashCode();
        }
    }

    public static class GuiButtonDiplomacy
    extends GuiText.MillGuiButton {
        public static final int REL_GOOD = 100;
        public static final int REL_NEUTRAL = 0;
        public static final int REL_BAD = -100;
        public static final int REL = 0;
        public static final int RAID = 1;
        public static final int RAIDCANCEL = 2;
        public Point targetVillage;
        public int data = 0;

        public GuiButtonDiplomacy(Point targetVillage, int id, int data, String s) {
            super(id, 0, 0, 0, 0, s);
            this.targetVillage = targetVillage;
            this.data = data;
        }
    }
}

