/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.client.gui;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.millenaire.client.gui.GuiText;
import org.millenaire.client.network.ClientSender;
import org.millenaire.common.MLN;
import org.millenaire.common.VillagerRecord;
import org.millenaire.common.building.Building;
import org.millenaire.common.building.BuildingProject;

public class GuiControlledProjects
extends GuiText {
    private final Building townHall;
    private List<BuildingProject> projects;
    private final EntityPlayer player;
    ResourceLocation background = new ResourceLocation("millenaire", "textures/gui/ML_panel.png");

    public GuiControlledProjects(EntityPlayer player, Building th) {
        this.townHall = th;
        this.projects = this.townHall.getFlatProjectList();
        this.player = player;
    }

    protected void func_146284_a(GuiButton guibutton) {
        if (!guibutton.field_146124_l) {
            return;
        }
        GuiButtonProject gbp = (GuiButtonProject)guibutton;
        if (gbp.field_146127_k == 1) {
            ClientSender.controlledBuildingsToggleUpgrades(this.player, this.townHall, gbp.project, true);
        } else if (gbp.field_146127_k == 2) {
            ClientSender.controlledBuildingsToggleUpgrades(this.player, this.townHall, gbp.project, false);
        } else if (gbp.field_146127_k == 3) {
            ClientSender.controlledBuildingsForgetBuilding(this.player, this.townHall, gbp.project);
            this.projects = this.townHall.getFlatProjectList();
        }
        this.fillData();
    }

    @Override
    protected void customDrawBackground(int i, int j, float f) {
    }

    @Override
    protected void customDrawScreen(int i, int j, float f) {
    }

    private void fillData() {
        ArrayList<GuiText.Line> text = new ArrayList<GuiText.Line>();
        text.add(new GuiText.Line(this.townHall.getVillageQualifiedName(), false));
        text.add(new GuiText.Line(false));
        text.add(new GuiText.Line(MLN.string("ui.controlbuildingprojects")));
        text.add(new GuiText.Line());
        for (int i = 0; i < this.projects.size(); ++i) {
            boolean canForget;
            BuildingProject project = this.projects.get(i);
            if (project.planSet == null) continue;
            String status = project.location.level < 0 ? MLN.string("ui.notyetbuilt") : MLN.string("ui.level") + ": " + (project.location.level + 1) + "/" + project.planSet.plans.get(project.location.getVariation()).length;
            text.add(new GuiText.Line(project.getFullName(this.player) + " (" + (char)(65 + project.location.getVariation()) + "):", false));
            text.add(new GuiText.Line(status + ", " + this.townHall.getPos().distanceDirectionShort(project.location.pos), false));
            int nbInhabitants = 0;
            if (project.location != null && project.location.chestPos != null) {
                for (VillagerRecord vr : this.townHall.vrecords) {
                    if (!project.location.chestPos.equals(vr.housePos)) continue;
                    ++nbInhabitants;
                }
            }
            text.add(new GuiText.Line(MLN.string("ui.nbinhabitants", "" + nbInhabitants)));
            GuiButtonProject firstButton = null;
            GuiButtonProject secondButton = null;
            if (project.location.level < project.planSet.plans.get(project.location.getVariation()).length - 1 && project.planSet.plans.get(project.location.getVariation()).length > 1) {
                firstButton = project.location.upgradesAllowed ? new GuiButtonProject(project, 2, MLN.string("ui.forbidupgrades")) : new GuiButtonProject(project, 1, MLN.string("ui.allowupgrades"));
            }
            if (project.location == null || project.location.getBuilding(this.townHall.worldObj) != null && project.location.getBuilding((World)this.townHall.worldObj).isTownhall) {
                canForget = false;
            } else {
                boolean bl = canForget = nbInhabitants == 0;
            }
            if (canForget) {
                secondButton = new GuiButtonProject(project, 3, MLN.string("ui.cancelbuilding"));
            }
            text.add(new GuiText.Line(firstButton, secondButton));
            text.add(new GuiText.Line(false));
            text.add(new GuiText.Line());
            text.add(new GuiText.Line());
        }
        ArrayList<List<GuiText.Line>> pages = new ArrayList<List<GuiText.Line>>();
        pages.add(text);
        this.descText = this.adjustText(pages);
        this.buttonPagination();
    }

    @Override
    public int getLineSizeInPx() {
        return 195;
    }

    @Override
    public int getPageSize() {
        return 19;
    }

    @Override
    public ResourceLocation getPNGPath() {
        return this.background;
    }

    @Override
    public int getXSize() {
        return 204;
    }

    @Override
    public int getYSize() {
        return 220;
    }

    @Override
    public void initData() {
        this.fillData();
    }

    public static class GuiButtonProject
    extends GuiText.MillGuiButton {
        public static final int ALLOW_UPGRADES = 1;
        public static final int FORBID_UPGRADES = 2;
        public static final int CANCEL_BUILDING = 3;
        public BuildingProject project;

        public GuiButtonProject(BuildingProject project, int i, String s) {
            super(i, 0, 0, 0, 0, s);
            this.project = project;
        }
    }
}

