/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.client.gui;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import org.millenaire.common.MLN;

public abstract class GuiText
extends GuiScreen {
    public static final String WHITE = "<white>";
    public static final String YELLOW = "<yellow>";
    public static final String PINK = "<pink>";
    public static final String LIGHTRED = "<lightred>";
    public static final String CYAN = "<cyan>";
    public static final String LIGHTGREEN = "<lightgreen>";
    public static final String BLUE = "<blue>";
    public static final String DARKGREY = "<darkgrey>";
    public static final String LIGHTGREY = "<lightgrey>";
    public static final String ORANGE = "<orange>";
    public static final String PURPLE = "<purple>";
    public static final String DARKRED = "<darkred>";
    public static final String LIGHTBLUE = "<lightblue>";
    public static final String DARKGREEN = "<darkgreen>";
    public static final String DARKBLUE = "<darkblue>";
    public static final String BLACK = "<black>";
    public static final String LINE_HELP_GUI_BUTTON = "<help_gui_button>";
    public static final String LINE_CHUNK_GUI_BUTTON = "<chunk_gui_button>";
    public static final String LINE_CONFIG_GUI_BUTTON = "<config_gui_button>";
    protected int pageNum = 0;
    protected List<List<Line>> descText = null;
    List<MillGuiTextField> textFields = new ArrayList<MillGuiTextField>();
    protected static RenderItem itemRenderer = new RenderItem();

    public List<List<Line>> adjustText(List<List<Line>> baseText) {
        ArrayList<List<Line>> text = new ArrayList<List<Line>>();
        for (List<Line> page : baseText) {
            ArrayList<Line> newPage = new ArrayList<Line>();
            for (Line line : page) {
                if (line.buttons != null || line.textField != null) {
                    newPage.add(line);
                    continue;
                }
                for (String l : line.text.split("<ret>")) {
                    int lineSize = this.getLineSizeInPx() - line.margin;
                    int lineSizeInChar = this.getLineWidthInChars(lineSize);
                    int lnpos = 0;
                    while (this.field_146289_q.func_78256_a(l) > lineSize) {
                        int end = l.lastIndexOf(32, lineSizeInChar);
                        if (end < 1) {
                            end = lineSizeInChar;
                        }
                        if (end >= l.length()) {
                            end = l.length() / 2;
                        }
                        String subLine = l.substring(0, end);
                        l = l.substring(subLine.length()).trim();
                        int colPos = subLine.lastIndexOf(167);
                        if (colPos > -1) {
                            l = subLine.substring(colPos, colPos + 2) + l;
                        }
                        newPage.add(new Line(subLine, line, lnpos));
                        ++lnpos;
                    }
                    newPage.add(new Line(l, line, lnpos));
                    ++lnpos;
                    if (line.icons == null) continue;
                    for (int i = lnpos; i < line.icons.size() / 2; ++i) {
                        newPage.add(new Line("", line, i));
                    }
                }
            }
            while (newPage.size() > this.getPageSize()) {
                int i;
                List<Line> newPage2 = new ArrayList<Line>();
                int nblinetaken = 0;
                for (i = 0; i < this.getPageSize(); ++i) {
                    int blockSize = -1;
                    for (int j = i; j < newPage.size() && blockSize == -1; ++j) {
                        if (!((Line)newPage.get((int)j)).canCutAfter) continue;
                        blockSize = j - i;
                    }
                    if (blockSize == -1) {
                        blockSize = newPage.size() - i;
                    }
                    if (i + blockSize > this.getPageSize()) break;
                    newPage2.add((Line)newPage.get(i));
                    ++nblinetaken;
                }
                for (i = 0; i < nblinetaken; ++i) {
                    newPage.remove(0);
                }
                if ((newPage2 = this.clearEmptyLines(newPage2)) == null) continue;
                text.add(newPage2);
            }
            List<Line> adjustedPage = this.clearEmptyLines(newPage);
            if (adjustedPage == null) continue;
            text.add(adjustedPage);
        }
        return text;
    }

    public void buttonPagination() {
        try {
            if (this.descText == null) {
                return;
            }
            int xStart = (this.field_146294_l - this.getXSize()) / 2;
            int yStart = (this.field_146295_m - this.getYSize()) / 2;
            this.field_146292_n.clear();
            this.textFields.clear();
            int vpos = 6;
            if (this.pageNum < this.descText.size()) {
                for (int cp = 0; cp < this.getPageSize() && cp < this.descText.get(this.pageNum).size(); ++cp) {
                    Line line = this.descText.get(this.pageNum).get(cp);
                    if (line.buttons != null) {
                        if (line.buttons.length == 1) {
                            if (line.buttons[0] != null) {
                                line.buttons[0].field_146128_h = xStart + this.getXSize() / 2 - 100;
                                line.buttons[0].setWidth(200);
                            }
                        } else if (line.buttons.length == 2) {
                            if (line.buttons[0] != null) {
                                line.buttons[0].field_146128_h = xStart + this.getXSize() / 2 - 100;
                                line.buttons[0].setWidth(95);
                            }
                            if (line.buttons[1] != null) {
                                line.buttons[1].field_146128_h = xStart + this.getXSize() / 2 + 5;
                                line.buttons[1].setWidth(95);
                            }
                        } else if (line.buttons.length == 3) {
                            if (line.buttons[0] != null) {
                                line.buttons[0].field_146128_h = xStart + this.getXSize() / 2 - 100;
                                line.buttons[0].setWidth(60);
                            }
                            if (line.buttons[1] != null) {
                                line.buttons[1].field_146128_h = xStart + this.getXSize() / 2 - 30;
                                line.buttons[1].setWidth(60);
                            }
                            if (line.buttons[2] != null) {
                                line.buttons[2].field_146128_h = xStart + this.getXSize() / 2 + 40;
                                line.buttons[2].setWidth(60);
                            }
                        }
                        for (int i = 0; i < line.buttons.length; ++i) {
                            if (line.buttons[i] == null) continue;
                            line.buttons[i].field_146129_i = yStart + vpos;
                            line.buttons[i].setHeight(20);
                            this.field_146292_n.add(line.buttons[i]);
                        }
                    } else if (line.textField != null) {
                        MillGuiTextField textField = new MillGuiTextField(this.field_146289_q, xStart + this.getXSize() / 2 + 40, yStart + vpos, 95, 20, line.textField.fieldKey);
                        textField.func_146180_a(line.textField.func_146179_b());
                        textField.func_146203_f(line.textField.func_146208_g());
                        textField.func_146193_g(-1);
                        line.textField = textField;
                        line.textField.func_146193_g(-1);
                        line.textField.func_146185_a(false);
                        this.textFields.add(textField);
                    }
                    vpos += 10;
                }
            }
        }
        catch (Exception e) {
            MLN.printException("Exception while doing button pagination in GUI " + (Object)((Object)this), e);
        }
    }

    private List<Line> clearEmptyLines(List<Line> page) {
        ArrayList<Line> clearedPage = new ArrayList<Line>();
        boolean nonEmptyLine = false;
        for (Line line : page) {
            if (!line.empty()) {
                clearedPage.add(line);
                nonEmptyLine = true;
                continue;
            }
            if (!nonEmptyLine) continue;
            clearedPage.add(line);
        }
        if (clearedPage.size() > 0) {
            return clearedPage;
        }
        return null;
    }

    protected void closeWindow() {
        this.field_146297_k.func_147108_a(null);
        this.field_146297_k.func_71381_h();
    }

    public List<List<Line>> convertAdjustText(List<List<String>> baseText) {
        ArrayList<List<Line>> text = new ArrayList<List<Line>>();
        for (List<String> page : baseText) {
            ArrayList<Line> newPage = new ArrayList<Line>();
            for (String s : page) {
                if (s.equals(LINE_HELP_GUI_BUTTON)) {
                    newPage.add(new Line(new MillGuiButton(2000, 0, 0, 0, 0, MLN.string("ui.helpbutton"))));
                    continue;
                }
                if (s.equals(LINE_CHUNK_GUI_BUTTON)) {
                    newPage.add(new Line(new MillGuiButton(3000, 0, 0, 0, 0, MLN.string("ui.chunkbutton"))));
                    continue;
                }
                if (s.equals(LINE_CONFIG_GUI_BUTTON)) {
                    newPage.add(new Line(new MillGuiButton(4000, 0, 0, 0, 0, MLN.string("ui.configbutton"))));
                    continue;
                }
                newPage.add(new Line(s, true));
            }
            text.add(newPage);
        }
        return this.adjustText(text);
    }

    protected abstract void customDrawBackground(int var1, int var2, float var3);

    protected abstract void customDrawScreen(int var1, int var2, float var3);

    public void decrementPage() {
        if (this.descText == null) {
            return;
        }
        if (this.pageNum > 0) {
            --this.pageNum;
        }
        this.buttonPagination();
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void drawHoveringText(List par1List, int par2, int par3, FontRenderer font) {
        if (!par1List.isEmpty()) {
            GL11.glDisable((int)32826);
            RenderHelper.func_74518_a();
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            int k = 0;
            for (String s : par1List) {
                int l = font.func_78256_a(s);
                if (l <= k) continue;
                k = l;
            }
            int i1 = par2 + 12;
            int j1 = par3 - 12;
            int k1 = 8;
            if (par1List.size() > 1) {
                k1 += 2 + (par1List.size() - 1) * 10;
            }
            if (i1 + k > this.field_146294_l) {
                i1 -= 28 + k;
            }
            if (j1 + k1 + 6 > this.field_146295_m) {
                j1 = this.field_146295_m - k1 - 6;
            }
            this.field_73735_i = 300.0f;
            GuiText.itemRenderer.field_77023_b = 300.0f;
            int l1 = -267386864;
            this.func_73733_a(i1 - 3, j1 - 4, i1 + k + 3, j1 - 3, -267386864, -267386864);
            this.func_73733_a(i1 - 3, j1 + k1 + 3, i1 + k + 3, j1 + k1 + 4, -267386864, -267386864);
            this.func_73733_a(i1 - 3, j1 - 3, i1 + k + 3, j1 + k1 + 3, -267386864, -267386864);
            this.func_73733_a(i1 - 4, j1 - 3, i1 - 3, j1 + k1 + 3, -267386864, -267386864);
            this.func_73733_a(i1 + k + 3, j1 - 3, i1 + k + 4, j1 + k1 + 3, -267386864, -267386864);
            int i2 = 0x505000FF;
            int j2 = 1344798847;
            this.func_73733_a(i1 - 3, j1 - 3 + 1, i1 - 3 + 1, j1 + k1 + 3 - 1, 0x505000FF, 1344798847);
            this.func_73733_a(i1 + k + 2, j1 - 3 + 1, i1 + k + 3, j1 + k1 + 3 - 1, 0x505000FF, 1344798847);
            this.func_73733_a(i1 - 3, j1 - 3, i1 + k + 3, j1 - 3 + 1, 0x505000FF, 0x505000FF);
            this.func_73733_a(i1 - 3, j1 + k1 + 2, i1 + k + 3, j1 + k1 + 3, 1344798847, 1344798847);
            for (int k2 = 0; k2 < par1List.size(); ++k2) {
                String s1 = (String)par1List.get(k2);
                font.func_78261_a(s1, i1, j1, -1);
                if (k2 == 0) {
                    j1 += 2;
                }
                j1 += 10;
            }
            this.field_73735_i = 0.0f;
            GuiText.itemRenderer.field_77023_b = 0.0f;
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
            RenderHelper.func_74519_b();
            GL11.glEnable((int)32826);
        }
    }

    protected void drawItemStackTooltip(ItemStack par1ItemStack, int par2, int par3, String extraLegend) {
        List list = par1ItemStack.func_82840_a((EntityPlayer)this.field_146297_k.field_71439_g, this.field_146297_k.field_71474_y.field_82882_x);
        if (extraLegend != null) {
            list.add(extraLegend);
        }
        for (int k = 0; k < list.size(); ++k) {
            if (k == 0) {
                list.set(k, par1ItemStack.func_77953_t().field_77937_e + (String)list.get(k));
                continue;
            }
            list.set(k, EnumChatFormatting.GRAY + (String)list.get(k));
        }
        FontRenderer font = par1ItemStack.func_77973_b().getFontRenderer(par1ItemStack);
        this.drawHoveringText(list, par2, par3, font == null ? this.field_146289_q : font);
    }

    public void func_73863_a(int i, int j, float f) {
        try {
            this.func_146276_q_();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146297_k.field_71446_o.func_110577_a(this.getPNGPath());
            int xStart = (this.field_146294_l - this.getXSize()) / 2;
            int yStart = (this.field_146295_m - this.getYSize()) / 2;
            this.func_73729_b(xStart, yStart, 0, 0, this.getXSize(), this.getYSize());
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.customDrawBackground(i, j, f);
            GL11.glPushMatrix();
            GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            RenderHelper.func_74519_b();
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glTranslatef((float)xStart, (float)yStart, (float)0.0f);
            RenderHelper.func_74518_a();
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            if (this.descText != null) {
                int vpos = 6;
                if (this.pageNum < this.descText.size()) {
                    if (this.descText.get(this.pageNum) == null) {
                        MLN.printException(new MLN.MillenaireException("descText.get(pageNum)==null for pageNum: " + this.pageNum + " in GUI: " + (Object)((Object)this)));
                    }
                    for (int cp = 0; cp < this.getPageSize() && cp < this.descText.get(this.pageNum).size(); ++cp) {
                        if (this.descText.get((int)this.pageNum).get((int)cp).shadow) {
                            this.field_146289_q.func_78261_a(this.descText.get((int)this.pageNum).get((int)cp).text, this.getTextXStart() + this.descText.get((int)this.pageNum).get((int)cp).margin, vpos, 0x101010);
                        } else {
                            this.field_146289_q.func_78276_b(this.descText.get((int)this.pageNum).get((int)cp).text, this.getTextXStart() + this.descText.get((int)this.pageNum).get((int)cp).margin, vpos, 0x101010);
                        }
                        vpos += 10;
                    }
                }
                this.field_146289_q.func_78276_b(this.pageNum + 1 + "/" + this.getNbPage(), this.getXSize() / 2 - 10, this.getYSize() - 10, 0x101010);
                vpos = 6;
                this.field_73735_i = 100.0f;
                GuiText.itemRenderer.field_77023_b = 100.0f;
                ItemStack hoverIcon = null;
                String extraLegend = null;
                if (this.pageNum < this.descText.size()) {
                    for (int cp = 0; cp < this.getPageSize() && cp < this.descText.get(this.pageNum).size(); ++cp) {
                        if (this.descText.get((int)this.pageNum).get((int)cp).icons != null) {
                            for (int ic = 0; ic < this.descText.get((int)this.pageNum).get((int)cp).icons.size(); ++ic) {
                                ItemStack icon = this.descText.get((int)this.pageNum).get((int)cp).icons.get(ic);
                                if (this.descText.get((int)this.pageNum).get((int)cp).iconExtraLegends == null) {
                                    MLN.error(null, "Null legends!");
                                }
                                String legend = this.descText.get((int)this.pageNum).get((int)cp).iconExtraLegends.get(ic);
                                GL11.glEnable((int)2929);
                                itemRenderer.func_82406_b(this.field_146289_q, this.field_146297_k.field_71446_o, icon, this.getTextXStart() + 18 * ic, vpos);
                                itemRenderer.func_94148_a(this.field_146289_q, this.field_146297_k.field_71446_o, icon, this.getTextXStart() + 18 * ic, vpos, null);
                                if (xStart + this.getTextXStart() + 18 * ic >= i || yStart + vpos >= j || xStart + this.getTextXStart() + 18 * ic + 16 <= i || yStart + vpos + 16 <= j) continue;
                                hoverIcon = icon;
                                extraLegend = legend;
                            }
                        }
                        vpos += 10;
                    }
                }
                if (hoverIcon != null) {
                    this.drawItemStackTooltip(hoverIcon, i - xStart, j - yStart, extraLegend);
                }
                GuiText.itemRenderer.field_77023_b = 0.0f;
                this.field_73735_i = 0.0f;
                this.customDrawScreen(i, j, f);
            }
            GL11.glPopMatrix();
            super.func_73863_a(i, j, f);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
            GL11.glDisable((int)2896);
            for (MillGuiTextField textField : this.textFields) {
                textField.func_146194_f();
            }
        }
        catch (Exception e) {
            MLN.printException("Exception in drawScreen of GUI: " + (Object)((Object)this), e);
        }
    }

    public abstract int getLineSizeInPx();

    private int getLineWidthInChars(int lineWidthInPx) {
        String testLine = "a";
        while (this.field_146289_q.func_78256_a(testLine) < lineWidthInPx) {
            testLine = testLine + "a";
        }
        return testLine.length() - 1;
    }

    protected int getNbPage() {
        return this.descText.size();
    }

    public abstract int getPageSize();

    public abstract ResourceLocation getPNGPath();

    public int getTextXStart() {
        return 8;
    }

    public abstract int getXSize();

    public abstract int getYSize();

    protected void handleTextFieldPress(MillGuiTextField textField) {
    }

    public void incrementPage() {
        if (this.descText == null) {
            return;
        }
        if (this.pageNum < this.getNbPage() - 1) {
            ++this.pageNum;
        }
        this.buttonPagination();
    }

    public abstract void initData();

    public void func_73866_w_() {
        super.func_73866_w_();
        this.initData();
        this.buttonPagination();
    }

    protected void func_73869_a(char c, int i) {
        boolean keyTyped = false;
        for (MillGuiTextField textField : this.textFields) {
            if (!textField.func_146201_a(c, i)) continue;
            keyTyped = true;
            this.handleTextFieldPress(textField);
        }
        if (!keyTyped && i == 1) {
            this.field_146297_k.func_147108_a(null);
            this.field_146297_k.func_71381_h();
        }
    }

    protected void func_73864_a(int i, int j, int k) {
        int xStart = (this.field_146294_l - this.getXSize()) / 2;
        int yStart = (this.field_146295_m - this.getYSize()) / 2;
        int ai = i - xStart;
        int aj = j - yStart;
        if (aj > this.getYSize() - 14 && aj < this.getYSize()) {
            if (ai > 0 && ai < 33) {
                this.decrementPage();
            } else if (ai > this.getXSize() - 33 && ai < this.getXSize()) {
                this.incrementPage();
            }
        }
        for (MillGuiTextField textField : this.textFields) {
            textField.func_146192_a(i, j, k);
        }
        super.func_73864_a(i, j, k);
    }

    public static class MillGuiTextField
    extends GuiTextField {
        public final String fieldKey;

        public MillGuiTextField(FontRenderer par1FontRenderer, int par2, int par3, int par4, int par5, String fieldKey) {
            super(par1FontRenderer, par2, par3, par4, par5);
            this.fieldKey = fieldKey;
        }
    }

    public static class MillGuiButton
    extends GuiButton {
        public static final int HELPBUTTON = 2000;
        public static final int CHUNKBUTTON = 3000;
        public static final int CONFIGBUTTON = 4000;

        public MillGuiButton(int par1, int par2, int par3, int par4, int par5, String par6Str) {
            super(par1, par2, par3, par4, par5, par6Str);
        }

        public MillGuiButton(String label, int id) {
            super(id, 0, 0, 0, 0, label);
        }

        public int getHeight() {
            return this.field_146121_g;
        }

        public int getWidth() {
            return this.field_146120_f;
        }

        public void setHeight(int h) {
            this.field_146121_g = h;
        }

        public void setWidth(int w) {
            this.field_146120_f = w;
        }
    }

    public static class Line {
        String text = "";
        MillGuiButton[] buttons = null;
        MillGuiTextField textField = null;
        List<ItemStack> icons = null;
        List<String> iconExtraLegends = null;
        boolean canCutAfter = true;
        boolean shadow = false;
        int margin = 0;

        public Line() {
        }

        public Line(boolean canCutAfter) {
            this.canCutAfter = canCutAfter;
        }

        public Line(List<ItemStack> icons, List<String> iconExtraLegends, String s, int margin) {
            this.icons = icons;
            this.iconExtraLegends = iconExtraLegends;
            if (icons != null && iconExtraLegends == null) {
                MLN.printException("iconExtraLegends is null but icons isn't.", new Exception());
            } else if (icons != null && iconExtraLegends != null && icons.size() != iconExtraLegends.size()) {
                MLN.printException("iconExtraLegends has a size of " + iconExtraLegends.size() + " but icons has a size of " + icons.size(), new Exception());
            }
            this.text = s;
            this.canCutAfter = false;
            this.margin = margin;
        }

        public Line(MillGuiButton b) {
            this.buttons = new MillGuiButton[]{b};
            this.canCutAfter = false;
        }

        public Line(MillGuiButton b, MillGuiButton b2) {
            this.buttons = new MillGuiButton[]{b, b2};
            this.canCutAfter = false;
        }

        public Line(MillGuiButton b, MillGuiButton b2, MillGuiButton b3) {
            this.buttons = new MillGuiButton[]{b, b2, b3};
            this.canCutAfter = false;
        }

        public Line(MillGuiTextField tf) {
            this.textField = tf;
        }

        public Line(String s) {
            if (s == null) {
                this.text = "";
            } else {
                this.text = s;
                this.interpretTags();
            }
        }

        public Line(String s, boolean canCutAfter) {
            if (s == null) {
                this.text = "";
            } else {
                this.text = s;
                this.interpretTags();
            }
            this.canCutAfter = canCutAfter;
        }

        public Line(String s, Line model, int lnpos) {
            if (model.icons != null && lnpos % 2 == 0) {
                int lnicon = lnpos / 2;
                this.icons = new ArrayList<ItemStack>();
                this.iconExtraLegends = new ArrayList<String>();
                for (int i = lnicon * 4; i < model.icons.size() && i < (lnicon + 1) * 4; ++i) {
                    this.icons.add(model.icons.get(i));
                    this.iconExtraLegends.add(model.iconExtraLegends.get(i));
                }
            }
            if (s == null) {
                this.text = "";
            } else {
                this.text = s;
                this.interpretTags();
            }
            this.canCutAfter = model.canCutAfter;
            this.shadow = model.shadow;
            this.margin = model.margin;
        }

        public Line(String s, MillGuiTextField tf) {
            this.textField = tf;
            if (s == null) {
                this.text = "";
            } else {
                this.text = s;
                this.interpretTags();
            }
        }

        public boolean empty() {
            return (this.text == null || this.text.length() == 0) && this.buttons == null && this.textField == null;
        }

        private void interpretTags() {
            if (this.text.startsWith("<shadow>")) {
                this.shadow = true;
                this.text = this.text.replaceAll("<shadow>", "");
            }
            this.text = this.text.replaceAll(GuiText.BLACK, "\u00a70");
            this.text = this.text.replaceAll(GuiText.DARKBLUE, "\u00a71");
            this.text = this.text.replaceAll(GuiText.DARKGREEN, "\u00a72");
            this.text = this.text.replaceAll(GuiText.LIGHTBLUE, "\u00a73");
            this.text = this.text.replaceAll(GuiText.DARKRED, "\u00a74");
            this.text = this.text.replaceAll(GuiText.PURPLE, "\u00a75");
            this.text = this.text.replaceAll(GuiText.ORANGE, "\u00a76");
            this.text = this.text.replaceAll(GuiText.LIGHTGREY, "\u00a77");
            this.text = this.text.replaceAll(GuiText.DARKGREY, "\u00a78");
            this.text = this.text.replaceAll(GuiText.BLUE, "\u00a79");
            this.text = this.text.replaceAll(GuiText.LIGHTGREEN, "\u00a7a");
            this.text = this.text.replaceAll(GuiText.CYAN, "\u00a7b");
            this.text = this.text.replaceAll(GuiText.LIGHTRED, "\u00a7c");
            this.text = this.text.replaceAll(GuiText.PINK, "\u00a7d");
            this.text = this.text.replaceAll(GuiText.YELLOW, "\u00a7e");
            this.text = this.text.replaceAll(GuiText.WHITE, "\u00a7f");
        }
    }
}

