/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common;

import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import org.millenaire.common.MLN;
import org.millenaire.common.MillVillager;
import org.millenaire.common.building.Building;
import org.millenaire.common.core.MillCommonUtilities;
import org.millenaire.common.forge.Mill;
import org.millenaire.common.item.Goods;

public class ContainerTrade
extends Container {
    private Building building;
    private MillVillager merchant;
    public int nbRowSelling = 0;
    public int nbRowBuying = 0;

    public ContainerTrade(EntityPlayer player, Building building) {
        this.building = building;
        Set<Goods> sellingGoods = building.getSellingGoods(player);
        int slotnb = 0;
        if (sellingGoods != null) {
            for (Goods g : sellingGoods) {
                int slotrow = slotnb / 13;
                this.func_75146_a(new TradeSlot(building, player, true, g, 8 + 18 * (slotnb - 13 * slotrow), 32 + slotrow * 18));
                ++slotnb;
            }
        }
        this.nbRowSelling = slotnb / 13 + 1;
        Set<Goods> buyingGoods = building.getBuyingGoods(player);
        slotnb = 0;
        if (buyingGoods != null) {
            for (Goods g : buyingGoods) {
                int slotrow = slotnb / 13;
                this.func_75146_a(new TradeSlot(building, player, false, g, 8 + 18 * (slotnb - 13 * slotrow), 86 + slotrow * 18));
                ++slotnb;
            }
        }
        this.nbRowBuying = slotnb / 13 + 1;
        for (int l = 0; l < 3; ++l) {
            for (int k1 = 0; k1 < 9; ++k1) {
                this.func_75146_a(new Slot((IInventory)player.field_71071_by, k1 + l * 9 + 9, 8 + k1 * 18 + 36, 103 + l * 18 + 37));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.func_75146_a(new Slot((IInventory)player.field_71071_by, i1, 8 + i1 * 18 + 36, 198));
        }
    }

    public ContainerTrade(EntityPlayer player, MillVillager merchant) {
        this.merchant = merchant;
        int slotnb = 0;
        Set<Goods> sellingGoods = merchant.merchantSells.keySet();
        if (sellingGoods != null) {
            for (Goods g : sellingGoods) {
                int slotrow = slotnb / 13;
                this.func_75146_a(new MerchantSlot(merchant, player, g, 8 + 18 * (slotnb - 13 * slotrow), 32 + slotrow * 18));
                ++slotnb;
            }
        }
        this.nbRowSelling = slotnb / 13 + 1;
        for (int l = 0; l < 3; ++l) {
            for (int k1 = 0; k1 < 9; ++k1) {
                this.func_75146_a(new Slot((IInventory)player.field_71071_by, k1 + l * 9 + 9, 8 + k1 * 18 + 36, 103 + l * 18 + 37));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.func_75146_a(new Slot((IInventory)player.field_71071_by, i1, 8 + i1 * 18 + 36, 198));
        }
    }

    public boolean func_75145_c(EntityPlayer entityplayer) {
        return true;
    }

    public boolean isUsableByPlayer(EntityPlayer entityplayer) {
        return true;
    }

    public ItemStack func_75144_a(int slotNb, int buttonNumber, int shiftPressed, EntityPlayer player) {
        if (slotNb >= 0 && slotNb < this.field_75151_b.size()) {
            Slot slot = (Slot)this.field_75151_b.get(slotNb);
            if (slot != null && slot instanceof TradeSlot) {
                TradeSlot tslot = (TradeSlot)slot;
                Goods good = tslot.good;
                int nbItems = 1;
                if (shiftPressed > 0) {
                    nbItems = 64;
                } else if (buttonNumber == 1) {
                    nbItems = 8;
                }
                if (tslot.isProblem() == null) {
                    int playerMoney = MillCommonUtilities.countMoney((IInventory)player.field_71071_by);
                    if (tslot.sellingSlot) {
                        if (playerMoney < good.getCalculatedSellingPrice(this.building, player) * nbItems) {
                            nbItems = MathHelper.func_76128_c((double)(playerMoney / good.getCalculatedSellingPrice(this.building, player)));
                        }
                        if (!good.autoGenerate && this.building.countGoods(good.item.getItem(), good.item.meta) < nbItems) {
                            nbItems = this.building.countGoods(good.item.getItem(), good.item.meta);
                        }
                        nbItems = MillCommonUtilities.putItemsInChest((IInventory)player.field_71071_by, good.item.getItem(), good.item.meta, nbItems);
                        MillCommonUtilities.changeMoney((IInventory)player.field_71071_by, -good.getCalculatedSellingPrice(this.building, player) * nbItems, player);
                        if (!good.autoGenerate) {
                            this.building.takeGoods(good.item.getItem(), good.item.meta, nbItems);
                        }
                        this.building.adjustReputation(player, good.getCalculatedSellingPrice(this.building, player) * nbItems);
                        this.building.getTownHall().adjustLanguage(player, nbItems);
                    } else {
                        if (MillCommonUtilities.countChestItems((IInventory)player.field_71071_by, good.item.getItem(), good.item.meta) < nbItems) {
                            nbItems = MillCommonUtilities.countChestItems((IInventory)player.field_71071_by, good.item.getItem(), good.item.meta);
                        }
                        nbItems = this.building.storeGoods(good.item.getItem(), good.item.meta, nbItems);
                        MillCommonUtilities.getItemsFromChest((IInventory)player.field_71071_by, good.item.getItem(), good.item.meta, nbItems);
                        MillCommonUtilities.changeMoney((IInventory)player.field_71071_by, good.getCalculatedBuyingPrice(this.building, player) * nbItems, player);
                        this.building.adjustReputation(player, good.getCalculatedBuyingPrice(this.building, player) * nbItems);
                        this.building.getTownHall().adjustLanguage(player, nbItems);
                    }
                }
                return slot.func_75211_c();
            }
            if (slot != null && slot instanceof MerchantSlot) {
                MerchantSlot tslot = (MerchantSlot)slot;
                int nbItems = 1;
                if (shiftPressed > 0) {
                    nbItems = 64;
                } else if (buttonNumber == 1) {
                    nbItems = 8;
                }
                if (tslot.isProblem() == null) {
                    int playerMoney = MillCommonUtilities.countMoney((IInventory)player.field_71071_by);
                    if (playerMoney < tslot.good.getCalculatedSellingPrice(this.merchant) * nbItems) {
                        nbItems = MathHelper.func_76128_c((double)(playerMoney / tslot.good.getCalculatedSellingPrice(this.merchant)));
                    }
                    if (this.merchant.getHouse().countGoods(tslot.good.item) < nbItems) {
                        nbItems = this.merchant.getHouse().countGoods(tslot.good.item);
                    }
                    nbItems = MillCommonUtilities.putItemsInChest((IInventory)player.field_71071_by, tslot.good.item.getItem(), tslot.good.item.meta, nbItems);
                    MillCommonUtilities.changeMoney((IInventory)player.field_71071_by, -tslot.good.getCalculatedSellingPrice(this.merchant) * nbItems, player);
                    this.merchant.getHouse().takeGoods(tslot.good.item, nbItems);
                    Mill.getMillWorld(player.field_70170_p).getProfile(player.getDisplayName()).adjustLanguage(this.merchant.getCulture().key, nbItems);
                }
                return slot.func_75211_c();
            }
        }
        if (shiftPressed > 0) {
            return null;
        }
        return super.func_75144_a(slotNb, buttonNumber, shiftPressed, player);
    }

    public static class TradeSlot
    extends Slot {
        public final Building building;
        public final EntityPlayer player;
        public final Goods good;
        public final boolean sellingSlot;

        public TradeSlot(Building building, EntityPlayer player, boolean sellingSlot, Goods good, int xpos, int ypos) {
            super((IInventory)player.field_71071_by, -1, xpos, ypos);
            this.building = building;
            this.good = good;
            this.player = player;
            this.sellingSlot = sellingSlot;
        }

        public ItemStack func_75209_a(int i) {
            return null;
        }

        public boolean func_25014_f() {
            return false;
        }

        public IIcon func_75212_b() {
            return null;
        }

        public boolean func_75216_d() {
            return this.func_75211_c() != null;
        }

        public int func_75219_a() {
            return 0;
        }

        public ItemStack func_75211_c() {
            if (this.sellingSlot) {
                return new ItemStack(this.good.item.getItem(), Math.min(this.building.countGoods(this.good.item.getItem(), this.good.item.meta), 99), this.good.item.meta);
            }
            return new ItemStack(this.good.item.getItem(), Math.min(MillCommonUtilities.countChestItems((IInventory)this.player.field_71071_by, this.good.item.getItem(), this.good.item.meta), 99), this.good.item.meta);
        }

        public boolean func_75214_a(ItemStack itemstack) {
            return true;
        }

        public String isProblem() {
            if (this.sellingSlot) {
                if (this.building.countGoods(this.good.item.getItem(), this.good.item.meta) < 1 && this.good.requiredTag != null && !this.building.location.tags.contains(this.good.requiredTag)) {
                    return MLN.string("ui.missingequipment") + ": " + this.good.requiredTag;
                }
                if (this.building.countGoods(this.good.item.getItem(), this.good.item.meta) < 1 && !this.good.autoGenerate) {
                    return MLN.string("ui.outofstock");
                }
                if (this.building.getTownHall().getReputation(this.player.getDisplayName()) < this.good.minReputation) {
                    return MLN.string("ui.reputationneeded", this.building.culture.getReputationLevelLabel(this.good.minReputation));
                }
                int playerMoney = MillCommonUtilities.countMoney((IInventory)this.player.field_71071_by);
                if (playerMoney < this.good.getCalculatedSellingPrice(this.building, this.player)) {
                    return MLN.string("ui.missingdeniers").replace("<0>", "" + (this.good.getCalculatedSellingPrice(this.building, this.player) - playerMoney));
                }
            } else if (MillCommonUtilities.countChestItems((IInventory)this.player.field_71071_by, this.good.item.getItem(), this.good.item.meta) == 0) {
                return MLN.string("ui.noneininventory");
            }
            return null;
        }

        public void func_75218_e() {
        }

        public void func_75215_d(ItemStack itemstack) {
        }

        public String toString() {
            return this.good.name + (this.sellingSlot ? MLN.string("ui.selling") : MLN.string("ui.buying"));
        }
    }

    public static class MerchantSlot
    extends Slot {
        public MillVillager merchant;
        public EntityPlayer player;
        public final Goods good;

        public MerchantSlot(MillVillager merchant, EntityPlayer player, Goods good, int xpos, int ypos) {
            super(null, -1, xpos, ypos);
            this.merchant = merchant;
            this.good = good;
            this.player = player;
        }

        public ItemStack func_75209_a(int i) {
            return null;
        }

        public boolean func_25014_f() {
            return false;
        }

        public IIcon func_75212_b() {
            return null;
        }

        public boolean func_75216_d() {
            return this.func_75211_c() != null;
        }

        public int func_75219_a() {
            return 0;
        }

        public ItemStack func_75211_c() {
            return new ItemStack(this.good.item.getItem(), Math.min(this.merchant.getHouse().countGoods(this.good.item), 99), this.good.item.meta);
        }

        public boolean func_75214_a(ItemStack itemstack) {
            return true;
        }

        public String isProblem() {
            if (this.merchant.getHouse().countGoods(this.good.item) < 1) {
                return MLN.string("ui.outofstock");
            }
            int playerMoney = MillCommonUtilities.countMoney((IInventory)this.player.field_71071_by);
            if (this.merchant.getCulture().goodsByItem.containsKey(this.good.item)) {
                if (playerMoney < this.good.getCalculatedSellingPrice(this.merchant)) {
                    return MLN.string("ui.missingdeniers").replace("<0>", "" + (this.good.getCalculatedSellingPrice(this.merchant) - playerMoney));
                }
            } else {
                MLN.error(null, "Unknown trade good: " + this.good);
            }
            return null;
        }

        public void func_75218_e() {
        }

        public void func_75215_d(ItemStack itemstack) {
        }

        public String toString() {
            return this.good.getName();
        }
    }
}

