/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common;

import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.world.World;
import org.millenaire.common.Culture;
import org.millenaire.common.MLN;
import org.millenaire.common.MillVillager;
import org.millenaire.common.MillWorld;
import org.millenaire.common.Point;
import org.millenaire.common.Quest;
import org.millenaire.common.UserProfile;
import org.millenaire.common.VillageType;
import org.millenaire.common.VillagerRecord;
import org.millenaire.common.WorldGenVillage;
import org.millenaire.common.building.Building;
import org.millenaire.common.building.BuildingCustomPlan;
import org.millenaire.common.building.BuildingPlan;
import org.millenaire.common.building.BuildingPlanSet;
import org.millenaire.common.building.BuildingProject;
import org.millenaire.common.core.MillCommonUtilities;
import org.millenaire.common.forge.Mill;
import org.millenaire.common.forge.MillAchievements;
import org.millenaire.common.network.ServerSender;

public class GuiActions {
    public static final int VILLAGE_SCROLL_PRICE = 128;
    public static final int VILLAGE_SCROLL_REPUTATION = 8192;
    public static final int CROP_REPUTATION = 8192;
    public static final int CROP_PRICE = 512;
    public static final int CULTURE_CONTROL_REPUTATION = 131072;

    public static void activateMillChest(EntityPlayer player, Point p) {
        MillWorld mw;
        World world = player.field_70170_p;
        if (MLN.DEV && (mw = Mill.getMillWorld(world)).buildingExists(p)) {
            Building ent = mw.getBuilding(p);
            if (player.field_71071_by.func_70448_g() != null && player.field_71071_by.func_70448_g().func_77973_b() == Item.func_150898_a((Block)Blocks.field_150354_m)) {
                ent.testModeGoods();
                return;
            }
            if (player.field_71071_by.func_70448_g() != null && player.field_71071_by.func_70448_g().func_77973_b() == Item.func_150898_a((Block)Mill.path)) {
                ent.clearOldPaths();
                ent.constructCalculatedPaths();
                return;
            }
            if (player.field_71071_by.func_70448_g() != null && player.field_71071_by.func_70448_g().func_77973_b() == Item.func_150898_a((Block)Mill.pathSlab)) {
                ent.recalculatePaths(true);
                return;
            }
            if (player.field_71071_by.func_70448_g() != null && player.field_71071_by.func_70448_g().func_77973_b() == Mill.denier_or) {
                ent.displayInfos(player);
                return;
            }
            if (player.field_71071_by.func_70448_g() != null && player.field_71071_by.func_70448_g().func_77973_b() == Items.field_151069_bo) {
                mw.setGlobalTag("alchemy");
                MLN.major(mw, "Set alchemy tag.");
                return;
            }
            if (player.field_71071_by.func_70448_g() != null && player.field_71071_by.func_70448_g().func_77973_b() == Mill.summoningWand) {
                ent.displayInfos(player);
                try {
                    if (ent.isTownhall) {
                        ent.rushBuilding();
                    }
                    if (ent.isInn) {
                        ent.attemptMerchantMove(true);
                    }
                    if (ent.isMarket) {
                        ent.updateMarket(true);
                    }
                }
                catch (MLN.MillenaireException e) {
                    MLN.printException(e);
                }
                return;
            }
        }
        ServerSender.displayMillChest(player, p);
    }

    public static void controlledBuildingsForgetBuilding(EntityPlayer player, Building townHall, BuildingProject project) {
        townHall.cancelBuilding(project.location);
    }

    public static void controlledBuildingsToggleUpgrades(EntityPlayer player, Building townHall, BuildingProject project, boolean allow) {
        project.location.upgradesAllowed = allow;
        if (allow) {
            townHall.noProjectsLeft = false;
        }
    }

    public static void controlledMilitaryCancelRaid(EntityPlayer player, Building townHall) {
        if (townHall.raidStart == 0L) {
            townHall.cancelRaid();
            if (!townHall.worldObj.field_72995_K) {
                townHall.sendBuildingPacket(player, false);
            }
        }
    }

    public static void controlledMilitaryDiplomacy(EntityPlayer player, Building townHall, Point target, int level) {
        townHall.adjustRelation(target, level, true);
        if (!townHall.worldObj.field_72995_K) {
            townHall.sendBuildingPacket(player, false);
        }
    }

    public static void controlledMilitaryPlanRaid(EntityPlayer player, Building townHall, Building target) {
        if (townHall.raidStart == 0L) {
            townHall.adjustRelation(target.getPos(), -100, true);
            townHall.planRaid(target);
            if (!townHall.worldObj.field_72995_K) {
                townHall.sendBuildingPacket(player, false);
            }
        }
    }

    public static void hireExtend(EntityPlayer player, MillVillager villager) {
        villager.hiredBy = player.getDisplayName();
        villager.hiredUntil += 24000L;
        MillCommonUtilities.changeMoney((IInventory)player.field_71071_by, -villager.getHireCost(player), player);
    }

    public static void hireHire(EntityPlayer player, MillVillager villager) {
        villager.hiredBy = player.getDisplayName();
        villager.hiredUntil = villager.field_70170_p.func_72820_D() + 24000L;
        VillagerRecord vr = villager.getTownHall().getVillagerRecordById(villager.villager_id);
        if (vr != null) {
            vr.awayhired = true;
        }
        player.func_71064_a((StatBase)MillAchievements.hired, 1);
        MillCommonUtilities.changeMoney((IInventory)player.field_71071_by, -villager.getHireCost(player), player);
    }

    public static void hireRelease(EntityPlayer player, MillVillager villager) {
        villager.hiredBy = null;
        villager.hiredUntil = 0L;
        VillagerRecord vr = villager.getTownHall().getVillagerRecordById(villager.villager_id);
        if (vr != null) {
            vr.awayhired = false;
        }
    }

    public static void newBuilding(EntityPlayer player, Building townHall, Point pos, String planKey) {
        BuildingPlanSet set = townHall.culture.getBuildingPlanSet(planKey);
        if (set == null) {
            return;
        }
        BuildingPlan plan = set.getRandomStartingPlan();
        BuildingPlan.LocationReturn lr = plan.testSpot(townHall.winfo, townHall.pathing, townHall.getPos(), pos.getiX() - townHall.winfo.mapStartX, pos.getiZ() - townHall.winfo.mapStartZ, MillCommonUtilities.getRandom(), -1);
        if (lr.location == null) {
            String error = null;
            error = lr.errorCode == 3 ? "ui.constructionforbidden" : (lr.errorCode == 2 ? "ui.locationclash" : (lr.errorCode == 1 ? "ui.outsideradius" : (lr.errorCode == 4 ? "ui.wrongelevation" : (lr.errorCode == 5 ? "ui.danger" : (lr.errorCode == 4 ? "ui.notreachable" : "ui.unknownerror")))));
            if (MLN.DEV) {
                MillCommonUtilities.setBlock(townHall.mw.world, lr.errorPos.getRelative(0.0, 30.0, 0.0), Blocks.field_150351_n);
            }
            ServerSender.sendTranslatedSentence(player, '6', "ui.problemat", pos.distanceDirectionShort(lr.errorPos), error);
        } else {
            lr.location.level = -1;
            BuildingProject project = new BuildingProject(set);
            project.location = lr.location;
            GuiActions.setSign(townHall, lr.location.minx, lr.location.minz, project);
            GuiActions.setSign(townHall, lr.location.maxx, lr.location.minz, project);
            GuiActions.setSign(townHall, lr.location.minx, lr.location.maxz, project);
            GuiActions.setSign(townHall, lr.location.maxx, lr.location.maxz, project);
            townHall.buildingProjects.get((Object)BuildingProject.EnumProjects.CORE).add(project);
            townHall.noProjectsLeft = false;
            ServerSender.sendTranslatedSentence(player, '2', "ui.projectadded", new String[0]);
        }
    }

    public static void newCustomBuilding(EntityPlayer player, Building townHall, Point pos, String planKey) {
        BuildingCustomPlan customBuilding = townHall.culture.getBuildingCustom(planKey);
        if (customBuilding != null) {
            try {
                townHall.addCustomBuilding(customBuilding, pos);
            }
            catch (Exception e) {
                MLN.printException("Exception when creation custom building: " + planKey, e);
            }
        }
    }

    public static void newVillageCreation(EntityPlayer player, Point pos, String cultureKey, String villageTypeKey) {
        Culture culture = Culture.getCultureByName(cultureKey);
        if (culture == null) {
            return;
        }
        VillageType villageType = culture.getVillageType(villageTypeKey);
        if (villageType == null) {
            return;
        }
        WorldGenVillage genVillage = new WorldGenVillage();
        boolean result = genVillage.generateVillageAtPoint(player.field_70170_p, MillCommonUtilities.random, pos.getiX(), pos.getiY(), pos.getiZ(), player, false, true, 0, villageType, null, null);
        if (result) {
            player.func_71064_a((StatBase)MillAchievements.summoningwand, 1);
            if (villageType.playerControlled) {
                player.func_71064_a((StatBase)MillAchievements.villageleader, 1);
            }
        }
    }

    public static void pujasChangeEnchantment(EntityPlayer player, Building temple, int enchantmentId) {
        if (temple != null && temple.pujas != null) {
            temple.pujas.changeEnchantment(enchantmentId);
            player.func_71064_a((StatBase)MillAchievements.puja, 1);
            temple.sendBuildingPacket(player, false);
        }
    }

    public static void questCompleteStep(EntityPlayer player, MillVillager villager) {
        UserProfile profile = Mill.getMillWorld(player.field_70170_p).getProfile(player.getDisplayName());
        Quest.QuestInstance qi = profile.villagersInQuests.get(villager.villager_id);
        if (qi == null) {
            MLN.error(villager, "Could not find quest instance for this villager.");
        } else {
            qi.completeStep(player, villager);
        }
    }

    public static void questRefuse(EntityPlayer player, MillVillager villager) {
        UserProfile profile = Mill.getMillWorld(player.field_70170_p).getProfile(player.getDisplayName());
        Quest.QuestInstance qi = profile.villagersInQuests.get(villager.villager_id);
        if (qi == null) {
            MLN.error(villager, "Could not find quest instance for this villager.");
        } else {
            qi.refuseQuest(player, villager);
        }
    }

    private static void setSign(Building townHall, int i, int j, BuildingProject project) {
        MillCommonUtilities.setBlockAndMetadata(townHall.worldObj, i, MillCommonUtilities.findTopSoilBlock(townHall.worldObj, i, j), j, Blocks.field_150472_an, 0, true, false);
        TileEntitySign sign = (TileEntitySign)townHall.worldObj.func_147438_o(i, MillCommonUtilities.findTopSoilBlock(townHall.worldObj, i, j), j);
        if (sign != null) {
            sign.field_145915_a = new String[]{project.getNativeName(), "", project.getGameName(), ""};
        }
    }

    public static void updateCustomBuilding(EntityPlayer player, Building building) {
        if (building.location.getCustomPlan() != null) {
            building.location.getCustomPlan().registerResources(building, building.location);
        }
    }

    public static void useNegationWand(EntityPlayer player, Building townHall) {
        ServerSender.sendTranslatedSentence(player, '4', "negationwand.destroyed", townHall.villageType.name);
        if (!townHall.villageType.lonebuilding) {
            player.func_71064_a((StatBase)MillAchievements.scipio, 1);
        }
        townHall.destroyVillage();
    }

    public static void useSummoningWand(EntityPlayer player, Point pos) {
        MillWorld mw = Mill.getMillWorld(player.field_70170_p);
        Building closestVillage = mw.getClosestVillage(pos);
        if (closestVillage != null && pos.squareRadiusDistance(closestVillage.getPos()) < closestVillage.villageType.radius + 10) {
            if (closestVillage.controlledBy(player.getDisplayName())) {
                Building b = closestVillage.getBuildingAtCoordPlanar(pos);
                if (b != null) {
                    if (b.location.isCustomBuilding) {
                        ServerSender.displayNewBuildingProjectGUI(player, closestVillage, pos);
                    } else {
                        ServerSender.sendTranslatedSentence(player, 'e', "ui.wand_locationinuse", new String[0]);
                    }
                } else {
                    ServerSender.displayNewBuildingProjectGUI(player, closestVillage, pos);
                }
                return;
            }
            ServerSender.sendTranslatedSentence(player, 'e', "ui.wand_invillagerange", closestVillage.getVillageQualifiedName());
            return;
        }
        Block block = MillCommonUtilities.getBlock(player.field_70170_p, pos);
        if (block == Blocks.field_150343_Z) {
            WorldGenVillage genVillage = new WorldGenVillage();
            genVillage.generateVillageAtPoint(player.field_70170_p, MillCommonUtilities.random, pos.getiX(), pos.getiY(), pos.getiZ(), player, false, true, 0, null, null, null);
        }
        if (block == Blocks.field_150340_R) {
            ServerSender.displayNewVillageGUI(player, pos);
        }
        ServerSender.sendTranslatedSentence(player, 'f', "ui.wandinstruction", new String[0]);
    }

    public static void villageChiefPerformBuilding(EntityPlayer player, MillVillager chief, String planKey) {
        BuildingPlan plan = chief.getTownHall().culture.getBuildingPlanSet(planKey).getRandomStartingPlan();
        chief.getTownHall().buildingsBought.add(planKey);
        MillCommonUtilities.changeMoney((IInventory)player.field_71071_by, -plan.price, player);
        ServerSender.sendTranslatedSentence(player, 'f', "ui.housebought", chief.getName(), plan.nativeName);
    }

    public static void villageChiefPerformCrop(EntityPlayer player, MillVillager chief, String value) {
        UserProfile profile = Mill.getMillWorld(player.field_70170_p).getProfile(player.getDisplayName());
        profile.setTag("cropplanting_" + value);
        MillCommonUtilities.changeMoney((IInventory)player.field_71071_by, -512, player);
        ServerSender.sendTranslatedSentence(player, 'f', "ui.croplearned", chief.getName(), "item." + value);
    }

    public static void villageChiefPerformCultureControl(EntityPlayer player, MillVillager chief) {
        UserProfile profile = Mill.getMillWorld(player.field_70170_p).getProfile(player.getDisplayName());
        profile.setTag("culturecontrol_" + chief.getCulture().key);
        ServerSender.sendTranslatedSentence(player, 'f', "ui.control_gotten", chief.getName(), "culture." + chief.getCulture().key);
    }

    public static void villageChiefPerformDiplomacy(EntityPlayer player, MillVillager chief, Point village, boolean praise) {
        float effect = 0.0f;
        effect = praise ? 10.0f : -10.0f;
        int reputation = Math.min(chief.getTownHall().getReputation(player.getDisplayName()), 32768);
        float coeff = (float)((Math.log(reputation) / Math.log(32768.0) * 2.0 + (double)(reputation / 32768)) / 3.0);
        effect *= coeff;
        effect = (float)((double)effect * ((double)(MillCommonUtilities.randomInt(40) + 80) / 100.0));
        chief.getTownHall().adjustRelation(village, (int)effect, false);
        UserProfile profile = Mill.getMillWorld(player.field_70170_p).getProfile(player.getDisplayName());
        profile.adjustDiplomacyPoint(chief.getTownHall(), -1);
        if (MLN.LogVillage >= 1) {
            MLN.major(chief.getTownHall(), "Adjusted relation by " + effect + " (coef: " + coeff + ")");
        }
    }

    public static void villageChiefPerformVillageScroll(EntityPlayer player, MillVillager chief) {
        for (int i = 0; i < Mill.getMillWorld((World)player.field_70170_p).villagesList.pos.size(); ++i) {
            Point p = Mill.getMillWorld((World)player.field_70170_p).villagesList.pos.get(i);
            if (!chief.getTownHall().getPos().sameBlock(p)) continue;
            MillCommonUtilities.changeMoney((IInventory)player.field_71071_by, -128, player);
            MillCommonUtilities.putItemsInChest((IInventory)player.field_71071_by, Mill.parchmentVillageScroll, i, 1);
            ServerSender.sendTranslatedSentence(player, 'f', "ui.scrollbought", chief.getName());
        }
    }
}

