/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common;

import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.stats.StatBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import org.millenaire.common.Culture;
import org.millenaire.common.InvItem;
import org.millenaire.common.MLN;
import org.millenaire.common.MillWorld;
import org.millenaire.common.Point;
import org.millenaire.common.Quest;
import org.millenaire.common.UserProfile;
import org.millenaire.common.VillagerRecord;
import org.millenaire.common.VillagerType;
import org.millenaire.common.block.BlockMillCrops;
import org.millenaire.common.building.Building;
import org.millenaire.common.building.BuildingLocation;
import org.millenaire.common.core.DevModUtilities;
import org.millenaire.common.core.MillCommonUtilities;
import org.millenaire.common.forge.Mill;
import org.millenaire.common.forge.MillAchievements;
import org.millenaire.common.goal.Goal;
import org.millenaire.common.item.Goods;
import org.millenaire.common.network.ServerSender;
import org.millenaire.common.network.StreamReadWrite;
import org.millenaire.common.pathing.AStarPathing;
import org.millenaire.common.pathing.atomicstryker.AS_PathEntity;
import org.millenaire.common.pathing.atomicstryker.AStarConfig;
import org.millenaire.common.pathing.atomicstryker.AStarNode;
import org.millenaire.common.pathing.atomicstryker.AStarPathPlanner;
import org.millenaire.common.pathing.atomicstryker.AStarStatic;
import org.millenaire.common.pathing.atomicstryker.IAStarPathedEntity;

public abstract class MillVillager
extends EntityCreature
implements IEntityAdditionalSpawnData,
IAStarPathedEntity {
    private static final double MOVE_SPEED = 0.699;
    private static final int ATTACK_RANGE_DEFENSIVE = 20;
    private static final String FREE_CLOTHES = "free";
    public static final int CONCEPTION_CHANCE = 6;
    public static final int FOREIGN_MERCHANT_NB_NIGHTS_BEFORE_LEAVING = 5;
    public static final int MALE = 1;
    public static final int FEMALE = 2;
    public static final String GENERIC_VILLAGER = "ml_GenericVillager";
    public static final String GENERIC_ASYMM_FEMALE = "ml_GenericAsimmFemale";
    public static final String GENERIC_SYMM_FEMALE = "ml_GenericSimmFemale";
    public static final String GENERIC_ZOMBIE = "ml_GenericZombie";
    public static ItemStack[] hoeWood = new ItemStack[]{new ItemStack(Items.field_151017_I, 1)};
    public static ItemStack[] hoeStone = new ItemStack[]{new ItemStack(Items.field_151018_J, 1)};
    public static ItemStack[] hoeSteel = new ItemStack[]{new ItemStack(Items.field_151019_K, 1)};
    public static ItemStack[] hoeNorman = new ItemStack[]{new ItemStack(Mill.normanHoe, 1)};
    public static ItemStack[] hoeMayan = new ItemStack[]{new ItemStack(Mill.mayanHoe, 1)};
    public static ItemStack[] shovelWood = new ItemStack[]{new ItemStack(Items.field_151038_n, 1)};
    public static ItemStack[] shovelStone = new ItemStack[]{new ItemStack(Items.field_151051_r, 1)};
    public static ItemStack[] shovelSteel = new ItemStack[]{new ItemStack(Items.field_151037_a, 1)};
    public static ItemStack[] shovelNorman = new ItemStack[]{new ItemStack(Mill.normanShovel, 1)};
    public static ItemStack[] shovelMayan = new ItemStack[]{new ItemStack(Mill.mayanShovel, 1)};
    public static ItemStack[] pickaxeWood = new ItemStack[]{new ItemStack(Items.field_151039_o, 1)};
    public static ItemStack[] pickaxeStone = new ItemStack[]{new ItemStack(Items.field_151050_s, 1)};
    public static ItemStack[] pickaxeSteel = new ItemStack[]{new ItemStack(Items.field_151035_b, 1)};
    public static ItemStack[] pickaxeNorman = new ItemStack[]{new ItemStack(Mill.normanPickaxe, 1)};
    public static ItemStack[] pickaxeMayan = new ItemStack[]{new ItemStack(Mill.mayanPickaxe, 1)};
    public static ItemStack[] axeWood = new ItemStack[]{new ItemStack(Items.field_151053_p, 1)};
    public static ItemStack[] axeStone = new ItemStack[]{new ItemStack(Items.field_151049_t, 1)};
    public static ItemStack[] axeSteel = new ItemStack[]{new ItemStack(Items.field_151036_c, 1)};
    public static ItemStack[] axeNorman = new ItemStack[]{new ItemStack(Mill.normanAxe, 1)};
    public static ItemStack[] axeMayan = new ItemStack[]{new ItemStack(Mill.mayanAxe, 1)};
    public static ItemStack[] swordWood = new ItemStack[]{new ItemStack(Items.field_151041_m, 1)};
    public static ItemStack[] swordStone = new ItemStack[]{new ItemStack(Items.field_151052_q, 1)};
    public static ItemStack[] swordSteel = new ItemStack[]{new ItemStack(Items.field_151040_l, 1)};
    public static ItemStack[] swordNorman = new ItemStack[]{new ItemStack(Mill.normanBroadsword, 1)};
    public static ItemStack[] swordMayan = new ItemStack[]{new ItemStack(Mill.mayanMace, 1)};
    public static ItemStack[] swordByzantine = new ItemStack[]{new ItemStack(Mill.byzantineMace, 1)};
    public static final Item[] weapons = new Item[]{Mill.normanBroadsword, Mill.tachiSword, Mill.byzantineMace, Items.field_151048_u, Mill.mayanMace, Items.field_151040_l, Items.field_151052_q, Mill.yumiBow, Items.field_151031_f, Mill.normanAxe, Mill.mayanAxe, Items.field_151036_c, Items.field_151049_t, Mill.normanPickaxe, Mill.mayanPickaxe, Items.field_151035_b, Items.field_151050_s, Mill.normanHoe, Mill.mayanHoe, Items.field_151019_K, Items.field_151018_J, Mill.normanShovel, Mill.mayanShovel, Items.field_151051_r, Items.field_151038_n};
    public static final Item[] weaponsHandToHand = new Item[]{Mill.normanBroadsword, Mill.tachiSword, Mill.byzantineMace, Items.field_151048_u, Mill.mayanMace, Items.field_151040_l, Items.field_151052_q, Mill.normanAxe, Mill.mayanAxe, Items.field_151036_c, Items.field_151049_t, Mill.normanPickaxe, Mill.mayanPickaxe, Items.field_151035_b, Items.field_151050_s, Mill.normanHoe, Mill.mayanHoe, Items.field_151019_K, Items.field_151018_J, Mill.normanShovel, Mill.mayanShovel, Items.field_151051_r, Items.field_151038_n};
    public static final Item[] weaponsSwords = new Item[]{Mill.normanBroadsword, Mill.tachiSword, Mill.byzantineMace, Items.field_151048_u, Mill.mayanMace, Items.field_151040_l, Items.field_151052_q, Items.field_151041_m};
    public static final Item[] weaponsRanged = new Item[]{Mill.yumiBow, Items.field_151031_f};
    private static final Item[] weaponsBow = new Item[]{Mill.yumiBow, Items.field_151031_f};
    public static final Item[] helmets = new Item[]{Mill.normanHelmet, Mill.byzantineHelmet, Mill.japaneseWarriorBlueHelmet, Mill.japaneseWarriorRedHelmet, Mill.japaneseGuardHelmet, Items.field_151161_ac, Items.field_151028_Y, Items.field_151020_U, Items.field_151169_ag, Items.field_151024_Q};
    public static final Item[] chestplates = new Item[]{Mill.normanPlate, Mill.byzantinePlate, Mill.japaneseWarriorBluePlate, Mill.japaneseWarriorRedPlate, Mill.japaneseGuardPlate, Items.field_151163_ad, Items.field_151030_Z, Items.field_151023_V, Items.field_151171_ah, Items.field_151027_R};
    public static final Item[] legs = new Item[]{Mill.normanLegs, Mill.byzantineLegs, Mill.japaneseWarriorBlueLegs, Mill.japaneseWarriorRedLegs, Mill.japaneseGuardLegs, Items.field_151173_ae, Items.field_151165_aa, Items.field_151022_W, Items.field_151149_ai, Items.field_151026_S};
    public static final Item[] boots = new Item[]{Mill.normanBoots, Mill.byzantineBoots, Mill.japaneseWarriorBlueBoots, Mill.japaneseWarriorRedBoots, Mill.japaneseGuardBoots, Items.field_151175_af, Items.field_151167_ab, Items.field_151029_X, Items.field_151151_aj, Items.field_151021_T};
    public static final Item[] pickaxes = new Item[]{Mill.normanPickaxe, Items.field_151046_w, Items.field_151035_b, Items.field_151050_s, Items.field_151039_o};
    public static final Item[] axes = new Item[]{Mill.normanAxe, Items.field_151056_x, Items.field_151036_c, Items.field_151049_t, Items.field_151053_p};
    public static final Item[] shovels = new Item[]{Mill.normanShovel, Items.field_151047_v, Items.field_151037_a, Items.field_151051_r, Items.field_151038_n};
    public static final Item[] hoes = new Item[]{Mill.normanHoe, Items.field_151012_L, Items.field_151019_K, Items.field_151018_J, Items.field_151017_I};
    private static final Item[] foodGrowth = new Item[]{Items.field_151110_aK, Items.field_151025_P, Items.field_151083_be, Items.field_151147_al, Items.field_151077_bg, Items.field_151101_aQ, Items.field_151172_bF, Items.field_151168_bH, Mill.tripes, Mill.boudin, Mill.vegcurry, Mill.chickencurry, Mill.rice, Mill.masa, Mill.wah, Mill.udon, Mill.ikayaki, Mill.lambCooked, Mill.souvlaki};
    private static final int[] foodGrowthValues = new int[]{1, 2, 4, 4, 3, 3, 1, 2, 6, 4, 3, 5, 1, 3, 5, 5, 5, 3, 6};
    private static final Item[] foodConception = new Item[]{Mill.wineFancy, Items.field_151105_aU, Mill.calva, Mill.sake, Mill.cacauhaa, Mill.wineBasic, Mill.cider, Mill.rasgulla, Mill.feta, Items.field_151106_aX};
    private static final int[] foodConceptionChanceOn = new int[]{2, 2, 2, 2, 2, 3, 3, 3, 3, 4};
    static final int GATHER_RANGE = 20;
    private static final int HOLD_DURATION = 20;
    public static final int ATTACK_RANGE = 80;
    public static boolean usingCustomPathing = true;
    public static boolean usingBinaryPathing = false;
    public VillagerType vtype;
    public int action = 0;
    public String goalKey = null;
    private Goal.GoalInformation goalInformation = null;
    private Point pathDestPoint;
    public PathPoint prevPathPoint;
    private Building house = null;
    private Building townHall = null;
    public Point housePoint = null;
    public Point prevPoint = null;
    public Point townHallPoint = null;
    public boolean extraLog = false;
    public String firstName = "";
    public String familyName = "";
    public ItemStack heldItem;
    public long timer = 0L;
    public long actionStart = 0L;
    public boolean allowRandomMoves = false;
    public boolean stopMoving = false;
    public PathPoint lastJump = null;
    public float scale = 1.0f;
    public int gender = 0;
    public boolean noHouseorTH = false;
    public boolean registered = false;
    public int longDistanceStuck;
    public boolean nightActionPerformed = false;
    public long speech_started = 0L;
    public HashMap<InvItem, Integer> inventory;
    public Block previousBlock;
    public int previousBlockMeta;
    public int size = 0;
    public long pathingTime;
    public long timeSinceLastPathingTimeDisplay;
    public long villager_id = 0L;
    public int nbPathsCalculated = 0;
    public int nbPathNoStart = 0;
    public int nbPathNoEnd = 0;
    public int nbPathAborted = 0;
    public int nbPathFailure = 0;
    public List<AStarPathing.PathKey> abortedKeys = new ArrayList<AStarPathing.PathKey>();
    public long goalStarted = 0L;
    public boolean hasPrayedToday = false;
    public boolean hasDrunkToday = false;
    public int heldItemCount = 0;
    public int heldItemId = -1;
    public static final int MAX_CHILD_SIZE = 20;
    public String speech_key = null;
    public int speech_variant = 0;
    public String dialogueKey = null;
    public int dialogueRole = 0;
    public long dialogueStart = 0L;
    public char dialogueColour = (char)102;
    public boolean dialogueChat = false;
    public String dialogueTargetFirstName = null;
    public String dialogueTargetLastName = null;
    private Point doorToClose = null;
    public int foreignMerchantNbNights = 0;
    public int foreignMerchantStallId = -1;
    public boolean lastAttackByPlayer = false;
    public HashMap<Goal, Long> lastGoalTime = new HashMap();
    public String hiredBy = null;
    public boolean aggressiveStance = false;
    public long hiredUntil = 0L;
    public boolean isUsingBow;
    public boolean isUsingHandToHand;
    public boolean isRaider = false;
    private AStarPathing.PathingWorker pathingWorker;
    public AStarPathPlanner jpsPathPlanner;
    public static final AStarConfig DEFAULT_JPS_CONFIG = new AStarConfig(true, false, false, true);
    public AS_PathEntity pathEntity;
    public int updateCounter = 0;
    public long client_lastupdated;
    private boolean registeredInGlobalList = false;
    public MillWorld mw;
    public int pathfailure = 0;
    private boolean pathFailedSincelastTick = false;
    private List<AStarNode> pathCalculatedSinceLastTick = null;
    private int localStuck = 0;
    private long pathCalculationStartTime = 0L;
    private ResourceLocation clothTexture = null;
    private String clothName = null;
    public boolean shouldLieDown = false;
    public LinkedHashMap<Goods, Integer> merchantSells = new LinkedHashMap();
    public ResourceLocation texture = null;

    public static MillVillager createVillager(Culture c, String type, int gender, World world, Point spawnPos, Point housePos, Point thPos, boolean respawn, String firstName, String familyName) {
        MillVillager villager;
        if (world.field_72995_K || !(world instanceof WorldServer)) {
            MLN.printException("Tried creating a villager in client world: " + world, new Exception());
            return null;
        }
        if (type == null || type.length() == 0) {
            MLN.error(null, "Tried creating child of null type: " + type);
        }
        if (c.getVillagerType(type.toLowerCase()) == null) {
            for (Culture c2 : Culture.ListCultures) {
                if (c2.getVillagerType(type) == null) continue;
                MLN.error(null, "Could not find villager type " + type + " in culture " + c.key + " but could in " + c2.key + " so switching.");
                c = c2;
            }
        }
        if (c.getVillagerType(type.toLowerCase()) != null) {
            VillagerType vtype = c.getVillagerType(type.toLowerCase());
            villager = (MillVillager)EntityList.func_75620_a((String)vtype.getEntityName(), (World)world);
            if (villager == null) {
                MLN.error(c, "Could not create villager of dynamic type: " + type + " entity: " + vtype.getEntityName());
                return null;
            }
            villager.housePoint = housePos;
            villager.townHallPoint = thPos;
            if (familyName == null) {
                familyName = vtype.getRandomFamilyName();
            }
            villager.initialise(vtype, familyName, respawn);
            if (firstName != null) {
                villager.firstName = firstName;
            }
        } else {
            MLN.error(null, "Unknown villager type: " + type + " for culture " + c);
            return null;
        }
        villager.func_70107_b(spawnPos.x, spawnPos.y, spawnPos.z);
        return villager;
    }

    public static void readVillagerPacket(ByteBufInputStream data) {
        try {
            long villager_id = data.readLong();
            if (Mill.clientWorld.villagers.containsKey(villager_id)) {
                Mill.clientWorld.villagers.get(villager_id).readVillagerStreamdata((DataInput)data);
            } else if (MLN.LogNetwork >= 2) {
                MLN.minor(null, "readVillagerPacket for unknown villager: " + villager_id);
            }
        }
        catch (IOException e) {
            MLN.printException(e);
        }
    }

    public MillVillager(World world) {
        super(world);
        this.field_70170_p = world;
        this.mw = Mill.getMillWorld(world);
        this.inventory = new HashMap();
        this.func_70606_j(this.func_110138_aP());
        this.field_70178_ae = true;
        this.client_lastupdated = world.func_72820_D();
        this.jpsPathPlanner = new AStarPathPlanner(world, this);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.699);
        if (MLN.LogVillagerSpawn >= 3) {
            Exception e = new Exception();
            MLN.printException("Creating villager " + this + " in world: " + world, e);
        }
    }

    public void addToInv(Block block, int nb) {
        this.addToInv(Item.func_150898_a((Block)block), 0, nb);
    }

    public void addToInv(Block block, int meta, int nb) {
        this.addToInv(Item.func_150898_a((Block)block), meta, nb);
    }

    public void addToInv(InvItem iv, int nb) {
        this.addToInv(iv.getItem(), iv.meta, nb);
    }

    public void addToInv(Item item, int nb) {
        this.addToInv(item, 0, nb);
    }

    public void addToInv(Item item, int meta, int nb) {
        try {
            InvItem key = new InvItem(item, meta);
            if (this.inventory.containsKey(key)) {
                this.inventory.put(key, this.inventory.get(key) + nb);
            } else {
                this.inventory.put(key, nb);
            }
            if (this.getTownHall() != null) {
                this.getTownHall().updateVillagerRecord(this);
            } else {
                MLN.error(this, "Wanted to update VR after an addToInv but TH is null.");
            }
            this.updateClothTexturePath();
        }
        catch (MLN.MillenaireException e) {
            MLN.printException(e);
        }
    }

    public void adjustSize() {
        this.scale = 0.5f + (float)this.size / 100.0f;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.699);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.computeMaxHealth());
    }

    private void applyPathCalculatedSinceLastTick() {
        AS_PathEntity path = AStarStatic.translateAStarPathtoPathEntity(this.field_70170_p, this.pathCalculatedSinceLastTick, this.getPathingConfig());
        try {
            this.registerNewPath(path);
            this.pathfailure = 0;
        }
        catch (Exception e) {
            MLN.printException("Exception when finding JPS path:", e);
        }
        this.pathCalculatedSinceLastTick = null;
    }

    public void func_70785_a(Entity entity, float f) {
        if (this.vtype.isArcher && f > 5.0f && this.hasBow()) {
            this.attackEntityBow(entity, f);
            this.isUsingBow = true;
        } else {
            if (this.field_70724_aR <= 0 && f < 2.0f && entity.field_70121_D.field_72337_e > this.field_70121_D.field_72338_b && entity.field_70121_D.field_72338_b < this.field_70121_D.field_72337_e) {
                this.field_70724_aR = 20;
                entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.getAttackStrength());
                this.func_71038_i();
            }
            this.isUsingHandToHand = true;
        }
    }

    public void attackEntityBow(Entity entity, float f) {
        if (!(entity instanceof EntityLivingBase)) {
            return;
        }
        if (f < 10.0f) {
            double d = entity.field_70165_t - this.field_70165_t;
            double d1 = entity.field_70161_v - this.field_70161_v;
            if (this.field_70724_aR == 0) {
                Item item;
                float speedFactor = 1.0f;
                float damageBonus = 0.0f;
                ItemStack weapon = this.getWeapon();
                if (weapon != null && (item = weapon.func_77973_b()) instanceof Goods.ItemMillenaireBow) {
                    Goods.ItemMillenaireBow bow = (Goods.ItemMillenaireBow)item;
                    if (bow.speedFactor > speedFactor) {
                        speedFactor = bow.speedFactor;
                    }
                    if (bow.damageBonus > damageBonus) {
                        damageBonus = bow.damageBonus;
                    }
                }
                EntityArrow arrow = new EntityArrow(this.field_70170_p, (EntityLivingBase)this, (EntityLivingBase)entity, 1.6f, 12.0f);
                this.field_70170_p.func_72956_a((Entity)this, "random.bow", 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
                this.field_70170_p.func_72838_d((Entity)arrow);
                this.field_70724_aR = 60;
                arrow.field_70159_w *= (double)speedFactor;
                arrow.field_70181_x *= (double)speedFactor;
                arrow.field_70179_y *= (double)speedFactor;
                arrow.func_70239_b(arrow.func_70242_d() + (double)damageBonus);
            }
            this.field_70177_z = (float)(Math.atan2(d1, d) * 180.0 / 3.1415927410125732) - 90.0f;
            this.field_70787_b = true;
        }
    }

    public boolean func_70097_a(DamageSource ds, float i) {
        if (ds.func_76364_f() == null && ds != DamageSource.field_76380_i) {
            return false;
        }
        boolean hadFullHealth = this.func_110138_aP() == this.func_110143_aJ();
        boolean b = super.func_70097_a(ds, i);
        Entity entity = ds.func_76364_f();
        this.lastAttackByPlayer = false;
        if (entity != null && entity instanceof EntityLivingBase) {
            if (entity instanceof EntityPlayer) {
                this.lastAttackByPlayer = true;
                EntityPlayer player = (EntityPlayer)entity;
                if (!this.isRaider) {
                    if (!this.vtype.hostile) {
                        MillCommonUtilities.getServerProfile(player.field_70170_p, player.getDisplayName()).adjustReputation(this.getTownHall(), (int)(-i * 10.0f));
                    }
                    if (this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL && this.func_110143_aJ() < this.func_110138_aP() - 10.0f) {
                        this.field_70789_a = entity;
                        this.clearGoal();
                        if (this.getTownHall() != null) {
                            this.getTownHall().callForHelp(entity);
                        }
                    }
                    if (hadFullHealth && (player.func_70694_bm() == null || MillCommonUtilities.getItemWeaponDamage(player.func_70694_bm().func_77973_b()) <= 1.0) && !this.field_70170_p.field_72995_K) {
                        ServerSender.sendTranslatedSentence(player, '6', "ui.communicationexplanations", new String[0]);
                    }
                }
                if (this.lastAttackByPlayer && this.func_110143_aJ() <= 0.0f) {
                    if (this.vtype.hostile) {
                        player.func_71064_a((StatBase)MillAchievements.selfdefense, 1);
                    } else {
                        player.func_71064_a((StatBase)MillAchievements.darkside, 1);
                    }
                }
            } else {
                this.field_70789_a = entity;
                this.clearGoal();
                if (this.getTownHall() != null) {
                    this.getTownHall().callForHelp(entity);
                }
            }
        }
        return b;
    }

    public boolean attemptChildConception() {
        int nbChildren = 0;
        for (MillVillager villager : this.getHouse().villagers) {
            if (!villager.func_70631_g_()) continue;
            ++nbChildren;
        }
        if (nbChildren > 1) {
            if (MLN.LogChildren >= 3) {
                MLN.debug(this, "Wife already has " + nbChildren + " children, no need for more.");
            }
            return true;
        }
        int nbChildVillage = this.getTownHall().countChildren();
        if (nbChildVillage > MLN.maxChildrenNumber) {
            if (MLN.LogChildren >= 3) {
                MLN.debug(this, "Village already has " + nbChildVillage + ", no need for more.");
            }
            return true;
        }
        boolean couldMoveIn = false;
        for (Point housePoint : this.getTownHall().buildings) {
            Building house = this.mw.getBuilding(housePoint);
            if (house == null || house.equals(this.getHouse()) || !house.isHouse() || !house.canChildMoveIn(1, this.familyName) && !house.canChildMoveIn(2, this.familyName)) continue;
            couldMoveIn = true;
        }
        if (nbChildVillage > 5 && !couldMoveIn) {
            if (MLN.LogChildren >= 3) {
                MLN.debug(this, "Village already has " + nbChildVillage + " and no slot is available for the new child.");
            }
            return true;
        }
        List<Entity> entities = MillCommonUtilities.getEntitiesWithinAABB(this.field_70170_p, MillVillager.class, this.getPos(), 4, 2);
        boolean manFound = false;
        for (Entity ent : entities) {
            MillVillager villager = (MillVillager)ent;
            if (villager.gender != 1 || villager.func_70631_g_()) continue;
            manFound = true;
        }
        if (!manFound) {
            return false;
        }
        if (MLN.LogChildren >= 3) {
            MLN.debug(this, "Less than two kids and man present, trying for new child.");
        }
        boolean createChild = false;
        boolean foundConceptionFood = false;
        for (int i = 0; i < foodConception.length && !foundConceptionFood; ++i) {
            if (this.getHouse().countGoods(foodConception[i]) <= 0) continue;
            this.getHouse().takeGoods(foodConception[i], 1);
            foundConceptionFood = true;
            if (MillCommonUtilities.randomInt(foodConceptionChanceOn[i]) != 0) continue;
            createChild = true;
            if (MLN.LogChildren >= 2) {
                MLN.minor(this, "Conceiving child with help from: " + foodConception[i].func_77658_a());
                continue;
            }
            if (MLN.LogChildren < 2) continue;
            MLN.minor(this, "Failed to conceive child even with help from: " + foodConception[i].func_77658_a());
        }
        if (!foundConceptionFood) {
            if (MillCommonUtilities.randomInt(6) == 0) {
                createChild = true;
                if (MLN.LogChildren >= 2) {
                    MLN.minor(this, "Conceiving child without help.");
                }
            } else if (MLN.LogChildren >= 2) {
                MLN.minor(this, "Failed to conceive child without help.");
            }
        }
        if (MLN.DEV) {
            createChild = true;
        }
        if (createChild) {
            this.getHouse().createChild(this, this.getTownHall(), this.getRecord().spousesName);
        }
        return true;
    }

    public void calculateMerchantGoods() {
        for (InvItem key : this.vtype.foreignMerchantStock.keySet()) {
            if (!this.getCulture().goodsByItem.containsKey(key) || this.getBasicForeignMerchantPrice(key) <= 0) continue;
            this.merchantSells.put(this.getCulture().goodsByItem.get(key), this.getBasicForeignMerchantPrice(key));
        }
    }

    public boolean func_70692_ba() {
        return false;
    }

    public boolean canMeditate() {
        return this.vtype.canMeditate;
    }

    public boolean canPerformSacrifices() {
        return this.vtype.canPerformSacrifices;
    }

    public void checkGoals() throws Exception {
        Goal goal = Goal.goals.get(this.goalKey);
        if (goal == null) {
            MLN.error(this, "Invalid goal key: " + this.goalKey);
            this.goalKey = null;
            return;
        }
        if (this.getGoalDestEntity() != null) {
            if (this.getGoalDestEntity().field_70128_L) {
                this.setGoalDestEntity(null);
                this.setPathDestPoint(null);
            } else {
                this.setPathDestPoint(new Point(this.getGoalDestEntity()));
            }
        }
        Point target = null;
        boolean continuingGoal = true;
        if (this.getPathDestPoint() != null) {
            target = this.getPathDestPoint();
            if (this.pathEntity != null && this.pathEntity.func_75874_d() > 0) {
                target = new Point(this.pathEntity.func_75870_c());
            }
        }
        this.speakSentence(goal.sentenceKey());
        if (this.getGoalDestPoint() == null && this.getGoalDestEntity() == null) {
            goal.setVillagerDest(this);
            if (MLN.LogGeneralAI >= 2 && this.extraLog) {
                MLN.minor(this, "Goal destination: " + this.getGoalDestPoint() + "/" + this.getGoalDestEntity());
            }
        } else if (target != null && target.horizontalDistanceTo((Entity)this) < (double)goal.range(this)) {
            if (this.actionStart == 0L) {
                this.stopMoving = goal.stopMovingWhileWorking();
                this.actionStart = System.currentTimeMillis();
                this.shouldLieDown = goal.shouldVillagerLieDown();
                if (MLN.LogGeneralAI >= 2 && this.extraLog) {
                    MLN.minor(this, "Starting action: " + this.actionStart);
                }
            }
            if (System.currentTimeMillis() - this.actionStart >= (long)goal.actionDuration(this)) {
                if (goal.performAction(this)) {
                    this.clearGoal();
                    this.goalKey = goal.nextGoal(this);
                    this.stopMoving = false;
                    this.shouldLieDown = false;
                    this.heldItem = null;
                    continuingGoal = false;
                    if (MLN.LogGeneralAI >= 2 && this.extraLog) {
                        MLN.minor(this, "Goal performed. Now doing: " + this.goalKey);
                    }
                } else {
                    this.stopMoving = goal.stopMovingWhileWorking();
                }
                this.actionStart = 0L;
                this.goalStarted = System.currentTimeMillis();
            }
        } else {
            this.stopMoving = false;
            this.shouldLieDown = false;
        }
        if (!continuingGoal) {
            return;
        }
        if (goal.isStillValid(this)) {
            if (System.currentTimeMillis() - this.goalStarted > goal.stuckDelay(this)) {
                boolean actionDone = goal.stuckAction(this);
                if (actionDone) {
                    this.goalStarted = System.currentTimeMillis();
                }
                if (goal.isStillValid(this)) {
                    this.allowRandomMoves = goal.allowRandomMoves();
                    if (this.stopMoving) {
                        this.func_70778_a(null);
                        this.pathEntity = null;
                    }
                    if (this.heldItemCount > 20) {
                        ItemStack[] heldItems = null;
                        heldItems = target != null && target.horizontalDistanceTo((Entity)this) < (double)goal.range(this) ? goal.getHeldItemsDestination(this) : goal.getHeldItemsTravelling(this);
                        if (heldItems != null && heldItems.length > 0) {
                            this.heldItemId = (this.heldItemId + 1) % heldItems.length;
                            this.heldItem = heldItems[this.heldItemId];
                        }
                        this.heldItemCount = 0;
                    }
                    if (this.heldItemCount == 0 && goal.swingArms(this)) {
                        this.func_71038_i();
                    }
                    ++this.heldItemCount;
                }
            } else {
                if (this.heldItemCount > 20) {
                    ItemStack[] heldItems = null;
                    heldItems = target != null && target.horizontalDistanceTo((Entity)this) < (double)goal.range(this) ? goal.getHeldItemsDestination(this) : goal.getHeldItemsTravelling(this);
                    if (heldItems != null && heldItems.length > 0) {
                        this.heldItemId = (this.heldItemId + 1) % heldItems.length;
                        this.heldItem = heldItems[this.heldItemId];
                    }
                    this.heldItemCount = 0;
                }
                if (this.heldItemCount == 0 && goal.swingArms(this)) {
                    this.func_71038_i();
                }
                ++this.heldItemCount;
            }
        } else {
            this.stopMoving = false;
            this.shouldLieDown = false;
            goal.onComplete(this);
            this.clearGoal();
            this.goalKey = goal.nextGoal(this);
            this.heldItemCount = 21;
            this.heldItemId = -1;
        }
    }

    private void checkRegistration() throws MLN.MillenaireException {
        if (!this.registered || MillCommonUtilities.chanceOn(100)) {
            if (this.getHouse() != null && !this.getHouse().villagers.contains(this)) {
                this.getHouse().registerVillager(this);
                if (MLN.LogOther >= 3) {
                    MLN.debug(this, "Registering in house List.");
                }
            }
            if (this.getTownHall() != null && !this.getTownHall().villagers.contains(this)) {
                this.getTownHall().registerVillager(this);
                if (MLN.LogOther >= 3) {
                    MLN.debug(this, "Registering in TH List.");
                }
            }
            this.registered = true;
        }
    }

    public void clearGoal() {
        this.setGoalDestPoint(null);
        this.setGoalBuildingDestPoint(null);
        this.setGoalDestEntity(null);
        this.goalKey = null;
        this.shouldLieDown = false;
    }

    private boolean closeFenceGate(int i, int j, int k) {
        int l = this.field_70170_p.func_72805_g(i, j, k);
        if (BlockFenceGate.func_149896_b((int)l)) {
            MillCommonUtilities.setBlockMetadata(this.field_70170_p, i, j, k, l & 0xFFFFFFFB, true);
            return true;
        }
        return false;
    }

    public float computeMaxHealth() {
        if (this.vtype == null) {
            return 40.0f;
        }
        if (this.func_70631_g_()) {
            return 10 + this.size;
        }
        return this.vtype.health;
    }

    private List<PathPoint> computeNewPath(Point dest) {
        if (this.getPos().sameBlock(dest)) {
            return null;
        }
        if (usingCustomPathing) {
            if (MLN.jpsPathing) {
                if (this.jpsPathPlanner.isBusy()) {
                    this.jpsPathPlanner.stopPathSearch(true);
                }
                AStarNode destNode = null;
                AStarNode[] possibles = AStarStatic.getAccessNodesSorted(this.field_70170_p, this.doubleToInt(this.field_70165_t), this.doubleToInt(this.field_70163_u), this.doubleToInt(this.field_70161_v), this.getPathDestPoint().getiX(), this.getPathDestPoint().getiY(), this.getPathDestPoint().getiZ(), this.getPathingConfig());
                if (possibles.length != 0) {
                    destNode = possibles[0];
                }
                if (destNode != null) {
                    this.pathCalculationStartTime = System.currentTimeMillis();
                    this.jpsPathPlanner.getPath(this.doubleToInt(this.field_70165_t), this.doubleToInt(this.field_70163_u) - 1, this.doubleToInt(this.field_70161_v), destNode.x, destNode.y, destNode.z, this.getPathingConfig());
                } else {
                    this.onNoPathAvailable();
                }
            } else {
                if (this.pathingWorker != null) {
                    this.pathingWorker.interrupt();
                }
                this.pathingWorker = this.townHall.calculatePath(this, this.getPos(), dest, this.extraLog);
            }
            return null;
        }
        ArrayList<PathPoint> pp = new ArrayList<PathPoint>();
        PathEntity pe = this.field_70170_p.func_72844_a((Entity)this, dest.getiX(), dest.getiY(), dest.getiZ(), (float)(this.getPos().distanceTo(dest) + 16.0), true, false, false, true);
        if (pe == null) {
            return null;
        }
        for (int i = 0; i < pe.func_75874_d(); ++i) {
            pp.add(pe.func_75877_a(i));
        }
        return pp;
    }

    public int countBlocksAround(int x, int y, int z, int rx, int ry, int rz) {
        return MillCommonUtilities.countBlocksAround(this.field_70170_p, x, y, z, rx, ry, rz);
    }

    public int countInv(Block block, int meta) {
        try {
            return this.countInv(new InvItem(Item.func_150898_a((Block)block), meta));
        }
        catch (MLN.MillenaireException e) {
            MLN.printException(e);
            return 0;
        }
    }

    public int countInv(InvItem key) {
        if (key.meta == -1) {
            int nb = 0;
            for (int i = 0; i < 16; ++i) {
                try {
                    InvItem tkey = new InvItem(key.item, i);
                    if (!this.inventory.containsKey(tkey)) continue;
                    nb += this.inventory.get(tkey).intValue();
                    continue;
                }
                catch (MLN.MillenaireException e) {
                    MLN.printException(e);
                }
            }
            return nb;
        }
        if (this.inventory.containsKey(key)) {
            return this.inventory.get(key);
        }
        return 0;
    }

    public int countInv(Item item) {
        return this.countInv(item, 0);
    }

    public int countInv(Item item, int meta) {
        try {
            return this.countInv(new InvItem(item, meta));
        }
        catch (MLN.MillenaireException e) {
            MLN.printException(e);
            return 0;
        }
    }

    public int countItemsAround(Item item, int radius) {
        return this.countItemsAround(new Item[]{item}, radius);
    }

    public int countItemsAround(Item[] items, int radius) {
        List<Entity> list = MillCommonUtilities.getEntitiesWithinAABB(this.field_70170_p, EntityItem.class, this.getPos(), radius, radius);
        int count = 0;
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i).getClass() != EntityItem.class) continue;
                EntityItem entity = (EntityItem)list.get(i);
                if (entity.field_70128_L) continue;
                for (Item id : items) {
                    if (id != entity.func_92059_d().func_77973_b()) continue;
                    ++count;
                }
            }
        }
        return count;
    }

    public void despawnVillager() {
        EntityPlayer owner;
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.hiredBy != null && (owner = this.field_70170_p.func_72924_a(this.hiredBy)) != null) {
            ServerSender.sendTranslatedSentence(owner, '4', "hire.hiredied", this.getName());
        }
        super.func_70106_y();
    }

    public void despawnVillagerSilent() {
        if (MLN.LogVillagerSpawn >= 3) {
            Exception e = new Exception();
            MLN.printException("Despawning villager: " + this, e);
        }
        super.func_70106_y();
    }

    public void detrampleCrops() {
        if (this.getPos().sameBlock(this.prevPoint) && (this.previousBlock == Blocks.field_150464_aj || this.previousBlock instanceof BlockMillCrops) && this.getBlock(this.getPos()) != Blocks.field_150350_a && this.getBlock(this.getPos().getBelow()) == Blocks.field_150346_d) {
            this.setBlock(this.getPos(), this.previousBlock);
            this.setBlockMetadata(this.getPos(), this.previousBlockMeta);
            this.setBlock(this.getPos().getBelow(), Blocks.field_150458_ak);
        }
        this.previousBlock = this.getBlock(this.getPos());
        this.previousBlockMeta = this.getBlockMeta(this.getPos());
    }

    public int doubleToInt(double input) {
        return AStarStatic.getIntCoordFromDoubleCoord(input);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof MillVillager)) {
            return false;
        }
        MillVillager v = (MillVillager)obj;
        return this.villager_id == v.villager_id;
    }

    public void func_70625_a(Entity par1Entity, float par2, float par3) {
    }

    public void faceEntityMill(Entity par1Entity, float par2, float par3) {
        double d2;
        double d0 = par1Entity.field_70165_t - this.field_70165_t;
        double d1 = par1Entity.field_70161_v - this.field_70161_v;
        if (par1Entity instanceof EntityLivingBase) {
            EntityLivingBase entityliving = (EntityLivingBase)par1Entity;
            d2 = entityliving.field_70163_u + (double)entityliving.func_70047_e() - (this.field_70163_u + (double)this.func_70047_e());
        } else {
            d2 = (par1Entity.field_70121_D.field_72338_b + par1Entity.field_70121_D.field_72337_e) / 2.0 - (this.field_70163_u + (double)this.func_70047_e());
        }
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
        float f2 = (float)(Math.atan2(d1, d0) * 180.0 / Math.PI) - 90.0f;
        float f3 = (float)(-(Math.atan2(d2, d3) * 180.0 / Math.PI));
        this.field_70125_A = this.func_70663_b(this.field_70125_A, f3, par3);
        this.field_70177_z = this.func_70663_b(this.field_70177_z, f2, par2);
    }

    public void facePoint(Point p, float par2, float par3) {
        double x = p.x - this.field_70165_t;
        double z = p.z - this.field_70161_v;
        double y = p.y - (this.field_70163_u + (double)this.func_70047_e());
        this.func_70671_ap().func_75650_a(x, y, z, 10.0f, (float)this.func_70646_bf());
    }

    private boolean foreignMerchantNightAction() {
        ++this.foreignMerchantNbNights;
        if (this.foreignMerchantNbNights > 5) {
            this.leaveVillage();
        } else {
            boolean hasItems = false;
            for (InvItem key : this.vtype.foreignMerchantStock.keySet()) {
                if (this.getHouse().countGoods(key) <= 0) continue;
                hasItems = true;
            }
            if (!hasItems) {
                this.leaveVillage();
            }
        }
        return true;
    }

    private void foreignMerchantUpdate() {
        if (this.foreignMerchantStallId < 0) {
            for (int i = 0; i < this.getHouse().getResManager().stalls.size() && this.foreignMerchantStallId < 0; ++i) {
                boolean taken = false;
                for (MillVillager v : this.getHouse().villagers) {
                    if (v.foreignMerchantStallId != i) continue;
                    taken = true;
                }
                if (taken) continue;
                this.foreignMerchantStallId = i;
            }
        }
        if (this.foreignMerchantStallId < 0) {
            this.foreignMerchantStallId = 0;
        }
    }

    public ItemStack func_130225_q(int type) {
        if (type == 0) {
            for (Item weapon : helmets) {
                if (this.countInv(weapon) <= 0) continue;
                return new ItemStack(weapon, 1);
            }
            return null;
        }
        if (type == 1) {
            for (Item weapon : chestplates) {
                if (this.countInv(weapon) <= 0) continue;
                return new ItemStack(weapon, 1);
            }
            return null;
        }
        if (type == 2) {
            for (Item weapon : legs) {
                if (this.countInv(weapon) <= 0) continue;
                return new ItemStack(weapon, 1);
            }
            return null;
        }
        if (type == 3) {
            for (Item weapon : boots) {
                if (this.countInv(weapon) <= 0) continue;
                return new ItemStack(weapon, 1);
            }
            return null;
        }
        return null;
    }

    public boolean gathersApples() {
        return this.vtype.gathersApples;
    }

    public String getActionLabel(int action) {
        return "none";
    }

    public int getAttackStrength() {
        int attackStrength = this.vtype.baseAttackStrength;
        ItemStack weapon = this.getWeapon();
        if (weapon != null) {
            attackStrength = (int)((double)attackStrength + Math.ceil((float)MillCommonUtilities.getItemWeaponDamage(weapon.func_77973_b()) / 2.0f));
        }
        return attackStrength;
    }

    public int getBasicForeignMerchantPrice(InvItem item) {
        if (this.getTownHall() == null) {
            return 0;
        }
        if (this.getCulture().goodsByItem.containsKey(item)) {
            if (this.getCulture() != this.getTownHall().culture) {
                return (int)((double)this.getCulture().goodsByItem.get((Object)item).foreignMerchantPrice * 1.5);
            }
            return this.getCulture().goodsByItem.get((Object)item).foreignMerchantPrice;
        }
        return 0;
    }

    public float getBedOrientationInDegrees() {
        int z;
        int y;
        int x;
        Block block;
        Point ref = this.getPos();
        if (this.getGoalDestPoint() != null) {
            ref = this.getGoalDestPoint();
        }
        if ((block = this.field_70170_p.func_147439_a(x = (int)ref.x, y = (int)ref.y, z = (int)ref.z)) == Blocks.field_150324_C) {
            int var2 = block == null ? 0 : block.getBedDirection((IBlockAccess)this.field_70170_p, x, y, z);
            switch (var2) {
                case 0: {
                    return 270.0f;
                }
                case 1: {
                    return 0.0f;
                }
                case 2: {
                    return 90.0f;
                }
                case 3: {
                    return 180.0f;
                }
            }
        } else {
            if (this.field_70170_p.func_147439_a(x + 1, y, z) == Blocks.field_150350_a) {
                return 0.0f;
            }
            if (this.field_70170_p.func_147439_a(x, y, z + 1) == Blocks.field_150350_a) {
                return 90.0f;
            }
            if (this.field_70170_p.func_147439_a(x - 1, y, z) == Blocks.field_150350_a) {
                return 180.0f;
            }
            if (this.field_70170_p.func_147439_a(x, y, z - 1) == Blocks.field_150350_a) {
                return 270.0f;
            }
        }
        return 0.0f;
    }

    public ItemTool getBestAxe() {
        ItemTool bestTool = (ItemTool)Items.field_151053_p;
        float bestRating = 0.0f;
        for (InvItem item : this.inventory.keySet()) {
            ItemTool tool;
            if (this.inventory.get(item) <= 0 || item.staticStack == null || !(item.item instanceof ItemAxe) && !(item.item instanceof Goods.ItemMillenaireAxe) || !((tool = (ItemTool)item.item).func_150893_a(item.staticStack, Blocks.field_150364_r) > bestRating)) continue;
            bestTool = tool;
            bestRating = tool.func_150893_a(item.staticStack, Blocks.field_150348_b);
        }
        return bestTool;
    }

    public ItemStack[] getBestAxeStack() {
        ItemStack[] bestTool = axeWood;
        float bestRating = 0.0f;
        for (InvItem item : this.inventory.keySet()) {
            ItemTool tool;
            if (this.inventory.get(item) <= 0 || item.staticStack == null || !(item.item instanceof ItemAxe) && !(item.item instanceof Goods.ItemMillenaireAxe) || !((tool = (ItemTool)item.item).func_150893_a(item.staticStack, Blocks.field_150364_r) > bestRating)) continue;
            bestTool = item.staticStackArray;
            bestRating = tool.func_150893_a(item.staticStack, Blocks.field_150348_b);
        }
        return bestTool;
    }

    public Item getBestHoe() {
        Item bestTool = Items.field_151017_I;
        float bestRating = 0.0f;
        for (InvItem item : this.inventory.keySet()) {
            if (this.inventory.get(item) <= 0 || item.staticStack == null || !(item.item instanceof ItemHoe) && !(item.item instanceof Goods.ItemMillenaireHoe) || !((float)item.item.func_77612_l() > bestRating)) continue;
            bestTool = item.item;
            bestRating = item.item.func_77612_l();
        }
        return bestTool;
    }

    public ItemStack[] getBestHoeStack() {
        ItemStack[] bestTool = hoeWood;
        float bestRating = 0.0f;
        for (InvItem item : this.inventory.keySet()) {
            if (this.inventory.get(item) <= 0 || item.staticStack == null || !(item.item instanceof ItemHoe) && !(item.item instanceof Goods.ItemMillenaireHoe) || !((float)item.item.func_77612_l() > bestRating)) continue;
            bestTool = item.staticStackArray;
            bestRating = item.item.func_77612_l();
        }
        return bestTool;
    }

    public ItemTool getBestPickaxe() {
        ItemTool bestTool = (ItemTool)Items.field_151039_o;
        float bestRating = 0.0f;
        for (InvItem item : this.inventory.keySet()) {
            ItemTool tool;
            if (this.inventory.get(item) <= 0 || item.staticStack == null || !(item.item instanceof ItemPickaxe) && !(item.item instanceof Goods.ItemMillenairePickaxe) || !((tool = (ItemTool)item.item).func_150893_a(item.staticStack, Blocks.field_150348_b) > bestRating)) continue;
            bestTool = tool;
            bestRating = tool.func_150893_a(item.staticStack, Blocks.field_150348_b);
        }
        return bestTool;
    }

    public ItemStack[] getBestPickaxeStack() {
        ItemStack[] bestTool = pickaxeWood;
        float bestRating = 0.0f;
        for (InvItem item : this.inventory.keySet()) {
            ItemTool tool;
            if (this.inventory.get(item) <= 0 || item.staticStack == null || !(item.item instanceof ItemPickaxe) && !(item.item instanceof Goods.ItemMillenairePickaxe) || !((tool = (ItemTool)item.item).func_150893_a(item.staticStack, Blocks.field_150348_b) > bestRating)) continue;
            bestTool = item.staticStackArray;
            bestRating = tool.func_150893_a(item.staticStack, Blocks.field_150348_b);
        }
        return bestTool;
    }

    public ItemTool getBestShovel() {
        ItemTool bestTool = (ItemTool)Items.field_151038_n;
        float bestRating = 0.0f;
        for (InvItem item : this.inventory.keySet()) {
            ItemTool tool;
            if (this.inventory.get(item) <= 0 || item.staticStack == null || !(item.item instanceof ItemSpade) && !(item.item instanceof Goods.ItemMillenaireShovel) || !((tool = (ItemTool)item.item).func_150893_a(item.staticStack, Blocks.field_150346_d) > bestRating)) continue;
            bestTool = tool;
            bestRating = tool.func_150893_a(item.staticStack, Blocks.field_150348_b);
        }
        return bestTool;
    }

    public ItemStack[] getBestShovelStack() {
        ItemStack[] bestTool = shovelWood;
        float bestRating = 0.0f;
        for (InvItem item : this.inventory.keySet()) {
            ItemTool tool;
            if (this.inventory.get(item) <= 0 || item.staticStack == null || !(item.item instanceof ItemSpade) && !(item.item instanceof Goods.ItemMillenaireShovel) || !((tool = (ItemTool)item.item).func_150893_a(item.staticStack, Blocks.field_150346_d) > bestRating)) continue;
            bestTool = item.staticStackArray;
            bestRating = tool.func_150893_a(item.staticStack, Blocks.field_150348_b);
        }
        return bestTool;
    }

    public Block getBlock(Point p) {
        return MillCommonUtilities.getBlock(this.field_70170_p, p);
    }

    public int getBlockMeta(Point p) {
        return MillCommonUtilities.getBlockMeta(this.field_70170_p, p);
    }

    public float func_70783_a(int i, int j, int k) {
        if (!this.allowRandomMoves) {
            if (MLN.LogPathing >= 3 && this.extraLog) {
                MLN.debug(this, "Forbiding random moves. Current goal: " + Goal.goals.get(this.goalKey) + " Returning: " + -99999.0f);
            }
            return Float.NEGATIVE_INFINITY;
        }
        Point rp = new Point(i, j, k);
        double dist = rp.distanceTo(this.housePoint);
        if (this.field_70170_p.func_147439_a(i, j - 1, k) == Blocks.field_150458_ak) {
            return -50.0f;
        }
        if (dist > 10.0) {
            return -((float)dist);
        }
        return MillCommonUtilities.randomInt(10);
    }

    public Point getClosest(List<Point> points) {
        double bestdist = Double.MAX_VALUE;
        Point bp = null;
        for (Point p : points) {
            double dist = p.distanceToSquared((Entity)this);
            if (!(dist < bestdist)) continue;
            bestdist = dist;
            bp = p;
        }
        return bp;
    }

    public Point getClosestBlock(Block[] blockIds, Point pos, int rx, int ry, int rz) {
        return MillCommonUtilities.getClosestBlock(this.field_70170_p, blockIds, pos, rx, ry, rz);
    }

    public Point getClosestBlockMeta(Block[] blockIds, int meta, Point pos, int rx, int ry, int rz) {
        return MillCommonUtilities.getClosestBlockMeta(this.field_70170_p, blockIds, meta, pos, rx, ry, rz);
    }

    public Point getClosestHorizontal(List<Point> points) {
        double bestdist = Double.MAX_VALUE;
        Point bp = null;
        for (Point p : points) {
            double dist = p.horizontalDistanceToSquared((Entity)this);
            if (!(dist < bestdist)) continue;
            bestdist = dist;
            bp = p;
        }
        return bp;
    }

    public Point getClosestHorizontalWithAltitudeCost(List<Point> points, float vCost) {
        double bestdist = Double.MAX_VALUE;
        Point bp = null;
        for (Point p : points) {
            double dist = p.horizontalDistanceToSquared((Entity)this);
            if (!((dist += (double)((float)Math.abs(this.townHall.getAltitude((int)this.field_70165_t, (int)this.field_70161_v) - this.townHall.getAltitude(p.getiX(), p.getiZ())) * vCost)) < bestdist)) continue;
            bestdist = dist;
            bp = p;
        }
        return bp;
    }

    public EntityItem getClosestItemVertical(InvItem item, int radius, int vertical) {
        return this.getClosestItemVertical(new InvItem[]{item}, radius, vertical);
    }

    public EntityItem getClosestItemVertical(InvItem[] items, int radius, int vertical) {
        return MillCommonUtilities.getClosestItemVertical(this.field_70170_p, this.getPos(), items, radius, vertical);
    }

    public Point getClosestToHouse(List<Point> points) {
        double bestdist = Double.MAX_VALUE;
        Point bp = null;
        for (Point p : points) {
            double dist = p.distanceToSquared(this.house.getPos());
            if (!(dist < bestdist)) continue;
            bestdist = dist;
            bp = p;
        }
        return bp;
    }

    public ResourceLocation getClothTexturePath() {
        return this.clothTexture;
    }

    public Culture getCulture() {
        if (this.vtype == null) {
            return null;
        }
        return this.vtype.culture;
    }

    public Entity func_70777_m() {
        return this.field_70789_a;
    }

    public ItemStack func_71124_b(int par1) {
        if (par1 > 0) {
            return this.func_130225_q(par1 - 1);
        }
        return this.heldItem;
    }

    protected int func_70693_a(EntityPlayer par1EntityPlayer) {
        return this.vtype.expgiven;
    }

    public String getFemaleChild() {
        return this.vtype.femaleChild;
    }

    public String getGameOccupationName(String playername) {
        if (this.getCulture() == null || this.vtype == null) {
            return "";
        }
        if (!this.getCulture().canReadVillagerNames(playername)) {
            return "";
        }
        if (this.func_70631_g_() && this.size == 20) {
            return this.getCulture().getCultureString("villager." + this.vtype.altkey);
        }
        return this.getCulture().getCultureString("villager." + this.vtype.key);
    }

    public String getGameSpeech(String playername) {
        if (this.getCulture() == null) {
            return null;
        }
        String speech = MillCommonUtilities.getVillagerSentence(this, playername, false);
        if (speech != null) {
            int duration = 10 + speech.length() / 5;
            if (this.speech_started + (long)(20 * (duration = Math.min(duration, 30))) < this.field_70170_p.func_72820_D()) {
                return null;
            }
        }
        return speech;
    }

    public int getGatheringRange() {
        return 20;
    }

    public String getGenderString() {
        if (this.gender == 1) {
            return "male";
        }
        return "female";
    }

    public Building getGoalBuildingDest() {
        return this.mw.getBuilding(this.getGoalBuildingDestPoint());
    }

    public Point getGoalBuildingDestPoint() {
        if (this.goalInformation == null) {
            return null;
        }
        return this.goalInformation.getDestBuildingPos();
    }

    public Entity getGoalDestEntity() {
        if (this.goalInformation == null) {
            return null;
        }
        return this.goalInformation.getTargetEnt();
    }

    public Point getGoalDestPoint() {
        if (this.goalInformation == null) {
            return null;
        }
        return this.goalInformation.getDest();
    }

    public String getGoalLabel(String goal) {
        if (Goal.goals.containsKey(goal)) {
            return Goal.goals.get(goal).gameName(this);
        }
        return "none";
    }

    public Goal[] getGoals() {
        if (this.vtype != null) {
            return this.vtype.goals;
        }
        return null;
    }

    public InvItem[] getGoodsToBringBackHome() {
        return this.vtype.bringBackHomeGoods;
    }

    public InvItem[] getGoodsToCollect() {
        return this.vtype.collectGoods;
    }

    public ItemStack func_70694_bm() {
        return this.heldItem;
    }

    public int getHireCost(EntityPlayer player) {
        int cost = this.vtype.hireCost;
        if (this.getTownHall().controlledBy(player.getDisplayName())) {
            cost /= 2;
        }
        return cost;
    }

    public Building getHouse() {
        if (this.house != null) {
            return this.house;
        }
        if (MLN.LogVillager >= 3 && this.extraLog) {
            MLN.debug(this, "Seeking uncached house");
        }
        if (this.mw != null) {
            this.house = this.mw.getBuilding(this.housePoint);
            return this.house;
        }
        return null;
    }

    public Set<InvItem> getInventoryKeys() {
        return this.inventory.keySet();
    }

    public String getMaleChild() {
        return this.vtype.maleChild;
    }

    public int getMerchantSellPrice(Goods g) {
        return this.merchantSells.get(g);
    }

    public String getName() {
        return this.firstName + " " + this.familyName;
    }

    public String getNameKey() {
        if (this.vtype == null) {
            return "";
        }
        if (this.func_70631_g_() && this.size == 20) {
            return this.vtype.altkey;
        }
        return this.vtype.key;
    }

    public String getNativeOccupationName() {
        if (this.vtype == null) {
            return null;
        }
        if (this.func_70631_g_() && this.size == 20) {
            return this.vtype.altname;
        }
        return this.vtype.name;
    }

    public String getNativeSpeech(String playername) {
        if (this.getCulture() == null) {
            return null;
        }
        String speech = MillCommonUtilities.getVillagerSentence(this, playername, true);
        if (speech != null) {
            int duration = 10 + speech.length() / 5;
            if (this.speech_started + (long)(20 * (duration = Math.min(duration, 30))) < this.field_70170_p.func_72820_D()) {
                return null;
            }
        }
        return speech;
    }

    public int getNewGender(Building th) {
        return this.vtype.gender;
    }

    public String getNewName() {
        return this.getCulture().getRandomNameFromList(this.vtype.firstNameList);
    }

    public ResourceLocation getNewTexture() {
        if (this.vtype != null) {
            return new ResourceLocation("millenaire", this.vtype.getTexture());
        }
        return null;
    }

    public Point getPathDestPoint() {
        return this.pathDestPoint;
    }

    private AStarConfig getPathingConfig() {
        if (this.goalKey != null) {
            return Goal.goals.get(this.goalKey).getPathingConfig();
        }
        return DEFAULT_JPS_CONFIG;
    }

    public PathPoint getPathPointPos() {
        return new PathPoint(MathHelper.func_76128_c((double)this.field_70121_D.field_72340_a), MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b), MathHelper.func_76128_c((double)this.field_70121_D.field_72339_c));
    }

    public Point getPos() {
        return new Point(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    public String getRandomFamilyName() {
        return this.getCulture().getRandomNameFromList(this.vtype.familyNameList);
    }

    public VillagerRecord getRecord() {
        if (this.getTownHall() != null && this.getTownHall().vrecords != null) {
            for (VillagerRecord vr : this.getTownHall().vrecords) {
                if (vr.id != this.villager_id) continue;
                return vr;
            }
        }
        if (this.getHouse() != null && this.getHouse().vrecords != null) {
            for (VillagerRecord vr : this.getHouse().vrecords) {
                if (vr.id != this.villager_id) continue;
                return vr;
            }
        }
        return null;
    }

    public MillVillager getSpouse() {
        if (this.getHouse() == null || this.func_70631_g_()) {
            return null;
        }
        for (MillVillager v : this.getHouse().villagers) {
            if (v.func_70631_g_() || v.gender == this.gender) continue;
            return v;
        }
        return null;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public InvItem[] getToolsNeeded() {
        if (this.vtype != null) {
            return this.vtype.toolsNeeded;
        }
        return null;
    }

    public int func_70658_aO() {
        int total = 0;
        for (int i = 0; i < 4; ++i) {
            ItemStack armour = this.func_130225_q(i);
            if (armour == null || !(armour.func_77973_b() instanceof ItemArmor)) continue;
            total += ((ItemArmor)armour.func_77973_b()).field_77879_b;
        }
        return total;
    }

    public Building getTownHall() {
        if (this.townHall != null) {
            return this.townHall;
        }
        if (MLN.LogVillager >= 3 && this.extraLog) {
            MLN.debug(this, "Seeking uncached townHall");
        }
        if (this.mw != null) {
            this.townHall = this.mw.getBuilding(this.townHallPoint);
            return this.townHall;
        }
        return null;
    }

    public ItemStack getWeapon() {
        if (this.isUsingBow) {
            for (Item weapon : weaponsBow) {
                if (this.countInv(weapon) <= 0) continue;
                return new ItemStack(weapon, 1);
            }
        }
        if (this.isUsingHandToHand || !this.vtype.isArcher) {
            for (Item weapon : weaponsHandToHand) {
                if (this.countInv(weapon) <= 0) continue;
                return new ItemStack(weapon, 1);
            }
            if (this.vtype != null && this.vtype.startingWeapon != null) {
                return new ItemStack(this.vtype.startingWeapon.getItem(), 1, this.vtype.startingWeapon.meta);
            }
        }
        for (Item weapon : weapons) {
            if (this.countInv(weapon) <= 0) continue;
            return new ItemStack(weapon, 1);
        }
        if (this.vtype != null && this.vtype.startingWeapon != null) {
            return new ItemStack(this.vtype.startingWeapon.getItem(), 1, this.vtype.startingWeapon.meta);
        }
        return null;
    }

    public void growSize() {
        int growth = 2;
        int nb = 0;
        nb = this.getHouse().takeGoods(Items.field_151110_aK, 1);
        if (nb == 1) {
            growth += 1 + MillCommonUtilities.randomInt(5);
        }
        for (int i = 0; i < foodGrowth.length; ++i) {
            if (growth >= 10 || this.size + growth >= 20 || (nb = this.getHouse().takeGoods(foodGrowth[i], 1)) != 1) continue;
            growth += foodGrowthValues[i] + MillCommonUtilities.randomInt(foodGrowthValues[i]);
        }
        this.size += growth;
        if (this.size > 20) {
            this.size = 20;
        }
        this.getRecord().villagerSize = this.size;
        this.adjustSize();
        if (MLN.LogChildren >= 2) {
            MLN.minor(this, "Child growing by " + growth + ", new size: " + this.size);
        }
    }

    private void handleDoorsAndFenceGates() {
        if (this.doorToClose != null) {
            if (this.pathEntity == null || this.pathEntity.func_75874_d() == 0 || this.pathEntity.getPastTargetPathPoint(2) != null && this.doorToClose.sameBlock(this.pathEntity.getPastTargetPathPoint(2))) {
                if (this.getBlock(this.doorToClose) == Blocks.field_150466_ao) {
                    int meta = this.getBlockMeta(this.doorToClose);
                    if ((meta & 4) == 4) {
                        this.toggleDoor(this.doorToClose.getiX(), this.doorToClose.getiY(), this.doorToClose.getiZ());
                    }
                    this.doorToClose = null;
                } else if (this.getBlock(this.doorToClose) == Blocks.field_150396_be) {
                    if (this.closeFenceGate(this.doorToClose.getiX(), this.doorToClose.getiY(), this.doorToClose.getiZ())) {
                        this.doorToClose = null;
                    }
                } else {
                    this.doorToClose = null;
                }
            }
        } else if (this.pathEntity != null && this.pathEntity.func_75874_d() > 0) {
            PathPoint p = null;
            if (this.pathEntity.getCurrentTargetPathPoint() != null && this.field_70170_p.func_147439_a(this.pathEntity.getCurrentTargetPathPoint().field_75839_a, this.pathEntity.getCurrentTargetPathPoint().field_75837_b, this.pathEntity.getCurrentTargetPathPoint().field_75838_c) == Blocks.field_150466_ao) {
                p = this.pathEntity.getCurrentTargetPathPoint();
            } else if (this.pathEntity.getNextTargetPathPoint() != null && this.field_70170_p.func_147439_a(this.pathEntity.getNextTargetPathPoint().field_75839_a, this.pathEntity.getNextTargetPathPoint().field_75837_b, this.pathEntity.getNextTargetPathPoint().field_75838_c) == Blocks.field_150466_ao) {
                p = this.pathEntity.getNextTargetPathPoint();
            }
            if (p != null) {
                int meta = this.field_70170_p.func_72805_g(p.field_75839_a, p.field_75837_b, p.field_75838_c);
                if ((meta & 4) == 0) {
                    this.toggleDoor(p.field_75839_a, p.field_75837_b, p.field_75838_c);
                    this.doorToClose = new Point(p);
                }
            } else {
                if (this.pathEntity.getNextTargetPathPoint() != null && this.field_70170_p.func_147439_a(this.pathEntity.getNextTargetPathPoint().field_75839_a, this.pathEntity.getNextTargetPathPoint().field_75837_b, this.pathEntity.getNextTargetPathPoint().field_75838_c) == Blocks.field_150396_be) {
                    p = this.pathEntity.getNextTargetPathPoint();
                } else if (this.pathEntity.getCurrentTargetPathPoint() != null && this.field_70170_p.func_147439_a(this.pathEntity.getCurrentTargetPathPoint().field_75839_a, this.pathEntity.getCurrentTargetPathPoint().field_75837_b, this.pathEntity.getCurrentTargetPathPoint().field_75838_c) == Blocks.field_150396_be) {
                    p = this.pathEntity.getCurrentTargetPathPoint();
                }
                if (p != null) {
                    this.openFenceGate(p.field_75839_a, p.field_75837_b, p.field_75838_c);
                    this.doorToClose = new Point(p);
                }
            }
        }
    }

    private boolean hasBow() {
        for (Item weapon : weaponsBow) {
            if (this.countInv(weapon) <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean hasChildren() {
        return this.vtype.maleChild != null && this.vtype.femaleChild != null;
    }

    public int hashCode() {
        return (int)this.villager_id;
    }

    public boolean helpsInAttacks() {
        return this.vtype.helpInAttacks;
    }

    public void initialise(VillagerType v, String familyName, boolean respawn) {
        this.vtype = v;
        this.villager_id = Math.abs(MillCommonUtilities.randomLong());
        this.gender = v.gender;
        this.firstName = this.getNewName();
        this.familyName = familyName;
        this.texture = this.getNewTexture();
        this.func_70606_j(this.func_110138_aP());
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)v.health);
        this.updateClothTexturePath();
        if (this.func_70631_g_()) {
            this.size = 0;
            this.scale = 0.5f;
        } else {
            this.scale = v.baseScale + (float)((MillCommonUtilities.randomInt(10) - 5) / 100);
        }
        if (!respawn) {
            for (InvItem item : v.startingInv.keySet()) {
                this.addToInv(item.getItem(), item.meta, (int)v.startingInv.get(item));
            }
        }
        this.registerInGlobalList();
    }

    public boolean func_70085_c(EntityPlayer entityplayer) {
        if (this.field_70170_p.field_72995_K || this.isVillagerSleeping()) {
            return true;
        }
        UserProfile profile = this.mw.getProfile(entityplayer.getDisplayName());
        entityplayer.func_71064_a((StatBase)MillAchievements.firstContact, 1);
        if (this.vtype != null && (this.vtype.key.equals("indian_sadhu") || this.vtype.key.equals("alchemist"))) {
            entityplayer.func_71064_a((StatBase)MillAchievements.maitreapenser, 1);
        }
        if (profile.villagersInQuests.containsKey(this.villager_id)) {
            Quest.QuestInstance qi = profile.villagersInQuests.get(this.villager_id);
            if (qi.getCurrentVillager().id == this.villager_id) {
                ServerSender.displayQuestGUI(entityplayer, this);
            } else {
                this.interactSpecial(entityplayer);
            }
        } else {
            this.interactSpecial(entityplayer);
        }
        if (MLN.DEV) {
            this.interactDev(entityplayer);
        }
        return true;
    }

    public void interactDev(EntityPlayer entityplayer) {
        DevModUtilities.villagerInteractDev(entityplayer, this);
    }

    public boolean interactSpecial(EntityPlayer entityplayer) {
        if (this.getTownHall() == null) {
            MLN.error(this, "Trying to interact with a villager with no TH.");
        }
        if (this.isChief()) {
            ServerSender.displayVillageChiefGUI(entityplayer, this);
            return true;
        }
        UserProfile profile = this.mw.getProfile(entityplayer.getDisplayName());
        if (this.canMeditate() && this.mw.isGlobalTagSet("pujas") || this.canPerformSacrifices() && this.mw.isGlobalTagSet("mayansacrifices")) {
            if (MLN.LogPujas >= 3) {
                MLN.debug(this, "canMeditate");
            }
            if (this.getTownHall().getReputation(entityplayer.getDisplayName()) >= -1024) {
                for (BuildingLocation l : this.getTownHall().getLocations()) {
                    if (l.level < 0 || l.getSellingPos() == null || !(l.getSellingPos().distanceTo((Entity)this) < 8.0)) continue;
                    Building b = l.getBuilding(this.field_70170_p);
                    if (b.pujas == null) continue;
                    if (MLN.LogPujas >= 3) {
                        MLN.debug(this, "Found shrine: " + b);
                    }
                    Point p = b.getPos();
                    entityplayer.openGui((Object)Mill.instance, 6, this.field_70170_p, p.getiX(), p.getiY(), p.getiZ());
                    return true;
                }
            } else {
                ServerSender.sendTranslatedSentence(entityplayer, 'f', "ui.sellerboycott", this.getName());
                return false;
            }
        }
        if (this.isSeller() && !this.getTownHall().controlledBy(entityplayer.getDisplayName())) {
            if (this.getTownHall().getReputation(entityplayer.getDisplayName()) >= -1024 && this.getTownHall().chestLocked) {
                for (BuildingLocation l : this.getTownHall().getLocations()) {
                    if (l.level < 0 || l.shop == null || l.shop.length() <= 0 || !(l.getSellingPos() != null && l.getSellingPos().distanceTo((Entity)this) < 5.0) && !(l.sleepingPos.distanceTo((Entity)this) < 5.0)) continue;
                    ServerSender.displayVillageTradeGUI(entityplayer, l.getBuilding(this.field_70170_p));
                    return true;
                }
            } else {
                if (!this.getTownHall().chestLocked) {
                    ServerSender.sendTranslatedSentence(entityplayer, 'f', "ui.sellernotcurrently possible", this.getName());
                    return false;
                }
                ServerSender.sendTranslatedSentence(entityplayer, 'f', "ui.sellerboycott", this.getName());
                return false;
            }
        }
        if (this.isForeignMerchant()) {
            ServerSender.displayMerchantTradeGUI(entityplayer, this);
            return true;
        }
        if (this.vtype.hireCost > 0) {
            if (this.hiredBy == null || this.hiredBy.equals(entityplayer.getDisplayName())) {
                ServerSender.displayHireGUI(entityplayer, this);
                return true;
            }
            ServerSender.sendTranslatedSentence(entityplayer, 'f', "hire.hiredbyotherplayer", this.getName(), this.hiredBy);
            return false;
        }
        if (this.isLocalMerchant() && !profile.villagersInQuests.containsKey(this.villager_id)) {
            ServerSender.sendTranslatedSentence(entityplayer, '6', "other.localmerchantinteract", this.getName(), this.hiredBy);
            return false;
        }
        return false;
    }

    public boolean isChief() {
        return this.vtype.isChief;
    }

    public boolean func_70631_g_() {
        if (this.vtype == null) {
            return false;
        }
        return this.vtype.isChild;
    }

    public boolean isForeignMerchant() {
        return this.vtype.isForeignMerchant;
    }

    public boolean isHostile() {
        return this.vtype.hostile;
    }

    public boolean isLocalMerchant() {
        return this.vtype.isLocalMerchant;
    }

    protected boolean func_70610_aX() {
        return this.func_110143_aJ() <= 0.0f || this.isVillagerSleeping();
    }

    public boolean isPriest() {
        return this.vtype.isReligious;
    }

    public boolean isReligious() {
        return this.vtype.isReligious;
    }

    public boolean isSeller() {
        return this.vtype.canSell;
    }

    public boolean isTextureValid(String texture) {
        if (this.vtype != null) {
            return this.vtype.isTextureValid(texture);
        }
        return true;
    }

    public boolean isVillagerSleeping() {
        return this.shouldLieDown;
    }

    public boolean isVisitor() {
        if (this.vtype == null) {
            return false;
        }
        return this.vtype.visitor;
    }

    private void jumpToDest() {
        Point jumpTo = MillCommonUtilities.findVerticalStandingPos(this.field_70170_p, this.getPathDestPoint());
        if (jumpTo != null && jumpTo.distanceTo(this.getPathDestPoint()) < 4.0) {
            if (MLN.LogPathing >= 1 && this.extraLog) {
                MLN.major(this, "Jumping from " + this.getPos() + " to " + jumpTo);
            }
            this.func_70107_b((double)jumpTo.getiX() + 0.5, (double)jumpTo.getiY() + 0.5, (double)jumpTo.getiZ() + 0.5);
            this.longDistanceStuck = 0;
            this.localStuck = 0;
        } else if (this.goalKey != null && Goal.goals.containsKey(this.goalKey)) {
            Goal goal = Goal.goals.get(this.goalKey);
            try {
                goal.unreachableDestination(this);
            }
            catch (Exception e) {
                MLN.printException(this + ": Exception in handling unreachable dest for goal " + this.goalKey, e);
            }
        }
    }

    public void killVillager() {
        VillagerRecord vr;
        EntityPlayer owner;
        if (this.field_70170_p.field_72995_K || !(this.field_70170_p instanceof WorldServer)) {
            super.func_70106_y();
            return;
        }
        for (InvItem iv : this.inventory.keySet()) {
            if (this.inventory.get(iv) <= 0) continue;
            MillCommonUtilities.spawnItem(this.field_70170_p, this.getPos(), new ItemStack(iv.getItem(), this.inventory.get(iv).intValue(), iv.meta), 0.0f);
        }
        if (this.hiredBy != null && (owner = this.field_70170_p.func_72924_a(this.hiredBy)) != null) {
            ServerSender.sendTranslatedSentence(owner, 'f', "hire.hiredied", this.getName());
        }
        if (this.getTownHall() != null && (vr = this.getTownHall().getVillagerRecordById(this.villager_id)) != null) {
            if (MLN.LogGeneralAI >= 1) {
                MLN.major(this, this.getTownHall() + ": Villager has been killed!");
            }
            vr.killed = true;
        }
        super.func_70106_y();
    }

    private void leaveVillage() {
        for (InvItem iv : this.vtype.foreignMerchantStock.keySet()) {
            this.getHouse().takeGoods(iv.getItem(), iv.meta, (int)this.vtype.foreignMerchantStock.get(iv));
        }
        this.getTownHall().deleteVillager(this);
        this.getTownHall().removeVillagerRecord(this.villager_id);
        this.getHouse().deleteVillager(this);
        this.getHouse().removeVillagerRecord(this.villager_id);
        this.despawnVillager();
    }

    public void localMerchantUpdate() throws Exception {
        if (this.getHouse() != null && this.getHouse() == this.getTownHall()) {
            List<Building> buildings = this.getTownHall().getBuildingsWithTag("inn");
            Building inn = null;
            for (Building building : buildings) {
                if (building.merchantRecord != null) continue;
                inn = building;
            }
            if (inn == null) {
                this.getHouse().removeVillagerRecord(this.villager_id);
                this.getHouse().deleteVillager(this);
                this.despawnVillager();
                MLN.error(this, "Merchant had Town Hall as house and inn is full. Killing him.");
            } else {
                this.setHousePoint(inn.getPos());
                this.getHouse().addOrReplaceVillager(this);
                this.getTownHall().removeVillagerRecord(this.villager_id);
                VillagerRecord vr = new VillagerRecord(this.mw, this);
                this.getHouse().addOrReplaceRecord(vr);
                this.getTownHall().addOrReplaceRecord(vr);
                MLN.error(this, "Merchant had Town Hall as house. Moving him to the inn.");
            }
        }
    }

    @Override
    public void onFoundPath(List<AStarNode> result) {
        this.pathCalculatedSinceLastTick = result;
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.func_82168_bl();
        this.setFacingDirection();
        if (this.isVillagerSleeping()) {
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
        }
    }

    @Override
    public void onNoPathAvailable() {
        this.pathFailedSincelastTick = true;
        if (MLN.LogPathing >= 2) {
            MLN.minor(this, "No path found between " + this.getPos() + " and " + this.getPathDestPoint() + " in " + (System.currentTimeMillis() - this.pathCalculationStartTime));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_70071_h_() {
        try {
            if (this.vtype == null) {
                if (this.field_70128_L) return;
                MLN.error(this, "Unknown villager type. Killing him.");
                this.despawnVillagerSilent();
                return;
            }
            this.registerInGlobalList();
            if (this.pathFailedSincelastTick) {
                this.pathFailedSinceLastTick();
            }
            if (this.pathCalculatedSinceLastTick != null) {
                this.applyPathCalculatedSinceLastTick();
            }
            if (MLN.DEV && this.goalKey != null) {
                Goal goal = Goal.goals.get(this.goalKey);
                if (this.getPathDestPoint() == null || this.jpsPathPlanner.isBusy() || this.pathEntity != null || this.stopMoving || this.goalKey == null || this.goalKey.equals("gorest") || this.getPathDestPoint().distanceTo(this.getPos()) > (double)goal.range(this)) {
                    // empty if block
                }
            }
            if (this.field_70170_p.field_72995_K) {
                super.func_70071_h_();
                try {
                    this.checkRegistration();
                    return;
                }
                catch (MLN.MillenaireException e) {
                    MLN.printException(this.getName(), e);
                }
                return;
            }
            long startTime = System.nanoTime();
            if (this.field_70128_L) {
                super.func_70071_h_();
                return;
            }
            if (this.hiredBy != null) {
                this.updateHired();
                super.func_70071_h_();
                return;
            }
            if (this.getTownHall() == null || this.getHouse() == null) {
                return;
            }
            if (this.getTownHall() != null && !this.getTownHall().isActive) {
                return;
            }
            try {
                ++this.timer;
                if (this.func_110143_aJ() < this.func_110138_aP() & MillCommonUtilities.randomInt(1600) == 0) {
                    this.func_70606_j(this.func_110143_aJ() + 1.0f);
                }
                this.detrampleCrops();
                this.allowRandomMoves = true;
                if (this.getTownHall() == null || this.getHouse() == null) {
                    super.func_70071_h_();
                    return;
                }
                this.checkRegistration();
                if (Goal.beSeller.key.equals(this.goalKey)) {
                    this.townHall.seller = this;
                } else if (Goal.getResourcesForBuild.key.equals(this.goalKey) || Goal.construction.key.equals(this.goalKey)) {
                    if (MLN.LogTileEntityBuilding >= 3) {
                        MLN.debug(this, "Registering as builder for: " + this.townHall);
                    }
                    this.townHall.builder = this;
                }
                if (this.getTownHall().underAttack) {
                    if (this.goalKey == null || !this.goalKey.equals(Goal.raidVillage.key) && !this.goalKey.equals(Goal.defendVillage.key) && !this.goalKey.equals(Goal.hide.key)) {
                        this.clearGoal();
                    }
                    if (this.isRaider) {
                        this.goalKey = Goal.raidVillage.key;
                        this.targetDefender();
                    } else if (this.helpsInAttacks()) {
                        this.goalKey = Goal.defendVillage.key;
                        this.targetRaider();
                    } else {
                        this.goalKey = Goal.hide.key;
                    }
                    this.checkGoals();
                }
                if (this.field_70789_a != null) {
                    if (this.vtype.isDefensive && this.getPos().distanceTo(this.getHouse().getResManager().getDefendingPos()) > 20.0) {
                        this.field_70789_a = null;
                    } else if (!this.field_70789_a.func_70089_S() || this.getPos().distanceTo(this.field_70789_a) > 80.0 || this.field_70170_p.field_73013_u == EnumDifficulty.PEACEFUL && this.field_70789_a instanceof EntityPlayer) {
                        this.field_70789_a = null;
                    }
                    if (this.field_70789_a != null) {
                        this.shouldLieDown = false;
                    }
                } else if (this.isHostile() && this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL && this.getTownHall().closestPlayer != null && this.getPos().distanceTo((Entity)this.getTownHall().closestPlayer) <= 80.0) {
                    int range = 80;
                    if (this.vtype.isDefensive) {
                        range = 20;
                    }
                    this.field_70789_a = this.field_70170_p.func_72977_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, (double)range);
                    this.clearGoal();
                }
                if (this.field_70789_a != null) {
                    this.setGoalDestPoint(new Point(this.field_70789_a));
                    this.heldItem = this.getWeapon();
                    if (this.goalKey != null && !Goal.goals.get(this.goalKey).isFightingGoal()) {
                        this.clearGoal();
                    }
                } else if (!this.getTownHall().underAttack) {
                    if (this.field_70170_p.func_72935_r()) {
                        EntityItem item;
                        this.speakSentence("greeting", 12000, 3, 10);
                        this.nightActionPerformed = false;
                        InvItem[] goods = this.getGoodsToCollect();
                        if (goods != null && (item = this.getClosestItemVertical(goods, 3, 30)) != null) {
                            item.func_70106_y();
                            if (item.func_92059_d().func_77973_b() == Item.func_150898_a((Block)Blocks.field_150345_g)) {
                                this.addToInv(item.func_92059_d().func_77973_b(), item.func_92059_d().func_77960_j() & 3, 1);
                            } else {
                                this.addToInv(item.func_92059_d().func_77973_b(), item.func_92059_d().func_77960_j(), 1);
                            }
                        }
                        this.specificUpdate();
                        if (!this.isRaider) {
                            if (this.goalKey == null) {
                                this.setNextGoal();
                            }
                            if (this.goalKey != null) {
                                this.checkGoals();
                            } else {
                                this.shouldLieDown = false;
                            }
                        }
                    } else {
                        this.hasPrayedToday = false;
                        this.hasDrunkToday = false;
                        if (!this.isRaider) {
                            if (this.goalKey == null) {
                                this.setNextGoal();
                            }
                            if (this.goalKey != null) {
                                this.checkGoals();
                            } else {
                                this.shouldLieDown = false;
                            }
                        }
                    }
                }
                if (this.getPathDestPoint() != null && this.pathEntity != null && this.pathEntity.func_75874_d() > 0 && !this.stopMoving) {
                    PathPoint nextPoint;
                    double newdistance;
                    double olddistance = this.prevPoint.horizontalDistanceToSquared(this.getPathDestPoint());
                    this.longDistanceStuck = olddistance - (newdistance = this.getPos().horizontalDistanceToSquared(this.getPathDestPoint())) < 2.0E-4 ? ++this.longDistanceStuck : --this.longDistanceStuck;
                    if (this.longDistanceStuck < 0) {
                        this.longDistanceStuck = 0;
                    }
                    if (this.pathEntity != null && this.pathEntity.func_75874_d() > 1 && MLN.LogPathing >= 2 && this.extraLog) {
                        MLN.minor(this, "Stuck: " + this.longDistanceStuck + " pos " + this.getPos() + " node: " + this.pathEntity.getCurrentTargetPathPoint() + " next node: " + this.pathEntity.getNextTargetPathPoint() + " dest: " + this.getPathDestPoint());
                    }
                    if (this.longDistanceStuck > 3000 && (!this.vtype.noTeleport || this.getRecord() != null && this.getRecord().raidingVillage)) {
                        this.jumpToDest();
                    }
                    if ((nextPoint = this.pathEntity.getNextTargetPathPoint()) != null) {
                        olddistance = this.prevPoint.distanceToSquared(nextPoint);
                        this.localStuck = olddistance - (newdistance = this.getPos().distanceToSquared(nextPoint)) < 2.0E-4 ? (this.localStuck += 4) : --this.localStuck;
                        if (this.localStuck < 0) {
                            this.localStuck = 0;
                        }
                        if (this.localStuck > 30) {
                            this.func_70778_a(null);
                            this.pathEntity = null;
                        }
                        if (this.localStuck > 100) {
                            this.func_70107_b((double)nextPoint.field_75839_a + 0.5, (double)nextPoint.field_75837_b + 0.5, (double)nextPoint.field_75838_c + 0.5);
                            this.localStuck = 0;
                        }
                    }
                } else {
                    this.longDistanceStuck = 0;
                    this.localStuck = 0;
                }
                if (this.getPathDestPoint() != null && !this.stopMoving) {
                    this.updatePathIfNeeded(this.getPathDestPoint());
                }
                if (this.stopMoving || this.jpsPathPlanner.isBusy()) {
                    this.func_70778_a(null);
                    this.pathEntity = null;
                }
                this.prevPoint = this.getPos();
                this.handleDoorsAndFenceGates();
                if (System.currentTimeMillis() - this.timeSinceLastPathingTimeDisplay > 10000L) {
                    if (this.pathingTime > 500L) {
                        if (this.getPathDestPoint() != null) {
                            MLN.warning(this, "Pathing time in last 10 secs: " + this.pathingTime + " dest: " + this.getPathDestPoint() + " dest bid: " + MillCommonUtilities.getBlock(this.field_70170_p, this.getPathDestPoint()) + " above bid: " + MillCommonUtilities.getBlock(this.field_70170_p, this.getPathDestPoint().getAbove()));
                        } else {
                            MLN.warning(this, "Pathing time in last 10 secs: " + this.pathingTime + " null dest point.");
                        }
                        MLN.warning(this, "nbPathsCalculated: " + this.nbPathsCalculated + " nbPathNoStart: " + this.nbPathNoStart + " nbPathNoEnd: " + this.nbPathNoEnd + " nbPathAborted: " + this.nbPathAborted + " nbPathFailure: " + this.nbPathFailure);
                        String s = "";
                        for (AStarPathing.PathKey p : this.abortedKeys) {
                            s = s + p + "     ";
                        }
                        MLN.warning(this, "Aborted keys: " + s);
                        if (this.goalKey != null) {
                            MLN.warning(this, "Current goal: " + Goal.goals.get(this.goalKey));
                        }
                    }
                    this.timeSinceLastPathingTimeDisplay = System.currentTimeMillis();
                    this.pathingTime = 0L;
                    this.nbPathsCalculated = 0;
                    this.nbPathNoStart = 0;
                    this.nbPathNoEnd = 0;
                    this.nbPathAborted = 0;
                    this.nbPathFailure = 0;
                    this.abortedKeys.clear();
                }
                this.sendVillagerPacket();
            }
            catch (MLN.MillenaireException e) {
                Mill.proxy.sendChatAdmin(this.getName() + ": Error in onUpdate(). Check millenaire.log.");
                MLN.error(this, e.getMessage());
            }
            catch (Exception e) {
                Mill.proxy.sendChatAdmin(this.getName() + ": Error in onUpdate(). Check millenaire.log.");
                MLN.error(this, "Exception in Villager.onUpdate(): ");
                MLN.printException(e);
            }
            this.triggerMobAttacks();
            this.updateDialogue();
            this.isUsingBow = false;
            this.isUsingHandToHand = false;
            for (int i = 0; i < 5; ++i) {
                if (this.func_71124_b(i) == null || this.func_71124_b(i).func_77973_b() != null) continue;
                MLN.printException("ItemStack with null item for villager " + this + ", goal: " + this.goalKey, new Exception());
            }
            super.func_70071_h_();
            double timeInMl = (double)(System.nanoTime() - startTime) / 1000000.0;
            if (!MLN.DEV) return;
            this.getTownHall().monitor.addToGoal(this.goalKey, timeInMl);
            if (this.getPathDestPoint() == null || this.jpsPathPlanner.isBusy() || this.pathEntity == null) {
                // empty if block
            }
            if (this.getPathDestPoint() != null && this.getGoalDestPoint() != null && !(this.getPathDestPoint().distanceTo(this.getGoalDestPoint()) > 20.0)) return;
        }
        catch (Exception e) {
            MLN.printException("Exception in onUpdate() of villager: " + this, e);
        }
    }

    private boolean openFenceGate(int i, int j, int k) {
        int l = this.field_70170_p.func_72805_g(i, j, k);
        if (!BlockFenceGate.func_149896_b((int)l)) {
            int i1 = (MathHelper.func_76128_c((double)((double)(this.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3) % 4;
            int j1 = BlockDirectional.func_149895_l((int)l);
            if (j1 == (i1 + 2) % 4) {
                l = i1;
            }
            MillCommonUtilities.setBlockMetadata(this.field_70170_p, i, j, k, l | 4, true);
        }
        return true;
    }

    private void pathFailedSinceLastTick() {
        if (this.pathfailure >= 20 && (!this.vtype.noTeleport || this.getRecord() != null && this.getRecord().raidingVillage)) {
            this.jumpToDest();
            this.pathfailure = 0;
        } else {
            ++this.pathfailure;
            Point p = MillCommonUtilities.findRandomStandingPosAround(this.field_70170_p, this.getPathDestPoint());
            this.jpsPathPlanner.stopPathSearch(true);
            if (p != null) {
                this.computeNewPath(p);
            } else {
                if (!this.vtype.noTeleport || this.getRecord() != null && this.getRecord().raidingVillage) {
                    this.jumpToDest();
                }
                this.pathfailure = 0;
            }
        }
        this.pathFailedSincelastTick = false;
    }

    public boolean performNightAction() {
        if (this.getRecord() == null || this.getHouse() == null || this.getTownHall() == null) {
            return false;
        }
        if (this.func_70631_g_()) {
            if (this.size < 20) {
                this.growSize();
            } else {
                this.teenagerNightAction();
            }
        }
        if (this.isForeignMerchant()) {
            this.foreignMerchantNightAction();
        }
        if (this.hasChildren()) {
            return this.attemptChildConception();
        }
        return true;
    }

    public int putInBuilding(Building building, Item item, int nb) {
        return this.putInBuilding(building, item, 0, nb);
    }

    public int putInBuilding(Building building, Item item, int meta, int nb) {
        nb = this.takeFromInv(item, meta, nb);
        building.storeGoods(item, meta, nb);
        return nb;
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        String type = nbttagcompound.func_74779_i("vtype");
        String culture = nbttagcompound.func_74779_i("culture");
        if (Culture.getCultureByName(culture) != null) {
            if (Culture.getCultureByName(culture).getVillagerType(type) != null) {
                this.vtype = Culture.getCultureByName(culture).getVillagerType(type);
            } else {
                MLN.error(this, "Could not load dynamic NPC: unknown type: " + type + " in culture: " + culture);
            }
        } else {
            MLN.error(this, "Could not load dynamic NPC: unknown culture: " + culture);
        }
        this.texture = new ResourceLocation("millenaire", nbttagcompound.func_74779_i("texture"));
        this.housePoint = Point.read(nbttagcompound, "housePos");
        if (this.housePoint == null) {
            MLN.error(this, "Error when loading villager: housePoint null");
            Mill.proxy.sendChatAdmin(this.getName() + ": Could not load house position. Check millenaire.log");
        }
        this.townHallPoint = Point.read(nbttagcompound, "townHallPos");
        if (this.townHallPoint == null) {
            MLN.error(this, "Error when loading villager: townHallPoint null");
            Mill.proxy.sendChatAdmin(this.getName() + ": Could not load town hall position. Check millenaire.log");
        }
        this.setGoalDestPoint(Point.read(nbttagcompound, "destPoint"));
        this.setPathDestPoint(Point.read(nbttagcompound, "pathDestPoint"));
        this.setGoalBuildingDestPoint(Point.read(nbttagcompound, "destBuildingPoint"));
        this.prevPoint = Point.read(nbttagcompound, "prevPoint");
        this.doorToClose = Point.read(nbttagcompound, "doorToClose");
        this.action = nbttagcompound.func_74762_e("action");
        this.goalKey = nbttagcompound.func_74779_i("goal");
        if (this.goalKey.trim().length() == 0) {
            this.goalKey = null;
        }
        if (this.goalKey != null && !Goal.goals.containsKey(this.goalKey)) {
            this.goalKey = null;
        }
        this.dialogueKey = nbttagcompound.func_74779_i("dialogueKey");
        this.dialogueStart = nbttagcompound.func_74763_f("dialogueStart");
        this.dialogueRole = nbttagcompound.func_74762_e("dialogueRole");
        this.dialogueColour = (char)nbttagcompound.func_74762_e("dialogueColour");
        this.dialogueChat = nbttagcompound.func_74767_n("dialogueChat");
        if (this.dialogueKey.trim().length() == 0) {
            this.dialogueKey = null;
        }
        this.familyName = nbttagcompound.func_74779_i("familyName");
        this.firstName = nbttagcompound.func_74779_i("firstName");
        this.scale = nbttagcompound.func_74760_g("scale");
        this.gender = nbttagcompound.func_74762_e("gender");
        if (nbttagcompound.func_74764_b("villager_lid")) {
            this.villager_id = Math.abs(nbttagcompound.func_74763_f("villager_lid"));
        }
        if (!this.isTextureValid(this.texture.func_110623_a())) {
            this.texture = this.getNewTexture();
        }
        NBTTagList nbttaglist = nbttagcompound.func_150295_c("inventory", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            int itemID = nbttagcompound1.func_74762_e("item");
            int itemMeta = nbttagcompound1.func_74762_e("meta");
            if (itemID == Block.func_149682_b((Block)Blocks.field_150364_r)) {
                itemMeta &= 3;
            }
            try {
                this.inventory.put(new InvItem(Item.func_150899_d((int)itemID), itemMeta), nbttagcompound1.func_74762_e("amount"));
                continue;
            }
            catch (MLN.MillenaireException e) {
                MLN.printException(e);
            }
        }
        nbttaglist = nbttagcompound.func_150295_c("inventoryNew", 10);
        MillCommonUtilities.readInventory(nbttaglist, this.inventory);
        this.previousBlock = Block.func_149729_e((int)nbttagcompound.func_74762_e("previousBlock"));
        this.previousBlockMeta = nbttagcompound.func_74762_e("previousBlockMeta");
        this.size = nbttagcompound.func_74762_e("size");
        this.hasPrayedToday = nbttagcompound.func_74767_n("hasPrayedToday");
        this.hasDrunkToday = nbttagcompound.func_74767_n("hasDrunkToday");
        this.hiredBy = nbttagcompound.func_74779_i("hiredBy");
        this.hiredUntil = nbttagcompound.func_74763_f("hiredUntil");
        this.aggressiveStance = nbttagcompound.func_74767_n("aggressiveStance");
        this.isRaider = nbttagcompound.func_74767_n("isRaider");
        if (this.hiredBy.equals("")) {
            this.hiredBy = null;
        }
        this.clothName = nbttagcompound.func_74779_i("clothName");
        this.clothTexture = new ResourceLocation("millenaire", nbttagcompound.func_74779_i("clothTexture"));
        if (this.clothName.equals("")) {
            this.clothName = null;
            this.clothTexture = null;
        }
        this.registerInGlobalList();
        this.updateClothTexturePath();
    }

    public void readSpawnData(ByteBuf ds) {
        ByteBufInputStream data = new ByteBufInputStream(ds);
        try {
            this.villager_id = data.readLong();
            this.readVillagerStreamdata((DataInput)data);
            this.registerInGlobalList();
        }
        catch (IOException e) {
            MLN.printException("Error in readSpawnData for villager " + this, e);
        }
    }

    private void readVillagerStreamdata(DataInput data) throws IOException {
        Entity ent;
        int goalDestEntityID;
        Culture culture = Culture.getCultureByName(StreamReadWrite.readNullableString(data));
        String vt = StreamReadWrite.readNullableString(data);
        if (culture != null) {
            this.vtype = culture.getVillagerType(vt);
        }
        this.texture = StreamReadWrite.readNullableResourceLocation(data);
        this.goalKey = StreamReadWrite.readNullableString(data);
        this.housePoint = StreamReadWrite.readNullablePoint(data);
        this.townHallPoint = StreamReadWrite.readNullablePoint(data);
        this.firstName = StreamReadWrite.readNullableString(data);
        this.familyName = StreamReadWrite.readNullableString(data);
        this.scale = data.readFloat();
        this.gender = data.readInt();
        this.size = data.readInt();
        this.hiredBy = StreamReadWrite.readNullableString(data);
        this.aggressiveStance = data.readBoolean();
        this.hiredUntil = data.readLong();
        this.isUsingBow = data.readBoolean();
        this.isUsingHandToHand = data.readBoolean();
        this.speech_key = StreamReadWrite.readNullableString(data);
        this.speech_variant = data.readInt();
        this.speech_started = data.readLong();
        this.heldItem = StreamReadWrite.readNullableItemStack(data);
        this.inventory = StreamReadWrite.readInventory(data);
        this.clothName = StreamReadWrite.readNullableString(data);
        this.clothTexture = StreamReadWrite.readNullableResourceLocation(data);
        this.setGoalDestPoint(StreamReadWrite.readNullablePoint(data));
        this.shouldLieDown = data.readBoolean();
        this.dialogueTargetFirstName = StreamReadWrite.readNullableString(data);
        this.dialogueTargetLastName = StreamReadWrite.readNullableString(data);
        this.dialogueColour = data.readChar();
        this.dialogueChat = data.readBoolean();
        this.func_70606_j(data.readFloat());
        int nbMerchantSells = data.readInt();
        if (nbMerchantSells > -1) {
            this.merchantSells.clear();
            for (int i = 0; i < nbMerchantSells; ++i) {
                try {
                    Goods g = StreamReadWrite.readNullableGoods(data);
                    this.merchantSells.put(g, data.readInt());
                    continue;
                }
                catch (MLN.MillenaireException e) {
                    MLN.printException(e);
                }
            }
        }
        if ((goalDestEntityID = data.readInt()) != -1 && (ent = this.field_70170_p.func_73045_a(goalDestEntityID)) != null) {
            this.setGoalDestEntity(ent);
        }
        this.client_lastupdated = this.field_70170_p.func_72820_D();
    }

    public void registerInGlobalList() {
        if (this.registeredInGlobalList) {
            if (MillCommonUtilities.chanceOn(20)) {
                if (!this.mw.villagers.containsKey(this.villager_id)) {
                    this.mw.villagers.put(this.villager_id, this);
                } else if (this.mw.villagers.get(this.villager_id) != null && this.mw.villagers.get(this.villager_id) != this && !this.mw.villagers.get((Object)Long.valueOf((long)this.villager_id)).field_70128_L) {
                    this.despawnVillagerSilent();
                }
            }
            return;
        }
        if (this.mw == null) {
            MLN.error(this, "Could not register as mw is null");
            return;
        }
        if (this.mw.villagers.containsKey(this.villager_id)) {
            this.mw.villagers.get(this.villager_id).despawnVillagerSilent();
        }
        this.mw.villagers.put(this.villager_id, this);
        this.registeredInGlobalList = true;
    }

    public void registerNewPath(AS_PathEntity path) throws Exception {
        if (path == null) {
            boolean handled = false;
            if (this.goalKey != null) {
                Goal goal = Goal.goals.get(this.goalKey);
                handled = goal.unreachableDestination(this);
            }
            if (!handled) {
                this.clearGoal();
            }
        } else {
            this.func_70778_a(path);
            this.pathEntity = path;
            this.field_70702_br = 0.0f;
        }
        this.prevPathPoint = this.getPathPointPos();
        this.pathingWorker = null;
    }

    public void registerNewPath(List<PathPoint> result) throws Exception {
        AS_PathEntity path = null;
        if (result != null) {
            PathPoint[] pointsCopy = new PathPoint[result.size()];
            int i = 0;
            for (PathPoint p : result) {
                PathPoint p2;
                pointsCopy[i] = p == null ? null : (p2 = new PathPoint(p.field_75839_a, p.field_75837_b, p.field_75838_c));
                ++i;
            }
            path = new AS_PathEntity(pointsCopy);
        }
        this.registerNewPath(path);
    }

    public void registerNewPathException(Exception e) {
        if (e instanceof AStarPathing.PathingException && ((AStarPathing.PathingException)e).errorCode == AStarPathing.PathingException.UNREACHABLE_START) {
            if (MLN.LogPathing >= 1 && this.extraLog) {
                MLN.major(this, "Unreachable start. Jumping back home.");
            }
            this.func_70107_b(this.getHouse().getResManager().getSleepingPos().x + 0.5, this.getHouse().getResManager().getSleepingPos().y + 1.0, this.getHouse().getResManager().getSleepingPos().z + 0.5);
        }
        this.pathingWorker = null;
    }

    public void registerNewPathInterrupt(AStarPathing.PathingWorker worker) {
        if (this.pathingWorker == worker) {
            this.pathingWorker = null;
        }
    }

    public HashMap<InvItem, Integer> requiresGoods() {
        if (this.func_70631_g_() && this.size < 20) {
            return this.vtype.requiredFoodAndGoods;
        }
        if (this.hasChildren() && this.getHouse().villagers.size() < 4) {
            return this.vtype.requiredFoodAndGoods;
        }
        return this.vtype.requiredGoods;
    }

    private void sendVillagerPacket() {
        DataOutput data = ServerSender.getNewByteBufOutputStream();
        try {
            data.write(3);
            this.writeVillagerStreamData(data, false);
        }
        catch (IOException e) {
            MLN.printException(this + ": Error in sendVillagerPacket", e);
        }
        ServerSender.sendPacketToPlayersInRange(data, this.getPos(), 30);
    }

    public boolean setBlock(Point p, Block block) {
        return MillCommonUtilities.setBlock(this.field_70170_p, p, block, true, true);
    }

    public boolean setBlockAndMetadata(Point p, Block block, int metadata) {
        return MillCommonUtilities.setBlockAndMetadata(this.field_70170_p, p, block, metadata, true, true);
    }

    public boolean setBlockMetadata(Point p, int metadata) {
        return MillCommonUtilities.setBlockMetadata(this.field_70170_p, p, metadata);
    }

    public void func_70106_y() {
        if (this.func_110143_aJ() <= 0.0f) {
            this.killVillager();
        }
    }

    public void setEntityToAttack(Entity ent) {
        this.field_70789_a = ent;
    }

    private void setFacingDirection() {
        if (this.field_70789_a != null) {
            this.faceEntityMill(this.field_70789_a, 30.0f, 30.0f);
            return;
        }
        if (this.goalKey != null && (this.getGoalDestPoint() != null || this.getGoalDestEntity() != null)) {
            EntityPlayer player;
            Goal goal = Goal.goals.get(this.goalKey);
            if (goal.lookAtGoal()) {
                if (this.getGoalDestEntity() != null && this.getPos().distanceTo(this.getGoalDestEntity()) < (double)goal.range(this)) {
                    this.faceEntityMill(this.getGoalDestEntity(), 10.0f, 10.0f);
                } else if (this.getGoalDestPoint() != null && this.getPos().distanceTo(this.getGoalDestPoint()) < (double)goal.range(this)) {
                    this.facePoint(this.getGoalDestPoint(), 10.0f, 10.0f);
                }
            }
            if (goal.lookAtPlayer() && (player = this.field_70170_p.func_72890_a((Entity)this, 10.0)) != null) {
                this.faceEntityMill((Entity)player, 10.0f, 10.0f);
                return;
            }
        }
    }

    public void setGoalBuildingDestPoint(Point newDest) {
        if (this.goalInformation == null) {
            this.goalInformation = new Goal.GoalInformation(null, null, null);
        }
        this.goalInformation.setDestBuildingPos(newDest);
    }

    public void setGoalDestEntity(Entity ent) {
        if (this.goalInformation == null) {
            this.goalInformation = new Goal.GoalInformation(null, null, null);
        }
        this.goalInformation.setTargetEnt(ent);
        if (ent != null) {
            this.setPathDestPoint(new Point(ent));
        }
        if (ent instanceof MillVillager) {
            MillVillager v = (MillVillager)ent;
            this.dialogueTargetFirstName = v.firstName;
            this.dialogueTargetLastName = v.familyName;
        }
    }

    public void setGoalDestPoint(Point newDest) {
        if (this.goalInformation == null) {
            this.goalInformation = new Goal.GoalInformation(null, null, null);
        }
        this.goalInformation.setDest(newDest);
        this.setPathDestPoint(newDest);
    }

    public void setGoalInformation(Goal.GoalInformation info) {
        this.goalInformation = info;
        if (info != null) {
            if (info.getTargetEnt() != null) {
                this.setPathDestPoint(new Point(info.getTargetEnt()));
            } else if (info.getDest() != null) {
                this.setPathDestPoint(info.getDest());
            } else {
                this.setPathDestPoint(null);
            }
        } else {
            this.setPathDestPoint(null);
        }
    }

    public void setHousePoint(Point p) {
        this.housePoint = p;
        this.house = null;
    }

    public void setInv(Item item, int nb) {
        this.setInv(item, 0, nb);
    }

    public void setInv(Item item, int meta, int nb) {
        try {
            this.inventory.put(new InvItem(item, meta), nb);
        }
        catch (MLN.MillenaireException e) {
            MLN.printException(e);
        }
        if (this.getTownHall() != null) {
            this.getTownHall().updateVillagerRecord(this);
        }
    }

    public void setNextGoal() throws Exception {
        Goal nextGoal = null;
        this.clearGoal();
        for (Goal goal : this.getGoals()) {
            if (!goal.isPossible(this)) continue;
            if (MLN.LogGeneralAI >= 2 && this.extraLog) {
                MLN.minor(this, "Priority for goal " + goal.gameName(this) + ": " + goal.priority(this));
            }
            if (nextGoal != null && nextGoal.priority(this) >= goal.priority(this)) continue;
            nextGoal = goal;
        }
        if (MLN.LogGeneralAI >= 2 && this.extraLog) {
            MLN.minor(this, "Selected this: " + nextGoal);
        }
        if (MLN.LogBuildingPlan >= 1 && nextGoal != null && nextGoal.key.equals(Goal.getResourcesForBuild.key)) {
            MLN.major(this, this.getName() + " is new builder, for: " + this.townHall.getCurrentBuildingPlan() + ". Blocks loaded: " + this.townHall.getBblocks().length);
        }
        if (nextGoal != null) {
            this.speakSentence(nextGoal.key + ".chosen");
            this.goalKey = nextGoal.key;
            this.heldItem = null;
            this.heldItemCount = Integer.MAX_VALUE;
            nextGoal.onAccept(this);
            this.goalStarted = System.currentTimeMillis();
            this.lastGoalTime.put(nextGoal, this.field_70170_p.func_72820_D());
        } else {
            this.goalKey = null;
        }
    }

    public void setPathDestPoint(Point newDest) {
        if (newDest == null || !newDest.equals(this.pathDestPoint)) {
            this.func_70778_a(null);
            this.pathEntity = null;
        }
        this.pathDestPoint = newDest;
    }

    public void setTexture(ResourceLocation tx) {
        this.texture = tx;
    }

    public void setTownHallPoint(Point p) {
        this.townHallPoint = p;
        this.townHall = null;
    }

    public void speakSentence(String key) {
        this.speakSentence(key, 600, 3, 1);
    }

    public void speakSentence(String key, int chanceOn) {
        this.speakSentence(key, 600, 3, chanceOn);
    }

    public void speakSentence(String key, int delay, int distance, int chanceOn) {
        if ((long)delay > this.field_70170_p.func_72820_D() - this.speech_started) {
            return;
        }
        if (!MillCommonUtilities.chanceOn(chanceOn)) {
            return;
        }
        if (this.getTownHall() == null || this.getTownHall().closestPlayer == null || this.getPos().distanceTo((Entity)this.getTownHall().closestPlayer) > (double)distance) {
            return;
        }
        key = key.toLowerCase();
        this.speech_key = null;
        if (this.getCulture().hasSentences(this.getNameKey() + "." + key)) {
            this.speech_key = this.getNameKey() + "." + key;
        } else if (this.getCulture().hasSentences(this.getGenderString() + "." + key)) {
            this.speech_key = this.getGenderString() + "." + key;
        } else if (this.getCulture().hasSentences("villager." + key)) {
            this.speech_key = "villager." + key;
        }
        if (this.speech_key != null) {
            this.speech_variant = MillCommonUtilities.randomInt(this.getCulture().getSentences(this.speech_key).size());
            this.speech_started = this.field_70170_p.func_72820_D();
            this.sendVillagerPacket();
            ServerSender.sendVillageSentenceInRange(this.field_70170_p, this.getPos(), 30, this);
        }
    }

    public void specificUpdate() throws Exception {
        if (this.isLocalMerchant()) {
            this.localMerchantUpdate();
        }
        if (this.isForeignMerchant()) {
            this.foreignMerchantUpdate();
        }
    }

    public int takeFromBuilding(Building building, InvItem ii, int nb) {
        return this.takeFromBuilding(building, ii.getItem(), ii.meta, nb);
    }

    public int takeFromBuilding(Building building, Item item, int nb) {
        return this.takeFromBuilding(building, item, 0, nb);
    }

    public int takeFromBuilding(Building building, Item item, int meta, int nb) {
        if (item == Item.func_150898_a((Block)Blocks.field_150364_r) && meta == -1) {
            int total = 0;
            int nb2 = building.takeGoods(item, 0, nb);
            this.addToInv(item, 0, nb2);
            total += nb2;
            nb2 = building.takeGoods(item, 0, nb - total);
            this.addToInv(item, 0, nb2);
            total += nb2;
            nb2 = building.takeGoods(item, 0, nb - total);
            this.addToInv(item, 0, nb2);
            return total += nb2;
        }
        nb = building.takeGoods(item, meta, nb);
        this.addToInv(item, meta, nb);
        return nb;
    }

    public int takeFromInv(Block block, int nb) {
        return this.takeFromInv(Item.func_150898_a((Block)block), 0, nb);
    }

    public int takeFromInv(Block block, int meta, int nb) {
        return this.takeFromInv(Item.func_150898_a((Block)block), meta, nb);
    }

    public int takeFromInv(InvItem item, int nb) {
        return this.takeFromInv(item.getItem(), item.meta, nb);
    }

    public int takeFromInv(Item item, int nb) {
        return this.takeFromInv(item, 0, nb);
    }

    public int takeFromInv(Item item, int meta, int nb) {
        if (item == Item.func_150898_a((Block)Blocks.field_150364_r) && meta == -1) {
            int total = 0;
            try {
                for (int i = 0; i < 16; ++i) {
                    InvItem key = new InvItem(item, i);
                    if (!this.inventory.containsKey(key)) continue;
                    int nb2 = Math.min(nb, this.inventory.get(key));
                    this.inventory.put(key, this.inventory.get(key) - nb2);
                    total += nb2;
                }
                if (this.getTownHall() != null) {
                    this.getTownHall().updateVillagerRecord(this);
                }
            }
            catch (MLN.MillenaireException e) {
                MLN.printException(e);
            }
            return total;
        }
        try {
            InvItem key = new InvItem(item, meta);
            if (this.inventory.containsKey(key)) {
                nb = Math.min(nb, this.inventory.get(key));
                this.inventory.put(key, this.inventory.get(key) - nb);
                if (this.getTownHall() != null) {
                    this.getTownHall().updateVillagerRecord(this);
                }
                this.updateClothTexturePath();
                return nb;
            }
            return 0;
        }
        catch (MLN.MillenaireException e) {
            MLN.printException(e);
            return 0;
        }
    }

    private void targetDefender() {
        int bestDist = Integer.MAX_VALUE;
        MillVillager target = null;
        for (MillVillager v : this.getTownHall().villagers) {
            if (!v.helpsInAttacks() || v.isRaider || !(this.getPos().distanceToSquared((Entity)v) < (double)bestDist)) continue;
            target = v;
            bestDist = (int)this.getPos().distanceToSquared((Entity)v);
        }
        if (target != null && this.getPos().distanceToSquared((Entity)target) <= 25.0) {
            this.field_70789_a = target;
        }
    }

    private void targetRaider() {
        int bestDist = Integer.MAX_VALUE;
        MillVillager target = null;
        for (MillVillager v : this.getTownHall().villagers) {
            if (!v.isRaider || !(this.getPos().distanceToSquared((Entity)v) < (double)bestDist)) continue;
            target = v;
            bestDist = (int)this.getPos().distanceToSquared((Entity)v);
        }
        if (target != null && this.getPos().distanceToSquared((Entity)target) <= 25.0) {
            this.field_70789_a = target;
        }
    }

    private void teenagerNightAction() {
        for (Point p : this.getTownHall().getKnownVillages()) {
            Building distantVillage;
            if (this.getTownHall().getRelationWithVillage(p) <= 90 || (distantVillage = this.mw.getBuilding(p)) == null || distantVillage.culture != this.getCulture() || distantVillage == this.getTownHall()) continue;
            boolean canMoveIn = false;
            if (MLN.LogChildren >= 1) {
                MLN.major(this, "Attempting to move to village: " + distantVillage.getVillageQualifiedName());
            }
            Building distantInn = null;
            for (Building distantBuilding : distantVillage.getBuildings()) {
                if (!canMoveIn && distantBuilding != null && distantBuilding.isHouse()) {
                    if (!distantBuilding.canChildMoveIn(this.gender, this.familyName)) continue;
                    canMoveIn = true;
                    continue;
                }
                if (distantInn != null || !distantBuilding.isInn || distantBuilding.vrecords.size() >= 2) continue;
                distantInn = distantBuilding;
            }
            if (!canMoveIn || distantInn == null) continue;
            if (MLN.LogChildren >= 1) {
                MLN.major(this, "Moving to village: " + distantVillage.getVillageQualifiedName());
            }
            this.getHouse().transferVillager(this.getHouse().getVillagerRecordById(this.villager_id), distantInn, false);
            distantInn.visitorsList.add("panels.childarrived;" + this.getName() + ";" + this.getTownHall().getVillageQualifiedName());
        }
    }

    public boolean teleportTo(double d, double d1, double d2) {
        int k;
        int j;
        double d3 = this.field_70165_t;
        double d4 = this.field_70163_u;
        double d5 = this.field_70161_v;
        this.field_70165_t = d;
        this.field_70163_u = d1;
        this.field_70161_v = d2;
        boolean flag = false;
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        if (this.field_70170_p.func_72899_e(i, j = MathHelper.func_76128_c((double)this.field_70163_u), k = MathHelper.func_76128_c((double)this.field_70161_v))) {
            boolean flag1 = false;
            while (!flag1 && j > 0) {
                Block block = this.field_70170_p.func_147439_a(i, j - 1, k);
                if (block == Blocks.field_150350_a || !block.func_149688_o().func_76230_c()) {
                    this.field_70163_u -= 1.0;
                    --j;
                    continue;
                }
                flag1 = true;
            }
            if (flag1) {
                this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                if (this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D).size() == 0 && !this.field_70170_p.func_72953_d(this.field_70121_D)) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            this.func_70107_b(d3, d4, d5);
            return false;
        }
        return true;
    }

    public boolean teleportToEntity(Entity entity) {
        Vec3 vec3d = Vec3.func_72443_a((double)(this.field_70165_t - entity.field_70165_t), (double)(this.field_70121_D.field_72338_b + (double)(this.field_70131_O / 2.0f) - entity.field_70163_u + (double)entity.func_70047_e()), (double)(this.field_70161_v - entity.field_70161_v));
        vec3d = vec3d.func_72432_b();
        double d = 16.0;
        double d1 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3d.field_72450_a * 16.0;
        double d2 = this.field_70163_u + (double)(this.field_70146_Z.nextInt(16) - 8) - vec3d.field_72448_b * 16.0;
        double d3 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3d.field_72449_c * 16.0;
        return this.teleportTo(d1, d2, d3);
    }

    private void toggleDoor(int i, int j, int k) {
        int l = this.field_70170_p.func_72805_g(i, j, k);
        MillCommonUtilities.setBlockMetadata(this.field_70170_p, i, j, k, l ^ 4, true);
        this.field_70170_p.func_147458_c(i, j - 1, k, i, j, k);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + ": " + this.getName() + "/" + this.villager_id + "/" + this.field_70170_p;
    }

    private void triggerMobAttacks() {
        List<Entity> entities = MillCommonUtilities.getEntitiesWithinAABB(this.field_70170_p, EntityMob.class, this.getPos(), 16, 5);
        for (Entity ent : entities) {
            EntityMob mob = (EntityMob)ent;
            if (mob.func_70777_m() != null || !mob.func_70685_l((Entity)this)) continue;
            mob.func_70784_b((Entity)this);
        }
    }

    private void updateClothTexturePath() {
        if (this.vtype == null) {
            return;
        }
        String bestClothName = null;
        int clothLevel = -1;
        if (this.vtype.getRandomClothTexture(FREE_CLOTHES) != null) {
            bestClothName = FREE_CLOTHES;
            clothLevel = 0;
        }
        for (InvItem iv : this.inventory.keySet()) {
            if (iv.item != Mill.clothes || this.inventory.get(iv) <= 0 || Mill.clothes.getClothPriority(iv.meta) <= clothLevel || this.vtype.getRandomClothTexture(Mill.clothes.getClothName(iv.meta)) == null) continue;
            bestClothName = Mill.clothes.getClothName(iv.meta);
            clothLevel = Mill.clothes.getClothPriority(iv.meta);
        }
        if (bestClothName != null) {
            if (!bestClothName.equals(this.clothName) || !this.vtype.isClothValid(this.clothName, this.clothTexture.func_110623_a())) {
                this.clothName = bestClothName;
                this.clothTexture = new ResourceLocation("millenaire", this.vtype.getRandomClothTexture(bestClothName));
            }
        } else {
            this.clothName = null;
            this.clothTexture = null;
        }
    }

    private void updateDialogue() {
        if (this.dialogueKey == null) {
            return;
        }
        Culture.CultureLanguage.Dialogue d = this.getCulture().getDialogue(this.dialogueKey);
        if (d == null) {
            this.dialogueKey = null;
            return;
        }
        long timePassed = this.field_70170_p.func_72820_D() - this.dialogueStart;
        if ((long)(d.timeDelays.get(d.timeDelays.size() - 1) + 100) < timePassed) {
            this.dialogueKey = null;
            return;
        }
        String toSpeakKey = null;
        for (int i = 0; i < d.speechBy.size(); ++i) {
            if (this.dialogueRole != d.speechBy.get(i) || timePassed < (long)d.timeDelays.get(i).intValue()) continue;
            toSpeakKey = "chat_" + d.key + "_" + i;
        }
        if (!(toSpeakKey == null || this.speech_key != null && this.speech_key.contains(toSpeakKey))) {
            this.speakSentence(toSpeakKey, 0, 10, 1);
        }
    }

    private void updateHired() {
        try {
            if (this.func_110143_aJ() < this.func_110138_aP() & MillCommonUtilities.randomInt(1600) == 0) {
                this.func_70606_j(this.func_110143_aJ() + 1.0f);
            }
            EntityPlayer entityplayer = this.field_70170_p.func_72924_a(this.hiredBy);
            if (this.field_70170_p.func_72820_D() > this.hiredUntil) {
                if (entityplayer != null) {
                    ServerSender.sendTranslatedSentence(entityplayer, 'f', "hire.hireover", this.getName());
                }
                this.hiredBy = null;
                this.hiredUntil = 0L;
                VillagerRecord vr = this.getTownHall().getVillagerRecordById(this.villager_id);
                if (vr != null) {
                    vr.awayhired = false;
                }
                return;
            }
            if (this.field_70789_a != null) {
                if (this.getPos().distanceTo(this.field_70789_a) > 80.0 || this.field_70170_p.field_73013_u == EnumDifficulty.PEACEFUL) {
                    this.field_70789_a = null;
                }
            } else if (this.isHostile() && this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL && this.getTownHall().closestPlayer != null && this.getPos().distanceTo((Entity)this.getTownHall().closestPlayer) <= 80.0) {
                this.field_70789_a = this.field_70170_p.func_72977_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, 100.0);
            }
            if (this.field_70789_a == null) {
                List list = this.field_70170_p.func_72872_a(EntityCreature.class, AxisAlignedBB.func_72330_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)(this.field_70165_t + 1.0), (double)(this.field_70163_u + 1.0), (double)(this.field_70161_v + 1.0)).func_72314_b(16.0, 8.0, 16.0));
                for (Object o : list) {
                    EntityCreature creature;
                    if (this.field_70789_a != null || (creature = (EntityCreature)o).func_70777_m() != entityplayer || creature instanceof EntityCreeper) continue;
                    this.field_70789_a = creature;
                }
                if (this.field_70789_a == null && this.aggressiveStance) {
                    list = this.field_70170_p.func_72872_a(EntityMob.class, AxisAlignedBB.func_72330_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)(this.field_70165_t + 1.0), (double)(this.field_70163_u + 1.0), (double)(this.field_70161_v + 1.0)).func_72314_b(16.0, 8.0, 16.0));
                    if (!list.isEmpty()) {
                        this.field_70789_a = (Entity)list.get(this.field_70170_p.field_73012_v.nextInt(list.size()));
                        if (this.field_70789_a instanceof EntityCreeper) {
                            this.field_70789_a = null;
                        }
                    }
                    if (this.field_70789_a == null) {
                        list = this.field_70170_p.func_72872_a(MillVillager.class, AxisAlignedBB.func_72330_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)(this.field_70165_t + 1.0), (double)(this.field_70163_u + 1.0), (double)(this.field_70161_v + 1.0)).func_72314_b(16.0, 8.0, 16.0));
                        for (Object o : list) {
                            MillVillager villager;
                            if (this.field_70789_a != null || !(villager = (MillVillager)o).isHostile()) continue;
                            this.field_70789_a = villager;
                        }
                    }
                }
            }
            Entity target = null;
            if (this.field_70789_a != null) {
                target = this.field_70789_a;
                this.heldItem = this.getWeapon();
                PathEntity pathentity = this.field_70170_p.func_72865_a((Entity)this, target, 16.0f, true, false, false, true);
                if (pathentity != null) {
                    this.func_70778_a(pathentity);
                }
            } else {
                PathEntity pathentity;
                Entity player;
                this.heldItem = null;
                target = player = (Entity)this.mw.world.field_73010_i.get(0);
                int dist = (int)this.getPos().distanceTo(target);
                if (dist > 16) {
                    this.teleportToEntity(player);
                } else if (dist > 4 && (pathentity = this.field_70170_p.func_72865_a((Entity)this, target, 16.0f, true, false, false, true)) != null) {
                    this.func_70778_a(pathentity);
                }
            }
            this.prevPoint = this.getPos();
            this.handleDoorsAndFenceGates();
        }
        catch (Exception e) {
            MLN.printException("Error in hired onUpdate():", e);
        }
    }

    private void updatePathIfNeeded(Point dest) throws Exception {
        if (dest == null) {
            return;
        }
        if (this.pathEntity != null && this.pathEntity.func_75874_d() > 0 && !MillCommonUtilities.chanceOn(50) && this.pathEntity.getCurrentTargetPathPoint() != null) {
            if (MLN.DEV) {
                ++this.getTownHall().monitor.nbPathing;
                ++this.getTownHall().monitor.nbReused;
            }
            this.func_70778_a(this.pathEntity);
        } else if (MLN.jpsPathing) {
            if (!this.jpsPathPlanner.isBusy()) {
                this.computeNewPath(dest);
            }
        } else if (this.pathingWorker == null) {
            this.computeNewPath(dest);
        }
    }

    public float func_70663_b(float f, float f1, float f2) {
        float f3;
        for (f3 = f1 - f; f3 < -180.0f; f3 += 360.0f) {
        }
        while (f3 >= 180.0f) {
            f3 -= 360.0f;
        }
        if (f3 > f2) {
            f3 = f2;
        }
        if (f3 < -f2) {
            f3 = -f2;
        }
        return f + f3;
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        try {
            if (this.vtype == null) {
                MLN.error(this, "Not saving villager due to null vtype.");
                return;
            }
            super.func_70014_b(nbttagcompound);
            nbttagcompound.func_74778_a("vtype", this.vtype.key);
            nbttagcompound.func_74778_a("culture", this.getCulture().key);
            nbttagcompound.func_74778_a("texture", this.texture.func_110623_a());
            if (this.housePoint != null) {
                this.housePoint.write(nbttagcompound, "housePos");
            }
            if (this.townHallPoint != null) {
                this.townHallPoint.write(nbttagcompound, "townHallPos");
            }
            if (this.getGoalDestPoint() != null) {
                this.getGoalDestPoint().write(nbttagcompound, "destPoint");
            }
            if (this.getGoalBuildingDestPoint() != null) {
                this.getGoalBuildingDestPoint().write(nbttagcompound, "destBuildingPoint");
            }
            if (this.getPathDestPoint() != null) {
                this.getPathDestPoint().write(nbttagcompound, "pathDestPoint");
            }
            if (this.prevPoint != null) {
                this.prevPoint.write(nbttagcompound, "prevPoint");
            }
            if (this.doorToClose != null) {
                this.doorToClose.write(nbttagcompound, "doorToClose");
            }
            nbttagcompound.func_74768_a("action", this.action);
            if (this.goalKey != null) {
                nbttagcompound.func_74778_a("goal", this.goalKey);
            }
            nbttagcompound.func_74778_a("firstName", this.firstName);
            nbttagcompound.func_74778_a("familyName", this.familyName);
            nbttagcompound.func_74776_a("scale", this.scale);
            nbttagcompound.func_74768_a("gender", this.gender);
            nbttagcompound.func_74772_a("lastSpeechLong", this.speech_started);
            nbttagcompound.func_74772_a("villager_lid", this.villager_id);
            if (this.dialogueKey != null) {
                nbttagcompound.func_74778_a("dialogueKey", this.dialogueKey);
                nbttagcompound.func_74772_a("dialogueStart", this.dialogueStart);
                nbttagcompound.func_74768_a("dialogueRole", this.dialogueRole);
                nbttagcompound.func_74768_a("dialogueColour", (int)this.dialogueColour);
                nbttagcompound.func_74757_a("dialogueChat", this.dialogueChat);
            }
            NBTTagList nbttaglist = MillCommonUtilities.writeInventory(this.inventory);
            nbttagcompound.func_74782_a("inventoryNew", (NBTBase)nbttaglist);
            nbttagcompound.func_74768_a("previousBlock", Block.func_149682_b((Block)this.previousBlock));
            nbttagcompound.func_74768_a("previousBlockMeta", this.previousBlockMeta);
            nbttagcompound.func_74768_a("size", this.size);
            nbttagcompound.func_74757_a("hasPrayedToday", this.hasPrayedToday);
            nbttagcompound.func_74757_a("hasDrunkToday", this.hasDrunkToday);
            if (this.hiredBy != null) {
                nbttagcompound.func_74778_a("hiredBy", this.hiredBy);
                nbttagcompound.func_74772_a("hiredUntil", this.hiredUntil);
                nbttagcompound.func_74757_a("aggressiveStance", this.aggressiveStance);
            }
            nbttagcompound.func_74757_a("isRaider", this.isRaider);
            if (this.clothName != null) {
                nbttagcompound.func_74778_a("clothName", this.clothName);
                nbttagcompound.func_74778_a("clothTexture", this.clothTexture.func_110623_a());
            }
        }
        catch (Exception e) {
            MLN.printException("Exception when attempting to save villager " + this, e);
        }
    }

    public void writeSpawnData(ByteBuf ds) {
        ByteBufOutputStream data = new ByteBufOutputStream(ds);
        try {
            this.writeVillagerStreamData((DataOutput)data, true);
        }
        catch (IOException e) {
            MLN.printException("Error in writeSpawnData for villager " + this, e);
        }
    }

    private void writeVillagerStreamData(DataOutput data, boolean isSpawn) throws IOException {
        if (this.vtype == null) {
            MLN.error(this, "Cannot write stream data due to null vtype.");
            return;
        }
        data.writeLong(this.villager_id);
        StreamReadWrite.writeNullableString(this.vtype.culture.key, data);
        StreamReadWrite.writeNullableString(this.vtype.key, data);
        StreamReadWrite.writeNullableResourceLocation(this.texture, data);
        StreamReadWrite.writeNullableString(this.goalKey, data);
        StreamReadWrite.writeNullablePoint(this.housePoint, data);
        StreamReadWrite.writeNullablePoint(this.townHallPoint, data);
        StreamReadWrite.writeNullableString(this.firstName, data);
        StreamReadWrite.writeNullableString(this.familyName, data);
        data.writeFloat(this.scale);
        data.writeInt(this.gender);
        data.writeInt(this.size);
        StreamReadWrite.writeNullableString(this.hiredBy, data);
        data.writeBoolean(this.aggressiveStance);
        data.writeLong(this.hiredUntil);
        data.writeBoolean(this.isUsingBow);
        data.writeBoolean(this.isUsingHandToHand);
        StreamReadWrite.writeNullableString(this.speech_key, data);
        data.writeInt(this.speech_variant);
        data.writeLong(this.speech_started);
        StreamReadWrite.writeNullableItemStack(this.heldItem, data);
        StreamReadWrite.writeInventory(this.inventory, data);
        StreamReadWrite.writeNullableString(this.clothName, data);
        StreamReadWrite.writeNullableResourceLocation(this.clothTexture, data);
        StreamReadWrite.writeNullablePoint(this.getGoalDestPoint(), data);
        data.writeBoolean(this.shouldLieDown);
        StreamReadWrite.writeNullableString(this.dialogueTargetFirstName, data);
        StreamReadWrite.writeNullableString(this.dialogueTargetLastName, data);
        data.writeChar(this.dialogueColour);
        data.writeBoolean(this.dialogueChat);
        data.writeFloat(this.func_110143_aJ());
        if (isSpawn) {
            this.calculateMerchantGoods();
            data.writeInt(this.merchantSells.size());
            for (Goods g : this.merchantSells.keySet()) {
                StreamReadWrite.writeNullableGoods(g, data);
                data.writeInt(this.merchantSells.get(g));
            }
        } else {
            data.writeInt(-1);
        }
        if (this.getGoalDestEntity() != null) {
            data.writeInt(this.getGoalDestEntity().func_145782_y());
        } else {
            data.writeInt(-1);
        }
    }

    public static class MLEntityGenericZombie
    extends MillVillager {
        public MLEntityGenericZombie(World world) {
            super(world);
        }

        @Override
        public void readSpawnData(ByteBuf additionalData) {
        }
    }

    public static class MLEntityGenericSymmFemale
    extends MillVillager {
        public MLEntityGenericSymmFemale(World world) {
            super(world);
        }
    }

    public static class MLEntityGenericMale
    extends MillVillager {
        public MLEntityGenericMale(World world) {
            super(world);
        }
    }

    public static class MLEntityGenericAsymmFemale
    extends MillVillager {
        public MLEntityGenericAsymmFemale(World world) {
            super(world);
        }
    }

    public static class InvItemAlphabeticalComparator
    implements Comparator<InvItem> {
        @Override
        public int compare(InvItem arg0, InvItem arg1) {
            return arg0.getName().compareTo(arg1.getName());
        }
    }
}

