/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common;

import io.netty.buffer.ByteBufInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import org.millenaire.common.Culture;
import org.millenaire.common.MLN;
import org.millenaire.common.MillVillager;
import org.millenaire.common.Point;
import org.millenaire.common.SpecialQuestActions;
import org.millenaire.common.TileEntityPanel;
import org.millenaire.common.UserProfile;
import org.millenaire.common.VillageType;
import org.millenaire.common.building.Building;
import org.millenaire.common.core.DevModUtilities;
import org.millenaire.common.core.MillCommonUtilities;
import org.millenaire.common.forge.Mill;
import org.millenaire.common.network.ServerSender;
import org.millenaire.common.network.StreamReadWrite;

public class MillWorld {
    public static final String CULTURE_CONTROL = "culturecontrol_";
    public static final String CROP_PLANTING = "cropplanting_";
    public static final String PUJAS = "pujas";
    public static final String MAYANSACRIFICES = "mayansacrifices";
    private final HashMap<Point, Building> buildings = new HashMap();
    private final HashMap<Point, String> renameNames = new HashMap();
    private final HashMap<Point, String> renameQualifiers = new HashMap();
    public final HashMap<Long, MillVillager> villagers = new HashMap();
    public final List<String> globalTags = new ArrayList<String>();
    public MillCommonUtilities.VillageList loneBuildingsList = new MillCommonUtilities.VillageList();
    public File millenaireDir;
    public File saveDir = null;
    public MillCommonUtilities.VillageList villagesList = new MillCommonUtilities.VillageList();
    public long lastWorldUpdate = 0L;
    public HashMap<String, UserProfile> profiles = new HashMap();
    public List<TileEntityPanel.PanelPacketInfo> panelPacketInfos = new ArrayList<TileEntityPanel.PanelPacketInfo>();
    public World world;
    public boolean millenaireEnabled = false;
    private int lastupdate;
    private static HashMap<Point, String> buildingsTags = new HashMap();
    private static HashMap<Point, Integer> buildingsVariation = new HashMap();
    private static HashMap<Point, String> buildingsLocation = new HashMap();

    public MillWorld(World worldObj) {
        this.world = worldObj;
        if (!this.world.field_72995_K) {
            this.saveDir = MillCommonUtilities.getWorldSaveDir(this.world);
            this.millenaireEnabled = true;
        }
        if (!this.world.field_72995_K) {
            this.millenaireDir = new File(this.saveDir, "millenaire");
            if (!this.millenaireDir.exists()) {
                this.millenaireDir.mkdir();
            }
        }
        Culture.removeServerContent();
    }

    public void addBuilding(Building b, Point p) {
        this.buildings.put(p, b);
    }

    public Collection<Building> allBuildings() {
        return this.buildings.values();
    }

    public boolean buildingExists(Point p) {
        return this.buildings.containsKey(p);
    }

    public void checkConnections() {
        for (UserProfile profile : this.profiles.values()) {
            if (!profile.connected || profile.getPlayer() != null) continue;
            profile.disconnectUser();
        }
    }

    public void clearGlobalTag(String tag) {
        if (this.globalTags.contains(tag)) {
            this.globalTags.remove(tag);
            this.saveGlobalTags();
            if (!this.world.field_72995_K) {
                for (UserProfile up : this.profiles.values()) {
                    if (!up.connected) continue;
                    up.sendProfilePacket(7);
                }
            }
        }
    }

    public void clearPanelQueue() {
        ArrayList<TileEntityPanel.PanelPacketInfo> toDelete = new ArrayList<TileEntityPanel.PanelPacketInfo>();
        for (TileEntityPanel.PanelPacketInfo pinfo : this.panelPacketInfos) {
            TileEntityPanel panel = pinfo.pos.getPanel(this.world);
            if (panel == null) continue;
            panel.panelType = pinfo.panelType;
            panel.buildingPos = pinfo.buildingPos;
            panel.villager_id = pinfo.villager_id;
            for (int i = 0; i < pinfo.lines.length && i < panel.field_145915_a.length; ++i) {
                panel.field_145915_a[i] = MLN.string(pinfo.lines[i]);
            }
            toDelete.add(pinfo);
        }
        for (TileEntityPanel.PanelPacketInfo pinfo : toDelete) {
            this.panelPacketInfos.remove(pinfo);
        }
    }

    public void displayTagActionData(EntityPlayer player) {
        String s = "";
        for (String tag : this.globalTags) {
            s = s + tag + " ";
        }
        ServerSender.sendChat(player, EnumChatFormatting.GREEN, "Tags: " + s);
        ServerSender.sendChat(player, EnumChatFormatting.GREEN, "ActionData: " + s);
        String biomeName = this.world.func_72959_q().func_76935_a((int)((int)player.field_70165_t), (int)((int)player.field_70161_v)).field_76791_y.toLowerCase();
        ServerSender.sendChat(player, EnumChatFormatting.GREEN, "Biome: " + biomeName + ", time: " + this.world.func_72820_D() % 24000L + " / " + this.world.func_72820_D());
    }

    public void displayVillageList(EntityPlayer player, boolean loneBuildings) {
        int i;
        MillCommonUtilities.VillageList list = loneBuildings ? this.loneBuildingsList : this.villagesList;
        ArrayList<MillCommonUtilities.VillageInfo> villageList = new ArrayList<MillCommonUtilities.VillageInfo>();
        for (i = 0; i < list.names.size(); ++i) {
            Point p = list.pos.get(i);
            int distance = MathHelper.func_76128_c((double)p.horizontalDistanceTo((Entity)player));
            if (distance > MLN.BackgroundRadius) continue;
            String direction = new Point((Entity)player).directionTo(p, true);
            Building townHall = this.getBuilding(p);
            String loaded = townHall == null ? "command.inactive" : (townHall.isActive ? "command.active" : (!townHall.isAreaLoaded ? "command.inactive" : "command.frozen"));
            VillageType villageType = loneBuildings ? Culture.getCultureByName(list.cultures.get(i)).getLoneBuildingType(list.types.get(i)) : Culture.getCultureByName(list.cultures.get(i)).getVillageType(list.types.get(i));
            MillCommonUtilities.VillageInfo vi = new MillCommonUtilities.VillageInfo();
            vi.distance = distance;
            if (villageType != null) {
                vi.textKey = "command.villagelist";
                vi.values = new String[]{list.names.get(i), loaded, "" + distance, direction, villageType.name};
            }
            villageList.add(vi);
        }
        if (!loneBuildings) {
            for (i = 0; i < this.loneBuildingsList.names.size(); ++i) {
                Point p;
                int distance;
                VillageType village = Culture.getCultureByName(this.loneBuildingsList.cultures.get(i)).getLoneBuildingType(this.loneBuildingsList.types.get(i));
                if (!village.keyLonebuilding && village.keyLoneBuildingGenerateTag == null || village.generatedForPlayer && !player.getDisplayName().equalsIgnoreCase(this.loneBuildingsList.generatedFor.get(i)) || (distance = MathHelper.func_76128_c((double)(p = this.loneBuildingsList.pos.get(i)).horizontalDistanceTo((Entity)player))) > 2000) continue;
                String direction = new Point((Entity)player).directionTo(p, true);
                MillCommonUtilities.VillageInfo vi = new MillCommonUtilities.VillageInfo();
                vi.distance = distance;
                if (village != null) {
                    vi.textKey = "command.villagelistkeylonebuilding";
                    vi.values = new String[]{village.name, "" + distance, direction};
                }
                villageList.add(vi);
            }
        }
        if (villageList.size() == 0) {
            ServerSender.sendTranslatedSentence(player, '7', "command.noknowvillage", new String[0]);
        } else {
            Collections.sort(villageList);
            for (MillCommonUtilities.VillageInfo vi : villageList) {
                ServerSender.sendTranslatedSentence(player, '7', vi.textKey, vi.values);
            }
        }
    }

    public void forcePreload() {
        int centreZ;
        int centreX;
        if (this.world.field_72995_K || MLN.forcePreload <= 0) {
            return;
        }
        ++this.lastupdate;
        if (this.lastupdate < 50) {
            return;
        }
        this.lastupdate = 0;
        if (this.world.field_73010_i.size() > 0) {
            Object o = this.world.field_73010_i.get(0);
            EntityPlayer player = (EntityPlayer)o;
            centreX = (int)(player.field_70165_t / 16.0);
            centreZ = (int)(player.field_70161_v / 16.0);
        } else {
            centreX = this.world.func_72861_E().field_71574_a / 16;
            centreZ = this.world.func_72861_E().field_71573_c / 16;
        }
        int nbGenerated = 0;
        for (int radius = 1; radius < MLN.forcePreload; ++radius) {
            for (int i = -MLN.forcePreload; i < MLN.forcePreload && nbGenerated < 100; ++i) {
                for (int j = -MLN.forcePreload; j < MLN.forcePreload && nbGenerated < 100; ++j) {
                    if (i * i + j * j >= radius * radius || this.world.func_72863_F().func_73149_a(i + centreX, j + centreZ)) continue;
                    this.world.func_72863_F().func_73158_c(i + centreX, j + centreZ);
                    Block block = this.world.func_147439_a((i + centreX) * 16, 60, (j + centreZ) * 16);
                    this.world.func_72863_F().func_73151_a(false, null);
                    MLN.minor(this, "Forcing population of chunk " + (i + centreX) + "/" + (j + centreZ) + ", block: " + block);
                    ++nbGenerated;
                }
            }
        }
    }

    public Building getBuilding(Point p) {
        if (this.buildings.containsKey(p)) {
            if (this.buildings.get(p) == null) {
                MLN.error(this, "Building record for " + p + " is null.");
            } else if (this.buildings.get((Object)p).location == null) {
                MLN.printException("Building location for " + p + " is null.", new Exception());
            }
            return this.buildings.get(p);
        }
        if (MLN.LogWorldInfo >= 2) {
            MLN.minor(this, "Could not find a building at location " + p + " amoung " + this.buildings.size() + " records.");
        }
        return null;
    }

    public Building getClosestVillage(Point p) {
        int bestDistance = Integer.MAX_VALUE;
        Building bestVillage = null;
        for (Point villageCoord : this.villagesList.pos) {
            Building village;
            int dist = (int)p.distanceToSquared(villageCoord);
            if (bestVillage != null && dist >= bestDistance || (village = this.getBuilding(villageCoord)) == null) continue;
            bestVillage = village;
            bestDistance = dist;
        }
        return bestVillage;
    }

    public List<Point> getCombinedVillagesLoneBuildings() {
        ArrayList<Point> thPosLists = new ArrayList<Point>(this.villagesList.pos);
        thPosLists.addAll(this.loneBuildingsList.pos);
        return thPosLists;
    }

    public UserProfile getProfile(String name) {
        if (this.profiles.containsKey(name)) {
            return this.profiles.get(name);
        }
        if (this.profiles.containsKey("SinglePlayer")) {
            UserProfile profile = this.profiles.get("SinglePlayer");
            profile.changeProfileKey(name);
            return profile;
        }
        UserProfile profile = new UserProfile(this, name, name);
        this.profiles.put(profile.key, profile);
        return profile;
    }

    public boolean isGlobalTagSet(String tag) {
        return this.globalTags.contains(tag);
    }

    private void loadBuildings() {
        long startTime = System.currentTimeMillis();
        File buildingsDir = new File(this.millenaireDir, "buildings");
        if (!buildingsDir.exists()) {
            buildingsDir.mkdir();
        }
        for (File file : buildingsDir.listFiles(new MillCommonUtilities.ExtFileFilter("gz"))) {
            try {
                FileInputStream fileinputstream = new FileInputStream(file);
                NBTTagCompound nbttagcompound = CompressedStreamTools.func_74796_a((InputStream)fileinputstream);
                NBTTagList nbttaglist = nbttagcompound.func_150295_c("buildings", 10);
                for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                    NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
                    new Building(this, nbttagcompound1);
                }
            }
            catch (Exception e) {
                MLN.printException("Error when attempting to load building file " + file.getAbsolutePath() + ":", e);
            }
        }
        if (MLN.LogHybernation >= 1) {
            for (Building b : this.buildings.values()) {
                MLN.major(null, b + " - " + b.culture);
            }
            MLN.major(this, "Loaded " + this.buildings.size() + " in " + (System.currentTimeMillis() - startTime) + " ms.");
        }
    }

    public void loadData() {
        if (this.world.field_72995_K) {
            return;
        }
        this.loadWorldConfig();
        this.loadVillageList();
        this.loadGlobalTags();
        this.loadBuildings();
        this.loadProfiles();
        Mill.startMessageDisplayed = false;
    }

    private void loadGlobalTags() {
        File tagsFile = new File(this.millenaireDir, "tags.txt");
        this.globalTags.clear();
        if (tagsFile.exists()) {
            try {
                BufferedReader reader = MillCommonUtilities.getReader(tagsFile);
                String line = reader.readLine();
                while (line != null) {
                    if (line.trim().length() > 0) {
                        this.globalTags.add(line.trim());
                    }
                    line = reader.readLine();
                }
                if (MLN.LogWorldGeneration >= 1) {
                    MLN.major(null, "Loaded " + this.globalTags.size() + " tags.");
                }
            }
            catch (Exception e) {
                MLN.printException(e);
            }
        }
    }

    private void loadProfiles() {
        File profilesDir = new File(this.millenaireDir, "profiles");
        if (!profilesDir.exists()) {
            profilesDir.mkdirs();
        }
        for (File profileDir : profilesDir.listFiles()) {
            UserProfile profile;
            if (!profileDir.isDirectory() || profileDir.isHidden() || (profile = UserProfile.readProfile(this, profileDir)) == null) continue;
            this.profiles.put(profile.key, profile);
        }
    }

    private void loadVillageList() {
        String generatedFor;
        Culture c;
        String culture;
        String type;
        String[] p;
        String line;
        BufferedReader reader;
        File villageLog = new File(this.millenaireDir, "villages.txt");
        if (villageLog.exists()) {
            try {
                reader = MillCommonUtilities.getReader(villageLog);
                line = reader.readLine();
                while (line != null) {
                    if (line.trim().length() > 0) {
                        p = line.split(";")[1].split("/");
                        type = "";
                        if (line.split(";").length > 2) {
                            type = line.split(";")[2];
                        }
                        culture = "";
                        if (line.split(";").length > 3) {
                            culture = line.split(";")[3];
                        }
                        c = Culture.getCultureByName(culture);
                        generatedFor = null;
                        if (line.split(";").length > 4) {
                            generatedFor = line.split(";")[4];
                        }
                        this.registerVillageLocation(this.world, new Point(Integer.parseInt(p[0]), Integer.parseInt(p[1]), Integer.parseInt(p[2])), line.split(";")[0], c.getVillageType(type), c, false, generatedFor);
                    }
                    line = reader.readLine();
                }
                if (MLN.LogWorldGeneration >= 1) {
                    MLN.major(null, "Loaded " + this.villagesList.names.size() + " village positions.");
                }
            }
            catch (Exception e) {
                MLN.printException(e);
            }
        }
        if ((villageLog = new File(this.millenaireDir, "lonebuildings.txt")).exists()) {
            try {
                reader = MillCommonUtilities.getReader(villageLog);
                line = reader.readLine();
                while (line != null) {
                    if (line.trim().length() > 0) {
                        p = line.split(";")[1].split("/");
                        type = "";
                        if (line.split(";").length > 2) {
                            type = line.split(";")[2];
                        }
                        culture = "";
                        if (line.split(";").length > 3) {
                            culture = line.split(";")[3];
                        }
                        c = Culture.getCultureByName(culture);
                        generatedFor = null;
                        if (line.split(";").length > 4) {
                            generatedFor = line.split(";")[4];
                        }
                        this.registerLoneBuildingsLocation(this.world, new Point(Integer.parseInt(p[0]), Integer.parseInt(p[1]), Integer.parseInt(p[2])), line.split(";")[0], c.getLoneBuildingType(type), c, false, generatedFor);
                    }
                    line = reader.readLine();
                }
                if (MLN.LogWorldGeneration >= 1) {
                    MLN.major(null, "Loaded " + this.loneBuildingsList.names.size() + " lone buildings positions.");
                }
            }
            catch (Exception e) {
                MLN.printException(e);
            }
        }
    }

    private void loadWorldConfig() {
        MLN.generateVillages = MLN.generateVillagesDefault;
        this.renameNames.clear();
        this.renameQualifiers.clear();
        File configFile = new File(this.millenaireDir, "config.txt");
        if (configFile != null && configFile.exists()) {
            try {
                String line;
                BufferedReader reader = MillCommonUtilities.getReader(configFile);
                while ((line = reader.readLine()) != null) {
                    Point p;
                    String[] temp;
                    if (line.trim().length() <= 0 || line.startsWith("//") || (temp = line.split("=")).length != 2) continue;
                    String key = temp[0];
                    String value = temp[1];
                    if (key.equalsIgnoreCase("generate_villages")) {
                        MLN.generateVillages = Boolean.parseBoolean(value);
                        continue;
                    }
                    if (key.equalsIgnoreCase("rename_name")) {
                        p = new Point(value.split(",")[0]);
                        this.renameNames.put(p, value.split(",")[1]);
                        continue;
                    }
                    if (!key.equalsIgnoreCase("rename_qualifier")) continue;
                    p = new Point(value.split(",")[0]);
                    if (value.split(",").length > 1) {
                        this.renameQualifiers.put(p, value.split(",")[1]);
                        continue;
                    }
                    this.renameQualifiers.put(p, "");
                }
                reader.close();
            }
            catch (IOException e) {
                MLN.printException(e);
            }
        }
        if (MLN.LogWorldGeneration >= 1) {
            MLN.major(null, "Config loaded. generateVillages: " + MLN.generateVillages);
        }
    }

    public int nbCultureInGeneratedVillages() {
        ArrayList<String> cultures = new ArrayList<String>();
        for (int i = 0; i < this.villagesList.names.size(); ++i) {
            if (cultures.contains(this.villagesList.cultures.get(i))) continue;
            cultures.add(this.villagesList.cultures.get(i));
        }
        return cultures.size();
    }

    public void receiveVillageListPacket(ByteBufInputStream ds) {
        if (MLN.LogNetwork >= 2) {
            MLN.minor(this, "Received village list packet.");
        }
        this.villagesList = new MillCommonUtilities.VillageList();
        this.loneBuildingsList = new MillCommonUtilities.VillageList();
        try {
            int i;
            int nb = ds.readInt();
            for (i = 0; i < nb; ++i) {
                this.villagesList.pos.add(StreamReadWrite.readNullablePoint((DataInput)ds));
                this.villagesList.names.add(StreamReadWrite.readNullableString((DataInput)ds));
                this.villagesList.cultures.add(StreamReadWrite.readNullableString((DataInput)ds));
                this.villagesList.types.add(StreamReadWrite.readNullableString((DataInput)ds));
            }
            nb = ds.readInt();
            for (i = 0; i < nb; ++i) {
                this.loneBuildingsList.pos.add(StreamReadWrite.readNullablePoint((DataInput)ds));
                this.loneBuildingsList.names.add(StreamReadWrite.readNullableString((DataInput)ds));
                this.loneBuildingsList.cultures.add(StreamReadWrite.readNullableString((DataInput)ds));
                this.loneBuildingsList.types.add(StreamReadWrite.readNullableString((DataInput)ds));
            }
        }
        catch (IOException e) {
            MLN.printException(this + ": Error in receiveVillageListPacket", e);
        }
    }

    public void registerLoneBuildingsLocation(World world, Point pos, String name, VillageType type, Culture culture, boolean newVillage, String playerName) {
        boolean found = false;
        for (Point p : this.loneBuildingsList.pos) {
            if (!p.equals(pos)) continue;
            found = true;
        }
        if (found) {
            return;
        }
        if (!type.generatedForPlayer) {
            playerName = null;
        }
        this.loneBuildingsList.addVillage(pos, name, type.key, culture.key, playerName);
        if (MLN.LogWorldGeneration >= 1) {
            MLN.major(null, "Registering lone buildings: " + name + " / " + type + " / " + culture + " / " + pos);
        }
        for (Point o : world.field_73010_i) {
            int distance;
            EntityPlayer player = (EntityPlayer)o;
            if (!newVillage || !type.keyLonebuilding && type.keyLoneBuildingGenerateTag == null || (distance = MathHelper.func_76128_c((double)pos.horizontalDistanceTo((Entity)player))) > 2000) continue;
            String direction = new Point((Entity)player).directionTo(pos, true);
            ServerSender.sendTranslatedSentence(player, 'e', "command.newlonebuildingfound", type.name, "" + distance, direction);
        }
        this.saveLoneBuildingsList();
    }

    public void registerVillageLocation(World world, Point pos, String name, VillageType type, Culture culture, boolean newVillage, String playerName) {
        boolean found = false;
        if (type == null) {
            MLN.error(null, "Attempting to register village with null type: " + pos + "/" + culture + "/" + name + "/" + newVillage);
            return;
        }
        if (culture == null) {
            MLN.error(null, "Attempting to register village with null culture: " + pos + "/" + type + "/" + name + "/" + newVillage);
            return;
        }
        for (Point p : this.villagesList.pos) {
            if (!p.equals(pos)) continue;
            found = true;
        }
        if (found) {
            return;
        }
        if (!type.generatedForPlayer) {
            playerName = null;
        }
        this.villagesList.addVillage(pos, name, type.key, culture.key, playerName);
        if (MLN.LogWorldGeneration >= 1) {
            MLN.major(null, "Registering village: " + name + " / " + type + " / " + culture + " / " + pos);
        }
        if (newVillage) {
            for (Point o : world.field_73010_i) {
                EntityPlayer player = (EntityPlayer)o;
                int distance = MathHelper.func_76128_c((double)pos.horizontalDistanceTo((Entity)player));
                if (distance > 2000 || world.field_72995_K) continue;
                String direction = new Point((Entity)player).directionTo(pos, true);
                ServerSender.sendTranslatedSentence(player, 'e', "command.newvillagefound", name, type.name, "culture." + culture.key, "" + distance, direction);
            }
        }
        this.saveVillageList();
    }

    public void removeBuilding(Point p) {
        this.buildings.remove(p);
    }

    public void removeVillageOrLoneBuilding(Point p) {
        this.loneBuildingsList.removeVillage(p);
        this.villagesList.removeVillage(p);
        this.saveLoneBuildingsList();
        this.saveVillageList();
    }

    public void saveEverything() {
        if (this.world.field_72995_K) {
            return;
        }
        this.saveGlobalTags();
        this.saveLoneBuildingsList();
        this.saveVillageList();
        this.saveWorldConfig();
        for (Building b : this.buildings.values()) {
            if (!b.isTownhall || !b.isActive) continue;
            b.saveTownHall("world save");
        }
    }

    private void saveGlobalTags() {
        if (this.world.field_72995_K) {
            return;
        }
        File configFile = new File(this.millenaireDir, "tags.txt");
        try {
            BufferedWriter writer = MillCommonUtilities.getWriter(configFile);
            for (String tag : this.globalTags) {
                writer.write(tag + MLN.EOL);
            }
            writer.flush();
        }
        catch (IOException e) {
            MLN.printException(e);
        }
    }

    public void saveLoneBuildingsList() {
        if (this.world.field_72995_K) {
            return;
        }
        File millenaireDir = new File(this.saveDir, "millenaire");
        if (!millenaireDir.exists()) {
            millenaireDir.mkdir();
        }
        File villageLog = new File(millenaireDir, "lonebuildings.txt");
        try {
            BufferedWriter writer = MillCommonUtilities.getWriter(villageLog);
            for (int i = 0; i < this.loneBuildingsList.pos.size(); ++i) {
                Point p = this.loneBuildingsList.pos.get(i);
                String generatedFor = this.loneBuildingsList.generatedFor.get(i);
                if (generatedFor == null) {
                    generatedFor = "";
                }
                writer.write(this.loneBuildingsList.names.get(i) + ";" + p.getiX() + "/" + p.getiY() + "/" + p.getiZ() + ";" + this.loneBuildingsList.types.get(i) + ";" + this.loneBuildingsList.cultures.get(i) + ";" + generatedFor + System.getProperty("line.separator"));
            }
            writer.flush();
            if (MLN.LogWorldGeneration >= 1) {
                MLN.major(null, "Saved " + this.loneBuildingsList.names.size() + " lone buildings.txt positions.");
            }
        }
        catch (IOException e) {
            MLN.printException(e);
        }
    }

    public void saveVillageList() {
        if (this.world.field_72995_K) {
            return;
        }
        File millenaireDir = new File(this.saveDir, "millenaire");
        if (!millenaireDir.exists()) {
            millenaireDir.mkdir();
        }
        File villageLog = new File(millenaireDir, "villages.txt");
        try {
            BufferedWriter writer = MillCommonUtilities.getWriter(villageLog);
            for (int i = 0; i < this.villagesList.pos.size(); ++i) {
                Point p = this.villagesList.pos.get(i);
                String generatedFor = this.villagesList.generatedFor.get(i);
                if (generatedFor == null) {
                    generatedFor = "";
                }
                writer.write(this.villagesList.names.get(i) + ";" + p.getiX() + "/" + p.getiY() + "/" + p.getiZ() + ";" + this.villagesList.types.get(i) + ";" + this.villagesList.cultures.get(i) + ";" + generatedFor + System.getProperty("line.separator"));
            }
            writer.flush();
            if (MLN.LogWorldGeneration >= 1) {
                MLN.major(null, "Saved " + this.villagesList.names.size() + " village positions.");
            }
        }
        catch (IOException e) {
            MLN.printException(e);
        }
    }

    public void saveWorldConfig() {
        if (this.world.field_72995_K) {
            return;
        }
        File configFile = new File(this.millenaireDir, "config.txt");
        try {
            BufferedWriter writer = MillCommonUtilities.getWriter(configFile);
            writer.write("generate_villages=" + MLN.generateVillages + MLN.EOL);
            writer.flush();
        }
        catch (IOException e) {
            MLN.printException(e);
        }
    }

    public void sendVillageListPacket(EntityPlayer player) {
        DataOutput data = ServerSender.getNewByteBufOutputStream();
        try {
            int i;
            data.write(9);
            data.writeInt(this.villagesList.pos.size());
            for (i = 0; i < this.villagesList.pos.size(); ++i) {
                StreamReadWrite.writeNullablePoint(this.villagesList.pos.get(i), data);
                StreamReadWrite.writeNullableString(this.villagesList.names.get(i), data);
                StreamReadWrite.writeNullableString(this.villagesList.cultures.get(i), data);
                StreamReadWrite.writeNullableString(this.villagesList.types.get(i), data);
            }
            data.writeInt(this.loneBuildingsList.pos.size());
            for (i = 0; i < this.loneBuildingsList.pos.size(); ++i) {
                StreamReadWrite.writeNullablePoint(this.loneBuildingsList.pos.get(i), data);
                StreamReadWrite.writeNullableString(this.loneBuildingsList.names.get(i), data);
                StreamReadWrite.writeNullableString(this.loneBuildingsList.cultures.get(i), data);
                StreamReadWrite.writeNullableString(this.loneBuildingsList.types.get(i), data);
            }
        }
        catch (IOException e) {
            MLN.printException(this + ": Error in sendVillageListPacket", e);
        }
        ServerSender.sendPacketToPlayer((Packet)ServerSender.createServerPacket(data), player);
    }

    public void setGlobalTag(String tag) {
        if (!this.globalTags.contains(tag)) {
            this.globalTags.add(tag);
            this.saveGlobalTags();
            if (!this.world.field_72995_K) {
                for (UserProfile up : this.profiles.values()) {
                    if (!up.connected) continue;
                    up.sendProfilePacket(7);
                }
            }
        }
    }

    public void testLocations(String label) {
        if (!MLN.DEV) {
            return;
        }
        for (Building b : this.allBuildings()) {
            try {
                if (b.location == null) continue;
                String tags = "";
                for (String s : b.location.tags) {
                    tags = tags + s + ";";
                }
                if (!buildingsTags.containsKey(b.getPos())) {
                    MLN.minor(null, "Detected new building: " + b + " with tags: " + tags);
                    buildingsTags.put(b.getPos(), tags);
                } else if (!tags.equals(buildingsTags.get(b.getPos()))) {
                    MLN.warning(null, "Testing locations due to: " + label);
                    MLN.warning(null, "Tags changed for building: " + b + ". Was: " + buildingsTags.get(b.getPos()) + " now: " + tags);
                    buildingsTags.put(b.getPos(), tags);
                }
                if (!buildingsVariation.containsKey(b.getPos())) {
                    MLN.minor(null, "Detected new building: " + b + " with variation: " + b.location.getVariation());
                    buildingsVariation.put(b.getPos(), b.location.getVariation());
                } else if (!buildingsVariation.get(b.getPos()).equals(b.location.getVariation())) {
                    MLN.warning(null, "Testing locations due to: " + label);
                    MLN.warning(null, "Variation changed for building: " + b + ". Was: " + buildingsVariation.get(b.getPos()) + " now: " + b.location.getVariation());
                    buildingsVariation.put(b.getPos(), b.location.getVariation());
                }
                if (!buildingsLocation.containsKey(b.getPos())) {
                    MLN.minor(null, "Detected new building: " + b + " with location key: " + b.location.planKey);
                    buildingsLocation.put(b.getPos(), b.location.planKey);
                    continue;
                }
                if (b.location.planKey.equals(buildingsLocation.get(b.getPos()))) continue;
                MLN.warning(null, "Testing locations due to: " + label);
                MLN.warning(null, "Location key changed for building: " + b + ". Was: " + buildingsLocation.get(b.getPos()) + " now: " + b.location.planKey);
                buildingsLocation.put(b.getPos(), b.location.planKey);
            }
            catch (Exception e) {
                MLN.printException("Error in dev monitoring of a building building: ", e);
            }
        }
    }

    private void testLog() {
        if (!MLN.logPerformed) {
            if (Mill.proxy.isTrueServer()) {
                MillCommonUtilities.logInstance(this.world);
            } else if (!(this.world instanceof WorldServer)) {
                MillCommonUtilities.logInstance(this.world);
            }
        }
    }

    public String toString() {
        return "World(" + this.world.func_72912_H().func_76063_b() + ")";
    }

    public void updateWorldClient(boolean surfaceLoaded) {
        if (!(Mill.checkedMillenaireDir || Mill.proxy.getBaseDir().exists() && new File(Mill.proxy.getBaseDir(), "config.txt").exists())) {
            Mill.proxy.sendChatAdmin("The millenaire directory could not be found. It should be inside the minecraft directory, alongside \"bin\".");
            Mill.proxy.sendChatAdmin("Le dossier millenaire est introuvable. Il devrait \u00eatre dans le dossier minecraft, \u00e0 c\u00f4t\u00e9 de \"bin\".");
        }
        Mill.checkedMillenaireDir = true;
        if (surfaceLoaded) {
            for (Building b : this.allBuildings()) {
                b.updateBuildingClient();
            }
        }
        Mill.proxy.checkTextureSize();
        this.testLog();
    }

    public void updateWorldServer() {
        int i;
        Building b;
        for (Building b2 : this.allBuildings()) {
            b2.updateBuildingServer();
            b2.updateBackgroundVillage();
        }
        this.checkConnections();
        for (UserProfile profile : this.profiles.values()) {
            if (!profile.connected && profile.getPlayer() != null) {
                profile.connectUser();
            }
            if (!profile.connected) continue;
            profile.updateProfile();
        }
        for (Object o : this.world.field_73010_i) {
            EntityPlayer player = (EntityPlayer)o;
            SpecialQuestActions.onTick(this, player);
        }
        if (MLN.DEV) {
            DevModUtilities.runAutoMove(this.world);
        }
        for (Point p : this.renameNames.keySet()) {
            if (!this.buildings.containsKey(p)) continue;
            b = this.buildings.get(p);
            b.changeVillageName(this.renameNames.get(p));
            for (i = 0; i < this.villagesList.pos.size(); ++i) {
                if (!this.villagesList.pos.get(i).equals(p)) continue;
                this.villagesList.names.add(i, b.getVillageQualifiedName());
            }
            for (i = 0; i < this.loneBuildingsList.pos.size(); ++i) {
                if (!this.loneBuildingsList.pos.get(i).equals(p)) continue;
                this.loneBuildingsList.names.add(i, b.getVillageQualifiedName());
            }
        }
        for (Point p : this.renameQualifiers.keySet()) {
            if (!this.buildings.containsKey(p)) continue;
            b = this.buildings.get(p);
            b.changeVillageQualifier(this.renameQualifiers.get(p));
            for (i = 0; i < this.villagesList.pos.size(); ++i) {
                if (!this.villagesList.pos.get(i).equals(p)) continue;
                this.villagesList.names.add(i, b.getVillageQualifiedName());
            }
            for (i = 0; i < this.loneBuildingsList.pos.size(); ++i) {
                if (!this.loneBuildingsList.pos.get(i).equals(p)) continue;
                this.loneBuildingsList.names.add(i, b.getVillageQualifiedName());
            }
        }
        this.renameNames.clear();
        this.renameQualifiers.clear();
        this.forcePreload();
        this.testLog();
    }
}

