/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import org.millenaire.common.MLN;
import org.millenaire.common.Point;
import org.millenaire.common.building.BuildingLocation;
import org.millenaire.common.core.MillCommonUtilities;
import org.millenaire.common.forge.Mill;

public class MillWorldInfo
implements Cloneable {
    private static final int MAP_MARGIN = 10;
    private static final int BUILDING_MARGIN = 5;
    private static final int VALID_HEIGHT_DIFF = 10;
    public static final int UPDATE_FREQUENCY = 1000;
    public int length = 0;
    public int width = 0;
    public int chunkStartX = 0;
    public int chunkStartZ = 0;
    public int mapStartX = 0;
    public int mapStartZ = 0;
    public int yBaseline = 0;
    public short[][] topGround;
    public short[][] constructionHeight;
    public short[][] spaceAbove;
    public boolean[][] danger;
    public boolean[][] buildingLoc;
    public boolean[][] canBuild;
    public boolean[][] buildingForbidden;
    public boolean[][] water;
    public boolean[][] tree;
    public boolean[][] buildTested = null;
    public boolean[][] topAdjusted;
    public boolean[][] path;
    public int frequency = 10;
    private List<BuildingLocation> buildingLocations = new ArrayList<BuildingLocation>();
    public BuildingLocation locationIP;
    public int nbLoc = 0;
    public World world;
    public int lastUpdatedX;
    public int lastUpdatedZ;
    private int updateCounter;

    public static boolean[][] booleanArrayDeepClone(boolean[][] source) {
        boolean[][] target = new boolean[source.length][];
        for (int i = 0; i < source.length; ++i) {
            target[i] = (boolean[])source[i].clone();
        }
        return target;
    }

    public static byte[][] byteArrayDeepClone(byte[][] source) {
        byte[][] target = new byte[source.length][];
        for (int i = 0; i < source.length; ++i) {
            target[i] = (byte[])source[i].clone();
        }
        return target;
    }

    public static boolean isForbiddenBlockForConstruction(Block block) {
        return block == Blocks.field_150355_j || block == Blocks.field_150358_i || block == Blocks.field_150432_aD || block == Blocks.field_150356_k || block == Blocks.field_150353_l || block == Blocks.field_150344_f || block == Blocks.field_150347_e || block == Blocks.field_150336_V || block == Blocks.field_150486_ae || block == Blocks.field_150359_w || block == Mill.earth_decoration || block == Mill.stone_decoration || block == Mill.wood_decoration;
    }

    public static short[][] shortArrayDeepClone(short[][] source) {
        short[][] target = new short[source.length][];
        for (int i = 0; i < source.length; ++i) {
            target[i] = (short[])source[i].clone();
        }
        return target;
    }

    public MillWorldInfo clone() throws CloneNotSupportedException {
        MillWorldInfo o = (MillWorldInfo)super.clone();
        o.topGround = MillWorldInfo.shortArrayDeepClone(this.topGround);
        o.constructionHeight = MillWorldInfo.shortArrayDeepClone(this.constructionHeight);
        o.spaceAbove = MillWorldInfo.shortArrayDeepClone(this.spaceAbove);
        o.danger = MillWorldInfo.booleanArrayDeepClone(this.danger);
        o.buildingLoc = MillWorldInfo.booleanArrayDeepClone(this.buildingLoc);
        o.canBuild = MillWorldInfo.booleanArrayDeepClone(this.canBuild);
        o.buildingForbidden = MillWorldInfo.booleanArrayDeepClone(this.buildingForbidden);
        o.water = MillWorldInfo.booleanArrayDeepClone(this.water);
        o.tree = MillWorldInfo.booleanArrayDeepClone(this.tree);
        o.path = MillWorldInfo.booleanArrayDeepClone(this.path);
        o.buildingLocations = new ArrayList<BuildingLocation>();
        o.buildingLocations.addAll(this.buildingLocations);
        return o;
    }

    private void createWorldInfo(List<BuildingLocation> locations, BuildingLocation blIP, int pstartX, int pstartZ, int endX, int endZ) throws MLN.MillenaireException {
        if (MLN.LogWorldInfo >= 2) {
            MLN.minor(this, "Creating world info: " + pstartX + "/" + pstartZ + "/" + endX + "/" + endZ);
        }
        this.chunkStartX = pstartX >> 4;
        this.chunkStartZ = pstartZ >> 4;
        this.mapStartX = this.chunkStartX << 4;
        this.mapStartZ = this.chunkStartZ << 4;
        this.length = ((endX >> 4) + 1 << 4) - this.mapStartX;
        this.width = ((endZ >> 4) + 1 << 4) - this.mapStartZ;
        this.frequency = (int)Math.max(1000.0 / (double)(this.length * this.width / 256), 10.0);
        if (this.frequency == 0) {
            throw new MLN.MillenaireException("Null frequency in createWorldInfo.");
        }
        if (MLN.LogWorldInfo >= 1) {
            MLN.major(this, "Creating world info: " + this.mapStartX + "/" + this.mapStartZ + "/" + this.length + "/" + this.width);
        }
        this.topGround = new short[this.length][this.width];
        this.constructionHeight = new short[this.length][this.width];
        this.spaceAbove = new short[this.length][this.width];
        this.danger = new boolean[this.length][this.width];
        this.buildingLoc = new boolean[this.length][this.width];
        this.buildingForbidden = new boolean[this.length][this.width];
        this.canBuild = new boolean[this.length][this.width];
        this.buildTested = new boolean[this.length][this.width];
        this.water = new boolean[this.length][this.width];
        this.tree = new boolean[this.length][this.width];
        this.path = new boolean[this.length][this.width];
        this.topAdjusted = new boolean[this.length][this.width];
        this.buildingLocations = new ArrayList<BuildingLocation>();
        for (int i = 0; i < this.length; ++i) {
            for (int j = 0; j < this.width; ++j) {
                this.buildingLoc[i][j] = false;
                this.canBuild[i][j] = false;
            }
        }
        for (BuildingLocation location : locations) {
            this.registerBuildingLocation(location);
        }
        this.locationIP = blIP;
        if (this.locationIP != null) {
            this.registerBuildingLocation(this.locationIP);
        }
        for (int i = 0; i < this.length; i += 16) {
            for (int j = 0; j < this.width; j += 16) {
                this.updateChunk(i, j);
            }
        }
        this.lastUpdatedX = 0;
        this.lastUpdatedZ = 0;
    }

    public BuildingLocation getLocationAtCoordPlanar(Point p) {
        if (this.locationIP != null && this.locationIP.isInsidePlanar(p)) {
            return this.locationIP;
        }
        for (BuildingLocation bl : this.buildingLocations) {
            if (!bl.isInsidePlanar(p)) continue;
            return bl;
        }
        return null;
    }

    public boolean isConstructionOrLoggingForbiddenHere(Point p) {
        if (p.getiX() < this.mapStartX || p.getiZ() < this.mapStartZ || p.getiX() >= this.mapStartX + this.length || p.getiZ() >= this.mapStartZ + this.width) {
            return false;
        }
        return this.buildingForbidden[p.getiX() - this.mapStartX][p.getiZ() - this.mapStartZ];
    }

    private void registerBuildingLocation(BuildingLocation bl) {
        if (MLN.LogWorldInfo >= 1) {
            MLN.major(this, "Registering building location: " + bl);
        }
        this.buildingLocations.add(bl);
        int sx = Math.max(bl.minxMargin - this.mapStartX, 0);
        int sz = Math.max(bl.minzMargin - this.mapStartZ, 0);
        int ex = Math.min(bl.maxxMargin - this.mapStartX, this.length + 1);
        int ez = Math.min(bl.maxzMargin - this.mapStartZ, this.width + 1);
        for (int i = sx; i < ex; ++i) {
            for (int j = sz; j < ez; ++j) {
                this.buildingLoc[i][j] = true;
            }
        }
    }

    public void removeBuildingLocation(BuildingLocation bl) {
        for (BuildingLocation l : this.buildingLocations) {
            if (!l.isLocationSamePlace(bl)) continue;
            this.buildingLocations.remove(l);
            break;
        }
        int sx = Math.max(bl.minxMargin - this.mapStartX, 0);
        int sz = Math.max(bl.minzMargin - this.mapStartZ, 0);
        int ex = Math.min(bl.maxxMargin - this.mapStartX, this.length);
        int ez = Math.min(bl.maxzMargin - this.mapStartZ, this.width);
        for (int i = sx; i < ex; ++i) {
            for (int j = sz; j < ez; ++j) {
                this.buildingLoc[i][j] = false;
            }
        }
    }

    public boolean update(World world, List<BuildingLocation> locations, BuildingLocation blIP, Point centre, int radius) throws MLN.MillenaireException {
        this.world = world;
        this.yBaseline = centre.getiY();
        this.locationIP = blIP;
        if (this.buildingLocations != null && this.buildingLocations.size() > 0 && this.buildingLocations.size() == locations.size()) {
            this.buildingLocations = locations;
            this.updateNextChunk();
            return false;
        }
        int startX = centre.getiX();
        int startZ = centre.getiZ();
        int endX = centre.getiX();
        int endZ = centre.getiZ();
        BuildingLocation blStartX = null;
        BuildingLocation blStartZ = null;
        BuildingLocation blEndX = null;
        BuildingLocation blEndZ = null;
        for (BuildingLocation location : locations) {
            if (location == null) continue;
            if (location.pos.getiX() - location.length / 2 < startX) {
                startX = location.pos.getiX() - location.length / 2;
                blStartX = location;
            }
            if (location.pos.getiX() + location.length / 2 > endX) {
                endX = location.pos.getiX() + location.length / 2;
                blEndX = location;
            }
            if (location.pos.getiZ() - location.width / 2 < startZ) {
                startZ = location.pos.getiZ() - location.width / 2;
                blStartZ = location;
            }
            if (location.pos.getiZ() + location.width / 2 <= endZ) continue;
            endZ = location.pos.getiZ() + location.width / 2;
            blEndZ = location;
        }
        if (blIP != null) {
            if (blIP.pos.getiX() - blIP.length / 2 < startX) {
                startX = blIP.pos.getiX() - blIP.length / 2;
                blStartX = blIP;
            }
            if (blIP.pos.getiX() + blIP.length / 2 > endX) {
                endX = blIP.pos.getiX() + blIP.length / 2;
                blEndX = blIP;
            }
            if (blIP.pos.getiZ() - blIP.width / 2 < startZ) {
                startZ = blIP.pos.getiZ() - blIP.width / 2;
                blStartZ = blIP;
            }
            if (blIP.pos.getiZ() + blIP.width / 2 > endZ) {
                endZ = blIP.pos.getiZ() + blIP.width / 2;
                blEndZ = blIP;
            }
        }
        if (MLN.LogWorldInfo >= 1) {
            MLN.major(this, "WorldInfo Centre: " + centre);
            if (startX - 5 < centre.getiX() - radius - 10) {
                MLN.major(this, "Pushing startX down by " + (startX - 5 - (centre.getiX() - radius - 10)) + " due to " + blStartX);
            } else {
                MLN.major(this, "Using default value of " + (centre.getiX() - radius - 10) + " for startX");
            }
            if (startZ - 5 < centre.getiZ() - radius - 10) {
                MLN.major(this, "Pushing startZ down by " + (startZ - 5 - (centre.getiZ() - radius - 10)) + " due to " + blStartZ);
            } else {
                MLN.major(this, "Using default value of " + (centre.getiZ() - radius - 10) + " for startZ");
            }
            if (endX + 5 > centre.getiX() + radius + 10) {
                MLN.major(this, "Pushing endX up by " + (endX + 5 - (centre.getiX() + radius + 10)) + " due to " + blEndX);
            } else {
                MLN.major(this, "Using default value of " + (centre.getiX() + radius + 10) + " for endX");
            }
            if (endZ + 5 > centre.getiZ() + radius + 10) {
                MLN.major(this, "Pushing endZ up by " + (endZ + 5 - (centre.getiZ() + radius + 10)) + " due to " + blEndZ);
            } else {
                MLN.major(this, "Using default value of " + (centre.getiZ() + radius + 10) + " for endZ");
            }
        }
        startX = Math.min(startX - 5, centre.getiX() - radius - 10);
        startZ = Math.min(startZ - 5, centre.getiZ() - radius - 10);
        endX = Math.max(endX + 5, centre.getiX() + radius + 10);
        endZ = Math.max(endZ + 5, centre.getiZ() + radius + 10);
        if (MLN.LogWorldInfo >= 1) {
            MLN.major(this, "Values: " + startX + "/" + startZ + "/" + endX + "/" + endZ);
        }
        int chunkStartXTemp = startX >> 4;
        int chunkStartZTemp = startZ >> 4;
        int mapStartXTemp = chunkStartXTemp << 4;
        int mapStartZTemp = chunkStartZTemp << 4;
        int lengthTemp = ((endX >> 4) + 1 << 4) - mapStartXTemp;
        int widthTemp = ((endZ >> 4) + 1 << 4) - mapStartZTemp;
        if (MLN.LogWorldInfo >= 1) {
            MLN.major(this, "Values after chunks: " + mapStartXTemp + "/" + mapStartZTemp + "/" + (mapStartXTemp + lengthTemp) + "/" + (mapStartZTemp + widthTemp));
        }
        if (lengthTemp != this.length || widthTemp != this.width) {
            this.createWorldInfo(locations, blIP, startX, startZ, endX, endZ);
            return true;
        }
        this.buildingLocations = new ArrayList<BuildingLocation>();
        for (BuildingLocation location : locations) {
            this.registerBuildingLocation(location);
        }
        this.updateNextChunk();
        return false;
    }

    private void updateChunk(int startX, int startZ) {
        int mz;
        int mx;
        int j;
        int i;
        for (int i2 = -1; i2 < 2; ++i2) {
            for (int j2 = -1; j2 < 2; ++j2) {
                if (this.world.func_72863_F().func_73149_a((startX + this.mapStartX >> 4) + i2, (startZ + this.mapStartZ >> 4) + j2)) continue;
                if (MLN.LogWorldInfo >= 3) {
                    MLN.debug(this, "Chunk is not loaded.");
                }
                return;
            }
        }
        Chunk chunk = this.world.func_72938_d(startX + this.mapStartX, startZ + this.mapStartZ);
        if (MLN.LogWorldInfo >= 3) {
            MLN.debug(this, "Updating chunk: " + startX + "/" + startZ + "/" + this.yBaseline + "/" + chunk.field_76635_g + "/" + chunk.field_76647_h);
        }
        for (int i3 = 0; i3 < 16; ++i3) {
            for (int j3 = 0; j3 < 16; ++j3) {
                short y;
                short miny = (short)Math.max(this.yBaseline - 25, 1);
                short maxy = (short)Math.min(this.yBaseline + 25, 255);
                int mx2 = i3 + startX;
                int mz2 = j3 + startZ;
                this.canBuild[mx2][mz2] = false;
                this.buildingForbidden[mx2][mz2] = false;
                this.water[mx2][mz2] = false;
                this.topAdjusted[mx2][mz2] = false;
                int ceilingSize = 0;
                Block tblock = chunk.func_150810_a(i3, (int)y, j3);
                for (y = maxy; y >= miny && !MillCommonUtilities.isBlockIdGround(tblock); y = (short)(y - 1)) {
                    ceilingSize = MillCommonUtilities.isBlockIdGroundOrCeiling(tblock) ? (int)((short)(ceilingSize + 1)) : 0;
                    if (ceilingSize > 3) break;
                    tblock = chunk.func_150810_a(i3, (int)y, j3);
                }
                this.constructionHeight[mx2][mz2] = y;
                boolean heightDone = false;
                Block block = y <= maxy && y > 1 ? chunk.func_150810_a(i3, (int)y, j3) : null;
                boolean onground = true;
                short lastLiquid = -1;
                while (block != null && (MillCommonUtilities.isBlockIdSolid(block) || MillCommonUtilities.isBlockIdLiquid(block) || !onground)) {
                    if (block == Blocks.field_150364_r) {
                        heightDone = true;
                    } else if (!heightDone) {
                        short[] sArray = this.constructionHeight[mx2];
                        int n = mz2;
                        sArray[n] = (short)(sArray[n] + 1);
                    } else {
                        heightDone = true;
                    }
                    if (MillWorldInfo.isForbiddenBlockForConstruction(block)) {
                        this.buildingForbidden[mx2][mz2] = true;
                    }
                    if (MillCommonUtilities.isBlockIdLiquid(block)) {
                        onground = false;
                        lastLiquid = y;
                    } else if (MillCommonUtilities.isBlockIdSolid(block)) {
                        onground = true;
                    }
                    y = (short)(y + 1);
                    if (y <= maxy && y > 1) {
                        block = chunk.func_150810_a(i3, (int)y, j3);
                        continue;
                    }
                    block = null;
                }
                if (!onground) {
                    y = lastLiquid;
                }
                while (y <= maxy && y > 1 && (MillCommonUtilities.isBlockIdSolid(chunk.func_150810_a(i3, (int)y, j3)) || MillCommonUtilities.isBlockIdSolid(chunk.func_150810_a(i3, y + 1, j3)))) {
                    y = (short)(y + 1);
                }
                this.topGround[mx2][mz2] = y = (short)((byte)Math.max(1, y));
                this.spaceAbove[mx2][mz2] = 0;
                Block soilBlock = chunk.func_150810_a(i3, y - 1, j3);
                block = chunk.func_150810_a(i3, (int)y, j3);
                if (block == Blocks.field_150358_i || block == Blocks.field_150355_j) {
                    this.water[mx2][mz2] = true;
                }
                this.tree[mx2][mz2] = soilBlock == Blocks.field_150364_r;
                this.path[mx2][mz2] = soilBlock == Mill.path || soilBlock == Mill.pathSlab;
                boolean blocked = false;
                if (soilBlock != Blocks.field_150422_aJ && !MillCommonUtilities.isBlockIdSolid(block) && block != Blocks.field_150358_i && soilBlock != Blocks.field_150355_j) {
                    this.spaceAbove[mx2][mz2] = 1;
                } else {
                    blocked = true;
                }
                if (block == Blocks.field_150356_k || block == Blocks.field_150353_l) {
                    if (MLN.LogWorldInfo >= 3) {
                        MLN.debug(this, "Found danger: " + block);
                    }
                    this.danger[mx2][mz2] = true;
                } else {
                    this.danger[mx2][mz2] = false;
                    for (Block forbiddenBlock : MLN.forbiddenBlocks) {
                        if (forbiddenBlock == block) {
                            this.danger[mx2][mz2] = true;
                        }
                        if (soilBlock != block) continue;
                        this.danger[mx2][mz2] = true;
                    }
                }
                if (!this.danger[mx2][mz2] && !this.buildingLoc[mx2][mz2] && this.constructionHeight[mx2][mz2] > this.yBaseline - 10 && this.constructionHeight[mx2][mz2] < this.yBaseline + 10) {
                    this.canBuild[mx2][mz2] = true;
                }
                if (MillWorldInfo.isForbiddenBlockForConstruction(block)) {
                    this.buildingForbidden[mx2][mz2] = true;
                }
                for (y = (short)((short)(y + 1)); y < maxy && y > 0; y = (short)((short)(y + 1))) {
                    block = chunk.func_150810_a(i3, (int)y, j3);
                    if (!blocked && this.spaceAbove[mx2][mz2] < 3 && !MillCommonUtilities.isBlockIdSolid(block)) {
                        short[] sArray = this.spaceAbove[mx2];
                        int n = mz2;
                        sArray[n] = (short)(sArray[n] + 1);
                    } else {
                        blocked = true;
                    }
                    if (!MillWorldInfo.isForbiddenBlockForConstruction(block)) continue;
                    this.buildingForbidden[mx2][mz2] = true;
                }
                if (!this.buildingForbidden[mx2][mz2]) continue;
                this.canBuild[mx2][mz2] = false;
            }
        }
        boolean gapFilled = true;
        while (gapFilled) {
            boolean samesolid;
            short ntg;
            gapFilled = false;
            for (i = -5; i < 21; ++i) {
                for (j = -5; j < 21; ++j) {
                    boolean above3solid;
                    boolean above2solid;
                    boolean abovesolid;
                    boolean below2solid;
                    boolean belowsolid;
                    mx = i + startX;
                    mz = j + startZ;
                    if (mz >= 0 && mz < this.width && mx > 1 && mx < this.length - 1 && Math.abs(this.topGround[mx - 1][mz] - this.topGround[mx + 1][mz]) < 2 && (this.topGround[mx - 1][mz] + 2 < this.topGround[mx][mz] || this.topGround[mx + 1][mz] + 2 < this.topGround[mx][mz])) {
                        ntg = this.topGround[mx - 1][mz];
                        samesolid = MillCommonUtilities.isBlockIdSolid(this.world.func_147439_a(startX + this.mapStartX + i, (int)ntg, startZ + this.mapStartZ + j));
                        belowsolid = MillCommonUtilities.isBlockIdSolid(this.world.func_147439_a(startX + this.mapStartX + i, ntg - 1, startZ + this.mapStartZ + j));
                        below2solid = MillCommonUtilities.isBlockIdSolid(this.world.func_147439_a(startX + this.mapStartX + i, ntg - 2, startZ + this.mapStartZ + j));
                        abovesolid = MillCommonUtilities.isBlockIdSolid(this.world.func_147439_a(startX + this.mapStartX + i, ntg + 1, startZ + this.mapStartZ + j));
                        above2solid = MillCommonUtilities.isBlockIdSolid(this.world.func_147439_a(startX + this.mapStartX + i, ntg + 2, startZ + this.mapStartZ + j));
                        above3solid = MillCommonUtilities.isBlockIdSolid(this.world.func_147439_a(startX + this.mapStartX + i, ntg + 3, startZ + this.mapStartZ + j));
                        if (Math.abs(this.topGround[mx - 1][mz] - this.topGround[mx + 1][mz]) < 2 && belowsolid && !samesolid && !abovesolid) {
                            this.topGround[mx][mz] = ntg;
                            this.spaceAbove[mx][mz] = !above2solid ? 3 : 2;
                            gapFilled = true;
                            this.topAdjusted[mx][mz] = true;
                        } else if (this.topGround[mx + 1][mz] <= this.topGround[mx - 1][mz] && below2solid && !belowsolid && !samesolid && !abovesolid) {
                            this.topGround[mx][mz] = (short)(ntg - 1);
                            this.spaceAbove[mx][mz] = !abovesolid ? 3 : 2;
                            gapFilled = true;
                            this.topAdjusted[mx][mz] = true;
                        } else if (this.topGround[mx + 1][mz] >= this.topGround[mx - 1][mz] && samesolid && !abovesolid && !above2solid) {
                            this.topGround[mx][mz] = (short)(ntg + 1);
                            this.spaceAbove[mx][mz] = !above3solid ? 3 : 2;
                            gapFilled = true;
                            this.topAdjusted[mx][mz] = true;
                        }
                    }
                    if (mx < 0 || mx >= this.length || mz <= 1 || mz >= this.width - 1 || Math.abs(this.topGround[mx][mz - 1] - this.topGround[mx][mz + 1]) >= 3 || this.topGround[mx][mz - 1] + 2 >= this.topGround[mx][mz] && this.topGround[mx][mz + 1] + 2 >= this.topGround[mx][mz]) continue;
                    ntg = this.topGround[mx][mz - 1];
                    samesolid = MillCommonUtilities.isBlockIdSolid(this.world.func_147439_a(startX + this.mapStartX + i, (int)ntg, startZ + this.mapStartZ + j));
                    belowsolid = MillCommonUtilities.isBlockIdSolid(this.world.func_147439_a(startX + this.mapStartX + i, ntg - 1, startZ + this.mapStartZ + j));
                    below2solid = MillCommonUtilities.isBlockIdSolid(this.world.func_147439_a(startX + this.mapStartX + i, ntg - 2, startZ + this.mapStartZ + j));
                    abovesolid = MillCommonUtilities.isBlockIdSolid(this.world.func_147439_a(startX + this.mapStartX + i, ntg + 1, startZ + this.mapStartZ + j));
                    above2solid = MillCommonUtilities.isBlockIdSolid(this.world.func_147439_a(startX + this.mapStartX + i, ntg + 2, startZ + this.mapStartZ + j));
                    above3solid = MillCommonUtilities.isBlockIdSolid(this.world.func_147439_a(startX + this.mapStartX + i, ntg + 3, startZ + this.mapStartZ + j));
                    if (Math.abs(this.topGround[mx][mz - 1] - this.topGround[mx][mz + 1]) < 2 && belowsolid && !samesolid && !abovesolid) {
                        this.topGround[mx][mz] = ntg;
                        this.spaceAbove[mx][mz] = !above2solid ? 3 : 2;
                        gapFilled = true;
                        this.topAdjusted[mx][mz] = true;
                        continue;
                    }
                    if (this.topGround[mx][mz + 1] <= this.topGround[mx][mz - 1] && below2solid && !belowsolid && !samesolid && !abovesolid) {
                        this.topGround[mx][mz] = (short)(ntg - 1);
                        this.spaceAbove[mx][mz] = !abovesolid ? 3 : 2;
                        gapFilled = true;
                        this.topAdjusted[mx][mz] = true;
                        continue;
                    }
                    if (this.topGround[mx][mz + 1] < this.topGround[mx][mz - 1] || !samesolid || abovesolid || above2solid) continue;
                    this.topGround[mx][mz] = (short)(ntg + 1);
                    this.spaceAbove[mx][mz] = !above3solid ? 3 : 2;
                    gapFilled = true;
                    this.topAdjusted[mx][mz] = true;
                }
            }
            for (i = -5; i < 21; ++i) {
                for (j = -5; j < 21; ++j) {
                    boolean nextabove2solid;
                    boolean nextabovesolid;
                    boolean nextbelowsolid;
                    boolean nextsamesolid;
                    boolean above2solid;
                    boolean abovesolid;
                    boolean belowsolid;
                    mx = i + startX;
                    mz = j + startZ;
                    if (mz >= 0 && mz < this.width && mx > 1 && mx < this.length - 2 && this.topGround[mx - 1][mz] == this.topGround[mx + 2][mz] && this.topGround[mx - 1][mz] < this.topGround[mx][mz] && this.topGround[mx - 1][mz] < this.topGround[mx + 1][mz]) {
                        ntg = this.topGround[mx - 1][mz];
                        samesolid = MillCommonUtilities.isBlockIdSolid(this.world.func_147439_a(startX + this.mapStartX + i, (int)ntg, startZ + this.mapStartZ + j));
                        belowsolid = MillCommonUtilities.isBlockIdSolid(this.world.func_147439_a(startX + this.mapStartX + i, ntg - 1, startZ + this.mapStartZ + j));
                        abovesolid = MillCommonUtilities.isBlockIdSolid(this.world.func_147439_a(startX + this.mapStartX + i, ntg + 1, startZ + this.mapStartZ + j));
                        above2solid = MillCommonUtilities.isBlockIdSolid(this.world.func_147439_a(startX + this.mapStartX + i, ntg + 2, startZ + this.mapStartZ + j));
                        nextsamesolid = MillCommonUtilities.isBlockIdSolid(this.world.func_147439_a(startX + this.mapStartX + i + 1, (int)ntg, startZ + this.mapStartZ + j));
                        nextbelowsolid = MillCommonUtilities.isBlockIdSolid(this.world.func_147439_a(startX + this.mapStartX + i + 1, ntg - 1, startZ + this.mapStartZ + j));
                        nextabovesolid = MillCommonUtilities.isBlockIdSolid(this.world.func_147439_a(startX + this.mapStartX + i + 1, ntg + 1, startZ + this.mapStartZ + j));
                        nextabove2solid = MillCommonUtilities.isBlockIdSolid(this.world.func_147439_a(startX + this.mapStartX + i + 1, ntg + 2, startZ + this.mapStartZ + j));
                        if (belowsolid && nextbelowsolid && !samesolid && !nextsamesolid && !abovesolid && !nextabovesolid) {
                            this.topGround[mx][mz] = ntg;
                            this.topGround[mx + 1][mz] = ntg;
                            this.spaceAbove[mx][mz] = !above2solid ? 3 : 2;
                            this.spaceAbove[mx + 1][mz] = !nextabove2solid ? 3 : 2;
                            gapFilled = true;
                            this.topAdjusted[mx][mz] = true;
                        }
                    }
                    if (mx < 0 || mx >= this.length || mz <= 1 || mz >= this.width - 2 || this.topGround[mx][mz - 1] != this.topGround[mx][mz + 2] || this.topGround[mx][mz - 1] >= this.topGround[mx][mz] || this.topGround[mx][mz - 1] >= this.topGround[mx][mz + 1]) continue;
                    ntg = this.topGround[mx][mz - 1];
                    samesolid = MillCommonUtilities.isBlockIdSolid(this.world.func_147439_a(startX + this.mapStartX + i, (int)ntg, startZ + this.mapStartZ + j));
                    belowsolid = MillCommonUtilities.isBlockIdSolid(this.world.func_147439_a(startX + this.mapStartX + i, ntg - 1, startZ + this.mapStartZ + j));
                    abovesolid = MillCommonUtilities.isBlockIdSolid(this.world.func_147439_a(startX + this.mapStartX + i, ntg + 1, startZ + this.mapStartZ + j));
                    above2solid = MillCommonUtilities.isBlockIdSolid(this.world.func_147439_a(startX + this.mapStartX + i, ntg + 2, startZ + this.mapStartZ + j));
                    nextsamesolid = MillCommonUtilities.isBlockIdSolid(this.world.func_147439_a(startX + this.mapStartX + i, (int)ntg, startZ + this.mapStartZ + j + 1));
                    nextbelowsolid = MillCommonUtilities.isBlockIdSolid(this.world.func_147439_a(startX + this.mapStartX + i, ntg - 1, startZ + this.mapStartZ + j + 1));
                    nextabovesolid = MillCommonUtilities.isBlockIdSolid(this.world.func_147439_a(startX + this.mapStartX + i, ntg + 1, startZ + this.mapStartZ + j + 1));
                    nextabove2solid = MillCommonUtilities.isBlockIdSolid(this.world.func_147439_a(startX + this.mapStartX + i, ntg + 2, startZ + this.mapStartZ + j + 1));
                    if (!belowsolid || !nextbelowsolid || samesolid || nextsamesolid || abovesolid || nextabovesolid) continue;
                    this.topGround[mx][mz] = ntg;
                    this.topGround[mx][mz + 1] = ntg;
                    this.spaceAbove[mx][mz] = !above2solid ? 3 : 2;
                    this.spaceAbove[mx][mz + 1] = !nextabove2solid ? 3 : 2;
                    gapFilled = true;
                    this.topAdjusted[mx][mz] = true;
                }
            }
        }
        for (i = 0; i < 16; ++i) {
            for (j = 0; j < 16; ++j) {
                mx = i + startX;
                mz = j + startZ;
                if (!this.danger[mx][mz]) continue;
                for (int k = -2; k < 3; ++k) {
                    for (int l = -2; l < 3; ++l) {
                        if (k < 0 || l < 0 || k >= this.length || l >= this.width) continue;
                        this.spaceAbove[mx][mz] = 0;
                    }
                }
            }
        }
    }

    public void updateNextChunk() {
        this.updateCounter = (this.updateCounter + 1) % this.frequency;
        if (this.updateCounter != 0) {
            return;
        }
        ++this.lastUpdatedX;
        if (this.lastUpdatedX * 16 >= this.length) {
            this.lastUpdatedX = 0;
            ++this.lastUpdatedZ;
        }
        if (this.lastUpdatedZ * 16 >= this.width) {
            this.lastUpdatedZ = 0;
        }
        UpdateThread thread = new UpdateThread();
        thread.setPriority(1);
        thread.x = this.lastUpdatedX << 4;
        thread.z = this.lastUpdatedZ << 4;
        thread.start();
    }

    public class UpdateThread
    extends Thread {
        int x;
        int z;

        @Override
        public void run() {
            MillWorldInfo.this.updateChunk(this.x, this.z);
        }
    }
}

