/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common.building;

import net.minecraft.block.Block;
import net.minecraft.block.BlockButton;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenForest;
import net.minecraft.world.gen.feature.WorldGenTaiga2;
import net.minecraft.world.gen.feature.WorldGenTrees;
import org.millenaire.common.EntityMillDecoration;
import org.millenaire.common.MLN;
import org.millenaire.common.Point;
import org.millenaire.common.building.Building;
import org.millenaire.common.core.MillCommonUtilities;
import org.millenaire.common.forge.Mill;

public class BuildingBlock {
    public static byte TAPESTRY = 1;
    public static byte OAKSPAWN = (byte)2;
    public static byte PINESPAWN = (byte)3;
    public static byte BIRCHSPAWN = (byte)4;
    public static byte INDIANSTATUE = (byte)5;
    public static byte PRESERVEGROUNDDEPTH = (byte)6;
    public static byte CLEARTREE = (byte)7;
    public static byte MAYANSTATUE = (byte)8;
    public static byte SPAWNERSKELETON = (byte)9;
    public static byte SPAWNERZOMBIE = (byte)10;
    public static byte SPAWNERSPIDER = (byte)11;
    public static byte SPAWNERCAVESPIDER = (byte)12;
    public static byte SPAWNERCREEPER = (byte)13;
    public static byte DISPENDERUNKNOWNPOWDER = (byte)14;
    public static byte JUNGLESPAWN = (byte)15;
    public static byte INVERTEDDOOR = (byte)16;
    public static byte CLEARGROUND = (byte)17;
    public static byte BYZANTINEICONSMALL = (byte)18;
    public static byte BYZANTINEICONMEDIUM = (byte)19;
    public static byte BYZANTINEICONLARGE = (byte)20;
    public static byte PRESERVEGROUNDSURFACE = (byte)21;
    public static byte SPAWNERBLAZE = (byte)22;
    public Block block;
    public byte meta;
    public Point p;
    public byte special;

    public static BuildingBlock read(NBTTagCompound nbttagcompound, String label) {
        Point p = Point.read(nbttagcompound, label + "pos");
        return new BuildingBlock(p, nbttagcompound.func_74762_e(label + "bid"), nbttagcompound.func_74762_e(label + "meta"), nbttagcompound.func_74762_e(label + "special"));
    }

    BuildingBlock(Point p, Block block) {
        this(p, block, 0);
    }

    public BuildingBlock(Point p, Block block, int meta) {
        this.p = p;
        this.block = block;
        this.meta = (byte)meta;
        this.special = 0;
    }

    public BuildingBlock(Point p, Block block, int meta, int special) {
        this.p = p;
        this.block = block;
        this.meta = (byte)meta;
        this.special = (byte)special;
    }

    public BuildingBlock(Point p, int blockID, int meta, int special) {
        this.p = p;
        this.block = (Block)Block.field_149771_c.func_148754_a(blockID);
        this.meta = (byte)meta;
        this.special = (byte)special;
    }

    public boolean alreadyDone(World world) {
        if (this.special != 0) {
            return false;
        }
        Block block = MillCommonUtilities.getBlock(world, this.p);
        if (this.block != block) {
            return false;
        }
        int meta = MillCommonUtilities.getBlockMeta(world, this.p);
        return this.meta == meta;
    }

    public void build(World world, boolean worldGeneration, boolean wandimport) {
        try {
            boolean playSound;
            boolean notifyBlocks = true;
            boolean bl = playSound = !worldGeneration && !wandimport;
            if (!(this.special == PRESERVEGROUNDDEPTH || this.special == PRESERVEGROUNDSURFACE || this.special == CLEARTREE || wandimport && this.block == Blocks.field_150350_a && MillCommonUtilities.getBlock(world, this.p) == Blocks.field_150472_an)) {
                MillCommonUtilities.setBlockAndMetadata(world, this.p, this.block, this.meta, true, playSound);
            }
            if (this.special == PRESERVEGROUNDDEPTH || this.special == PRESERVEGROUNDSURFACE) {
                boolean surface;
                Block block = MillCommonUtilities.getBlock(world, this.p);
                Block validGroundBlock = MillCommonUtilities.getBlockIdValidGround(block, surface = this.special == PRESERVEGROUNDSURFACE);
                if (validGroundBlock == null) {
                    Point below = this.p.getBelow();
                    Object targetblock = null;
                    while (targetblock == null && below.getiY() > 0) {
                        block = MillCommonUtilities.getBlock(world, below);
                        if (MillCommonUtilities.getBlockIdValidGround(block, surface) != null) {
                            targetblock = MillCommonUtilities.getBlockIdValidGround(block, surface);
                        }
                        below = below.getBelow();
                    }
                    if (targetblock == Blocks.field_150346_d && worldGeneration) {
                        targetblock = Blocks.field_150349_c;
                    } else if (targetblock == Blocks.field_150349_c && !worldGeneration) {
                        targetblock = Blocks.field_150346_d;
                    }
                    if (targetblock == Blocks.field_150350_a) {
                        targetblock = worldGeneration ? Blocks.field_150349_c : Blocks.field_150346_d;
                    }
                    MillCommonUtilities.setBlockAndMetadata(world, this.p, (Block)targetblock, 0, true, playSound);
                } else if (worldGeneration && validGroundBlock == Blocks.field_150346_d && MillCommonUtilities.getBlock(world, this.p.getAbove()) == null) {
                    MillCommonUtilities.setBlockAndMetadata(world, this.p, (Block)Blocks.field_150349_c, 0, true, playSound);
                } else if (validGroundBlock != block && (validGroundBlock != Blocks.field_150346_d || block != Blocks.field_150349_c)) {
                    MillCommonUtilities.setBlockAndMetadata(world, this.p, validGroundBlock, 0, true, playSound);
                }
            } else if (this.special == CLEARTREE) {
                Block block = MillCommonUtilities.getBlock(world, this.p);
                if (block == Blocks.field_150364_r || block == Blocks.field_150362_t) {
                    MillCommonUtilities.setBlockAndMetadata(world, this.p, Blocks.field_150350_a, 0, true, playSound);
                    Block blockBelow = MillCommonUtilities.getBlock(world, this.p.getBelow());
                    Block targetBlock = MillCommonUtilities.getBlockIdValidGround(blockBelow, true);
                    if (worldGeneration && targetBlock == Blocks.field_150346_d) {
                        MillCommonUtilities.setBlock(world, this.p.getBelow(), (Block)Blocks.field_150349_c, true, playSound);
                    } else if (targetBlock != null) {
                        MillCommonUtilities.setBlock(world, this.p.getBelow(), targetBlock, true, playSound);
                    }
                }
            } else if (this.special == CLEARGROUND) {
                if (!wandimport || MillCommonUtilities.getBlock(world, this.p) != Blocks.field_150472_an) {
                    MillCommonUtilities.setBlockAndMetadata(world, this.p, Blocks.field_150350_a, 0, true, playSound);
                }
                Block blockBelow = MillCommonUtilities.getBlock(world, this.p.getBelow());
                Block targetBlock = MillCommonUtilities.getBlockIdValidGround(blockBelow, true);
                if (worldGeneration && targetBlock == Blocks.field_150346_d) {
                    MillCommonUtilities.setBlock(world, this.p.getBelow(), (Block)Blocks.field_150349_c, true, playSound);
                } else if (targetBlock != null) {
                    MillCommonUtilities.setBlock(world, this.p.getBelow(), targetBlock, true, playSound);
                }
            } else if (this.special == TAPESTRY) {
                EntityMillDecoration tapestry = EntityMillDecoration.createTapestry(world, this.p, 1);
                if (tapestry.func_70518_d() && !world.field_72995_K) {
                    world.func_72838_d((Entity)tapestry);
                }
            } else if (this.special == INDIANSTATUE) {
                EntityMillDecoration statue = EntityMillDecoration.createTapestry(world, this.p, 2);
                if (statue.func_70518_d() && !world.field_72995_K) {
                    world.func_72838_d((Entity)statue);
                }
            } else if (this.special == MAYANSTATUE) {
                EntityMillDecoration statue = EntityMillDecoration.createTapestry(world, this.p, 3);
                if (statue.func_70518_d() && !world.field_72995_K) {
                    world.func_72838_d((Entity)statue);
                }
            } else if (this.special == BYZANTINEICONSMALL) {
                EntityMillDecoration statue = EntityMillDecoration.createTapestry(world, this.p, 4);
                if (statue.func_70518_d() && !world.field_72995_K) {
                    world.func_72838_d((Entity)statue);
                }
            } else if (this.special == BYZANTINEICONMEDIUM) {
                EntityMillDecoration statue = EntityMillDecoration.createTapestry(world, this.p, 5);
                if (statue.func_70518_d() && !world.field_72995_K) {
                    world.func_72838_d((Entity)statue);
                }
            } else if (this.special == BYZANTINEICONLARGE) {
                EntityMillDecoration statue = EntityMillDecoration.createTapestry(world, this.p, 6);
                if (statue.func_70518_d() && !world.field_72995_K) {
                    world.func_72838_d((Entity)statue);
                }
            } else if (this.special == OAKSPAWN) {
                if (worldGeneration) {
                    WorldGenTrees wg = new WorldGenTrees(false);
                    wg.func_76484_a(world, MillCommonUtilities.random, this.p.getiX(), this.p.getiY(), this.p.getiZ());
                }
            } else if (this.special == PINESPAWN) {
                if (worldGeneration) {
                    WorldGenTaiga2 wg = new WorldGenTaiga2(false);
                    wg.func_76484_a(world, MillCommonUtilities.random, this.p.getiX(), this.p.getiY(), this.p.getiZ());
                }
            } else if (this.special == BIRCHSPAWN) {
                if (worldGeneration) {
                    WorldGenForest wg = new WorldGenForest(false, true);
                    wg.func_76484_a(world, MillCommonUtilities.random, this.p.getiX(), this.p.getiY(), this.p.getiZ());
                }
            } else if (this.special == JUNGLESPAWN) {
                if (worldGeneration) {
                    WorldGenTrees wg = new WorldGenTrees(true, 4 + MillCommonUtilities.random.nextInt(7), 3, 3, false);
                    wg.func_76484_a(world, MillCommonUtilities.random, this.p.getiX(), this.p.getiY(), this.p.getiZ());
                }
            } else if (this.special == SPAWNERSKELETON) {
                MillCommonUtilities.setBlockAndMetadata(world, this.p, Blocks.field_150474_ac, 0);
                TileEntityMobSpawner tileentitymobspawner = (TileEntityMobSpawner)this.p.getTileEntity(world);
                tileentitymobspawner.func_145881_a().func_98272_a("Skeleton");
            } else if (this.special == SPAWNERZOMBIE) {
                MillCommonUtilities.setBlockAndMetadata(world, this.p, Blocks.field_150474_ac, 0);
                TileEntityMobSpawner tileentitymobspawner = (TileEntityMobSpawner)this.p.getTileEntity(world);
                tileentitymobspawner.func_145881_a().func_98272_a("Zombie");
            } else if (this.special == SPAWNERSPIDER) {
                MillCommonUtilities.setBlockAndMetadata(world, this.p, Blocks.field_150474_ac, 0);
                TileEntityMobSpawner tileentitymobspawner = (TileEntityMobSpawner)this.p.getTileEntity(world);
                tileentitymobspawner.func_145881_a().func_98272_a("Spider");
            } else if (this.special == SPAWNERCAVESPIDER) {
                MillCommonUtilities.setBlockAndMetadata(world, this.p, Blocks.field_150474_ac, 0);
                TileEntityMobSpawner tileentitymobspawner = (TileEntityMobSpawner)this.p.getTileEntity(world);
                tileentitymobspawner.func_145881_a().func_98272_a("CaveSpider");
            } else if (this.special == SPAWNERCREEPER) {
                MillCommonUtilities.setBlockAndMetadata(world, this.p, Blocks.field_150474_ac, 0);
                TileEntityMobSpawner tileentitymobspawner = (TileEntityMobSpawner)this.p.getTileEntity(world);
                tileentitymobspawner.func_145881_a().func_98272_a("Creeper");
            } else if (this.special == SPAWNERBLAZE) {
                MillCommonUtilities.setBlockAndMetadata(world, this.p, Blocks.field_150474_ac, 0);
                TileEntityMobSpawner tileentitymobspawner = (TileEntityMobSpawner)this.p.getTileEntity(world);
                tileentitymobspawner.func_145881_a().func_98272_a("Blaze");
            } else if (this.special == DISPENDERUNKNOWNPOWDER) {
                MillCommonUtilities.setBlockAndMetadata(world, this.p, Blocks.field_150367_z, 0);
                TileEntityDispenser dispenser = this.p.getDispenser(world);
                MillCommonUtilities.putItemsInChest((IInventory)dispenser, Mill.unknownPowder, 2);
            } else if (this.block == Blocks.field_150466_ao) {
                if (this.special == INVERTEDDOOR) {
                    MillCommonUtilities.setBlockAndMetadata(world, this.p.getAbove(), this.block, 9, true, playSound);
                } else {
                    MillCommonUtilities.setBlockAndMetadata(world, this.p.getAbove(), this.block, 8, true, playSound);
                }
            } else if (this.block == Blocks.field_150454_av) {
                if (this.special == INVERTEDDOOR) {
                    MillCommonUtilities.setBlockAndMetadata(world, this.p.getAbove(), this.block, 9, true, playSound);
                } else {
                    MillCommonUtilities.setBlockAndMetadata(world, this.p.getAbove(), this.block, 8, true, playSound);
                }
            } else if (this.block == Blocks.field_150324_C) {
                if ((this.meta & 3) == 0) {
                    MillCommonUtilities.setBlockAndMetadata(world, this.p.getEast(), this.block, this.meta - 8, true, playSound);
                }
                if ((this.meta & 3) == 1) {
                    MillCommonUtilities.setBlockAndMetadata(world, this.p.getSouth(), this.block, this.meta - 8, true, playSound);
                }
                if ((this.meta & 3) == 2) {
                    MillCommonUtilities.setBlockAndMetadata(world, this.p.getWest(), this.block, this.meta - 8, true, playSound);
                }
                if ((this.meta & 3) == 3) {
                    MillCommonUtilities.setBlockAndMetadata(world, this.p.getNorth(), this.block, this.meta - 8, true, playSound);
                }
            } else if (this.block == Blocks.field_150430_aB) {
                int newmeta = ((BlockButton)Blocks.field_150430_aB).func_149660_a(world, this.p.getiX(), this.p.getiY(), this.p.getiZ(), 0, 0.0f, 0.0f, 0.0f, 0);
                MillCommonUtilities.setBlockMetadata(world, this.p, newmeta, true);
            } else if (this.block == Blocks.field_150355_j) {
                MillCommonUtilities.notifyBlock(world, this.p);
            } else if (this.block == Blocks.field_150460_al) {
                this.setFurnaceMeta(world, this.p);
            } else if (this.block == Blocks.field_150427_aO) {
                Blocks.field_150427_aO.func_150000_e(world, this.p.getiX(), this.p.getiY(), this.p.getiZ());
            }
        }
        catch (Exception e) {
            MLN.printException("Exception in BuildingBlock.build():", e);
        }
    }

    public void pathBuild(Building th) {
        int targetPathLevel = 0;
        for (int i = 0; i < th.villageType.pathMaterial.size(); ++i) {
            if (th.villageType.pathMaterial.get(i).getBlock() != this.block && (th.villageType.pathMaterial.get(i).getBlock() != Mill.path || this.block != Mill.pathSlab) || th.villageType.pathMaterial.get((int)i).meta != this.meta) continue;
            targetPathLevel = i;
        }
        Block currentBlock = this.p.getBlock(th.worldObj);
        int meta = this.p.getMeta(th.worldObj);
        if (currentBlock != Mill.path && currentBlock != Mill.pathSlab && MillCommonUtilities.canPathBeBuiltHere(currentBlock, meta)) {
            this.build(th.worldObj, false, false);
        } else if (currentBlock == Mill.path || currentBlock == Mill.pathSlab) {
            int currentPathLevel = Integer.MAX_VALUE;
            for (int i = 0; i < th.villageType.pathMaterial.size(); ++i) {
                if (th.villageType.pathMaterial.get((int)i).meta != meta) continue;
                currentPathLevel = i;
            }
            if (currentPathLevel < targetPathLevel) {
                this.build(th.worldObj, false, false);
            }
        }
    }

    private void setFurnaceMeta(World world, Point p) {
        Block var5 = p.getRelative(0.0, 0.0, -1.0).getBlock(world);
        Block var6 = p.getRelative(0.0, 0.0, 1.0).getBlock(world);
        Block var7 = p.getRelative(-1.0, 0.0, 0.0).getBlock(world);
        Block var8 = p.getRelative(1.0, 0.0, 0.0).getBlock(world);
        int var9 = 3;
        if (var5.func_149662_c() && var5 != Blocks.field_150460_al && var5 != Blocks.field_150470_am && !var6.func_149662_c()) {
            var9 = 3;
        }
        if (var6.func_149662_c() && var6 != Blocks.field_150460_al && var6 != Blocks.field_150470_am && !var5.func_149662_c()) {
            var9 = 2;
        }
        if (var7.func_149662_c() && var7 != Blocks.field_150460_al && var7 != Blocks.field_150470_am && !var8.func_149662_c()) {
            var9 = 5;
        }
        if (var8.func_149662_c() && var8 != Blocks.field_150460_al && var8 != Blocks.field_150470_am && !var7.func_149662_c()) {
            var9 = 4;
        }
        MillCommonUtilities.setBlockMetadata(world, p, var9);
    }

    public String toString() {
        return "(block: " + this.block + " meta: " + this.meta + " pos:" + this.p + ")";
    }

    public void write(NBTTagCompound nbttagcompound, String label) {
        nbttagcompound.func_74768_a(label + "bid", Block.func_149682_b((Block)this.block));
        nbttagcompound.func_74768_a(label + "meta", (int)this.meta);
        nbttagcompound.func_74768_a(label + "special", (int)this.special);
        this.p.write(nbttagcompound, label + "pos");
    }
}

