/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common.building;

import net.minecraft.block.Block;
import org.millenaire.common.MLN;
import org.millenaire.common.building.BuildingPlan;
import org.millenaire.common.core.MillCommonUtilities;

public class PointType {
    int colour = -1;
    int meta = -1;
    char letter;
    final String name;
    Block block;
    boolean secondStep = false;

    static PointType readColourPoint(String s) throws MLN.MillenaireException {
        String[] params = s.split(";", -1);
        if (params.length != 5) {
            throw new MLN.MillenaireException("Line " + s + " in blocklist.txt does not have five fields.");
        }
        String[] rgb = params[4].split("/", -1);
        if (rgb.length != 3) {
            throw new MLN.MillenaireException("Colour in line " + s + " does not have three values.");
        }
        int colour = (Integer.parseInt(rgb[0]) << 16) + (Integer.parseInt(rgb[1]) << 8) + (Integer.parseInt(rgb[2]) << 0);
        if (MLN.LogBuildingPlan >= 1) {
            MLN.major(null, "Loading colour point: " + BuildingPlan.getColourString(colour) + ", " + params[0]);
        }
        if (params[1].length() == 0) {
            return new PointType(colour, params[0]);
        }
        return new PointType(colour, params[1], Integer.parseInt(params[2]), Boolean.parseBoolean(params[3]));
    }

    public PointType(char letter, Block block, int meta, boolean secondStep) {
        this.letter = letter;
        this.block = block;
        this.meta = meta;
        this.secondStep = secondStep;
        this.name = null;
    }

    public PointType(char letter, String name) {
        this.name = name;
        this.letter = letter;
        this.block = null;
    }

    public PointType(char letter, String minecraftBlockName, int meta, boolean secondStep) {
        this.letter = letter;
        this.block = Block.func_149684_b((String)minecraftBlockName);
        this.meta = meta;
        this.secondStep = secondStep;
        this.name = null;
    }

    public PointType(int colour, String name) {
        this.name = name;
        this.colour = colour;
        this.block = null;
    }

    public PointType(int colour, String minecraftBlockName, int meta, boolean secondStep) {
        this.colour = colour;
        this.block = Block.func_149684_b((String)minecraftBlockName);
        this.meta = meta;
        this.secondStep = secondStep;
        this.name = null;
    }

    public Block getBlock() {
        return this.block;
    }

    public boolean isSubType(String type) {
        if (this.name == null) {
            return false;
        }
        return this.name.startsWith(type);
    }

    public boolean isType(String type) {
        return type.equalsIgnoreCase(this.name);
    }

    public String toString() {
        return this.name + "/" + this.colour + "/" + this.block + "/" + this.meta + "/" + MillCommonUtilities.getPointHash(this.block, this.meta);
    }
}

