/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common.goal;

import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import org.millenaire.common.InvItem;
import org.millenaire.common.MLN;
import org.millenaire.common.MillVillager;
import org.millenaire.common.Point;
import org.millenaire.common.building.Building;
import org.millenaire.common.core.MillCommonUtilities;
import org.millenaire.common.goal.GoalBePujaPerformer;
import org.millenaire.common.goal.GoalBeSeller;
import org.millenaire.common.goal.GoalBreedAnimals;
import org.millenaire.common.goal.GoalBrewPotions;
import org.millenaire.common.goal.GoalBringBackResourcesHome;
import org.millenaire.common.goal.GoalBuildPath;
import org.millenaire.common.goal.GoalByzantineGatherSilk;
import org.millenaire.common.goal.GoalChildBecomeAdult;
import org.millenaire.common.goal.GoalClearOldPath;
import org.millenaire.common.goal.GoalConstructionStepByStep;
import org.millenaire.common.goal.GoalDefendVillage;
import org.millenaire.common.goal.GoalDeliverGoodsHousehold;
import org.millenaire.common.goal.GoalDeliverResourcesShop;
import org.millenaire.common.goal.GoalFish;
import org.millenaire.common.goal.GoalForeignMerchantKeepStall;
import org.millenaire.common.goal.GoalGatherGoods;
import org.millenaire.common.goal.GoalGetGoodsForHousehold;
import org.millenaire.common.goal.GoalGetResourcesForBuild;
import org.millenaire.common.goal.GoalGetResourcesForShops;
import org.millenaire.common.goal.GoalGetTool;
import org.millenaire.common.goal.GoalGuardPatrol;
import org.millenaire.common.goal.GoalHarvestCacao;
import org.millenaire.common.goal.GoalHarvestWarts;
import org.millenaire.common.goal.GoalHide;
import org.millenaire.common.goal.GoalHuntMonster;
import org.millenaire.common.goal.GoalIndianDryBrick;
import org.millenaire.common.goal.GoalIndianGatherBrick;
import org.millenaire.common.goal.GoalIndianHarvestSugarCane;
import org.millenaire.common.goal.GoalIndianPlantSugarCane;
import org.millenaire.common.goal.GoalLumbermanChopTrees;
import org.millenaire.common.goal.GoalLumbermanPlantSaplings;
import org.millenaire.common.goal.GoalMerchantVisitBuilding;
import org.millenaire.common.goal.GoalMerchantVisitInn;
import org.millenaire.common.goal.GoalMinerMineResource;
import org.millenaire.common.goal.GoalPerformPuja;
import org.millenaire.common.goal.GoalPlantCacao;
import org.millenaire.common.goal.GoalPlantNetherWarts;
import org.millenaire.common.goal.GoalRaidVillage;
import org.millenaire.common.goal.GoalShearSheep;
import org.millenaire.common.goal.GoalSleep;
import org.millenaire.common.goal.generic.GoalGeneric;
import org.millenaire.common.goal.leasure.GoalChildGoPlay;
import org.millenaire.common.goal.leasure.GoalGoChat;
import org.millenaire.common.goal.leasure.GoalGoDrink;
import org.millenaire.common.goal.leasure.GoalGoPray;
import org.millenaire.common.goal.leasure.GoalGoRest;
import org.millenaire.common.goal.leasure.GoalGoSocialise;
import org.millenaire.common.pathing.atomicstryker.AStarConfig;

public abstract class Goal {
    public static final int STANDARD_DELAY = 2000;
    public static HashMap<String, Goal> goals;
    public static GoalBeSeller beSeller;
    public static Goal construction;
    public static Goal deliverGoodsHousehold;
    public static Goal getResourcesForBuild;
    public static Goal raidVillage;
    public static Goal defendVillage;
    public static Goal hide;
    public static Goal sleep;
    public static Goal gettool;
    public static Goal gosocialise;
    public static final AStarConfig JPS_CONFIG_TIGHT;
    public static final AStarConfig JPS_CONFIG_WIDE;
    public static final AStarConfig JPS_CONFIG_BUILDING;
    public static final AStarConfig JPS_CONFIG_CHOPLUMBER;
    public static final AStarConfig JPS_CONFIG_SLAUGHTERSQUIDS;
    protected static final Point[] EMPTY_DEST;
    public String key;
    public boolean leasure = false;
    public HashMap<InvItem, Integer> buildingLimit = new HashMap();
    public HashMap<InvItem, Integer> townhallLimit = new HashMap();
    public int maxSimultaneousInBuilding = 0;
    public int maxSimultaneousTotal = 0;
    public InvItem balanceOutput1 = null;
    public InvItem balanceOutput2 = null;
    protected static int ACTIVATION_RANGE;

    public static void initGoals() {
        goals = new HashMap();
        goals.put("gorest", new GoalGoRest());
        goals.put("godrink", new GoalGoDrink());
        goals.put("gopray", new GoalGoPray());
        gosocialise = new GoalGoSocialise();
        goals.put("gosocialise", gosocialise);
        goals.put("chat", new GoalGoChat());
        goals.put("gathergoods", new GoalGatherGoods());
        goals.put("bringbackresourceshome", new GoalBringBackResourcesHome());
        gettool = new GoalGetTool();
        goals.put("getitemtokeep", gettool);
        goals.put("huntmonster", new GoalHuntMonster());
        goals.put("getgoodshousehold", new GoalGetGoodsForHousehold());
        sleep = new GoalSleep();
        goals.put("sleep", sleep);
        deliverGoodsHousehold = new GoalDeliverGoodsHousehold();
        goals.put("delivergoodshousehold", deliverGoodsHousehold);
        goals.put("gethousethresources", new GoalGetResourcesForShops());
        goals.put("deliverresourcesshop", new GoalDeliverResourcesShop());
        goals.put("choptrees", new GoalLumbermanChopTrees());
        goals.put("plantsaplings", new GoalLumbermanPlantSaplings());
        getResourcesForBuild = new GoalGetResourcesForBuild();
        goals.put("getresourcesforbuild", getResourcesForBuild);
        beSeller = new GoalBeSeller();
        goals.put("beseller", beSeller);
        construction = new GoalConstructionStepByStep();
        goals.put("construction", construction);
        goals.put("buildpath", new GoalBuildPath());
        goals.put("clearoldpath", new GoalClearOldPath());
        raidVillage = new GoalRaidVillage();
        goals.put("raidvillage", raidVillage);
        defendVillage = new GoalDefendVillage();
        goals.put("defendvillage", defendVillage);
        hide = new GoalHide();
        goals.put("hide", hide);
        goals.put("goplay", new GoalChildGoPlay());
        goals.put("becomeadult", new GoalChildBecomeAdult());
        goals.put("patrol", new GoalGuardPatrol());
        goals.put("shearsheep", new GoalShearSheep());
        goals.put("breed", new GoalBreedAnimals());
        goals.put("mining", new GoalMinerMineResource());
        goals.put("visitinn", new GoalMerchantVisitInn());
        goals.put("visitbuilding", new GoalMerchantVisitBuilding());
        goals.put("keepstall", new GoalForeignMerchantKeepStall());
        goals.put("drybrick", new GoalIndianDryBrick());
        goals.put("gatherbrick", new GoalIndianGatherBrick());
        goals.put("plantsugarcane", new GoalIndianPlantSugarCane());
        goals.put("harvestsugarcane", new GoalIndianHarvestSugarCane());
        goals.put("performpujas", new GoalPerformPuja());
        goals.put("bepujaperformer", new GoalBePujaPerformer());
        goals.put("fish", new GoalFish());
        goals.put("harvestwarts", new GoalHarvestWarts());
        goals.put("plantwarts", new GoalPlantNetherWarts());
        goals.put("brewpotions", new GoalBrewPotions());
        goals.put("gathersilk", new GoalByzantineGatherSilk());
        goals.put("plantcocoa", new GoalPlantCacao());
        goals.put("harvestcocoa", new GoalHarvestCacao());
        GoalGeneric.loadGenericGoals();
        Iterator<String> i$ = goals.keySet().iterator();
        while (i$.hasNext()) {
            String s;
            Goal.goals.get((Object)s).key = s = i$.next();
        }
    }

    public int actionDuration(MillVillager villager) throws Exception {
        return 500;
    }

    public boolean allowRandomMoves() throws Exception {
        return false;
    }

    public boolean canBeDoneAtNight() {
        return false;
    }

    public boolean canBeDoneInDayTime() {
        return true;
    }

    public String gameName(MillVillager villager) {
        if (villager != null && this.getCurrentGoalTarget(villager) != null && this.getCurrentGoalTarget(villager).horizontalDistanceTo((Entity)villager) > (double)this.range(villager)) {
            return MLN.string("goal." + this.labelKeyWhileTravelling(villager));
        }
        return MLN.string("goal." + this.labelKey(villager));
    }

    public Point getCurrentGoalTarget(MillVillager villager) {
        if (villager.getGoalDestEntity() != null) {
            return new Point(villager.getGoalDestEntity());
        }
        return villager.getGoalDestPoint();
    }

    public abstract GoalInformation getDestination(MillVillager var1) throws Exception;

    public ItemStack[] getHeldItemsDestination(MillVillager villager) throws Exception {
        return this.getHeldItemsTravelling(villager);
    }

    public ItemStack[] getHeldItemsTravelling(MillVillager villager) throws Exception {
        return null;
    }

    public AStarConfig getPathingConfig() {
        return MillVillager.DEFAULT_JPS_CONFIG;
    }

    public Entity getTargetEntity(MillVillager villager) {
        return null;
    }

    public boolean isFightingGoal() {
        return false;
    }

    public final boolean isPossible(MillVillager villager) {
        try {
            if (villager.field_70170_p.func_72935_r() && !this.canBeDoneInDayTime()) {
                return false;
            }
            if (!villager.field_70170_p.func_72935_r() && !this.canBeDoneAtNight()) {
                return false;
            }
            for (InvItem item : this.townhallLimit.keySet()) {
                if (villager.getTownHall().countGoods(item) <= this.townhallLimit.get(item)) continue;
                return false;
            }
            if (this.balanceOutput1 != null && villager.getTownHall().nbGoodAvailable(new InvItem(this.balanceOutput1.item, this.balanceOutput1.meta), false, false) < villager.getTownHall().nbGoodAvailable(new InvItem(this.balanceOutput2.item, this.balanceOutput2.meta), false, false)) {
                return false;
            }
            if (this.maxSimultaneousTotal > 0) {
                int nbSame = 0;
                for (MillVillager v : villager.getTownHall().villagers) {
                    if (v == villager || !this.key.equals(v.goalKey)) continue;
                    ++nbSame;
                }
                if (nbSame >= this.maxSimultaneousTotal) {
                    return false;
                }
            }
            return this.isPossibleSpecific(villager);
        }
        catch (Exception e) {
            MLN.printException("Exception in isPossible() for goal: " + this.key + " and villager: " + villager, e);
            return false;
        }
    }

    protected boolean isPossibleSpecific(MillVillager villager) throws Exception {
        return true;
    }

    public final boolean isStillValid(MillVillager villager) throws Exception {
        if (villager.field_70170_p.func_72935_r() && !this.canBeDoneInDayTime()) {
            return false;
        }
        if (!villager.field_70170_p.func_72935_r() && !this.canBeDoneAtNight()) {
            return false;
        }
        if (this.leasure) {
            for (Goal g : villager.getGoals()) {
                if (g.leasure || !g.isPossible(villager)) continue;
                return false;
            }
        }
        if (villager.getGoalDestPoint() == null && villager.getGoalDestEntity() == null) {
            return false;
        }
        return this.isStillValidSpecific(villager);
    }

    protected boolean isStillValidSpecific(MillVillager villager) throws Exception {
        return true;
    }

    public String labelKey(MillVillager villager) {
        return this.key;
    }

    public String labelKeyWhileTravelling(MillVillager villager) {
        return this.key;
    }

    public boolean lookAtGoal() {
        return false;
    }

    public boolean lookAtPlayer() {
        return false;
    }

    public String nextGoal(MillVillager villager) throws Exception {
        return null;
    }

    public void onAccept(MillVillager villager) throws Exception {
    }

    public void onComplete(MillVillager villager) throws Exception {
    }

    protected GoalInformation packDest(Point p) {
        return new GoalInformation(p, null, null);
    }

    protected GoalInformation packDest(Point p, Building b) {
        return new GoalInformation(p, b.getPos(), null);
    }

    protected GoalInformation packDest(Point p, Building b, Entity ent) {
        if (b == null) {
            return new GoalInformation(p, null, ent);
        }
        return new GoalInformation(p, b.getPos(), ent);
    }

    protected GoalInformation packDest(Point p, Point p2) {
        return new GoalInformation(p, p2, null);
    }

    public abstract boolean performAction(MillVillager var1) throws Exception;

    public abstract int priority(MillVillager var1) throws Exception;

    public int range(MillVillager villager) {
        return ACTIVATION_RANGE;
    }

    public String sentenceKey() {
        return this.key;
    }

    public void setVillagerDest(MillVillager villager) throws Exception {
        villager.setGoalInformation(this.getDestination(villager));
    }

    public boolean shouldVillagerLieDown() {
        return false;
    }

    public boolean stopMovingWhileWorking() {
        return true;
    }

    public boolean stuckAction(MillVillager villager) throws Exception {
        return false;
    }

    public long stuckDelay(MillVillager villager) {
        return 10000L;
    }

    public boolean swingArms() {
        return false;
    }

    public boolean swingArms(MillVillager villager) {
        if (villager != null && this.getCurrentGoalTarget(villager) != null && this.getCurrentGoalTarget(villager).horizontalDistanceTo((Entity)villager) > (double)this.range(villager)) {
            return this.swingArmsWhileTravelling();
        }
        return this.swingArms();
    }

    public boolean swingArmsWhileTravelling() {
        return false;
    }

    public String toString() {
        return "goal:" + this.key;
    }

    public boolean unreachableDestination(MillVillager villager) throws Exception {
        if (villager.getGoalDestPoint() == null && villager.getGoalDestEntity() == null) {
            return false;
        }
        int[] jumpTo = MillCommonUtilities.getJumpDestination(villager.field_70170_p, villager.getPathDestPoint().getiX(), villager.getTownHall().getAltitude(villager.getPathDestPoint().getiX(), villager.getPathDestPoint().getiZ()), villager.getPathDestPoint().getiZ());
        if (jumpTo != null) {
            if (MLN.LogPathing >= 2 && villager.extraLog) {
                MLN.minor(this, "Dest unreachable. Jumping " + villager + " from " + villager.getPos() + " to " + jumpTo[0] + "/" + jumpTo[1] + "/" + jumpTo[2]);
            }
            villager.func_70107_b((double)jumpTo[0] + 0.5, (double)jumpTo[1] + 0.5, (double)jumpTo[2] + 0.5);
            return true;
        }
        if (MLN.LogPathing >= 2 && villager.extraLog) {
            MLN.minor(this, "Dest unreachable. Couldn't jump " + villager + " from " + villager.getPos() + " to " + villager.getPathDestPoint());
        }
        return false;
    }

    public boolean validateDest(MillVillager villager, Building dest) throws MLN.MillenaireException {
        if (dest == null) {
            throw new MLN.MillenaireException("Given null dest in validateDest for goal: " + this.key);
        }
        for (InvItem item : this.buildingLimit.keySet()) {
            if (dest.countGoods(item) <= this.buildingLimit.get(item)) continue;
            return false;
        }
        int nbSameBuilding = 0;
        if (this.maxSimultaneousInBuilding > 0) {
            for (MillVillager v : villager.getTownHall().villagers) {
                if (v == villager || !this.key.equals(v.goalKey) || v.getGoalBuildingDest() != dest) continue;
                ++nbSameBuilding;
            }
            if (nbSameBuilding >= this.maxSimultaneousInBuilding) {
                return false;
            }
        }
        return true;
    }

    static {
        JPS_CONFIG_TIGHT = new AStarConfig(true, false, false, true);
        JPS_CONFIG_WIDE = new AStarConfig(true, false, false, true, 2, 10);
        JPS_CONFIG_BUILDING = new AStarConfig(true, false, false, true, 2, 20);
        JPS_CONFIG_CHOPLUMBER = new AStarConfig(true, false, false, true, 4, 20);
        JPS_CONFIG_SLAUGHTERSQUIDS = new AStarConfig(true, false, false, true, 6, 4);
        EMPTY_DEST = new Point[]{null, null};
        ACTIVATION_RANGE = 3;
    }

    public static class GoalInformation {
        private Point dest;
        private Point destBuildingPos;
        private Entity targetEnt;

        public GoalInformation(Point dest, Point buildingPos, Entity targetEnt) {
            this.dest = dest;
            this.destBuildingPos = buildingPos;
            this.targetEnt = targetEnt;
        }

        public Point getDest() {
            return this.dest;
        }

        public Point getDestBuildingPos() {
            return this.destBuildingPos;
        }

        public Entity getTargetEnt() {
            return this.targetEnt;
        }

        public void setDest(Point dest) {
            this.dest = dest;
        }

        public void setDestBuildingPos(Point destBuildingPos) {
            this.destBuildingPos = destBuildingPos;
        }

        public void setTargetEnt(Entity targetEnt) {
            this.targetEnt = targetEnt;
        }
    }
}

