/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common.goal;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import org.millenaire.common.MLN;
import org.millenaire.common.MillVillager;
import org.millenaire.common.goal.Goal;
import org.millenaire.common.network.ServerSender;

public class GoalBeSeller
extends Goal {
    public static final int sellingRadius = 7;

    @Override
    public Goal.GoalInformation getDestination(MillVillager villager) {
        return this.packDest(villager.getTownHall().sellingPlace);
    }

    @Override
    public boolean isPossibleSpecific(MillVillager villager) {
        return false;
    }

    @Override
    public boolean isStillValidSpecific(MillVillager villager) throws Exception {
        boolean valid;
        if (villager.getTownHall().sellingPlace == null) {
            return false;
        }
        EntityPlayer player = villager.field_70170_p.func_72977_a((double)villager.getTownHall().sellingPlace.getiX(), (double)villager.getTownHall().sellingPlace.getiY(), (double)villager.getTownHall().sellingPlace.getiZ(), 7.0);
        boolean bl = valid = player != null && villager.getTownHall().sellingPlace.distanceTo((Entity)player) < 7.0;
        if (!valid && MLN.LogWifeAI >= 1) {
            MLN.major(this, "Selling goal no longer valid.");
        }
        return valid;
    }

    @Override
    public boolean lookAtPlayer() {
        return true;
    }

    @Override
    public void onAccept(MillVillager villager) {
        EntityPlayer player = villager.field_70170_p.func_72977_a((double)villager.getTownHall().sellingPlace.getiX(), (double)villager.getTownHall().sellingPlace.getiY(), (double)villager.getTownHall().sellingPlace.getiZ(), 7.0);
        ServerSender.sendTranslatedSentence(player, 'f', "ui.sellercoming", villager.getName());
    }

    @Override
    public void onComplete(MillVillager villager) {
        EntityPlayer player = villager.field_70170_p.func_72977_a((double)villager.getTownHall().getResManager().getSellingPos().getiX(), (double)villager.getTownHall().getResManager().getSellingPos().getiY(), (double)villager.getTownHall().getResManager().getSellingPos().getiZ(), 17.0);
        ServerSender.sendTranslatedSentence(player, 'f', "ui.tradecomplete", villager.getName());
        villager.getTownHall().seller = null;
        villager.getTownHall().sellingPlace = null;
    }

    @Override
    public boolean performAction(MillVillager villager) {
        if (villager.getTownHall().sellingPlace == null) {
            MLN.error(this, "villager.townHall.sellingPlace is null.");
            return true;
        }
        return false;
    }

    @Override
    public int priority(MillVillager villager) {
        return 0;
    }

    @Override
    public int range(MillVillager villager) {
        return 2;
    }
}

