/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common.goal;

import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityBrewingStand;
import org.millenaire.common.MillVillager;
import org.millenaire.common.Point;
import org.millenaire.common.goal.Goal;

public class GoalBrewPotions
extends Goal {
    @Override
    public Goal.GoalInformation getDestination(MillVillager villager) throws Exception {
        int nbWarts = villager.getHouse().countGoods(Items.field_151075_bm);
        int nbBottles = villager.getHouse().countGoods(Items.field_151069_bo);
        int nbPotions = villager.getHouse().countGoods((Item)Items.field_151068_bn, -1);
        for (Point p : villager.getHouse().getResManager().brewingStands) {
            TileEntityBrewingStand brewingStand = p.getBrewingStand(villager.field_70170_p);
            if (brewingStand == null || brewingStand.func_145935_i() != 0) continue;
            if (brewingStand.func_70301_a(3) == null && nbWarts > 0 && nbPotions < 64) {
                return this.packDest(p, villager.getHouse());
            }
            if (nbBottles > 2 && (brewingStand.func_70301_a(0) == null || brewingStand.func_70301_a(1) == null || brewingStand.func_70301_a(2) == null) && nbPotions < 64) {
                return this.packDest(p, villager.getHouse());
            }
            for (int i = 0; i < 3; ++i) {
                if (brewingStand.func_70301_a(i) == null || brewingStand.func_70301_a(i).func_77973_b() != Items.field_151068_bn || brewingStand.func_70301_a(i).func_77960_j() != 16) continue;
                return this.packDest(p, villager.getHouse());
            }
        }
        return null;
    }

    @Override
    public boolean isPossibleSpecific(MillVillager villager) throws Exception {
        return this.getDestination(villager) != null;
    }

    @Override
    public boolean performAction(MillVillager villager) throws Exception {
        int nbWarts = villager.getHouse().countGoods(Items.field_151075_bm);
        int nbBottles = villager.getHouse().countGoods(Items.field_151069_bo);
        int nbPotions = villager.getHouse().countGoods((Item)Items.field_151068_bn);
        TileEntityBrewingStand brewingStand = villager.getGoalDestPoint().getBrewingStand(villager.field_70170_p);
        if (brewingStand == null) {
            return true;
        }
        if (brewingStand.func_145935_i() == 0) {
            int i;
            if (brewingStand.func_70301_a(3) == null && nbWarts > 0 && nbPotions < 64) {
                brewingStand.func_70299_a(3, new ItemStack(Items.field_151075_bm, 1));
                villager.getHouse().takeGoods(Items.field_151075_bm, 1);
            }
            if (nbBottles > 2 && nbPotions < 64) {
                for (i = 0; i < 3; ++i) {
                    if (brewingStand.func_70301_a(i) != null) continue;
                    brewingStand.func_70299_a(i, new ItemStack((Item)Items.field_151068_bn, 1));
                    villager.getHouse().takeGoods(Items.field_151069_bo, 1);
                }
            }
            for (i = 0; i < 3; ++i) {
                if (brewingStand.func_70301_a(i) == null || brewingStand.func_70301_a(i).func_77973_b() != Items.field_151068_bn || brewingStand.func_70301_a(i).func_77960_j() != 16) continue;
                brewingStand.func_70299_a(i, null);
                villager.getHouse().storeGoods((Item)Items.field_151068_bn, 16, 1);
            }
        }
        return true;
    }

    @Override
    public int priority(MillVillager villager) throws Exception {
        return 100;
    }

    @Override
    public boolean swingArms() {
        return true;
    }
}

