/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common.goal;

import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import org.millenaire.common.InvItem;
import org.millenaire.common.MillVillager;
import org.millenaire.common.Point;
import org.millenaire.common.core.MillCommonUtilities;
import org.millenaire.common.goal.Goal;
import org.millenaire.common.pathing.atomicstryker.AStarConfig;

public class GoalGatherGoods
extends Goal {
    @Override
    public Goal.GoalInformation getDestination(MillVillager villager) {
        EntityItem item = villager.getClosestItemVertical(villager.getGoodsToCollect(), villager.getGatheringRange(), 10);
        if (item == null) {
            return null;
        }
        return this.packDest(new Point((Entity)item));
    }

    @Override
    public AStarConfig getPathingConfig() {
        return JPS_CONFIG_WIDE;
    }

    @Override
    public boolean isPossibleSpecific(MillVillager villager) {
        if (villager.getGoodsToCollect().length == 0) {
            return false;
        }
        EntityItem item = villager.getClosestItemVertical(villager.getGoodsToCollect(), villager.getGatheringRange(), 10);
        return item != null;
    }

    @Override
    public boolean lookAtGoal() {
        return true;
    }

    @Override
    public boolean performAction(MillVillager villager) {
        return true;
    }

    @Override
    public int priority(MillVillager villager) {
        return 100;
    }

    @Override
    public int range(MillVillager villager) {
        return 5;
    }

    @Override
    public boolean stuckAction(MillVillager villager) {
        EntityItem item;
        InvItem[] goods = villager.getGoodsToCollect();
        if (goods != null && (item = MillCommonUtilities.getClosestItemVertical(villager.field_70170_p, villager.getGoalDestPoint(), goods, 3, 20)) != null) {
            item.func_70106_y();
            villager.addToInv(item.func_92059_d().func_77973_b(), item.func_92059_d().func_77960_j(), 1);
            return true;
        }
        return false;
    }
}

