/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common.goal;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import org.millenaire.common.MLN;
import org.millenaire.common.MillVillager;
import org.millenaire.common.Point;
import org.millenaire.common.building.Building;
import org.millenaire.common.core.MillCommonUtilities;
import org.millenaire.common.goal.Goal;
import org.millenaire.common.pathing.atomicstryker.AStarConfig;

public class GoalLumbermanPlantSaplings
extends Goal {
    public GoalLumbermanPlantSaplings() {
        this.maxSimultaneousInBuilding = 1;
    }

    @Override
    public int actionDuration(MillVillager villager) {
        return 1000;
    }

    @Override
    public Goal.GoalInformation getDestination(MillVillager villager) {
        ArrayList<Point> vp = new ArrayList<Point>();
        ArrayList<Point> buildingp = new ArrayList<Point>();
        for (Building grove : villager.getTownHall().getBuildingsWithTag("grove")) {
            Point p = grove.getResManager().getPlantingLocation();
            if (p == null) continue;
            vp.add(p);
            buildingp.add(grove.getPos());
        }
        if (vp.isEmpty()) {
            return null;
        }
        Point p = (Point)vp.get(0);
        Point buildingP = (Point)buildingp.get(0);
        for (int i = 1; i < vp.size(); ++i) {
            if (!(((Point)vp.get(i)).horizontalDistanceToSquared((Entity)villager) < p.horizontalDistanceToSquared((Entity)villager))) continue;
            p = (Point)vp.get(i);
            buildingP = (Point)buildingp.get(i);
        }
        return this.packDest(p, buildingP);
    }

    @Override
    public ItemStack[] getHeldItemsTravelling(MillVillager villager) {
        int meta = 0;
        if (villager.takeFromInv(Blocks.field_150345_g, 0, 1) == 1) {
            meta = 0;
        } else if (villager.takeFromInv(Blocks.field_150345_g, 1, 1) == 1) {
            meta = 1;
        } else if (villager.takeFromInv(Blocks.field_150345_g, 2, 1) == 1) {
            meta = 2;
        } else if (villager.takeFromInv(Blocks.field_150345_g, 3, 1) == 1) {
            meta = 3;
        }
        return new ItemStack[]{new ItemStack(Blocks.field_150345_g, 1, meta)};
    }

    @Override
    public AStarConfig getPathingConfig() {
        return JPS_CONFIG_WIDE;
    }

    @Override
    public boolean isPossibleSpecific(MillVillager villager) {
        for (Building grove : villager.getTownHall().getBuildingsWithTag("grove")) {
            Point p = grove.getResManager().getPlantingLocation();
            if (p == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean lookAtGoal() {
        return true;
    }

    @Override
    public boolean performAction(MillVillager villager) {
        Block block = MillCommonUtilities.getBlock(villager.field_70170_p, villager.getGoalDestPoint());
        if (block == Blocks.field_150350_a || block == Blocks.field_150433_aE) {
            int i;
            int metaStart = MillCommonUtilities.randomInt(4);
            int chosenMeta = -1;
            for (i = metaStart; i < 4 && chosenMeta == -1; ++i) {
                if (villager.takeFromInv(Blocks.field_150345_g, i, 1) != 1) continue;
                chosenMeta = i;
            }
            for (i = 0; i < metaStart && chosenMeta == -1; ++i) {
                if (villager.takeFromInv(Blocks.field_150345_g, i, 1) != 1) continue;
                chosenMeta = i;
            }
            if (chosenMeta == -1) {
                chosenMeta = 0;
            }
            villager.setBlockAndMetadata(villager.getGoalDestPoint(), Blocks.field_150345_g, chosenMeta);
            villager.func_71038_i();
            if (MLN.LogLumberman >= 3 && villager.extraLog) {
                MLN.debug(this, "Planted at: " + villager.getGoalDestPoint());
            }
        } else if (MLN.LogLumberman >= 3 && villager.extraLog) {
            MLN.debug(this, "Failed to plant at: " + villager.getGoalDestPoint());
        }
        return true;
    }

    @Override
    public int priority(MillVillager villager) {
        return 120;
    }

    @Override
    public int range(MillVillager villager) {
        return 5;
    }
}

